/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.view.View2D;

public class UndoColoringProperty
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private byte oldValue;
    private byte newValue;
    private View2D view;

    public UndoColoringProperty(View2D view) {
        this.oldValue = view.getHeatMapType();
        this.view = view;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.newValue = this.view.getHeatMapType();
        this.view.setHeatMapType(this.oldValue);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.view.setHeatMapType(this.newValue);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Coloring Property Change";
    }
}

