/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.view.View2D;

public class UndoClearAllParticles
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private List<Particle> particles = new ArrayList<Particle>();
    private View2D view;

    public UndoClearAllParticles(View2D view) {
        this.particles.addAll(view.getModel().getParticles());
        this.view = view;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (!this.particles.isEmpty()) {
            this.view.getModel().getParticles().addAll(this.particles);
        }
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.view.getModel().getParticles().clear();
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Clear All Particles";
    }
}

