/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.view.TextBox;
import org.concord.energy2d.view.View2D;

public class UndoAddManipulable
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Manipulable addedManipulable;
    private View2D view;
    private Model2D model;
    private String name;

    public UndoAddManipulable(Manipulable addedManipulable, View2D view) {
        this.view = view;
        this.model = view.getModel();
        this.addedManipulable = addedManipulable;
        if (addedManipulable instanceof Part) {
            this.name = "Part";
        } else if (addedManipulable instanceof Thermometer) {
            this.name = "Thermometer";
        } else if (addedManipulable instanceof HeatFluxSensor) {
            this.name = "Heat Flux Sensor";
        } else if (addedManipulable instanceof Anemometer) {
            this.name = "Anemometer";
        } else if (addedManipulable instanceof Particle) {
            this.name = "Particle";
        } else if (addedManipulable instanceof ParticleFeeder) {
            this.name = "Particle Feeder";
        } else if (addedManipulable instanceof Fan) {
            this.name = "Fan";
        } else if (addedManipulable instanceof Heliostat) {
            this.name = "Heliostat";
        } else if (addedManipulable instanceof Cloud) {
            this.name = "Cloud";
        } else if (addedManipulable instanceof Tree) {
            this.name = "Tree";
        } else if (addedManipulable instanceof TextBox) {
            this.name = "Text Box";
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.addedManipulable != null) {
            this.view.notifyManipulationListeners(this.addedManipulable, (byte)0);
        }
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.addedManipulable instanceof Part) {
            this.model.addPart((Part)this.addedManipulable);
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            this.model.setInitialTemperature();
            if (this.view.isViewFactorLinesOn()) {
                this.model.generateViewFactorMesh();
            }
        } else if (this.addedManipulable instanceof Thermometer) {
            this.model.addThermometer((Thermometer)this.addedManipulable);
        } else if (this.addedManipulable instanceof HeatFluxSensor) {
            this.model.addHeatFluxSensor((HeatFluxSensor)this.addedManipulable);
        } else if (this.addedManipulable instanceof Anemometer) {
            this.model.addAnemometer((Anemometer)this.addedManipulable);
        } else if (this.addedManipulable instanceof Particle) {
            this.model.addParticle((Particle)this.addedManipulable);
        } else if (this.addedManipulable instanceof ParticleFeeder) {
            this.model.addParticleFeeder((ParticleFeeder)this.addedManipulable);
        } else if (this.addedManipulable instanceof Fan) {
            this.model.addFan((Fan)this.addedManipulable);
            this.model.refreshMaterialPropertyArrays();
        } else if (this.addedManipulable instanceof Heliostat) {
            this.model.addHeliostat((Heliostat)this.addedManipulable);
        } else if (this.addedManipulable instanceof Cloud) {
            this.model.addCloud((Cloud)this.addedManipulable);
        } else if (this.addedManipulable instanceof Tree) {
            this.model.addTree((Tree)this.addedManipulable);
        } else if (this.addedManipulable instanceof TextBox) {
            this.view.addTextBox((TextBox)this.addedManipulable);
        }
        this.view.setSelectedManipulable(this.addedManipulable);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Add " + (this.name == null ? "Manipulable" : this.name);
    }
}

