/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.geom.Rectangle2D;
import java.util.List;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.Thermostat;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.system.System2D;
import org.concord.energy2d.system.Task;

class XmlEncoder {
    private System2D box;

    XmlEncoder(System2D box) {
        this.box = box;
    }

    String encode() {
        int n;
        List<Anemometer> anemometers;
        List<HeatFluxSensor> heatFluxSensors;
        List<ParticleFeeder> particleFeeders;
        List<Heliostat> heliostats;
        List<Fan> fans;
        List<Tree> trees;
        List<Particle> particles;
        List<Task> tasks;
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<state>\n");
        sb.append("<links>\n");
        if (this.box.getNextSimulation() != null) {
            sb.append("<next_sim>" + this.box.getNextSimulation() + "</next_sim>\n");
        }
        if (this.box.getPreviousSimulation() != null) {
            sb.append("<prev_sim>" + this.box.getPreviousSimulation() + "</prev_sim>\n");
        }
        sb.append("</links>\n");
        sb.append("<model>\n");
        if (this.box.model.getLx() != 10.0f) {
            sb.append("<model_width>" + this.box.model.getLx() + "</model_width>\n");
        }
        if (this.box.model.getLy() != 10.0f) {
            sb.append("<model_height>" + this.box.model.getLy() + "</model_height>\n");
        }
        sb.append("<timestep>" + this.box.model.getTimeStep() + "</timestep>\n");
        if (this.box.measure.getInterval() != 100) {
            sb.append("<measurement_interval>" + this.box.measure.getInterval() + "</measurement_interval>\n");
        }
        if (this.box.control.getInterval() != 100) {
            sb.append("<control_interval>" + this.box.control.getInterval() + "</control_interval>\n");
        }
        if (this.box.repaint.getInterval() != 20) {
            sb.append("<viewupdate_interval>" + this.box.repaint.getInterval() + "</viewupdate_interval>\n");
        }
        if ((tasks = this.box.taskManager.getCustomTasks()) != null && !tasks.isEmpty()) {
            sb.append("<tasks>\n");
            for (Task t : tasks) {
                sb.append(String.valueOf(t.toXml()) + "\n");
            }
            sb.append("</tasks>\n");
        }
        if (this.box.model.isSunny()) {
            sb.append("<sunny>true</sunny>");
        }
        sb.append("<sun_angle>" + this.box.model.getSunAngle() + "</sun_angle>\n");
        sb.append("<solar_power_density>" + this.box.model.getSolarPowerDensity() + "</solar_power_density>\n");
        sb.append("<solar_ray_count>" + this.box.model.getSolarRayCount() + "</solar_ray_count>\n");
        sb.append("<solar_ray_speed>" + this.box.model.getSolarRaySpeed() + "</solar_ray_speed>\n");
        sb.append("<photon_emission_interval>" + this.box.model.getPhotonEmissionInterval() + "</photon_emission_interval>\n");
        sb.append("<gravitational_acceleration>" + this.box.model.getGravitationalAcceleration() + "</gravitational_acceleration>\n");
        sb.append("<thermophoretic_coefficient>" + this.box.model.getThermophoreticCoefficient() + "</thermophoretic_coefficient>");
        sb.append("<particle_drag>" + this.box.model.getParticleDrag() + "</particle_drag>");
        sb.append("<particle_hardness>" + this.box.model.getParticleHardness() + "</particle_hardness>");
        sb.append("<z_heat_diffusivity>" + this.box.model.getZHeatDiffusivity() + "</z_heat_diffusivity>");
        if (!this.box.model.isConvective()) {
            sb.append("<convective>false</convective>\n");
        }
        if (this.box.model.getBackgroundConductivity() != 0.025f) {
            sb.append("<background_conductivity>" + this.box.model.getBackgroundConductivity() + "</background_conductivity>\n");
        }
        if (this.box.model.getBackgroundDensity() != 1.204f) {
            sb.append("<background_density>" + this.box.model.getBackgroundDensity() + "</background_density>\n");
        }
        if (this.box.model.getBackgroundSpecificHeat() != 1012.0f) {
            sb.append("<background_specific_heat>" + this.box.model.getBackgroundSpecificHeat() + "</background_specific_heat>\n");
        }
        if (this.box.model.getBackgroundTemperature() != 0.0f) {
            sb.append("<background_temperature>" + this.box.model.getBackgroundTemperature() + "</background_temperature>\n");
        }
        if (this.box.model.getBackgroundViscosity() != 1.568E-5f) {
            sb.append("<background_viscosity>" + this.box.model.getBackgroundViscosity() + "</background_viscosity>\n");
        }
        if (this.box.model.getGravityType() != 0) {
            sb.append("<gravity_type>" + this.box.model.getGravityType() + "</gravity_type>\n");
        }
        sb.append("<thermal_expansion_coefficient>" + this.box.model.getThermalExpansionCoefficient() + "</thermal_expansion_coefficient>\n");
        sb.append("<buoyancy_approximation>" + this.box.model.getBuoyancyApproximation() + "</buoyancy_approximation>\n");
        sb.append("<boundary>\n");
        sb.append(this.box.model.getThermalBoundary().toXml());
        sb.append(this.box.model.getMassBoundary().toXml());
        sb.append("</boundary>\n");
        sb.append("<structure>\n");
        List<Part> parts = this.box.model.getParts();
        if (!parts.isEmpty()) {
            for (Part p : parts) {
                sb.append(p.toXml());
            }
        }
        if (!(particles = this.box.model.getParticles()).isEmpty()) {
            for (Particle p : particles) {
                sb.append(p.toXml());
            }
        }
        sb.append("</structure>\n");
        sb.append("<environment>\n");
        List<Cloud> clouds = this.box.model.getClouds();
        if (clouds != null) {
            for (Cloud c : clouds) {
                sb.append(String.valueOf(c.toXml()) + "\n");
            }
        }
        if ((trees = this.box.model.getTrees()) != null) {
            for (Tree t : trees) {
                sb.append(String.valueOf(t.toXml()) + "\n");
            }
        }
        if (!(fans = this.box.model.getFans()).isEmpty()) {
            for (Fan f : fans) {
                sb.append(f.toXml());
            }
        }
        if (!(heliostats = this.box.model.getHeliostats()).isEmpty()) {
            for (Heliostat h : heliostats) {
                sb.append(h.toXml());
            }
        }
        if (!(particleFeeders = this.box.model.getParticleFeeders()).isEmpty()) {
            for (ParticleFeeder pf : particleFeeders) {
                sb.append(pf.toXml());
            }
        }
        sb.append("</environment>\n");
        sb.append("<sensor>\n");
        List<Thermometer> thermometers = this.box.model.getThermometers();
        if (!thermometers.isEmpty()) {
            for (Thermometer t : thermometers) {
                sb.append(String.valueOf(t.toXml()) + "\n");
            }
        }
        if (!(heatFluxSensors = this.box.model.getHeatFluxSensors()).isEmpty()) {
            for (HeatFluxSensor h : heatFluxSensors) {
                sb.append(String.valueOf(h.toXml()) + "\n");
            }
        }
        if (!(anemometers = this.box.model.getAnemometers()).isEmpty()) {
            for (Anemometer a : anemometers) {
                sb.append(String.valueOf(a.toXml()) + "\n");
            }
        }
        sb.append("</sensor>\n");
        sb.append("<controller>\n");
        List<Thermostat> thermostats = this.box.model.getThermostats();
        if (thermostats != null) {
            for (Thermostat t : thermostats) {
                sb.append(String.valueOf(t.toXml()) + "\n");
            }
        }
        sb.append("</controller>\n");
        sb.append("</model>\n");
        sb.append("<view>\n");
        if (this.box.view.isGridOn()) {
            sb.append("<grid>true</grid>\n");
        }
        sb.append("<snap_to_grid>" + this.box.view.isSnapToGrid() + "</snap_to_grid>\n");
        sb.append("<grid_size>" + this.box.view.getGridSize() + "</grid_size>\n");
        if (this.box.view.getGraphDataType() > 0) {
            sb.append("<graph_data_type>" + this.box.view.getGraphDataType() + "</graph_data_type>\n");
        }
        if (this.box.view.getGraphTimeUnit() > 0) {
            sb.append("<graph_time_unit>" + this.box.view.getGraphTimeUnit() + "</graph_time_unit>\n");
        }
        if (this.box.view.getFahrenheitUsed()) {
            sb.append("<fahrenheit_used>true</fahrenheit_used>\n");
        }
        if (this.box.view.isViewFactorLinesOn()) {
            sb.append("<view_factor_lines>true</view_factor_lines>\n");
        }
        sb.append("<perimeter_step_size>" + this.box.model.getPerimeterStepSize() + "</perimeter_step_size>\n");
        if (this.box.view.isBorderTickmarksOn()) {
            sb.append("<border_tickmarks>true</border_tickmarks>\n");
        }
        if (this.box.view.isIsothermOn()) {
            sb.append("<isotherm>true</isotherm>\n");
        }
        if (this.box.view.isColorPaletteOn()) {
            sb.append("<color_palette>true</color_palette>\n");
        }
        sb.append("<color_palette_type>" + this.box.view.getColorPaletteType() + "</color_palette_type>\n");
        if (!this.box.view.isFrankOn()) {
            sb.append("<brand>false</brand>\n");
        }
        if (this.box.view.isControlPanelVisible()) {
            sb.append("<control_panel>true</control_panel>\n");
        }
        Rectangle2D.Float colorPalette = this.box.view.getColorPaletteRectangle();
        sb.append("<color_palette_x>" + colorPalette.x + "</color_palette_x>");
        sb.append("<color_palette_y>" + colorPalette.y + "</color_palette_y>");
        sb.append("<color_palette_w>" + colorPalette.width + "</color_palette_w>");
        sb.append("<color_palette_h>" + colorPalette.height + "</color_palette_h>");
        sb.append("<minimum_temperature>" + this.box.view.getMinimumTemperature() + "</minimum_temperature>\n");
        sb.append("<maximum_temperature>" + this.box.view.getMaximumTemperature() + "</maximum_temperature>\n");
        sb.append("<fan_rotation_speed_scale_factor>" + this.box.view.getFanRotationSpeedScaleFactor() + "</fan_rotation_speed_scale_factor>");
        if (this.box.view.isVelocityOn()) {
            sb.append("<velocity>true</velocity>\n");
        }
        if (this.box.view.isHeatFluxArrowsOn()) {
            sb.append("<heat_flux_arrow>true</heat_flux_arrow>\n");
        }
        if (this.box.view.isHeatFluxLinesOn()) {
            sb.append("<heat_flux_line>true</heat_flux_line>\n");
        }
        if (this.box.view.isStreamlineOn()) {
            sb.append("<streamline>true</streamline>\n");
        }
        if (this.box.view.isGraphOn()) {
            sb.append("<graph>true</graph>\n");
        }
        sb.append("<graph_xlabel>" + this.box.view.getGraphXLabel() + "</graph_xlabel>");
        sb.append("<graph_ylabel>" + this.box.view.getGraphYLabel() + "</graph_ylabel>");
        if (this.box.view.getGraphDataType() > 1) {
            sb.append("<graph_ymin>" + this.box.view.getGraphYmin() + "</graph_ymin>");
            sb.append("<graph_ymax>" + this.box.view.getGraphYmax() + "</graph_ymax>");
        }
        if (!this.box.view.isClockOn()) {
            sb.append("<clock>false</clock>\n");
        }
        if (!this.box.view.isSmooth()) {
            sb.append("<smooth>false</smooth>\n");
        }
        if (this.box.view.getHeatMapType() != 1) {
            sb.append("<heat_map>" + this.box.view.getHeatMapType() + "</heat_map>\n");
        }
        if ((n = this.box.view.getTextBoxCount()) > 0) {
            int i = 0;
            while (i < n) {
                sb.append(this.box.view.getTextBox(i).toXml());
                ++i;
            }
        }
        sb.append("</view>\n");
        sb.append("</state>\n");
        return sb.toString();
    }
}

