/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.DirichletThermalBoundary;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.MassBoundary;
import org.concord.energy2d.model.NeumannThermalBoundary;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.model.SimpleMassBoundary;
import org.concord.energy2d.model.ThermalBoundary;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.Thermostat;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.system.System2D;
import org.concord.energy2d.system.Task;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.util.Scripter;
import org.concord.energy2d.util.Texture;
import org.concord.energy2d.util.XmlCharacterDecoder;
import org.concord.energy2d.view.TextBox;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class XmlDecoder
extends DefaultHandler {
    private System2D box;
    private String str;
    private float modelWidth = 10.0f;
    private float modelHeight = 10.0f;
    private float timeStep = 0.1f;
    private int measurementInterval = 100;
    private int controlInterval = 100;
    private int viewUpdateInterval = 20;
    private boolean sunny;
    private float sunAngle = 1.5707964f;
    private float solarPowerDensity = 2000.0f;
    private int solarRayCount = 24;
    private float solarRaySpeed = 0.1f;
    private int photonEmissionInterval = 20;
    private float perimeterStepSize = 0.05f;
    private boolean convective = true;
    private float zHeatDiffusivity;
    private float gravitationalAcceleration = -1.0f;
    private float thermophoreticCoefficient = 0.0f;
    private float particleDrag = -1.0f;
    private float particleHardness = -1.0f;
    private float backgroundConductivity = 0.025f;
    private float backgroundDensity = 1.204f;
    private float backgroundSpecificHeat = 1012.0f;
    private float backgroundViscosity = 1.568E-5f;
    private float backgroundTemperature;
    private float thermalExpansionCoefficient = 2.5E-4f;
    private byte buoyancyApproximation = 1;
    private byte gravityType = 0;
    private String nextSim;
    private String prevSim;
    private byte graphDataType;
    private byte graphTimeUnit;
    private boolean fahrenheitUsed;
    private boolean viewFactorLines;
    private boolean borderTickmarks;
    private boolean grid;
    private boolean snapToGrid = true;
    private boolean isotherm;
    private boolean streamline;
    private boolean colorPalette;
    private byte colorPaletteType = 0;
    private boolean brand = true;
    private boolean controlPanel;
    private byte heatMapType = 1;
    private float colorPaletteX;
    private float colorPaletteY;
    private float colorPaletteW;
    private float colorPaletteH;
    private int gridSize = 10;
    private boolean velocity;
    private boolean heatFluxArrows;
    private boolean heatFluxLines;
    private boolean graphOn;
    private boolean clock = true;
    private boolean smooth = true;
    private float minimumTemperature;
    private float maximumTemperature = 50.0f;
    private float fanRotationSpeedScaleFactor = 1.0f;
    private String graphXLabel;
    private String graphYLabel;
    private float graphYmin = 0.0f;
    private float graphYmax = 50.0f;
    private String uid;
    private String label;
    private float partThermalConductivity = Float.NaN;
    private float partSpecificHeat = Float.NaN;
    private float partDensity = Float.NaN;
    private float partEmissivity = Float.NaN;
    private float partAbsorption = Float.NaN;
    private float partReflection = Float.NaN;
    private float partElasticity = 1.0f;
    private boolean partScattering;
    private boolean partScatteringVisible = true;
    private float partTransmission = Float.NaN;
    private float temperature = Float.NaN;
    private float fanSpeed;
    private float fanAngle;
    private boolean partConstantTemperature = false;
    private float partPower = Float.NaN;
    private float partTemperatureCoefficient = 0.0f;
    private float partReferenceTemperature = 0.0f;
    private boolean partVisible = true;
    private boolean draggable = true;
    private boolean movable = true;
    private Color color;
    private Color velocityColor;
    private byte partTextureStyle;
    private int partTextureWidth = 10;
    private int partTextureHeight = 10;
    private Color partTextureForeground = Color.BLACK;
    private Color partTextureBackground = Color.WHITE;
    private boolean partFilled = true;
    private Part part;
    private float particleRx = Float.NaN;
    private float particleRy = Float.NaN;
    private float particleVx = Float.NaN;
    private float particleVy = Float.NaN;
    private float particleTheta = Float.NaN;
    private float particleOmega = Float.NaN;
    private float particleRadius = Float.NaN;
    private float particleMass = Float.NaN;
    private Particle particle;

    XmlDecoder(System2D box) {
        this.box = box;
    }

    @Override
    public void startDocument() {
        this.box.taskManager.clearCustomTasks();
        MassBoundary b = this.box.model.getMassBoundary();
        if (b instanceof SimpleMassBoundary) {
            SimpleMassBoundary smb = (SimpleMassBoundary)b;
            smb.setFlowTypeAtBorder((byte)3, (byte)0);
            smb.setFlowTypeAtBorder((byte)1, (byte)0);
            smb.setFlowTypeAtBorder((byte)2, (byte)0);
            smb.setFlowTypeAtBorder((byte)0, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endDocument() {
        List<Anemometer> list;
        List<HeatFluxSensor> heatFluxSensors;
        List<Thermometer> thermometers;
        this.box.view.setControlPanelVisible(this.controlPanel);
        this.box.setPreviousSimulation(this.prevSim);
        this.box.setNextSimulation(this.nextSim);
        this.box.model.setLx(this.modelWidth);
        this.box.model.setLy(this.modelHeight);
        this.box.view.setArea(0.0f, this.modelWidth, 0.0f, this.modelHeight);
        this.box.model.setTimeStep(this.timeStep);
        this.box.measure.setInterval(this.measurementInterval);
        this.box.control.setInterval(this.controlInterval);
        this.box.repaint.setInterval(this.viewUpdateInterval);
        this.box.model.setSunny(this.sunny);
        this.box.model.setSunAngle(this.sunAngle);
        this.box.model.setSolarPowerDensity(this.solarPowerDensity);
        this.box.model.setSolarRayCount(this.solarRayCount);
        this.box.model.setSolarRaySpeed(this.solarRaySpeed);
        this.box.model.setPhotonEmissionInterval(this.photonEmissionInterval);
        this.box.model.setPerimeterStepSize(this.perimeterStepSize);
        this.box.model.setConvective(this.convective);
        this.box.model.setZHeatDiffusivity(this.zHeatDiffusivity);
        if (this.gravitationalAcceleration >= 0.0f) {
            this.box.model.setGravitationalAcceleration(this.gravitationalAcceleration);
        }
        this.box.model.setThermophoreticCoefficient(this.thermophoreticCoefficient);
        if (this.particleDrag >= 0.0f) {
            this.box.model.setParticleDrag(this.particleDrag);
        }
        if (this.particleHardness >= 0.0f) {
            this.box.model.setParticleHardness(this.particleHardness);
        }
        this.box.model.setBackgroundConductivity(this.backgroundConductivity);
        this.box.model.setBackgroundDensity(this.backgroundDensity);
        this.box.model.setBackgroundSpecificHeat(this.backgroundSpecificHeat);
        this.box.model.setBackgroundTemperature(this.backgroundTemperature);
        this.box.model.setBackgroundViscosity(this.backgroundViscosity);
        this.box.model.setThermalExpansionCoefficient(this.thermalExpansionCoefficient);
        this.box.model.setBuoyancyApproximation(this.buoyancyApproximation);
        this.box.model.setGravityType(this.gravityType);
        this.box.view.setGraphDataType(this.graphDataType);
        this.box.view.setGraphTimeUnit(this.graphTimeUnit);
        this.box.view.setFahrenheitUsed(this.fahrenheitUsed);
        this.box.view.setViewFactorLinesOn(this.viewFactorLines);
        this.box.view.setBorderTickmarksOn(this.borderTickmarks);
        this.box.view.setGridOn(this.grid);
        this.box.view.setSnapToGrid(this.snapToGrid);
        this.box.view.setGridSize(this.gridSize);
        this.box.view.setIsothermOn(this.isotherm);
        this.box.view.setStreamlineOn(this.streamline);
        this.box.view.setVelocityOn(this.velocity);
        this.box.view.setHeatFluxArrowsOn(this.heatFluxArrows);
        this.box.view.setHeatFluxLinesOn(this.heatFluxLines);
        this.box.view.setColorPaletteOn(this.colorPalette);
        this.box.view.setColorPaletteType(this.colorPaletteType);
        this.box.view.setFrankOn(this.brand);
        this.box.view.setHeatMapType(this.heatMapType);
        float xColorPalette = this.colorPaletteX > 1.0f ? this.colorPaletteX / (float)this.box.view.getWidth() : this.colorPaletteX;
        float yColorPalette = this.colorPaletteY > 1.0f ? this.colorPaletteY / (float)this.box.view.getHeight() : this.colorPaletteY;
        float wColorPalette = this.colorPaletteW > 1.0f ? this.colorPaletteW / (float)this.box.view.getWidth() : this.colorPaletteW;
        float hColorPalette = this.colorPaletteH > 1.0f ? this.colorPaletteH / (float)this.box.view.getHeight() : this.colorPaletteH;
        this.box.view.setColorPaletteRectangle(xColorPalette, yColorPalette, wColorPalette, hColorPalette);
        this.box.view.setMinimumTemperature(this.minimumTemperature);
        this.box.view.setMaximumTemperature(this.maximumTemperature);
        this.box.view.setFanRotationSpeedScaleFactor(this.fanRotationSpeedScaleFactor);
        this.box.view.setClockOn(this.clock);
        this.box.view.setSmooth(this.smooth);
        this.box.view.setGraphOn(this.graphOn);
        if (this.graphXLabel != null) {
            this.box.view.setGraphXLabel(this.graphXLabel);
        }
        if (this.graphYLabel != null) {
            this.box.view.setGraphYLabel(this.graphYLabel);
        }
        if (this.graphYmin != 0.0f) {
            this.box.view.setGraphYmin(this.graphYmin);
        }
        if (this.graphYmax != 0.0f) {
            this.box.view.setGraphYmax(this.graphYmax);
        }
        if (!(thermometers = this.box.model.getThermometers()).isEmpty()) {
            List<Thermometer> list2 = thermometers;
            synchronized (list2) {
                for (Thermometer thermometer : thermometers) {
                    Rectangle2D.Float r = (Rectangle2D.Float)thermometer.getShape();
                    r.width = 0.01f * this.modelWidth;
                    r.height = 0.05f * this.modelHeight;
                    r.x -= 0.5f * r.width;
                    r.y -= 0.5f * r.height;
                }
            }
        }
        if (!(heatFluxSensors = this.box.model.getHeatFluxSensors()).isEmpty()) {
            List<HeatFluxSensor> list3 = heatFluxSensors;
            synchronized (list3) {
                for (HeatFluxSensor h : heatFluxSensors) {
                    Rectangle2D.Float r = (Rectangle2D.Float)h.getShape();
                    r.width = 0.036f * this.modelWidth;
                    r.height = 0.012f * this.modelHeight;
                    r.x -= 0.5f * r.width;
                    r.y -= 0.5f * r.height;
                }
            }
        }
        if (!(list = this.box.model.getAnemometers()).isEmpty()) {
            List<Anemometer> list4 = list;
            synchronized (list4) {
                for (Anemometer a : list) {
                    Rectangle2D.Float r = (Rectangle2D.Float)a.getShape();
                    r.width = 0.05f * this.modelWidth;
                    r.height = 0.05f * this.modelHeight;
                    r.x -= 0.5f * r.width;
                    r.y -= 0.5f * r.height;
                }
            }
        }
        this.box.model.refreshPowerArray();
        this.box.model.refreshTemperatureBoundaryArray();
        this.box.model.refreshMaterialPropertyArrays();
        this.box.model.setInitialTemperature();
        if (this.box.model.isRadiative()) {
            this.box.model.generateViewFactorMesh();
        }
        this.box.view.repaint();
        this.resetGlobalVariables();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrib) {
        this.str = null;
        if (qName == "task") {
            if (attrib != null) {
                boolean enabled = true;
                int interval = -1;
                int lifetime = Integer.MAX_VALUE;
                int priority = 1;
                String uid = null;
                String description = null;
                String script = null;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "interval") {
                        interval = Integer.parseInt(attribValue);
                    } else if (attribName == "lifetime") {
                        lifetime = Integer.parseInt(attribValue);
                    } else if (attribName == "priority") {
                        priority = Integer.parseInt(attribValue);
                    } else if (attribName == "uid") {
                        uid = attribValue;
                    } else if (attribName == "description") {
                        description = attribValue;
                    } else if (attribName == "script") {
                        script = attribValue;
                    } else if (attribName == "enabled") {
                        enabled = Boolean.parseBoolean(attribValue);
                    }
                    ++i;
                }
                Task t = new Task(uid, interval, lifetime){

                    @Override
                    public void execute() {
                        if (this.getScript() != null) {
                            ((XmlDecoder)XmlDecoder.this).box.taskManager.runScript(this.getScript());
                        }
                    }
                };
                t.setSystemTask(false);
                t.setEnabled(enabled);
                t.setScript(new XmlCharacterDecoder().decode(script));
                t.setDescription(new XmlCharacterDecoder().decode(description));
                t.setPriority(priority);
                this.box.taskManager.add(t);
                this.box.taskManager.processPendingRequests();
            }
        } else if (qName == "rectangle") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                float w = Float.NaN;
                float h = Float.NaN;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "width") {
                        w = Float.parseFloat(attribValue);
                    } else if (attribName == "height") {
                        h = Float.parseFloat(attribValue);
                    }
                    ++i;
                }
                if (!(Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(w) || Float.isNaN(h))) {
                    this.part = this.box.model.addRectangularPart(x, y, w, h);
                }
            }
        } else if (qName == "ellipse") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                float a = Float.NaN;
                float b = Float.NaN;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "a") {
                        a = Float.parseFloat(attribValue);
                    } else if (attribName == "b") {
                        b = Float.parseFloat(attribValue);
                    }
                    ++i;
                }
                if (!(Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(a) || Float.isNaN(b))) {
                    this.part = this.box.model.addEllipticalPart(x, y, a, b);
                }
            }
        } else if (qName == "ring") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                float inner = Float.NaN;
                float outer = Float.NaN;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "inner") {
                        inner = Float.parseFloat(attribValue);
                    } else if (attribName == "outer") {
                        outer = Float.parseFloat(attribValue);
                    }
                    ++i;
                }
                if (!(Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(inner) || Float.isNaN(outer))) {
                    this.part = this.box.model.addRingPart(x, y, inner, outer);
                }
            }
        } else if (qName == "polygon") {
            if (attrib != null) {
                int count = -1;
                String vertices = null;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "count") {
                        count = Integer.parseInt(attribValue);
                    } else if (attribName == "vertices") {
                        vertices = attribValue;
                    }
                    ++i;
                }
                if (count > 0 && vertices != null) {
                    float[] v = Scripter.parseArray(count * 2, vertices);
                    float[] x = new float[count];
                    float[] y = new float[count];
                    int i2 = 0;
                    while (i2 < count) {
                        x[i2] = v[2 * i2];
                        y[i2] = v[2 * i2 + 1];
                        ++i2;
                    }
                    this.part = this.box.model.addPolygonPart(x, y);
                }
            }
        } else if (qName == "blob") {
            if (attrib != null) {
                int count = -1;
                String points = null;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "count") {
                        count = Integer.parseInt(attribValue);
                    } else if (attribName == "points") {
                        points = attribValue;
                    }
                    ++i;
                }
                if (count > 0 && points != null) {
                    float[] v = Scripter.parseArray(count * 2, points);
                    float[] x = new float[count];
                    float[] y = new float[count];
                    int i3 = 0;
                    while (i3 < count) {
                        x[i3] = v[2 * i3];
                        y[i3] = v[2 * i3 + 1];
                        ++i3;
                    }
                    this.part = this.box.model.addBlobPart(x, y);
                }
            }
        } else if (qName == "particle") {
            this.particle = new Particle();
            this.box.model.addParticle(this.particle);
        } else if (qName == "temperature_at_border") {
            if (attrib != null) {
                float left = Float.NaN;
                float right = Float.NaN;
                float upper = Float.NaN;
                float lower = Float.NaN;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "left") {
                        left = Float.parseFloat(attribValue);
                    } else if (attribName == "right") {
                        right = Float.parseFloat(attribValue);
                    } else if (attribName == "upper") {
                        upper = Float.parseFloat(attribValue);
                    } else if (attribName == "lower") {
                        lower = Float.parseFloat(attribValue);
                    }
                    ++i;
                }
                if (!(Float.isNaN(left) || Float.isNaN(right) || Float.isNaN(upper) || Float.isNaN(lower))) {
                    DirichletThermalBoundary b = null;
                    ThermalBoundary boundary = this.box.model.getThermalBoundary();
                    if (boundary instanceof DirichletThermalBoundary) {
                        b = (DirichletThermalBoundary)boundary;
                    } else {
                        b = new DirichletThermalBoundary();
                        this.box.model.setThermalBoundary(b);
                    }
                    b.setTemperatureAtBorder((byte)0, upper);
                    b.setTemperatureAtBorder((byte)1, right);
                    b.setTemperatureAtBorder((byte)2, lower);
                    b.setTemperatureAtBorder((byte)3, left);
                }
            }
        } else if (qName == "flux_at_border") {
            if (attrib != null) {
                float left = Float.NaN;
                float right = Float.NaN;
                float upper = Float.NaN;
                float lower = Float.NaN;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "left") {
                        left = Float.parseFloat(attribValue);
                    } else if (attribName == "right") {
                        right = Float.parseFloat(attribValue);
                    } else if (attribName == "upper") {
                        upper = Float.parseFloat(attribValue);
                    } else if (attribName == "lower") {
                        lower = Float.parseFloat(attribValue);
                    }
                    ++i;
                }
                if (!(Float.isNaN(left) || Float.isNaN(right) || Float.isNaN(upper) || Float.isNaN(lower))) {
                    NeumannThermalBoundary b = null;
                    ThermalBoundary boundary = this.box.model.getThermalBoundary();
                    if (boundary instanceof NeumannThermalBoundary) {
                        b = (NeumannThermalBoundary)boundary;
                    } else {
                        b = new NeumannThermalBoundary();
                        this.box.model.setThermalBoundary(b);
                    }
                    b.setFluxAtBorder((byte)0, upper);
                    b.setFluxAtBorder((byte)1, right);
                    b.setFluxAtBorder((byte)2, lower);
                    b.setFluxAtBorder((byte)3, left);
                }
            }
        } else if (qName == "mass_flow_at_border") {
            if (attrib != null) {
                byte left = 0;
                byte right = 0;
                byte upper = 0;
                byte lower = 0;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "left") {
                        left = Byte.parseByte(attribValue);
                    } else if (attribName == "right") {
                        right = Byte.parseByte(attribValue);
                    } else if (attribName == "upper") {
                        upper = Byte.parseByte(attribValue);
                    } else if (attribName == "lower") {
                        lower = Byte.parseByte(attribValue);
                    }
                    ++i;
                }
                SimpleMassBoundary b = (SimpleMassBoundary)this.box.model.getMassBoundary();
                b.setFlowTypeAtBorder((byte)0, upper);
                b.setFlowTypeAtBorder((byte)1, right);
                b.setFlowTypeAtBorder((byte)2, lower);
                b.setFlowTypeAtBorder((byte)3, left);
            }
        } else if (qName == "thermometer") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                String label = null;
                String uid = null;
                String attachID = null;
                byte stencil = 1;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "stencil") {
                        stencil = Byte.parseByte(attribValue);
                    } else if (attribName == "uid") {
                        uid = attribValue;
                    } else if (attribName == "attach") {
                        attachID = attribValue;
                    } else if (attribName == "label") {
                        label = attribValue;
                    }
                    ++i;
                }
                if (!Float.isNaN(x) && !Float.isNaN(y)) {
                    Thermometer t = this.box.model.addThermometer(x, y, uid, label, stencil);
                    if (attachID != null) {
                        t.setAttachID(attachID);
                    }
                }
            }
        } else if (qName == "heat_flux_sensor") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                String label = null;
                String uid = null;
                String attachID = null;
                float angle = 0.0f;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "angle") {
                        angle = Float.parseFloat(attribValue);
                    } else if (attribName == "uid") {
                        uid = attribValue;
                    } else if (attribName == "attach") {
                        attachID = attribValue;
                    } else if (attribName == "label") {
                        label = attribValue;
                    }
                    ++i;
                }
                if (!Float.isNaN(x) && !Float.isNaN(y)) {
                    HeatFluxSensor h = this.box.model.addHeatFluxSensor(x, y, uid, label, angle);
                    if (attachID != null) {
                        h.setAttachID(attachID);
                    }
                }
            }
        } else if (qName == "anemometer") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                String label = null;
                String uid = null;
                String attachID = null;
                byte stencil = 1;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "stencil") {
                        stencil = Byte.parseByte(attribValue);
                    } else if (attribName == "uid") {
                        uid = attribValue;
                    } else if (attribName == "attach") {
                        attachID = attribValue;
                    } else if (attribName == "label") {
                        label = attribValue;
                    }
                    ++i;
                }
                if (!Float.isNaN(x) && !Float.isNaN(y)) {
                    Anemometer a = this.box.model.addAnemometer(x, y, uid, label, stencil);
                    if (attachID != null) {
                        a.setAttachID(attachID);
                    }
                }
            }
        } else if (qName == "thermostat") {
            if (attrib != null) {
                Part p;
                float setpoint = Float.NaN;
                float deadband = Float.NaN;
                String thermometerUID = null;
                String powerSourceUID = null;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "set_point") {
                        setpoint = Float.parseFloat(attribValue);
                    } else if (attribName == "deadband") {
                        deadband = Float.parseFloat(attribValue);
                    } else if (attribName == "thermometer") {
                        thermometerUID = attribValue;
                    } else if (attribName == "power_source") {
                        powerSourceUID = attribValue;
                    }
                    ++i;
                }
                if (!Float.isNaN(setpoint) && !Float.isNaN(deadband) && powerSourceUID != null && (p = this.box.model.getPart(powerSourceUID)) != null) {
                    Thermometer t = null;
                    if (thermometerUID != null) {
                        t = this.box.model.getThermometer(thermometerUID);
                    }
                    Thermostat ts = this.box.model.addThermostat(t, p);
                    ts.setDeadband(deadband);
                    ts.setSetPoint(setpoint);
                }
            }
        } else if (qName == "cloud") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                float w = Float.NaN;
                float h = Float.NaN;
                float speed = 0.0f;
                String label = null;
                String uid = null;
                Color color = Color.WHITE;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "width") {
                        w = Float.parseFloat(attribValue);
                    } else if (attribName == "height") {
                        h = Float.parseFloat(attribValue);
                    } else if (attribName == "speed") {
                        speed = Float.parseFloat(attribValue);
                    } else if (attribName == "uid") {
                        uid = attribValue;
                    } else if (attribName == "label") {
                        label = attribValue;
                    } else if (attribName == "color") {
                        color = new Color(Integer.parseInt(attribValue, 16));
                    }
                    ++i;
                }
                if (!(Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(w) || Float.isNaN(h))) {
                    Cloud c = new Cloud(new Rectangle2D.Float(0.0f, 0.0f, w, h));
                    c.setX(x);
                    c.setY(y);
                    c.setSpeed(speed);
                    c.setUid(uid);
                    c.setLabel(label);
                    c.setColor(color);
                    this.box.model.addCloud(c);
                }
            }
        } else if (qName == "tree") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                float w = Float.NaN;
                float h = Float.NaN;
                byte type = 0;
                String label = null;
                String uid = null;
                Color color = Color.GREEN.darker();
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "width") {
                        w = Float.parseFloat(attribValue);
                    } else if (attribName == "height") {
                        h = Float.parseFloat(attribValue);
                    } else if (attribName == "type") {
                        type = Byte.parseByte(attribValue);
                    } else if (attribName == "uid") {
                        uid = attribValue;
                    } else if (attribName == "label") {
                        label = attribValue;
                    } else if (attribName == "color") {
                        color = new Color(Integer.parseInt(attribValue, 16));
                    }
                    ++i;
                }
                if (!(Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(w) || Float.isNaN(h))) {
                    Tree t = new Tree(new Rectangle2D.Float(0.0f, 0.0f, w, h), type);
                    t.setX(x);
                    t.setY(y);
                    t.setUid(uid);
                    t.setLabel(label);
                    t.setColor(color);
                    this.box.model.addTree(t);
                }
            }
        } else if (qName == "text") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                int size = 14;
                int style = 0;
                String str = null;
                String face = null;
                String uid = null;
                Color color = null;
                boolean border = false;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "uid") {
                        uid = attribValue;
                    } else if (attribName == "string") {
                        str = attribValue;
                    } else if (attribName == "size") {
                        size = Integer.parseInt(attribValue);
                    } else if (attribName == "style") {
                        style = Integer.parseInt(attribValue);
                    } else if (attribName == "name") {
                        face = attribValue;
                    } else if (attribName == "face") {
                        face = attribValue;
                    } else if (attribName == "color") {
                        color = new Color(Integer.parseInt(attribValue, 16));
                    } else if (attribName == "border") {
                        border = Boolean.parseBoolean(attribValue);
                    }
                    ++i;
                }
                if (!Float.isNaN(x) && !Float.isNaN(y)) {
                    TextBox t = this.box.view.addText(new XmlCharacterDecoder().decode(str), x, y);
                    t.setUid(uid);
                    t.setSize(size);
                    t.setStyle(style);
                    t.setFace(face);
                    t.setColor(color);
                    t.setBorder(border);
                    this.box.view.repaint();
                }
            }
        } else if (qName == "fan") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                float w = Float.NaN;
                float h = Float.NaN;
                String label = null;
                String uid = null;
                float speed = 0.0f;
                float angle = 0.0f;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "width") {
                        w = Float.parseFloat(attribValue);
                    } else if (attribName == "height") {
                        h = Float.parseFloat(attribValue);
                    } else if (attribName == "speed") {
                        speed = Float.parseFloat(attribValue);
                    } else if (attribName == "angle") {
                        angle = Float.parseFloat(attribValue);
                    } else if (attribName == "uid") {
                        uid = attribValue;
                    } else if (attribName == "label") {
                        label = attribValue;
                    }
                    ++i;
                }
                if (!(Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(w) || Float.isNaN(h))) {
                    Fan f = new Fan(new Rectangle2D.Float(x, y, w, h));
                    f.setUid(uid);
                    f.setLabel(label);
                    f.setSpeed(speed);
                    f.setAngle(angle);
                    this.box.model.addFan(f);
                }
            }
        } else if (qName == "heliostat") {
            if (attrib != null) {
                float x = Float.NaN;
                float y = Float.NaN;
                float w = Float.NaN;
                float h = Float.NaN;
                String label = null;
                String uid = null;
                String targetID = null;
                byte type = 0;
                int i = 0;
                int n = attrib.getLength();
                while (i < n) {
                    String attribName = attrib.getQName(i).intern();
                    String attribValue = attrib.getValue(i);
                    if (attribName == "x") {
                        x = Float.parseFloat(attribValue);
                    } else if (attribName == "y") {
                        y = Float.parseFloat(attribValue);
                    } else if (attribName == "type") {
                        type = Byte.parseByte(attribValue);
                    } else if (attribName == "width") {
                        w = Float.parseFloat(attribValue);
                    } else if (attribName == "height") {
                        h = Float.parseFloat(attribValue);
                    } else if (attribName == "uid") {
                        uid = attribValue;
                    } else if (attribName == "target") {
                        targetID = attribValue;
                    } else if (attribName == "label") {
                        label = attribValue;
                    }
                    ++i;
                }
                if (!(Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(w) || Float.isNaN(h))) {
                    Heliostat hs = new Heliostat(new Rectangle2D.Float(x, y, w, h), this.box.model);
                    hs.setUid(uid);
                    hs.setType(type);
                    hs.setLabel(label);
                    if (targetID != null) {
                        hs.setTarget(this.box.model.getPart(targetID));
                    }
                    this.box.model.addHeliostat(hs);
                }
            }
        } else if (qName == "particle_feeder" && attrib != null) {
            float x = Float.NaN;
            float y = Float.NaN;
            float mass = Float.NaN;
            float radius = Float.NaN;
            String label = null;
            String uid = null;
            float period = Float.NaN;
            int maximum = 0;
            Color color = Color.WHITE;
            Color velocityColor = Color.BLACK;
            int i = 0;
            int n = attrib.getLength();
            while (i < n) {
                String attribName = attrib.getQName(i).intern();
                String attribValue = attrib.getValue(i);
                if (attribName == "x") {
                    x = Float.parseFloat(attribValue);
                } else if (attribName == "y") {
                    y = Float.parseFloat(attribValue);
                } else if (attribName == "mass") {
                    mass = Float.parseFloat(attribValue);
                } else if (attribName == "radius") {
                    radius = Float.parseFloat(attribValue);
                } else if (attribName == "period") {
                    period = Float.parseFloat(attribValue);
                } else if (attribName == "maximum") {
                    maximum = Integer.parseInt(attribValue);
                } else if (attribName == "uid") {
                    uid = attribValue;
                } else if (attribName == "label") {
                    label = attribValue;
                } else if (attribName == "color") {
                    color = new Color(Integer.parseInt(attribValue, 16));
                } else if (attribName == "velocity_color") {
                    velocityColor = new Color(Integer.parseInt(attribValue, 16));
                }
                ++i;
            }
            if (!Float.isNaN(x) && !Float.isNaN(y)) {
                ParticleFeeder pf = new ParticleFeeder(x, y);
                pf.setUid(uid);
                pf.setLabel(label);
                pf.setColor(color);
                pf.setVelocityColor(velocityColor);
                if (!Float.isNaN(mass)) {
                    pf.setMass(mass);
                }
                if (!Float.isNaN(radius)) {
                    pf.setRadius(radius);
                }
                if (!Float.isNaN(period)) {
                    pf.setPeriod(period);
                }
                if (maximum > 0) {
                    pf.setMaximum(maximum);
                }
                this.box.model.addParticleFeeder(pf);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName == "next_sim") {
            this.nextSim = this.str;
        } else if (qName == "prev_sim") {
            this.prevSim = this.str;
        } else if (qName == "model_width") {
            this.modelWidth = Float.parseFloat(this.str);
        } else if (qName == "model_height") {
            this.modelHeight = Float.parseFloat(this.str);
        } else if (qName == "timestep") {
            this.timeStep = Float.parseFloat(this.str);
        } else if (qName == "measurement_interval") {
            this.measurementInterval = Integer.parseInt(this.str);
        } else if (qName == "control_interval") {
            this.controlInterval = Integer.parseInt(this.str);
        } else if (qName == "viewupdate_interval") {
            this.viewUpdateInterval = Integer.parseInt(this.str);
        } else if (qName == "sunny") {
            this.sunny = Boolean.parseBoolean(this.str);
        } else if (qName == "sun_angle") {
            this.sunAngle = Float.parseFloat(this.str);
        } else if (qName == "solar_power_density") {
            this.solarPowerDensity = Float.parseFloat(this.str);
        } else if (qName == "solar_ray_count") {
            this.solarRayCount = Integer.parseInt(this.str);
        } else if (qName == "solar_ray_speed") {
            this.solarRaySpeed = Float.parseFloat(this.str);
        } else if (qName == "photon_emission_interval") {
            this.photonEmissionInterval = Integer.parseInt(this.str);
        } else if (qName == "perimeter_step_size") {
            this.perimeterStepSize = Float.parseFloat(this.str);
        } else if (qName == "z_heat_diffusivity") {
            this.zHeatDiffusivity = Float.parseFloat(this.str);
        } else if (qName == "gravitational_acceleration") {
            this.gravitationalAcceleration = Float.parseFloat(this.str);
        } else if (qName == "thermophoretic_coefficient") {
            this.thermophoreticCoefficient = Float.parseFloat(this.str);
        } else if (qName == "particle_drag") {
            this.particleDrag = Float.parseFloat(this.str);
        } else if (qName == "particle_hardness") {
            this.particleHardness = Float.parseFloat(this.str);
        } else if (qName == "convective") {
            this.convective = Boolean.parseBoolean(this.str);
        } else if (qName == "background_conductivity") {
            this.backgroundConductivity = Float.parseFloat(this.str);
        } else if (qName == "background_density") {
            this.backgroundDensity = Float.parseFloat(this.str);
        } else if (qName == "background_specific_heat") {
            this.backgroundSpecificHeat = Float.parseFloat(this.str);
        } else if (qName == "background_temperature") {
            this.backgroundTemperature = Float.parseFloat(this.str);
        } else if (qName == "background_viscosity") {
            this.backgroundViscosity = Float.parseFloat(this.str);
        } else if (qName == "thermal_buoyancy" || qName == "thermal_expansion_coefficient") {
            this.thermalExpansionCoefficient = Float.parseFloat(this.str);
        } else if (qName == "buoyancy_approximation") {
            this.buoyancyApproximation = Byte.parseByte(this.str);
        } else if (qName == "gravity_type") {
            this.gravityType = Byte.parseByte(this.str);
        } else if (qName == "minimum_temperature") {
            this.minimumTemperature = Float.parseFloat(this.str);
        } else if (qName == "maximum_temperature") {
            this.maximumTemperature = Float.parseFloat(this.str);
        } else if (qName == "fan_rotation_speed_scale_factor") {
            this.fanRotationSpeedScaleFactor = Float.parseFloat(this.str);
        } else if (qName == "graph_data_type") {
            this.graphDataType = Byte.parseByte(this.str);
        } else if (qName == "graph_time_unit") {
            this.graphTimeUnit = Byte.parseByte(this.str);
        } else if (qName == "view_factor_lines") {
            this.viewFactorLines = Boolean.parseBoolean(this.str);
        } else if (qName == "ruler" || qName == "border_tickmarks") {
            this.borderTickmarks = Boolean.parseBoolean(this.str);
        } else if (qName == "fahrenheit_used") {
            this.fahrenheitUsed = Boolean.parseBoolean(this.str);
        } else if (qName == "isotherm") {
            this.isotherm = Boolean.parseBoolean(this.str);
        } else if (qName == "streamline") {
            this.streamline = Boolean.parseBoolean(this.str);
        } else if (qName == "velocity") {
            this.velocity = Boolean.parseBoolean(this.str);
        } else if (qName == "heat_flux_arrow") {
            this.heatFluxArrows = Boolean.parseBoolean(this.str);
        } else if (qName == "heat_flux_line") {
            this.heatFluxLines = Boolean.parseBoolean(this.str);
        } else if (qName == "grid") {
            this.grid = Boolean.parseBoolean(this.str);
        } else if (qName == "snap_to_grid") {
            this.snapToGrid = Boolean.parseBoolean(this.str);
        } else if (qName == "grid_size") {
            this.gridSize = Integer.parseInt(this.str);
        } else if (qName == "color_palette") {
            this.colorPalette = Boolean.parseBoolean(this.str);
        } else if (qName == "color_palette_type") {
            this.colorPaletteType = Byte.parseByte(this.str);
        } else if (qName == "brand") {
            this.brand = Boolean.parseBoolean(this.str);
        } else if (qName == "control_panel") {
            this.controlPanel = Boolean.parseBoolean(this.str);
        } else if (qName == "heat_map") {
            this.heatMapType = Byte.parseByte(this.str);
        } else if (qName == "color_palette_x") {
            this.colorPaletteX = Float.parseFloat(this.str);
        } else if (qName == "color_palette_y") {
            this.colorPaletteY = Float.parseFloat(this.str);
        } else if (qName == "color_palette_w") {
            this.colorPaletteW = Float.parseFloat(this.str);
        } else if (qName == "color_palette_h") {
            this.colorPaletteH = Float.parseFloat(this.str);
        } else if (qName == "clock") {
            this.clock = Boolean.parseBoolean(this.str);
        } else if (qName == "smooth") {
            this.smooth = Boolean.parseBoolean(this.str);
        } else if (qName == "graph") {
            this.graphOn = Boolean.parseBoolean(this.str);
        } else if (qName == "graph_xlabel") {
            this.graphXLabel = this.str;
        } else if (qName == "graph_ylabel") {
            this.graphYLabel = this.str;
        } else if (qName == "graph_ymin") {
            this.graphYmin = Float.parseFloat(this.str);
        } else if (qName == "graph_ymax") {
            this.graphYmax = Float.parseFloat(this.str);
        } else if (qName == "elasticity") {
            this.partElasticity = Float.parseFloat(this.str);
        } else if (qName == "thermal_conductivity") {
            this.partThermalConductivity = Float.parseFloat(this.str);
        } else if (qName == "specific_heat") {
            this.partSpecificHeat = Float.parseFloat(this.str);
        } else if (qName == "density") {
            this.partDensity = Float.parseFloat(this.str);
        } else if (qName == "emissivity") {
            this.partEmissivity = Float.parseFloat(this.str);
        } else if (qName == "absorption") {
            this.partAbsorption = Float.parseFloat(this.str);
        } else if (qName == "reflection") {
            this.partReflection = Float.parseFloat(this.str);
        } else if (qName == "scattering") {
            this.partScattering = Boolean.parseBoolean(this.str);
        } else if (qName == "scattering_visible") {
            this.partScatteringVisible = Boolean.parseBoolean(this.str);
        } else if (qName == "transmission") {
            this.partTransmission = Float.parseFloat(this.str);
        } else if (qName == "constant_temperature") {
            this.partConstantTemperature = Boolean.parseBoolean(this.str);
        } else if (qName == "power") {
            this.partPower = Float.parseFloat(this.str);
        } else if (qName == "temperature_coefficient") {
            this.partTemperatureCoefficient = Float.parseFloat(this.str);
        } else if (qName == "reference_temperature") {
            this.partReferenceTemperature = Float.parseFloat(this.str);
        } else if (qName == "wind_speed") {
            this.fanSpeed = Float.parseFloat(this.str);
        } else if (qName == "wind_angle") {
            this.fanAngle = Float.parseFloat(this.str);
        } else if (qName == "texture_style") {
            this.partTextureStyle = Byte.parseByte(this.str);
        } else if (qName == "texture_width") {
            this.partTextureWidth = Integer.parseInt(this.str);
        } else if (qName == "texture_height") {
            this.partTextureHeight = Integer.parseInt(this.str);
        } else if (qName == "texture_fg") {
            this.partTextureForeground = new Color(Integer.parseInt(this.str, 16));
        } else if (qName == "texture_bg") {
            this.partTextureBackground = new Color(Integer.parseInt(this.str, 16));
        } else if (qName == "filled") {
            this.partFilled = Boolean.parseBoolean(this.str);
        } else if (qName == "visible") {
            this.partVisible = Boolean.parseBoolean(this.str);
        } else if (qName == "draggable") {
            this.draggable = Boolean.parseBoolean(this.str);
        } else if (qName == "movable") {
            this.movable = Boolean.parseBoolean(this.str);
        } else if (qName == "color") {
            this.color = new Color(Integer.parseInt(this.str, 16));
        } else if (qName == "velocity_color") {
            this.velocityColor = new Color(Integer.parseInt(this.str, 16));
        } else if (qName == "rx") {
            this.particleRx = Float.parseFloat(this.str);
        } else if (qName == "ry") {
            this.particleRy = Float.parseFloat(this.str);
        } else if (qName == "vx") {
            this.particleVx = Float.parseFloat(this.str);
        } else if (qName == "vy") {
            this.particleVy = Float.parseFloat(this.str);
        } else if (qName == "theta") {
            this.particleTheta = Float.parseFloat(this.str);
        } else if (qName == "omega") {
            this.particleOmega = Float.parseFloat(this.str);
        } else if (qName == "radius") {
            this.particleRadius = Float.parseFloat(this.str);
        } else if (qName == "mass") {
            this.particleMass = Float.parseFloat(this.str);
        } else if (qName == "uid") {
            this.uid = this.str;
        } else if (qName == "label") {
            this.label = this.str;
        } else if (qName == "temperature") {
            this.temperature = Float.parseFloat(this.str);
        } else if (qName != "boundary") {
            if (qName == "part") {
                if (this.part != null) {
                    if (!Float.isNaN(this.partThermalConductivity)) {
                        this.part.setThermalConductivity(this.partThermalConductivity);
                    }
                    if (!Float.isNaN(this.partSpecificHeat)) {
                        this.part.setSpecificHeat(this.partSpecificHeat);
                    }
                    if (!Float.isNaN(this.partDensity)) {
                        this.part.setDensity(this.partDensity);
                    }
                    if (!Float.isNaN(this.temperature)) {
                        this.part.setTemperature(this.temperature);
                    }
                    if (!Float.isNaN(this.partPower)) {
                        this.part.setPower(this.partPower);
                    }
                    if (!Float.isNaN(this.partEmissivity)) {
                        this.part.setEmissivity(this.partEmissivity);
                    }
                    if (!Float.isNaN(this.partAbsorption)) {
                        this.part.setAbsorptivity(this.partAbsorption);
                    }
                    if (!Float.isNaN(this.partReflection)) {
                        this.part.setReflectivity(this.partReflection);
                    }
                    if (!Float.isNaN(this.partTransmission)) {
                        this.part.setTransmissivity(this.partTransmission);
                    }
                    this.part.setElasticity(this.partElasticity);
                    this.part.setScattering(this.partScattering);
                    this.part.setScatteringVisible(this.partScatteringVisible);
                    this.part.setThermistorTemperatureCoefficient(this.partTemperatureCoefficient);
                    this.part.setThermistorReferenceTemperature(this.partReferenceTemperature);
                    this.part.setWindAngle(this.fanAngle);
                    this.part.setWindSpeed(this.fanSpeed);
                    this.part.setConstantTemperature(this.partConstantTemperature);
                    this.part.setDraggable(this.draggable);
                    this.part.setVisible(this.partVisible);
                    if (this.color != null) {
                        this.part.setFillPattern(new ColorFill(this.color));
                    }
                    if (this.partTextureStyle != 0) {
                        this.part.setFillPattern(new Texture(this.partTextureForeground.getRGB(), this.partTextureBackground.getRGB(), this.partTextureStyle, this.partTextureWidth, this.partTextureHeight));
                    }
                    this.part.setFilled(this.partFilled);
                    this.part.setUid(this.uid);
                    this.part.setLabel(this.label);
                    this.resetPartVariables();
                }
            } else if (qName == "particle" && this.particle != null) {
                if (!Float.isNaN(this.particleRx)) {
                    this.particle.setRx(this.particleRx);
                }
                if (!Float.isNaN(this.particleRy)) {
                    this.particle.setRy(this.particleRy);
                }
                if (!Float.isNaN(this.particleVx)) {
                    this.particle.setVx(this.particleVx);
                }
                if (!Float.isNaN(this.particleVy)) {
                    this.particle.setVy(this.particleVy);
                }
                if (!Float.isNaN(this.particleTheta)) {
                    this.particle.setTheta(this.particleTheta);
                }
                if (!Float.isNaN(this.particleOmega)) {
                    this.particle.setOmega(this.particleOmega);
                }
                if (!Float.isNaN(this.particleRadius)) {
                    this.particle.setRadius(this.particleRadius);
                }
                if (!Float.isNaN(this.particleMass)) {
                    this.particle.setMass(this.particleMass);
                }
                if (!Float.isNaN(this.temperature)) {
                    this.particle.setTemperature(this.temperature);
                }
                if (this.color != null) {
                    this.particle.setColor(this.color);
                }
                if (this.velocityColor != null) {
                    this.particle.setVelocityColor(this.velocityColor);
                }
                this.particle.setUid(this.uid);
                this.particle.setLabel(this.label);
                this.particle.setMovable(this.movable);
                this.particle.setDraggable(this.draggable);
                this.particle.storeState();
                this.resetParticleVariables();
            }
        }
    }

    private void resetPartVariables() {
        this.partThermalConductivity = Float.NaN;
        this.partSpecificHeat = Float.NaN;
        this.partDensity = Float.NaN;
        this.partElasticity = 1.0f;
        this.partConstantTemperature = false;
        this.partPower = Float.NaN;
        this.partTemperatureCoefficient = 0.0f;
        this.partReferenceTemperature = 0.0f;
        this.partEmissivity = Float.NaN;
        this.partAbsorption = Float.NaN;
        this.partReflection = Float.NaN;
        this.partTransmission = Float.NaN;
        this.partScattering = false;
        this.partScatteringVisible = true;
        this.fanSpeed = 0.0f;
        this.fanAngle = 0.0f;
        this.partVisible = true;
        this.partFilled = true;
        this.partTextureStyle = 0;
        this.partTextureWidth = 10;
        this.partTextureHeight = 10;
        this.partTextureForeground = Color.BLACK;
        this.partTextureBackground = Color.WHITE;
        this.uid = null;
        this.label = null;
        this.color = null;
        this.temperature = Float.NaN;
        this.draggable = true;
    }

    private void resetParticleVariables() {
        this.particleRx = Float.NaN;
        this.particleRy = Float.NaN;
        this.particleVx = Float.NaN;
        this.particleVy = Float.NaN;
        this.particleTheta = Float.NaN;
        this.particleOmega = Float.NaN;
        this.particleRadius = Float.NaN;
        this.particleMass = Float.NaN;
        this.movable = true;
        this.uid = null;
        this.label = null;
        this.color = null;
        this.velocityColor = null;
        this.temperature = Float.NaN;
        this.draggable = true;
    }

    private void resetGlobalVariables() {
        this.nextSim = null;
        this.prevSim = null;
        this.modelWidth = 10.0f;
        this.modelHeight = 10.0f;
        this.timeStep = 1.0f;
        this.measurementInterval = 100;
        this.controlInterval = 100;
        this.viewUpdateInterval = 20;
        this.sunny = false;
        this.sunAngle = 1.5707964f;
        this.solarPowerDensity = 2000.0f;
        this.solarRayCount = 24;
        this.solarRaySpeed = 0.1f;
        this.photonEmissionInterval = 20;
        this.perimeterStepSize = 0.05f;
        this.zHeatDiffusivity = 0.0f;
        this.gravitationalAcceleration = -1.0f;
        this.thermophoreticCoefficient = 0.0f;
        this.particleDrag = -1.0f;
        this.particleHardness = -1.0f;
        this.convective = true;
        this.backgroundConductivity = 0.025f;
        this.backgroundDensity = 1.204f;
        this.backgroundSpecificHeat = 1012.0f;
        this.backgroundViscosity = 1.568E-5f;
        this.backgroundTemperature = 0.0f;
        this.thermalExpansionCoefficient = 0.0f;
        this.buoyancyApproximation = 1;
        this.gravityType = 0;
        this.graphDataType = 0;
        this.graphTimeUnit = 0;
        this.fahrenheitUsed = false;
        this.viewFactorLines = false;
        this.borderTickmarks = false;
        this.grid = false;
        this.snapToGrid = true;
        this.gridSize = 10;
        this.isotherm = false;
        this.streamline = false;
        this.colorPalette = false;
        this.colorPaletteType = 0;
        this.velocity = false;
        this.heatFluxArrows = false;
        this.heatFluxLines = false;
        this.graphOn = false;
        this.clock = true;
        this.brand = true;
        this.controlPanel = false;
        this.smooth = true;
        this.minimumTemperature = 0.0f;
        this.maximumTemperature = 50.0f;
        this.fanRotationSpeedScaleFactor = 1.0f;
        this.graphXLabel = null;
        this.graphYLabel = null;
        this.graphYmin = 0.0f;
        this.graphYmax = 50.0f;
        this.heatMapType = 1;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.str = this.str == null ? new String(ch, start, length) : String.valueOf(this.str) + new String(ch, start, length);
    }

    @Override
    public void warning(SAXParseException e) {
        e.printStackTrace();
    }

    @Override
    public void error(SAXParseException e) {
        e.printStackTrace();
    }

    @Override
    public void fatalError(SAXParseException e) {
        e.printStackTrace();
    }
}

