/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;
import org.concord.energy2d.system.Helper;
import org.concord.energy2d.system.System2D;

final class UpdateAnnouncer {
    private static final String HOME = "http://energy.concord.org/energy2d/";

    UpdateAnnouncer() {
    }

    static void showMessage(System2D box) {
        String s = UpdateAnnouncer.getJarLocation();
        if (!s.endsWith(".jar")) {
            return;
        }
        if (new File(s).lastModified() >= UpdateAnnouncer.checkTimeStamp("http://energy.concord.org/energy2d/energy2d.jar")) {
            return;
        }
        String msg = "An update is available. Do you want to download it now?";
        if (JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(box.view), msg, "Update Energy2D", 0) == 0) {
            Helper.openBrowser("http://energy.concord.org/energy2d/update.html");
            System.exit(0);
        }
    }

    private static long checkTimeStamp(String s) {
        URLConnection connection = null;
        try {
            connection = new URL(s).openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        if (!(connection instanceof HttpURLConnection)) {
            return -1L;
        }
        HttpURLConnection c = (HttpURLConnection)connection;
        try {
            c.setRequestMethod("HEAD");
        }
        catch (ProtocolException e) {
            e.printStackTrace();
            return -1L;
        }
        long t = c.getLastModified();
        c.disconnect();
        return t;
    }

    private static String getJarLocation() {
        String jarLocation = System.getProperty("java.class.path");
        if (System.getProperty("os.name").startsWith("Mac")) {
            jarLocation = UpdateAnnouncer.validateJarLocationOnMacOSX(jarLocation);
        }
        return jarLocation;
    }

    private static String validateJarLocationOnMacOSX(String jarLocation) {
        int i = jarLocation.indexOf(".jar:/");
        if (i != -1) {
            jarLocation = String.valueOf(jarLocation.substring(0, i)) + ".jar";
        }
        return jarLocation;
    }
}

