/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.concord.energy2d.event.GraphEvent;
import org.concord.energy2d.event.GraphListener;
import org.concord.energy2d.event.ManipulationEvent;
import org.concord.energy2d.event.ManipulationListener;
import org.concord.energy2d.system.System2D;
import org.concord.energy2d.system.ToolBarEvent;
import org.concord.energy2d.system.ToolBarListener;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.Symbol;

class ToolBar
extends JToolBar
implements GraphListener,
ToolBarListener,
ManipulationListener {
    private JToggleButton graphButton;
    private JToggleButton selectButton;
    private JToggleButton heatingButton;
    private System2D box;

    ToolBar(final System2D s2d) {
        super(0);
        this.setFloatable(false);
        this.box = s2d;
        this.box.view.addGraphListener(this);
        ButtonGroup bg = new ButtonGroup();
        this.selectButton = new JToggleButton(new ImageIcon(ToolBar.class.getResource("resources/select.png")));
        this.selectButton.setToolTipText("Select and move an object");
        this.selectButton.setSelected(true);
        this.selectButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((ToolBar)ToolBar.this).box.view.setActionMode((byte)0);
            }
        });
        this.add(this.selectButton);
        bg.add(this.selectButton);
        JToggleButton x = new JToggleButton(new ImageIcon(ToolBar.class.getResource("resources/rectangle.png")));
        x.setToolTipText("Draw a rectangle");
        x.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((ToolBar)ToolBar.this).box.view.setActionMode((byte)1);
            }
        });
        x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiscUtil.setSelectedSilently(ToolBar.this.graphButton, false);
            }
        });
        this.add(x);
        bg.add(x);
        x = new JToggleButton(new ImageIcon(ToolBar.class.getResource("resources/ellipse.png")));
        x.setToolTipText("Draw an ellipse");
        x.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((ToolBar)ToolBar.this).box.view.setActionMode((byte)2);
            }
        });
        x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiscUtil.setSelectedSilently(ToolBar.this.graphButton, false);
            }
        });
        this.add(x);
        bg.add(x);
        x = new JToggleButton(new ImageIcon(ToolBar.class.getResource("resources/polygon.png")));
        x.setToolTipText("Draw a polygon");
        x.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((ToolBar)ToolBar.this).box.view.setActionMode((byte)3);
            }
        });
        x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiscUtil.setSelectedSilently(ToolBar.this.graphButton, false);
            }
        });
        this.add(x);
        bg.add(x);
        x = new JToggleButton(new ImageIcon(ToolBar.class.getResource("resources/blob.png")));
        x.setToolTipText("Draw a blob");
        x.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((ToolBar)ToolBar.this).box.view.setActionMode((byte)4);
            }
        });
        x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiscUtil.setSelectedSilently(ToolBar.this.graphButton, false);
            }
        });
        this.add(x);
        bg.add(x);
        ImageIcon particleIcon = new ImageIcon(ToolBar.class.getResource("resources/particle.png"));
        final JToggleButton miscButton = new JToggleButton(particleIcon);
        final JRadioButtonMenuItem rbmiParticle = new JRadioButtonMenuItem("Particle", particleIcon, true);
        Symbol.ParticleFeederIcon particleFeederIcon = new Symbol.ParticleFeederIcon(Color.WHITE, Color.GRAY, true);
        particleFeederIcon.setStroke(new BasicStroke(3.0f));
        particleFeederIcon.setIconWidth(19);
        particleFeederIcon.setIconHeight(19);
        particleFeederIcon.setMarginX(7);
        particleFeederIcon.setMarginY(7);
        particleFeederIcon.setOffsetX(7);
        particleFeederIcon.setOffsetY(7);
        final JRadioButtonMenuItem rbmiParticleFeeder = new JRadioButtonMenuItem("Particle Feeder", particleFeederIcon, false);
        Symbol.FanIcon fanIcon = new Symbol.FanIcon(Color.WHITE, Color.BLACK, true);
        fanIcon.setIconWidth(32);
        fanIcon.setIconHeight(32);
        fanIcon.setSymbolWidth(32);
        fanIcon.setSymbolHeight(32);
        fanIcon.setOffsetX(1);
        fanIcon.setOffsetY(1);
        final JRadioButtonMenuItem rbmiFan = new JRadioButtonMenuItem("Fan", fanIcon, false);
        Symbol.HeliostatIcon heliostatIcon = new Symbol.HeliostatIcon(Color.WHITE, Color.BLACK, true);
        heliostatIcon.setAngle(0.3926991f);
        heliostatIcon.setIconWidth(32);
        heliostatIcon.setIconHeight(32);
        heliostatIcon.setSymbolWidth(32);
        heliostatIcon.setSymbolHeight(32);
        heliostatIcon.setOffsetX(1);
        heliostatIcon.setOffsetY(1);
        final JRadioButtonMenuItem rbmiHeliostat = new JRadioButtonMenuItem("Heliostat", heliostatIcon, false);
        Symbol.CloudIcon cloudIcon = new Symbol.CloudIcon(true);
        cloudIcon.setBorderColor(Color.BLACK);
        cloudIcon.setIconWidth(32);
        cloudIcon.setIconHeight(32);
        cloudIcon.setSymbolWidth(32);
        cloudIcon.setSymbolHeight(16);
        cloudIcon.setMarginY(8);
        cloudIcon.setOffsetY(8);
        final JRadioButtonMenuItem rbmiCloud = new JRadioButtonMenuItem("Cloud", cloudIcon, false);
        Symbol.TreeIcon treeIcon = new Symbol.TreeIcon(1, true);
        treeIcon.setBorderColor(Color.BLACK);
        treeIcon.setIconWidth(32);
        treeIcon.setIconHeight(32);
        treeIcon.setSymbolWidth(20);
        treeIcon.setSymbolHeight(32);
        treeIcon.setMarginX(6);
        treeIcon.setOffsetX(6);
        final JRadioButtonMenuItem rbmiTree = new JRadioButtonMenuItem("Tree", treeIcon, false);
        ActionListener miscChoiceAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButtonMenuItem selected = (JRadioButtonMenuItem)e.getSource();
                miscButton.setIcon(selected.getIcon());
                if (selected == rbmiParticle) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)31);
                    miscButton.setToolTipText("Drop a particle");
                } else if (selected == rbmiParticleFeeder) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)32);
                    miscButton.setToolTipText("Drop a particle feeder");
                } else if (selected == rbmiFan) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)33);
                    miscButton.setToolTipText("Drop a fan");
                } else if (selected == rbmiHeliostat) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)34);
                    miscButton.setToolTipText("Drop a heliostat");
                } else if (selected == rbmiCloud) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)35);
                    miscButton.setToolTipText("Drop a cloud");
                } else if (selected == rbmiTree) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)36);
                    miscButton.setToolTipText("Drop a tree");
                }
                miscButton.setSelected(true);
                s2d.view.requestFocusInWindow();
            }
        };
        rbmiParticle.addActionListener(miscChoiceAction);
        rbmiParticleFeeder.addActionListener(miscChoiceAction);
        rbmiFan.addActionListener(miscChoiceAction);
        rbmiHeliostat.addActionListener(miscChoiceAction);
        rbmiCloud.addActionListener(miscChoiceAction);
        rbmiTree.addActionListener(miscChoiceAction);
        final JPopupMenu miscMenu = new JPopupMenu();
        miscMenu.add(rbmiParticle);
        miscMenu.add(rbmiParticleFeeder);
        miscMenu.add(rbmiFan);
        miscMenu.add(rbmiHeliostat);
        miscMenu.add(rbmiCloud);
        miscMenu.add(rbmiTree);
        ButtonGroup bgMisc = new ButtonGroup();
        bgMisc.add(rbmiParticle);
        bgMisc.add(rbmiParticleFeeder);
        bgMisc.add(rbmiFan);
        bgMisc.add(rbmiHeliostat);
        bgMisc.add(rbmiCloud);
        bgMisc.add(rbmiTree);
        miscButton.setToolTipText("Drop a particle");
        miscButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (rbmiParticle.isSelected()) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)31);
                } else if (rbmiParticleFeeder.isSelected()) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)32);
                } else if (rbmiFan.isSelected()) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)33);
                } else if (rbmiHeliostat.isSelected()) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)34);
                } else if (rbmiCloud.isSelected()) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)35);
                } else if (rbmiTree.isSelected()) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)36);
                }
            }
        });
        this.add(miscButton);
        bg.add(miscButton);
        JButton arrowButton = new JButton();
        Dimension d = new Dimension(12, x.getMaximumSize().height);
        arrowButton.setMaximumSize(d);
        arrowButton.setIcon(new Symbol.ArrowHead(Color.BLACK, d.width, d.height));
        arrowButton.setToolTipText("Click to select the action using the button to the left");
        arrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                miscMenu.show(miscButton, 0, miscButton.getHeight());
            }
        });
        arrowButton.setBorder(BorderFactory.createEmptyBorder());
        arrowButton.setFocusPainted(false);
        this.add(arrowButton);
        Symbol.Thermometer thermometerIcon = new Symbol.Thermometer(true);
        thermometerIcon.setValue(5);
        thermometerIcon.setIconWidth(4);
        thermometerIcon.setIconHeight(24);
        thermometerIcon.setMarginX(14);
        thermometerIcon.setMarginY(4);
        thermometerIcon.setOffsetX(14);
        thermometerIcon.setOffsetY(4);
        final JToggleButton sensorButton = new JToggleButton(thermometerIcon);
        final JRadioButtonMenuItem rbmiThermometer = new JRadioButtonMenuItem("Thermometer", thermometerIcon, true);
        Symbol.HeatFluxSensor heatFluxSensorIcon = new Symbol.HeatFluxSensor(true);
        heatFluxSensorIcon.setIconWidth(24);
        heatFluxSensorIcon.setIconHeight(10);
        heatFluxSensorIcon.setMarginX(4);
        heatFluxSensorIcon.setMarginY(11);
        heatFluxSensorIcon.setOffsetX(4);
        heatFluxSensorIcon.setOffsetY(11);
        final JRadioButtonMenuItem rbmiHeatFluxSensor = new JRadioButtonMenuItem("Heat Flux Sensor", heatFluxSensorIcon, false);
        Symbol.Anemometer anemometerIcon = new Symbol.Anemometer(true);
        anemometerIcon.setIconWidth(24);
        anemometerIcon.setIconHeight(24);
        anemometerIcon.setMarginX(4);
        anemometerIcon.setMarginY(4);
        anemometerIcon.setOffsetX(4);
        anemometerIcon.setOffsetY(4);
        final JRadioButtonMenuItem rbmiAnemometer = new JRadioButtonMenuItem("Anemometer", anemometerIcon, false);
        ActionListener sensorChoiceAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButtonMenuItem selected = (JRadioButtonMenuItem)e.getSource();
                sensorButton.setIcon(selected.getIcon());
                if (selected == rbmiThermometer) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)11);
                    sensorButton.setToolTipText("Drop a thermometer");
                } else if (selected == rbmiHeatFluxSensor) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)12);
                    sensorButton.setToolTipText("Drop a heat flux sensor");
                } else if (selected == rbmiAnemometer) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)13);
                    sensorButton.setToolTipText("Drop an anemometer");
                }
                sensorButton.setSelected(true);
                s2d.view.requestFocusInWindow();
            }
        };
        rbmiThermometer.addActionListener(sensorChoiceAction);
        rbmiHeatFluxSensor.addActionListener(sensorChoiceAction);
        rbmiAnemometer.addActionListener(sensorChoiceAction);
        final JPopupMenu sensorMenu = new JPopupMenu();
        sensorMenu.add(rbmiThermometer);
        sensorMenu.add(rbmiHeatFluxSensor);
        sensorMenu.add(rbmiAnemometer);
        ButtonGroup bgSensor = new ButtonGroup();
        bgSensor.add(rbmiThermometer);
        bgSensor.add(rbmiHeatFluxSensor);
        bgSensor.add(rbmiAnemometer);
        sensorButton.setToolTipText("Drop a thermometer");
        sensorButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (rbmiThermometer.isSelected()) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)11);
                } else if (rbmiHeatFluxSensor.isSelected()) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)12);
                } else if (rbmiAnemometer.isSelected()) {
                    ((ToolBar)ToolBar.this).box.view.setActionMode((byte)13);
                }
                ToolBar.this.graphButton.setEnabled(true);
            }
        });
        sensorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiscUtil.setSelectedSilently(ToolBar.this.graphButton, false);
            }
        });
        this.add(sensorButton);
        bg.add(sensorButton);
        arrowButton = new JButton();
        arrowButton.setMaximumSize(d);
        arrowButton.setIcon(new Symbol.ArrowHead(Color.BLACK, d.width, d.height));
        arrowButton.setToolTipText("Click to select the sensor type to add using the button to the left");
        arrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sensorMenu.show(sensorButton, 0, sensorButton.getHeight());
            }
        });
        arrowButton.setBorder(BorderFactory.createEmptyBorder());
        arrowButton.setFocusPainted(false);
        this.add(arrowButton);
        this.graphButton = new JToggleButton(new ImageIcon(ToolBar.class.getResource("resources/graph.png")));
        this.graphButton.setEnabled(false);
        this.graphButton.setToolTipText("Show or hide graphs");
        this.graphButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JToggleButton src = (JToggleButton)e.getSource();
                ((ToolBar)ToolBar.this).box.view.setGraphOn(src.isSelected());
                ((ToolBar)ToolBar.this).box.view.repaint();
                ((ToolBar)ToolBar.this).box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        this.add(this.graphButton);
        this.heatingButton = new JToggleButton(new ImageIcon(ToolBar.class.getResource("resources/heat.png")));
        this.heatingButton.setToolTipText("Click to heat, shift-click to cool");
        this.heatingButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((ToolBar)ToolBar.this).box.view.setActionMode((byte)21);
            }
        });
        this.heatingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiscUtil.setSelectedSilently(ToolBar.this.graphButton, false);
            }
        });
        this.add(this.heatingButton);
        bg.add(this.heatingButton);
        JButton button = new JButton(new ImageIcon(ToolBar.class.getResource("resources/zoomin.png")));
        button.setBorderPainted(false);
        button.setToolTipText("Halve the size of the simulation box");
        button.addActionListener(this.box.view.getActionMap().get("Zoom In"));
        this.add(button);
        button = new JButton(new ImageIcon(ToolBar.class.getResource("resources/zoomout.png")));
        button.setBorderPainted(false);
        button.setToolTipText("Double the size of the simulation box");
        button.addActionListener(this.box.view.getActionMap().get("Zoom Out"));
        this.add(button);
    }

    @Override
    public void graphClosed(GraphEvent e) {
        MiscUtil.setSelectedSilently(this.graphButton, false);
    }

    @Override
    public void graphOpened(GraphEvent e) {
        MiscUtil.setSelectedSilently(this.graphButton, true);
    }

    @Override
    public void manipulationOccured(ManipulationEvent e) {
        switch (e.getType()) {
            case 16: {
                MiscUtil.setSelectedSilently(this.graphButton, this.box.model.hasSensor());
                break;
            }
            case 7: 
            case 13: 
            case 21: {
                this.selectButton.doClick();
                break;
            }
            case 22: {
                this.heatingButton.doClick();
                break;
            }
            case 8: {
                this.graphButton.setEnabled(true);
            }
        }
    }

    @Override
    public void tableBarShouldChange(ToolBarEvent e) {
        switch (e.getType()) {
            case 0: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolBar.this.selectButton.doClick();
                        ToolBar.this.selectButton.requestFocusInWindow();
                        MiscUtil.setSelectedSilently(ToolBar.this.graphButton, ((ToolBar)ToolBar.this).box.view.isGraphOn());
                        ToolBar.this.graphButton.setEnabled(((ToolBar)ToolBar.this).box.model.hasSensor());
                    }
                });
                break;
            }
            case 2: {
                this.selectButton.doClick();
                break;
            }
            case 3: {
                this.selectButton.doClick();
                if (this.graphButton.isSelected()) {
                    MiscUtil.setSelectedSilently(this.graphButton, false);
                }
                this.graphButton.setEnabled(false);
            }
        }
    }
}

