/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.concord.energy2d.system.Task;
import org.concord.energy2d.system.TaskCreator;
import org.concord.energy2d.system.TaskManager;

class TaskManagerView {
    private JTable table;
    private Vector<Vector<Object>> rowData;
    private JTextArea note;
    private TaskCreator taskCreator;
    private JButton removeTaskButton;
    private JButton editTaskButton;
    private final int editableCol = 3;
    private final int uidCol = 1;
    private TaskManager taskManager;

    TaskManagerView(TaskManager taskManager) {
        this.taskManager = taskManager;
        this.rowData = new Vector();
    }

    void show(Window owner) {
        this.createTasks(owner).setVisible(true);
    }

    void insertRow(Task task) {
        if (task == null) {
            return;
        }
        Vector<Object> v = new Vector<Object>();
        v.add(task.isEnabled());
        v.add(task.getUid());
        v.add(Integer.toString(task.getPriority()));
        v.add(Integer.toString(task.getInterval()));
        v.add(task.getLifetime() == Integer.MAX_VALUE ? "Permanent" : Integer.toString(task.getLifetime()));
        this.rowData.add(v);
        if (this.table != null) {
            this.table.revalidate();
            this.table.repaint();
        }
    }

    void removeRow(Task task) {
        if (task == null) {
            return;
        }
        for (Vector<Object> v : this.rowData) {
            if (!v.elementAt(1).equals(task.getUid())) continue;
            this.rowData.remove(v);
            task.setCompleted(false);
            if (this.table == null) break;
            this.table.clearSelection();
            this.table.repaint();
            this.editTaskButton.setEnabled(false);
            this.removeTaskButton.setEnabled(false);
            break;
        }
    }

    private JDialog createTasks(final Window owner) {
        final JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(owner), "Task Manager", false);
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TaskManagerView.this.taskManager.notifyChange();
                dialog.dispose();
            }
        });
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        panel.setPreferredSize(new Dimension(600, 320));
        dialog.setContentPane(panel);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Enable");
        columnNames.add("Task");
        columnNames.add("Priority");
        columnNames.add("Interval");
        columnNames.add("Lifetime");
        this.table = new JTable();
        this.table.setSelectionMode(0);
        this.table.setSelectionBackground(Color.lightGray);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setPreferredSize(new Dimension(200, 18));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                int nrow = TaskManagerView.this.table.getModel().getRowCount();
                int ncol = TaskManagerView.this.table.getModel().getColumnCount();
                int i = 0;
                int j = 0;
                i = 0;
                block0: while (i < nrow) {
                    j = 0;
                    while (j < ncol) {
                        Rectangle r = TaskManagerView.this.table.getCellRect(i, j, true);
                        if (r.contains(x, y)) break block0;
                        ++j;
                    }
                    ++i;
                }
                if (j != 3 && j != 0 && e.getClickCount() >= 2) {
                    TaskManagerView.this.editTaskButton.doClick();
                }
            }
        });
        this.rowData.clear();
        for (Task t : this.taskManager.taskPool) {
            this.insertRow(t);
        }
        DefaultTableModel tm = new DefaultTableModel(this.rowData, columnNames){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.getValueAt(0, columnIndex).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                Task t = TaskManagerView.this.taskManager.getTaskByUid((String)TaskManagerView.this.table.getValueAt(row, 1));
                if (t.isSystemTask() && col == 0) {
                    return false;
                }
                return col == 3 || col == 0;
            }
        };
        this.table.setModel(tm);
        tm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                DefaultTableModel src = (DefaultTableModel)e.getSource();
                int col = e.getColumn();
                if (col == 3) {
                    int row = e.getFirstRow();
                    Task t = TaskManagerView.this.taskManager.getTaskByUid((String)src.getValueAt(row, 1));
                    String s = (String)src.getValueAt(row, col);
                    if (s != null) {
                        t.setInterval(Integer.parseInt(s));
                    }
                } else if (col == 0) {
                    int row = e.getFirstRow();
                    Task t = TaskManagerView.this.taskManager.getTaskByUid((String)src.getValueAt(row, 1));
                    Boolean b = (Boolean)src.getValueAt(row, col);
                    if (b != null) {
                        t.setEnabled(b);
                    }
                }
            }
        });
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = (ListSelectionModel)e.getSource();
                if (!sm.isSelectionEmpty()) {
                    int row = sm.getMinSelectionIndex();
                    Task t = TaskManagerView.this.taskManager.getTaskByUid((String)TaskManagerView.this.table.getValueAt(row, 1));
                    TaskManagerView.this.note.setText(t.getDescription());
                    boolean b = !t.isSystemTask();
                    TaskManagerView.this.removeTaskButton.setEnabled(b);
                    TaskManagerView.this.editTaskButton.setEnabled(b);
                }
            }
        });
        this.table.getColumnModel().getColumn(0).setMaxWidth(50);
        this.table.getColumnModel().getColumn(1).setMinWidth(200);
        this.table.setShowGrid(false);
        this.table.setRowHeight(24);
        this.table.setRowMargin(2);
        this.table.setColumnSelectionAllowed(false);
        this.table.setBackground(Color.white);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(400, 150));
        scroll.getViewport().setBackground(Color.white);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(scroll);
        splitPane.setPreferredSize(new Dimension(400, 230));
        splitPane.setOneTouchExpandable(true);
        panel.add((Component)splitPane, "North");
        this.note = new JTextArea("Display description of a task.");
        this.note.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.note.setEditable(false);
        this.note.setFont(new Font("Verdana", 0, 9));
        scroll = new JScrollPane(this.note);
        scroll.setVerticalScrollBarPolicy(22);
        splitPane.setBottomComponent(scroll);
        JPanel p = new JPanel(new BorderLayout(0, 10));
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)new JLabel("<html><font size=2>To change the interval of the selected system task:</font></html>"), "Center");
        p1.add((Component)new JLabel("<html><font size=2>Double-click the <i>Interval</i> Cell, change the number, and press ENTER to verify it.</font></html>"), "South");
        p.add((Component)p1, "Center");
        p1 = new JPanel(new FlowLayout(2));
        p.add((Component)p1, "South");
        JButton button = new JButton("Add Task");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TaskManagerView.this.taskCreator == null) {
                    TaskManagerView.this.taskCreator = new TaskCreator(TaskManagerView.this.taskManager, owner);
                }
                TaskManagerView.this.taskCreator.show(TaskManagerView.this.table, null, -1);
            }
        });
        p1.add(button);
        this.removeTaskButton = new JButton("Remove Task");
        this.removeTaskButton.setEnabled(false);
        this.removeTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelectionModel sm = TaskManagerView.this.table.getSelectionModel();
                if (!sm.isSelectionEmpty()) {
                    int row = sm.getMinSelectionIndex();
                    Task t = TaskManagerView.this.taskManager.getTaskByUid((String)TaskManagerView.this.table.getValueAt(row, 1));
                    if (t != null) {
                        TaskManagerView.this.taskManager.remove(t);
                        TaskManagerView.this.taskManager.processPendingRequests();
                    }
                }
            }
        });
        p1.add(this.removeTaskButton);
        this.editTaskButton = new JButton("Edit Task");
        this.editTaskButton.setEnabled(false);
        this.editTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelectionModel sm = TaskManagerView.this.table.getSelectionModel();
                if (!sm.isSelectionEmpty()) {
                    int row = sm.getMinSelectionIndex();
                    Task t = TaskManagerView.this.taskManager.getTaskByUid((String)TaskManagerView.this.table.getValueAt(row, 1));
                    if (t != null && !t.isSystemTask()) {
                        if (TaskManagerView.this.taskCreator == null) {
                            TaskManagerView.this.taskCreator = new TaskCreator(TaskManagerView.this.taskManager, owner);
                        }
                        TaskManagerView.this.taskCreator.show(TaskManagerView.this.table, t, row);
                        TaskManagerView.this.note.setText(t.getDescription());
                        TaskManagerView.this.table.setValueAt(t.isEnabled(), row, 0);
                        TaskManagerView.this.table.setValueAt(t.getUid(), row, 1);
                        TaskManagerView.this.table.setValueAt(Integer.toString(t.getPriority()), row, 2);
                        TaskManagerView.this.table.setValueAt(Integer.toString(t.getInterval()), row, 3);
                        TaskManagerView.this.table.setValueAt(t.getLifetime() == Integer.MAX_VALUE ? "Permanent" : Integer.toString(t.getLifetime()), row, 4);
                        TaskManagerView.this.table.repaint();
                    }
                }
            }
        });
        p1.add(this.editTaskButton);
        button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskManagerView.this.taskManager.notifyChange();
                dialog.dispose();
            }
        });
        p1.add(button);
        panel.add((Component)p, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        return dialog;
    }
}

