/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.EventQueue;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.concord.energy2d.system.Task;
import org.concord.energy2d.system.TaskManagerView;

public abstract class TaskManager {
    List<Task> taskPool = Collections.synchronizedList(new ArrayList());
    private List<Task> tasksToRemove;
    private List<Task> tasksToAdd = Collections.synchronizedList(new ArrayList());
    private TaskManagerView view;

    public TaskManager() {
        this.tasksToRemove = Collections.synchronizedList(new ArrayList());
    }

    public abstract int getIndexOfStep();

    public abstract void runScript(String var1);

    public abstract void notifyChange();

    private void createView() {
        if (this.view == null) {
            this.view = new TaskManagerView(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCustomTasks() {
        List<Task> list = this.taskPool;
        synchronized (list) {
            Iterator<Task> i = this.taskPool.iterator();
            while (i.hasNext()) {
                Task t = i.next();
                if (t.isSystemTask()) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task> getCustomTasks() {
        ArrayList<Task> list = new ArrayList<Task>();
        List<Task> list2 = this.taskPool;
        synchronized (list2) {
            for (Task t : this.taskPool) {
                if (t.isSystemTask()) continue;
                list.add(t);
            }
        }
        return list;
    }

    public void add(Task t) {
        if (t != null) {
            if (this.tasksToAdd.contains(t)) {
                return;
            }
            this.tasksToAdd.add(t);
        }
    }

    public void remove(Task t) {
        if (t != null) {
            if (this.tasksToRemove.contains(t)) {
                return;
            }
            this.tasksToRemove.add(t);
        }
    }

    public boolean contains(Task t) {
        return this.taskPool.contains(t);
    }

    public boolean toBeAdded(Task t) {
        return this.tasksToAdd.contains(t);
    }

    public boolean hasTaskToAdd() {
        return !this.tasksToAdd.isEmpty();
    }

    public boolean toBeRemoved(Task t) {
        return this.tasksToRemove.contains(t);
    }

    public boolean hasTaskToRemove() {
        return !this.tasksToRemove.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getTaskByUid(String uid) {
        List<Task> list = this.taskPool;
        synchronized (list) {
            for (Task t : this.taskPool) {
                if (!t.getUid().equals(uid)) continue;
                return t;
            }
        }
        return null;
    }

    public void execute() {
        this.processPendingRequests();
        try {
            for (Task task : this.taskPool) {
                if (!task.isEnabled() || task.getInterval() <= 0) continue;
                if (task.isCompleted()) {
                    this.remove(task);
                }
                if (this.getIndexOfStep() % task.getInterval() != 0) continue;
                task.execute();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingRequests() {
        List<Task> list;
        if (!this.tasksToAdd.isEmpty()) {
            list = this.tasksToAdd;
            synchronized (list) {
                for (Task t : this.tasksToAdd) {
                    this.addTask(t);
                }
            }
            this.tasksToAdd.clear();
        }
        if (!this.tasksToRemove.isEmpty()) {
            list = this.tasksToRemove;
            synchronized (list) {
                for (Task t : this.tasksToRemove) {
                    this.removeTask(t);
                }
            }
            this.tasksToRemove.clear();
        }
    }

    private void removeTask(final Task t) {
        if (!this.contains(t)) {
            return;
        }
        this.taskPool.remove(t);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskManager.this.createView();
                TaskManager.this.view.removeRow(t);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(final Task t) {
        if (this.contains(t)) {
            return;
        }
        if (this.taskPool.isEmpty()) {
            this.taskPool.add(t);
        } else {
            List<Task> list = this.taskPool;
            synchronized (list) {
                int m = -1;
                int n = this.taskPool.size();
                int i = 0;
                while (i < n) {
                    if (t.getPriority() > this.taskPool.get(i).getPriority()) {
                        m = i;
                        break;
                    }
                    ++i;
                }
                if (m == -1) {
                    this.taskPool.add(t);
                } else {
                    this.taskPool.add(m, t);
                }
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskManager.this.createView();
                TaskManager.this.view.insertRow(t);
            }
        });
    }

    public void show(final Window owner) {
        if (EventQueue.isDispatchThread()) {
            this.createView();
            this.view.show(owner);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskManager.this.createView();
                    TaskManager.this.view.show(owner);
                }
            });
        }
    }

    public String toString() {
        return this.taskPool.toString();
    }
}

