/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.concord.energy2d.system.Task;
import org.concord.energy2d.system.TaskManager;

class TaskCreator {
    private static final byte UID_OK = 0;
    private static final byte UID_ERROR = 1;
    private static final byte UID_EXISTS = 2;
    private static final byte INPUT_ERROR = 3;
    private TaskManager taskManager;
    private Task task;
    private JPanel contentPane;
    private JTextArea scriptArea;
    private JTextField uidField;
    private JTextField descriptionField;
    private JTextField intervalField;
    private JTextField lifetimeField;
    private JCheckBox permanentCheckBox;
    private JLabel lifetimeLabel;
    private JSpinner prioritySpinner;
    private JDialog dialog;
    private JTable table;
    private int row;
    private Window owner;

    TaskCreator(TaskManager t, Window w) {
        this.taskManager = t;
        this.owner = w;
        this.contentPane = new JPanel(new BorderLayout(5, 5));
        this.scriptArea = new JTextArea();
        this.scriptArea.setBorder(BorderFactory.createTitledBorder("Scripts:"));
        JScrollPane scroller = new JScrollPane(this.scriptArea);
        scroller.setPreferredSize(new Dimension(600, 400));
        this.contentPane.add((Component)scroller, "Center");
        JPanel topPanel = new JPanel(new BorderLayout());
        this.contentPane.add((Component)topPanel, "North");
        JPanel p1 = new JPanel(new FlowLayout(0, 5, 5));
        topPanel.add((Component)p1, "Center");
        p1.add(new JLabel("UID: "));
        this.uidField = new JTextField("Untitled");
        this.uidField.setColumns(10);
        p1.add(this.uidField);
        p1.add(new JLabel("Description: "));
        this.descriptionField = new JTextField();
        this.descriptionField.setColumns(50);
        p1.add(this.descriptionField);
        final JPanel p2 = new JPanel(new FlowLayout(0, 5, 2));
        topPanel.add((Component)p2, "South");
        p2.add(new JLabel("Priority: "));
        this.prioritySpinner = new JSpinner(new SpinnerNumberModel(1, 1, 5, 1));
        p2.add(this.prioritySpinner);
        p2.add(new JLabel("Interval: "));
        this.intervalField = new JTextField(10);
        p2.add(this.intervalField);
        this.permanentCheckBox = new JCheckBox("Permanent");
        this.permanentCheckBox.setSelected(true);
        this.permanentCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    p2.remove(TaskCreator.this.lifetimeLabel);
                    p2.remove(TaskCreator.this.lifetimeField);
                } else {
                    p2.add(TaskCreator.this.lifetimeLabel);
                    p2.add(TaskCreator.this.lifetimeField);
                    TaskCreator.this.lifetimeField.setText(Integer.toString(100000));
                }
                p2.validate();
                p2.repaint();
            }
        });
        p2.add(this.permanentCheckBox);
        this.lifetimeLabel = new JLabel("Lifetime: ");
        this.lifetimeField = new JTextField();
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 5));
        this.contentPane.add((Component)buttonPanel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (TaskCreator.this.check()) {
                    case 0: {
                        TaskCreator.this.taskManager.notifyChange();
                        TaskCreator.this.dialog.dispose();
                        break;
                    }
                    case 2: {
                        JOptionPane.showMessageDialog(TaskCreator.this.dialog, "A task with the UID \"" + TaskCreator.this.uidField.getText() + "\" already exists.", "Duplicate Task UID", 0);
                        break;
                    }
                    case 1: {
                        JOptionPane.showMessageDialog(TaskCreator.this.dialog, "A task UID must contain at least four characters in [a-zA-Z_0-9] (no space allowed): \"" + TaskCreator.this.uidField.getText() + "\".", "Task UID Error", 0);
                    }
                }
            }
        });
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskCreator.this.dialog.dispose();
            }
        });
        buttonPanel.add(button);
    }

    private byte check() {
        String uid = this.uidField.getText();
        if (!uid.matches("\\w{4,}")) {
            return 1;
        }
        if (this.task == null) {
            if (this.taskManager.getTaskByUid(uid) != null) {
                return 2;
            }
            float x = this.parse(this.intervalField.getText());
            if (Float.isNaN(x)) {
                return 3;
            }
            Task t = new Task((int)x){

                @Override
                public void execute() {
                    TaskCreator.this.taskManager.runScript(this.getScript());
                    if (TaskCreator.this.taskManager.getIndexOfStep() >= this.getLifetime()) {
                        this.setCompleted(true);
                    }
                }
            };
            t.setUid(uid);
            t.setSystemTask(false);
            t.setPriority((Integer)this.prioritySpinner.getValue());
            x = this.parse(this.lifetimeField.getText());
            if (Float.isNaN(x)) {
                return 3;
            }
            t.setLifetime(this.permanentCheckBox.isSelected() ? Integer.MAX_VALUE : (int)x);
            t.setDescription(this.descriptionField.getText());
            t.setScript(this.scriptArea.getText());
            this.taskManager.add(t);
            this.taskManager.processPendingRequests();
        } else {
            this.task.setPriority((Integer)this.prioritySpinner.getValue());
            float x = this.parse(this.intervalField.getText());
            if (Float.isNaN(x)) {
                return 3;
            }
            this.task.setInterval((int)x);
            x = this.parse(this.lifetimeField.getText());
            if (Float.isNaN(x)) {
                return 3;
            }
            this.task.setLifetime(this.permanentCheckBox.isSelected() ? Integer.MAX_VALUE : (int)x);
            this.task.setDescription(this.descriptionField.getText());
            this.task.setScript(this.scriptArea.getText());
            if (!this.task.getUid().equals(uid)) {
                this.task.setUid(uid);
                this.table.setValueAt(uid, this.row, 1);
            }
        }
        return 0;
    }

    void show(JTable table, Task task, int row) {
        this.table = table;
        this.task = task;
        this.row = row;
        if (this.dialog == null) {
            this.dialog = new JDialog(JOptionPane.getFrameForComponent(table), "Creating a Task", true);
            this.dialog.setContentPane(this.contentPane);
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(table);
        }
        if (task != null) {
            this.dialog.setTitle("Edit a Task");
            this.uidField.setText(task.getUid());
            this.descriptionField.setText(task.getDescription());
            this.scriptArea.setText(task.getScript());
            this.scriptArea.setCaretPosition(0);
            this.prioritySpinner.setValue(task.getPriority());
            this.permanentCheckBox.setSelected(task.getLifetime() == Integer.MAX_VALUE);
            this.lifetimeField.setText(Integer.toString(task.getLifetime()));
            this.intervalField.setText(Integer.toString(task.getInterval()));
        } else {
            this.dialog.setTitle("Create a Task");
            this.uidField.setText("Untitled");
            this.descriptionField.setText(null);
            this.scriptArea.setText(null);
            this.prioritySpinner.setValue(1);
            this.lifetimeField.setText(Integer.toString(Integer.MAX_VALUE));
            this.intervalField.setText(Integer.toString(10));
            this.permanentCheckBox.setSelected(true);
        }
        this.dialog.setVisible(true);
    }

    private float parse(String s) {
        float x = Float.NaN;
        try {
            x = Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this.owner, "Cannot parse " + e.getLocalizedMessage(), "Error", 0);
        }
        return x;
    }
}

