/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import org.concord.energy2d.util.XmlCharacterEncoder;

public abstract class Task {
    public static final int PERMANENT = Integer.MAX_VALUE;
    private int lifetime = Integer.MAX_VALUE;
    private int interval = 10;
    private String uid = Long.toHexString(System.currentTimeMillis());
    private String description;
    private boolean enabled = true;
    private boolean completed;
    private boolean systemTask = true;
    private String script;
    private int priority = 1;

    public Task() {
    }

    public Task(int interval) {
        this();
        this.setInterval(interval);
    }

    public Task(int interval, int lifetime) {
        this(interval);
        this.setLifetime(lifetime);
    }

    public Task(String uid, int interval, int lifetime) {
        this(interval, lifetime);
        this.setUid(uid);
    }

    public abstract void execute();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public void setSystemTask(boolean b) {
        this.systemTask = b;
    }

    public boolean isSystemTask() {
        return this.systemTask;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setCompleted(boolean b) {
        this.completed = b;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Task)) {
            return false;
        }
        return ((Task)o).getUid().equals(this.uid);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public String toString() {
        return this.uid;
    }

    public String toXml() {
        String xml = "<task";
        xml = String.valueOf(xml) + " uid=\"" + this.uid + "\"";
        if (!this.enabled) {
            xml = String.valueOf(xml) + " enabled=\"" + this.enabled + "\"";
        }
        if (this.lifetime != Integer.MAX_VALUE) {
            xml = String.valueOf(xml) + " lifetime=\"" + this.lifetime + "\"";
        }
        if (this.priority != 1) {
            xml = String.valueOf(xml) + " priority=\"" + this.priority + "\"";
        }
        if (this.script != null) {
            xml = String.valueOf(xml) + " script=\"" + new XmlCharacterEncoder().encode(this.script) + "\"";
        }
        if (this.description != null) {
            xml = String.valueOf(xml) + " description=\"" + new XmlCharacterEncoder().encode(this.description) + "\"";
        }
        xml = String.valueOf(xml) + " interval=\"" + this.interval + "\"/>";
        return xml;
    }
}

