/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.concord.energy2d.event.ManipulationEvent;
import org.concord.energy2d.event.ManipulationListener;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.model.Sensor;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.system.AppletConverter;
import org.concord.energy2d.system.Helper;
import org.concord.energy2d.system.MenuBar;
import org.concord.energy2d.system.PreferencesDialog;
import org.concord.energy2d.system.Scripter2D;
import org.concord.energy2d.system.Task;
import org.concord.energy2d.system.TaskManager;
import org.concord.energy2d.system.ToolBar;
import org.concord.energy2d.system.ToolBarEvent;
import org.concord.energy2d.system.ToolBarListener;
import org.concord.energy2d.system.UpdateAnnouncer;
import org.concord.energy2d.system.XmlDecoder;
import org.concord.energy2d.system.XmlEncoder;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.TextBox;
import org.concord.energy2d.view.View2D;
import org.concord.modeler.MwService;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class System2D
extends JApplet
implements MwService,
ManipulationListener {
    static final String BRAND_NAME = "Energy2D V2.3";
    Model2D model;
    View2D view;
    TaskManager taskManager;
    Task repaint;
    Task measure;
    Task control;
    private Scripter2D scripter;
    private ExecutorService threadService;
    private static boolean isApplet = true;
    private SAXParser saxParser;
    private DefaultHandler saxHandler;
    private XmlEncoder encoder;
    private File currentFile;
    private URL currentURL;
    private String currentModel;
    private boolean saved = true;
    private String nextSim;
    private String prevSim;
    Runnable clickRun;
    Runnable clickStop;
    Runnable clickReset;
    Runnable clickReload;
    private JButton buttonRun;
    private JButton buttonStop;
    private JButton buttonReset;
    private JButton buttonReload;
    private JLabel statusLabel;
    private ToolBarListener toolBarListener;
    private List<PropertyChangeListener> propertyChangeListeners;
    private JFrame owner;
    private static Preferences preferences;

    public System2D() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        this.model = new Model2D();
        this.model.addManipulationListener(this);
        this.view = new View2D();
        this.view.addManipulationListener(this);
        this.view.setModel(this.model);
        this.view.setPreferredSize(new Dimension(400, 400));
        this.view.setBorder(BorderFactory.createEtchedBorder());
        this.view.setArea(0.0f, this.model.getLx(), 0.0f, this.model.getLy());
        this.addPropertyChangeListener(this.view);
        this.model.addPropertyChangeListener(this.view);
        this.getContentPane().add((Component)this.view, "Center");
        this.encoder = new XmlEncoder(this);
        this.saxHandler = new XmlDecoder(this);
        try {
            this.saxParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.createActions();
        this.taskManager = new TaskManager(){

            @Override
            public void runScript(String script) {
                System2D.this.runNativeScript(script);
            }

            @Override
            public void notifyChange() {
                System2D.this.view.notifyManipulationListeners(null, (byte)3);
            }

            @Override
            public int getIndexOfStep() {
                return System2D.this.model.getIndexOfStep();
            }
        };
        this.model.setTasks(new Runnable(){

            @Override
            public void run() {
                System2D.this.taskManager.execute();
            }
        });
        this.createTasks();
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public void addTask(Task t) {
        this.taskManager.add(t);
    }

    private void createTasks() {
        this.repaint = new Task(20){

            @Override
            public void execute() {
                System2D.this.view.repaint();
                System2D.this.view.setTime(System2D.this.model.getTime());
            }
        };
        this.repaint.setUid("REPAINT");
        this.repaint.setDescription("Refresh the view.");
        this.addTask(this.repaint);
        this.measure = new Task(100){

            @Override
            public void execute() {
                System2D.this.model.takeMeasurement();
            }
        };
        this.measure.setUid("MEASURE");
        this.measure.setDescription("Take the measurements from the sensors.");
        this.addTask(this.measure);
        this.control = new Task(100){

            @Override
            public void execute() {
                System2D.this.model.control();
            }
        };
        this.control.setUid("CONTROL");
        this.control.setDescription("Invoke the controllers (e.g., thermostats).");
        this.addTask(this.control);
        this.taskManager.processPendingRequests();
    }

    public View2D getView() {
        return this.view;
    }

    public Model2D getModel() {
        return this.model;
    }

    public void setOwner(JFrame owner) {
        this.owner = owner;
    }

    private void createActions() {
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Helper.showScriptDialog(System2D.this);
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(114, 0, true);
        a.putValue("Name", "Script");
        a.putValue("AcceleratorKey", ks);
        a.putValue("ShortDescription", "Open the Script Console");
        this.view.getInputMap().put(ks, "Script");
        this.view.getActionMap().put("Script", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System2D.this.view.createDialog(System2D.this.model, true);
            }
        };
        ks = KeyStroke.getKeyStroke(10, 8);
        a.putValue("Name", "Property");
        a.putValue("AcceleratorKey", ks);
        a.putValue("ShortDescription", "Open the Properties Editor");
        this.view.getInputMap().put(ks, "Property");
        this.view.getActionMap().put("Property", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System2D.this.taskManager.show(System2D.this.owner);
            }
        };
        ks = KeyStroke.getKeyStroke(115, 0, true);
        a.putValue("Name", "Task_Manager");
        a.putValue("AcceleratorKey", ks);
        a.putValue("ShortDescription", "Open the Task Manager");
        this.view.getInputMap().put(ks, "Task_Manager");
        this.view.getActionMap().put("Task_Manager", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog d = new PreferencesDialog(System2D.this, true);
                d.setVisible(true);
            }
        };
        a.putValue("Name", "Preferences");
        a.putValue("ShortDescription", "Open the Preferences Dialog");
        this.view.getActionMap().put("Preferences", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (System2D.this.nextSim != null) {
                    if (!System2D.this.askSaveBeforeLoading()) {
                        return;
                    }
                    try {
                        System2D.this.loadSim(System2D.this.nextSim);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(System2D.this.view), String.valueOf(System2D.this.nextSim) + " cannot be loaded: " + ioe.getMessage(), "Error", 0);
                    }
                }
            }
        };
        a.putValue("Name", "Next");
        a.putValue("ShortDescription", "Next Simulation");
        this.view.getActionMap().put("Next_Simulation", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (System2D.this.prevSim != null) {
                    if (!System2D.this.askSaveBeforeLoading()) {
                        return;
                    }
                    try {
                        System2D.this.loadSim(System2D.this.prevSim);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(System2D.this.view), String.valueOf(System2D.this.prevSim) + " cannot be loaded: " + ioe.getMessage(), "Error", 0);
                    }
                }
            }
        };
        a.putValue("Name", "Previous");
        a.putValue("ShortDescription", "Previous Simulation");
        this.view.getActionMap().put("Previous_Simulation", a);
    }

    @Override
    public void init() {
        String s = null;
        try {
            s = this.getParameter("script");
        }
        catch (Exception e) {
            s = null;
        }
        if (s != null) {
            this.runNativeScript(s);
        }
        this.view.repaint();
        System.out.println("Energy2D V2.3 initialized.");
    }

    void executeInThreadService(Runnable r) {
        if (this.threadService == null) {
            this.threadService = Executors.newFixedThreadPool(1);
        }
        this.threadService.execute(r);
    }

    public void run() {
        this.view.setRunToggle(true);
        this.executeInThreadService(new Runnable(){

            @Override
            public void run() {
                System2D.this.model.run();
            }
        });
    }

    public void runSteps(int n) {
        this.executeInThreadService(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public void stop() {
        this.model.stop();
        this.view.setRunToggle(false);
    }

    public void reset() {
        this.model.reset();
        this.view.reset();
        this.view.repaint();
    }

    public void initialize() {
        this.clear();
        this.init();
    }

    public void clear() {
        this.model.clear();
        this.view.clear();
        this.view.repaint();
    }

    @Override
    public void destroy() {
        this.stop();
        try {
            if (this.threadService != null && !this.threadService.isShutdown()) {
                this.threadService.shutdownNow();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.view.getPopupMenu();
    }

    @Override
    public Component getSnapshotComponent() {
        return this.view;
    }

    void setSaved(boolean b) {
        this.saved = b;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                System2D.this.setFrameTitle();
            }
        });
    }

    void saveApplet(File file) {
        new AppletConverter(this).write(file);
    }

    private void loadStateApp(Reader reader) throws IOException {
        block6: {
            this.reset();
            this.clear();
            if (reader == null) {
                return;
            }
            try {
                try {
                    this.saxParser.parse(new InputSource(reader), this.saxHandler);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    reader.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (System2D.this.buttonStop != null) {
                    System2D.callAction(System2D.this.buttonStop);
                }
            }
        });
        this.setSaved(true);
    }

    private void loadStateApp(InputStream is) throws IOException {
        this.reset();
        this.clear();
        this.loadState(is);
    }

    @Override
    public void loadState(InputStream is) throws IOException {
        block6: {
            if (is == null) {
                return;
            }
            try {
                try {
                    this.saxParser.parse(new InputSource(is), this.saxHandler);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    is.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (System2D.this.buttonStop != null) {
                    System2D.callAction(System2D.this.buttonStop);
                }
            }
        });
        this.setSaved(true);
    }

    void saveState(Writer writer) throws IOException {
        this.updateStatus("Saving...");
        if (this.clickStop != null) {
            EventQueue.invokeLater(this.clickStop);
        } else {
            this.stop();
        }
        if (writer == null) {
            return;
        }
        try {
            writer.write(this.encoder.encode().toCharArray());
        }
        finally {
            writer.close();
        }
        this.setSaved(true);
    }

    @Override
    public void saveState(OutputStream os) throws IOException {
        this.updateStatus("Saving...");
        if (this.clickStop != null) {
            EventQueue.invokeLater(this.clickStop);
        } else {
            this.stop();
        }
        if (os == null) {
            return;
        }
        try {
            os.write(this.encoder.encode().getBytes());
        }
        finally {
            os.close();
        }
        this.setSaved(true);
    }

    private void updateStatus(final String status) {
        if (this.statusLabel != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    System2D.this.statusLabel.setText(status);
                    Timer timer = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            System2D.this.statusLabel.setText(null);
                            if (System2D.this.buttonReload != null) {
                                System2D.this.buttonReload.setEnabled(true);
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            });
        }
    }

    void loadFile(File file) {
        this.setReloadButtonEnabled(true);
        if (file == null) {
            return;
        }
        try {
            this.loadStateApp(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8")));
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.view), e.getLocalizedMessage(), "File error", 0);
            return;
        }
        this.notifyToolBarListener(new ToolBarEvent(0, this));
        this.currentFile = file;
        this.currentModel = null;
        this.currentURL = null;
        this.setFrameTitle();
        this.view.getUndoManager().die();
    }

    void loadModel(String name) {
        this.setReloadButtonEnabled(true);
        if (name == null) {
            return;
        }
        if (!this.askSaveBeforeLoading()) {
            return;
        }
        try {
            this.loadStateApp(System2D.class.getResourceAsStream(name));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.notifyToolBarListener(new ToolBarEvent(0, this));
        this.currentModel = name;
        this.currentFile = null;
        this.currentURL = null;
        this.setFrameTitle();
        this.view.getUndoManager().die();
    }

    public void loadURL(URL url) throws IOException {
        this.setReloadButtonEnabled(true);
        if (url == null) {
            return;
        }
        if (!this.askSaveBeforeLoading()) {
            return;
        }
        this.loadStateApp(url.openConnection().getInputStream());
        this.notifyToolBarListener(new ToolBarEvent(0, this));
        this.currentURL = url;
        this.currentFile = null;
        this.currentModel = null;
        this.setFrameTitle();
        this.view.getUndoManager().die();
    }

    public void reload() {
        if (this.currentFile != null) {
            this.loadFile(this.currentFile);
            return;
        }
        if (this.currentModel != null) {
            this.loadModel(this.currentModel);
            return;
        }
        if (this.currentURL != null) {
            try {
                this.loadURL(this.currentURL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    public void setNextSimulation(String nextSim) {
        this.notifyPropertyChangeListeners("Next Simulation", this.nextSim, nextSim);
        this.nextSim = nextSim;
    }

    public String getNextSimulation() {
        return this.nextSim;
    }

    public void setPreviousSimulation(String prevSim) {
        this.notifyPropertyChangeListeners("Prev Simulation", this.prevSim, prevSim);
        this.prevSim = prevSim;
    }

    public String getPreviousSimulation() {
        return this.prevSim;
    }

    public void loadSim(String fileName) throws IOException {
        if (this.currentFile != null) {
            String parentDirectory = MiscUtil.getParentDirectory(this.currentFile.toString());
            if (parentDirectory != null) {
                this.loadFile(new File(parentDirectory, fileName));
            }
        } else if (this.currentModel != null) {
            String parentDirectory = MiscUtil.getParentDirectory(this.currentModel);
            if (parentDirectory != null) {
                this.loadModel(String.valueOf(parentDirectory) + fileName);
            }
        } else if (this.currentURL != null) {
            String parentDirectory = MiscUtil.getParentDirectory(this.currentURL.toString());
            if (parentDirectory != null) {
                this.loadURL(new URL(String.valueOf(parentDirectory) + fileName));
            }
        } else {
            URL codeBase = null;
            try {
                codeBase = this.getCodeBase();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (codeBase != null) {
                this.loadURL(new URL(codeBase, fileName));
            }
        }
    }

    private void setReloadButtonEnabled(final boolean b) {
        if (this.buttonReload == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                System2D.this.buttonReload.setEnabled(b);
            }
        });
    }

    int askSaveOption() {
        if (this.saved || this.owner == null || this.currentModel != null || this.currentURL != null) {
            return 1;
        }
        return JOptionPane.showConfirmDialog(this.owner, "Do you want to save the changes?", "Save", 1);
    }

    boolean askSaveBeforeLoading() {
        if (this.owner == null) {
            return true;
        }
        switch (this.askSaveOption()) {
            case 0: {
                Action a = null;
                a = this.currentFile != null ? this.view.getActionMap().get("Save") : this.view.getActionMap().get("SaveAs");
                if (a != null) {
                    a.actionPerformed(null);
                }
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    void setCurrentModel(String name) {
        this.currentModel = name;
    }

    public String getCurrentModel() {
        return this.currentModel;
    }

    void setCurrentFile(File file) {
        this.currentFile = file;
        this.setFrameTitle();
    }

    File getCurrentFile() {
        return this.currentFile;
    }

    public URL getCurrentURL() {
        return this.currentURL;
    }

    @Override
    public boolean needExecutorService() {
        return true;
    }

    @Override
    public String runNativeScript(String script) {
        if (script == null) {
            return null;
        }
        if (this.scripter == null) {
            this.scripter = new Scripter2D(this);
        }
        this.scripter.executeScript(script);
        if (this.scripter.shouldNotifySaveReminder()) {
            this.setSaved(false);
        }
        return null;
    }

    public Scripter2D getScripter() {
        if (this.scripter == null) {
            this.scripter = new Scripter2D(this);
        }
        return this.scripter;
    }

    @Override
    public void setEditable(boolean b) {
    }

    @Override
    public void setExecutorService(ExecutorService service) {
        this.threadService = service;
    }

    @Override
    public void manipulationOccured(ManipulationEvent e) {
        Object target = e.getTarget();
        switch (e.getType()) {
            case 18: {
                this.view.repaint();
                break;
            }
            case 3: {
                this.setSaved(false);
                break;
            }
            case 1: {
                this.setSaved(false);
                break;
            }
            case 2: {
                this.setSaved(false);
                break;
            }
            case 7: {
                this.setSaved(false);
                break;
            }
            case 8: {
                this.setSaved(false);
                break;
            }
            case 0: {
                if (target instanceof Part) {
                    this.model.removePart((Part)target);
                } else if (target instanceof Particle) {
                    this.model.removeParticle((Particle)target);
                } else if (target instanceof ParticleFeeder) {
                    this.view.removeParticleFeeder((ParticleFeeder)target);
                } else if (target instanceof Anemometer) {
                    this.model.removeAnemometer((Anemometer)target);
                } else if (target instanceof Thermometer) {
                    this.model.removeThermometer((Thermometer)target);
                } else if (target instanceof HeatFluxSensor) {
                    this.model.removeHeatFluxSensor((HeatFluxSensor)target);
                } else if (target instanceof TextBox) {
                    this.view.removeTextBox((TextBox)target);
                } else if (target instanceof Cloud) {
                    this.view.removeCloud((Cloud)target);
                } else if (target instanceof Tree) {
                    this.view.removeTree((Tree)target);
                } else if (target instanceof Fan) {
                    this.view.removeFan((Fan)target);
                } else if (target instanceof Heliostat) {
                    this.view.removeHeliostat((Heliostat)target);
                }
                if (this.view.getSelectedManipulable() == target) {
                    this.view.setSelectedManipulable(null);
                }
                this.setSaved(false);
                break;
            }
            case 11: {
                if (this.clickRun != null) {
                    EventQueue.invokeLater(this.clickRun);
                    break;
                }
                this.run();
                break;
            }
            case 12: {
                if (this.clickStop != null) {
                    EventQueue.invokeLater(this.clickStop);
                    break;
                }
                this.stop();
                break;
            }
            case 13: {
                if (this.clickReset != null) {
                    EventQueue.invokeLater(this.clickReset);
                    break;
                }
                this.reset();
                break;
            }
            case 14: {
                if (this.clickReload != null) {
                    EventQueue.invokeLater(this.clickReload);
                    break;
                }
                this.reload();
                break;
            }
            case 99: {
                this.view.repaint();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(System2D.this.view), "<html>The current time steplength is " + System2D.this.model.getTimeStep() + " s.<br>Reduce it in the Properties Window and then reset the simulation.<br>(Usually it should be less than 1 s for convection simulations.)", "Fatal error", 1);
                        Action propertyAction = System2D.this.view.getActionMap().get("Property");
                        if (propertyAction != null) {
                            propertyAction.actionPerformed(null);
                        }
                    }
                });
                break;
            }
            case 4: {
                this.model.setSunny(!this.model.isSunny());
                this.model.refreshPowerArray();
                this.setSaved(false);
                break;
            }
            case 5: {
                float a = this.model.getSunAngle() + 0.17453294f;
                this.model.setSunAngle(Math.min(a, (float)Math.PI));
                this.model.refreshPowerArray();
                this.setSaved(false);
                break;
            }
            case 6: {
                float a = this.model.getSunAngle() - 0.17453294f;
                this.model.setSunAngle(Math.max(a, 0.0f));
                this.model.refreshPowerArray();
                this.setSaved(false);
            }
        }
        if (target instanceof Part) {
            Part p = (Part)target;
            this.model.refreshMaterialPropertyArrays();
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            if (p.getEmissivity() > 0.0f) {
                this.model.getPhotons().clear();
            }
            if (this.model.isRadiative()) {
                this.model.generateViewFactorMesh();
            }
            this.setSaved(false);
        } else if (target instanceof Fan) {
            this.model.refreshMaterialPropertyArrays();
        }
        this.view.repaint();
    }

    private JPanel createButtonPanel() {
        this.statusLabel = new JLabel();
        JPanel p = new JPanel();
        this.buttonRun = new JButton("Run");
        this.buttonRun.setToolTipText("Run the simulation");
        this.buttonRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System2D.this.run();
                System2D.this.buttonRun.setEnabled(false);
                System2D.this.buttonStop.setEnabled(true);
            }
        });
        p.add(this.buttonRun);
        this.buttonStop = new JButton("Stop");
        this.buttonStop.setEnabled(false);
        this.buttonStop.setToolTipText("Stop the simulation");
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System2D.this.stop();
                System2D.this.buttonRun.setEnabled(true);
                System2D.this.buttonStop.setEnabled(false);
            }
        });
        p.add(this.buttonStop);
        this.buttonReset = new JButton("Reset");
        this.buttonReset.setToolTipText("Reset the simulation to time zero");
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System2D.this.reset();
                System2D.this.buttonRun.setEnabled(true);
                System2D.this.buttonStop.setEnabled(false);
                System2D.this.notifyToolBarListener(new ToolBarEvent(2, System2D.this.buttonReset));
            }
        });
        p.add(this.buttonReset);
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(20, 10));
        p.add(spacer);
        this.buttonReload = new JButton("Reload");
        this.buttonReload.setEnabled(false);
        this.buttonReload.setToolTipText("Reload the initial configurations");
        this.buttonReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!System2D.this.askSaveBeforeLoading()) {
                    return;
                }
                System2D.this.reload();
                System2D.this.buttonRun.setEnabled(true);
                System2D.this.buttonStop.setEnabled(false);
            }
        });
        p.add(this.buttonReload);
        this.clickRun = new Runnable(){

            @Override
            public void run() {
                System2D.callAction(System2D.this.buttonRun);
            }
        };
        this.clickStop = new Runnable(){

            @Override
            public void run() {
                System2D.callAction(System2D.this.buttonStop);
            }
        };
        this.clickReset = new Runnable(){

            @Override
            public void run() {
                System2D.callAction(System2D.this.buttonReset);
            }
        };
        this.clickReload = new Runnable(){

            @Override
            public void run() {
                System2D.callAction(System2D.this.buttonReload);
            }
        };
        return p;
    }

    private static void callAction(JButton button) {
        ActionListener[] a = button.getActionListeners();
        if (a == null || a.length == 0) {
            return;
        }
        ActionListener[] actionListenerArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener x = actionListenerArray[n2];
            x.actionPerformed(null);
            ++n2;
        }
    }

    void setToolBarListener(ToolBarListener l) {
        this.toolBarListener = l;
    }

    void notifyToolBarListener(ToolBarEvent e) {
        this.setFrameTitle();
        if (this.toolBarListener != null) {
            this.toolBarListener.tableBarShouldChange(e);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.add(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    private void notifyPropertyChangeListeners(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChangeListeners.isEmpty()) {
            return;
        }
        PropertyChangeEvent e = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener x : this.propertyChangeListeners) {
            x.propertyChange(e);
        }
    }

    void setFrameTitle() {
        if (this.owner == null) {
            return;
        }
        if (this.currentFile != null) {
            this.owner.setTitle("Energy2D V2.3: " + this.currentFile + (this.saved ? "" : " *"));
        } else if (this.currentModel != null) {
            this.owner.setTitle("Energy2D V2.3: " + this.currentModel);
        } else if (this.currentURL != null) {
            this.owner.setTitle("Energy2D V2.3: " + this.currentURL);
        } else {
            this.owner.setTitle(BRAND_NAME);
        }
    }

    void shutdown() {
        if (preferences != null && this.owner != null) {
            int n;
            Rectangle bounds = this.owner.getBounds();
            preferences.putInt("Upper-left x", bounds.x);
            preferences.putInt("Upper-left y", bounds.y);
            MenuBar menuBar = (MenuBar)this.owner.getJMenuBar();
            preferences.put("Latest E2D Path", menuBar.getLatestPath("e2d"));
            preferences.put("Latest HTM Path", menuBar.getLatestPath("htm"));
            preferences.put("Latest PNG Path", menuBar.getLatestPath("png"));
            String[] recentFiles = menuBar.getRecentFiles();
            if (recentFiles != null && (n = recentFiles.length) > 0) {
                int i = 0;
                while (i < n) {
                    preferences.put("Recent File " + i, recentFiles[n - i - 1]);
                    ++i;
                }
            }
            preferences.putInt("Sensor Maximum Data Points", Sensor.getMaximumDataPoints());
        }
        MiscUtil.shutdown();
    }

    public static void main(final String[] args) {
        isApplet = false;
        Locale.setDefault(Locale.US);
        boolean launchedByJWS = false;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (!cl.equals(ClassLoader.getSystemClassLoader())) {
            launchedByJWS = true;
        }
        if (System.getProperty("os.name").startsWith("Mac")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", BRAND_NAME);
        }
        if (preferences == null) {
            preferences = Preferences.userNodeForPackage(System2D.class);
        }
        Sensor.setMaximumDataPoints(preferences.getInt("Sensor Maximum Data Points", 1000));
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int w = (int)((double)screen.height * 0.7);
        System2D box = new System2D();
        box.view.setPreferredSize(new Dimension(w, w));
        box.view.setGridOn(true);
        box.view.setBorderTickmarksOn(true);
        final JFrame frame = new JFrame();
        frame.setIconImage(new ImageIcon(System2D.class.getResource("resources/frame.png")).getImage());
        final MenuBar menuBar = new MenuBar(box, frame);
        menuBar.setLatestPath(preferences.get("Latest E2D Path", null), "e2d");
        menuBar.setLatestPath(preferences.get("Latest HTM Path", null), "htm");
        menuBar.setLatestPath(preferences.get("Latest PNG Path", null), "png");
        menuBar.addRecentFile(preferences.get("Recent File 0", null));
        menuBar.addRecentFile(preferences.get("Recent File 1", null));
        menuBar.addRecentFile(preferences.get("Recent File 2", null));
        menuBar.addRecentFile(preferences.get("Recent File 3", null));
        frame.setJMenuBar(menuBar);
        frame.setDefaultCloseOperation(0);
        frame.getContentPane().add((Component)box.getContentPane(), "Center");
        ToolBar toolBar = new ToolBar(box);
        box.setToolBarListener(toolBar);
        box.view.addManipulationListener(toolBar);
        frame.getContentPane().add((Component)toolBar, "North");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        bottomPanel.add((Component)box.createButtonPanel(), "Center");
        box.statusLabel.setPreferredSize(new Dimension(100, 24));
        bottomPanel.add((Component)box.statusLabel, "West");
        frame.getContentPane().add((Component)bottomPanel, "South");
        int x = preferences.getInt("Upper-left x", (screen.height - w) / 8);
        int y = preferences.getInt("Upper-left y", (screen.height - w) / 8);
        frame.setLocation(x, y);
        frame.setTitle(BRAND_NAME);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Action a = System2D.this.view.getActionMap().get("Quit");
                if (a != null) {
                    a.actionPerformed(null);
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String filePath;
                        if (args != null && args.length > 1 && (filePath = args[1]).toLowerCase().trim().endsWith(".e2d")) {
                            System2D.this.loadFile(new File(filePath));
                            menuBar.e2dFileChooser.rememberFile(filePath);
                        }
                    }
                });
            }
        });
        box.owner = frame;
        if (System.getProperty("os.name").startsWith("Mac")) {
            Application app = new Application();
            app.setEnabledPreferencesMenu(true);
            app.addApplicationListener(new ApplicationAdapter(){

                @Override
                public void handleQuit(ApplicationEvent e) {
                    Action a = System2D.this.view.getActionMap().get("Quit");
                    if (a != null) {
                        a.actionPerformed(null);
                    }
                    e.setHandled(true);
                }

                @Override
                public void handlePreferences(ApplicationEvent e) {
                    new PreferencesDialog(System2D.this, true).setVisible(true);
                    e.setHandled(true);
                }

                @Override
                public void handleOpenFile(final ApplicationEvent e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String filePath = e.getFilename();
                            if (filePath.toLowerCase().trim().endsWith(".e2d")) {
                                System2D.this.loadFile(new File(filePath));
                                menuBar.e2dFileChooser.rememberFile(filePath);
                            }
                        }
                    });
                    e.setHandled(true);
                }

                @Override
                public void handleAbout(ApplicationEvent e) {
                    Helper.showAbout(frame);
                    e.setHandled(true);
                }
            });
        }
        if (!launchedByJWS) {
            UpdateAnnouncer.showMessage(box);
        }
    }
}

