/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.concord.energy2d.event.ScriptEvent;
import org.concord.energy2d.event.ScriptListener;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.Polygon2D;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.DirichletThermalBoundary;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.MassBoundary;
import org.concord.energy2d.model.NeumannThermalBoundary;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.model.SimpleMassBoundary;
import org.concord.energy2d.model.ThermalBoundary;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.system.System2D;
import org.concord.energy2d.system.Task;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.util.Scripter;
import org.concord.energy2d.util.XmlCharacterDecoder;
import org.concord.energy2d.view.Picture;
import org.concord.energy2d.view.TextBox;

class Scripter2D
extends Scripter {
    private static final Pattern MOVE_SUN = Pattern.compile("(^(?i)movesun\\b){1}");
    private static final Pattern MESSAGE = Pattern.compile("(^(?i)message\\b){1}");
    private static final Pattern RUNSTEPS = Pattern.compile("(^(?i)runsteps\\b){1}");
    private static final Pattern PART = Pattern.compile("(^(?i)part\\b){1}");
    private static final Pattern THERMOMETER = Pattern.compile("(^(?i)thermometer\\b){1}");
    private static final Pattern ANEMOMETER = Pattern.compile("(^(?i)anemometer\\b){1}");
    private static final Pattern HEAT_FLUX_SENSOR = Pattern.compile("(^(?i)heatfluxsensor\\b){1}");
    private static final Pattern BOUNDARY = Pattern.compile("(^(?i)boundary\\b){1}");
    private static final Pattern PART_FIELD = Pattern.compile("^%?((?i)part){1}(\\[){1}[\\s&&[^\\r\\n]]*\\w+[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private static final Pattern PARTICLE_FIELD = Pattern.compile("^%?((?i)particle){1}(\\[){1}[\\s&&[^\\r\\n]]*\\w+[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private static final Pattern PARTICLE_FEEDER_FIELD = Pattern.compile("^%?((?i)particlefeeder){1}(\\[){1}[\\s&&[^\\r\\n]]*\\w+[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private static final Pattern FAN_FIELD = Pattern.compile("^%?((?i)fan){1}(\\[){1}[\\s&&[^\\r\\n]]*\\w+[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private static final Pattern TASK_FIELD = Pattern.compile("^%?((?i)task){1}(\\[){1}[\\s&&[^\\r\\n]]*\\w+[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private static final Pattern ANEMOMETER_FIELD = Pattern.compile("^%?((?i)anemometer){1}(\\[){1}[\\s&&[^\\r\\n]]*\\w+[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private static final Pattern THERMOMETER_FIELD = Pattern.compile("^%?((?i)thermometer){1}(\\[){1}[\\s&&[^\\r\\n]]*\\w+[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private static final Pattern HEAT_FLUX_SENSOR_FIELD = Pattern.compile("^%?((?i)heatfluxsensor){1}(\\[){1}[\\s&&[^\\r\\n]]*\\w+[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private static final Pattern IMAGE_FIELD = Pattern.compile("^%?((?i)image){1}(\\[){1}[\\s&&[^\\r\\n]]*((\\d*\\.\\d+)|(\\d+\\.\\d*)|(\\d+))[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private static final Pattern TEXT_FIELD = Pattern.compile("^%?((?i)text){1}(\\[){1}[\\s&&[^\\r\\n]]*((\\d*\\.\\d+)|(\\d+\\.\\d*)|(\\d+))[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private static final Pattern BOUNDARY_FIELD = Pattern.compile("^%?((?i)boundary){1}(\\[){1}[\\s&&[^\\r\\n]]*\\w+[\\s&&[^\\r\\n]]*(\\]){1}\\.");
    private System2D s2d;
    private List<ScriptListener> listenerList;
    private boolean arrayUpdateRequested;
    private boolean temperatureInitializationRequested;
    private boolean notifySaveReminder = true;

    Scripter2D(System2D s2d) {
        this.s2d = s2d;
    }

    boolean shouldNotifySaveReminder() {
        return this.notifySaveReminder;
    }

    void addScriptListener(ScriptListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new CopyOnWriteArrayList<ScriptListener>();
        }
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    void removeScriptListener(ScriptListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(listener);
    }

    void removeAllScriptListeners() {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyScriptListener(ScriptEvent e) {
        if (this.listenerList == null) {
            return;
        }
        List<ScriptListener> list = this.listenerList;
        synchronized (list) {
            for (ScriptListener l : this.listenerList) {
                l.outputScriptResult(e);
            }
        }
    }

    private void showException(String command, Exception e) {
        e.printStackTrace();
        this.out((byte)1, "Error in '" + command + "':" + e.getMessage());
    }

    private void showError(String command, String message) {
        this.out((byte)1, "Error in '" + command + "':" + message);
    }

    private void out(byte status, String description) {
        if (status == 1) {
            this.notifyScriptListener(new ScriptEvent(this.s2d, status, "Aborted: " + description));
        } else {
            this.notifyScriptListener(new ScriptEvent(this.s2d, status, description));
        }
    }

    @Override
    public void executeScript(String script) {
        this.notifySaveReminder = true;
        super.executeScript(script);
        if (this.arrayUpdateRequested) {
            this.s2d.model.refreshPowerArray();
            this.s2d.model.refreshTemperatureBoundaryArray();
            this.s2d.model.refreshMaterialPropertyArrays();
            if (this.s2d.model.isRadiative()) {
                this.s2d.model.generateViewFactorMesh();
            }
            this.arrayUpdateRequested = false;
        }
        if (this.temperatureInitializationRequested) {
            this.s2d.model.setInitialTemperature();
            this.temperatureInitializationRequested = false;
        }
        this.s2d.view.repaint();
    }

    @Override
    protected void evalCommand(String ci) {
        String[] t;
        String s;
        Matcher matcher = RESET.matcher(ci);
        if (matcher.find()) {
            if (this.s2d.clickReset != null) {
                EventQueue.invokeLater(this.s2d.clickReset);
            } else {
                this.s2d.reset();
            }
            this.notifySaveReminder = false;
            return;
        }
        matcher = RELOAD.matcher(ci);
        if (matcher.find()) {
            if (this.s2d.clickReload != null) {
                EventQueue.invokeLater(this.s2d.clickReload);
            } else {
                this.s2d.reload();
            }
            this.notifySaveReminder = false;
            return;
        }
        matcher = RUN.matcher(ci);
        if (matcher.find()) {
            if (this.s2d.clickRun != null) {
                EventQueue.invokeLater(this.s2d.clickRun);
            } else {
                this.s2d.run();
            }
            this.notifySaveReminder = false;
            return;
        }
        matcher = RUNSTEPS.matcher(ci);
        if (matcher.find()) {
            String s2 = ci.substring(matcher.end()).trim();
            int nsteps = 10;
            try {
                nsteps = (int)Float.parseFloat(s2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.s2d.runSteps(nsteps);
            this.notifySaveReminder = false;
            return;
        }
        matcher = STOP.matcher(ci);
        if (matcher.find()) {
            this.s2d.stop();
            if (this.s2d.clickStop != null) {
                EventQueue.invokeLater(this.s2d.clickStop);
            }
            this.notifySaveReminder = false;
            return;
        }
        matcher = BEEP.matcher(ci);
        if (matcher.find()) {
            String s3 = ci.substring(matcher.end()).trim();
            if (s3.equals("")) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                int noteNumber = 60;
                int velocity = 60;
                String[] s2 = s3.split("[\\s&&[^\\r\\n]]");
                if (s2.length >= 1) {
                    try {
                        noteNumber = (int)Float.parseFloat(s2[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (s2.length >= 2) {
                    try {
                        velocity = (int)Float.parseFloat(s2[1]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                MiscUtil.beep(noteNumber, velocity);
            }
            this.notifySaveReminder = false;
            return;
        }
        matcher = MOVE_SUN.matcher(ci);
        if (matcher.find()) {
            String s4 = ci.substring(matcher.end()).trim();
            if (s4 == null || s4.equals("")) {
                this.s2d.model.moveSun(6.0f, 18.0f);
            } else {
                String[] s2 = s4.split("[\\s&&[^\\r\\n]]");
                if (s2.length == 2) {
                    float sunrise = Float.valueOf(s2[0]).floatValue();
                    float sunset = Float.valueOf(s2[1]).floatValue();
                    if (sunrise > 0.0f && sunrise < 24.0f && sunset > 0.0f && sunset < 24.0f) {
                        this.s2d.model.moveSun(sunrise, sunset);
                    } else {
                        this.showError(ci, "Sunrise and sunset times must be 0-24.");
                    }
                } else {
                    this.showError(ci, "Expect two parameters for dawn and dusk time.");
                }
            }
            this.notifySaveReminder = false;
            return;
        }
        matcher = INIT.matcher(ci);
        if (matcher.find()) {
            this.s2d.initialize();
            this.notifySaveReminder = false;
            return;
        }
        matcher = LOAD.matcher(ci);
        if (matcher.find()) {
            String s5 = ci.substring(matcher.end()).trim();
            try {
                this.s2d.loadSim(s5);
            }
            catch (IOException e) {
                this.showException(ci, e);
            }
            this.notifySaveReminder = false;
            return;
        }
        matcher = DELAY.matcher(ci);
        if (matcher.find()) {
            String s6 = ci.substring(matcher.end()).trim();
            try {
                Thread.sleep((int)(Float.valueOf(s6).floatValue() * 1000.0f));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.notifySaveReminder = false;
            return;
        }
        matcher = MESSAGE.matcher(ci);
        if (matcher.find()) {
            final String s7 = new XmlCharacterDecoder().decode(ci.substring(matcher.end()).trim());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(((Scripter2D)Scripter2D.this).s2d.view), new JLabel(s7));
                }
            });
            this.notifySaveReminder = false;
            return;
        }
        matcher = ADD.matcher(ci);
        if (matcher.find()) {
            String s8 = ci.substring(matcher.end()).trim();
            if (s8.toLowerCase().startsWith("text")) {
                float[] z;
                int j;
                s8 = s8.substring(4).trim();
                boolean success = false;
                if (s8.startsWith("(") && (j = s8.indexOf(")")) != -1 && (z = Scripter2D.parseArray(2, s8.substring(1, j))) != null) {
                    final String s2 = s8;
                    final Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ((Scripter2D)Scripter2D.this).s2d.view.addText(s2.substring(j + 1).trim(), z[0], z[1]);
                        }
                    };
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EventQueue.invokeLater(r);
                        }
                    });
                    success = true;
                }
                if (!success) {
                    this.out((byte)1, "Error in '" + ci + "'");
                }
            } else if (s8.toLowerCase().startsWith("image")) {
                float[] z;
                int j;
                s8 = s8.substring(5).trim();
                boolean success = false;
                if (s8.startsWith("(") && (j = s8.indexOf(")")) != -1 && (z = Scripter2D.parseArray(2, s8.substring(1, j))) != null) {
                    String filename = s8.substring(j + 1);
                    URL url = null;
                    try {
                        url = new URL(this.s2d.getCodeBase(), filename);
                    }
                    catch (Exception e) {
                        this.showException(ci, e);
                        return;
                    }
                    if (url != null) {
                        final ImageIcon image = new ImageIcon(url);
                        final Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                ((Scripter2D)Scripter2D.this).s2d.view.addPicture(image, ((Scripter2D)Scripter2D.this).s2d.view.convertPointToPixelX(z[0]), ((Scripter2D)Scripter2D.this).s2d.view.convertPointToPixelY(z[1]));
                            }
                        };
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                EventQueue.invokeLater(r);
                            }
                        });
                        success = true;
                    }
                }
                if (!success) {
                    this.out((byte)1, "Error in '" + ci + "'");
                }
            } else {
                this.out((byte)1, "Unrecognized command '" + ci + "'");
            }
            return;
        }
        matcher = REMOVE.matcher(ci);
        if (matcher.find()) {
            String s9 = ci.substring(matcher.end()).trim();
            if (s9.equalsIgnoreCase("all")) {
                this.s2d.clear();
            } else if (s9.equalsIgnoreCase("particles")) {
                this.s2d.model.removeAllParticles();
            }
            return;
        }
        matcher = THERMOMETER.matcher(ci);
        if (matcher.find()) {
            s = ci.substring(matcher.end()).trim();
            t = (s = s.substring(1, s.length() - 1)).split("[,\\s&&[^\\r\\n]]+");
            if (t.length == 2) {
                try {
                    float x = Float.parseFloat(t[0]);
                    float y = this.convertVerticalCoordinate(Float.parseFloat(t[1]));
                    this.s2d.model.addThermometer(x, y);
                }
                catch (NumberFormatException e) {
                    this.showException(ci, e);
                }
                return;
            }
            this.out((byte)1, "Error in '" + ci + "'");
        }
        if ((matcher = ANEMOMETER.matcher(ci)).find()) {
            s = ci.substring(matcher.end()).trim();
            t = (s = s.substring(1, s.length() - 1)).split("[,\\s&&[^\\r\\n]]+");
            if (t.length == 2) {
                try {
                    float x = Float.parseFloat(t[0]);
                    float y = this.convertVerticalCoordinate(Float.parseFloat(t[1]));
                    this.s2d.model.addAnemometer(x, y);
                }
                catch (NumberFormatException e) {
                    this.showException(ci, e);
                }
                return;
            }
            this.out((byte)1, "Error in '" + ci + "'");
        }
        if ((matcher = HEAT_FLUX_SENSOR.matcher(ci)).find()) {
            s = ci.substring(matcher.end()).trim();
            t = (s = s.substring(1, s.length() - 1)).split("[,\\s&&[^\\r\\n]]+");
            if (t.length == 2) {
                try {
                    float x = Float.parseFloat(t[0]);
                    float y = this.convertVerticalCoordinate(Float.parseFloat(t[1]));
                    this.s2d.model.addHeatFluxSensor(x, y);
                }
                catch (NumberFormatException e) {
                    this.showException(ci, e);
                }
                return;
            }
            this.out((byte)1, "Error in '" + ci + "'");
        }
        if ((matcher = PART.matcher(ci)).find()) {
            s = ci.substring(matcher.end()).trim();
            if (s.toLowerCase().startsWith("rectangle")) {
                s = s.substring(9).trim();
                t = (s = s.substring(1, s.length() - 1)).split("[,\\s&&[^\\r\\n]]+");
                if (t.length == 4) {
                    try {
                        float x = Float.parseFloat(t[0]);
                        float y = this.convertVerticalCoordinate(Float.parseFloat(t[1]));
                        float w = Float.parseFloat(t[2]);
                        float h = Float.parseFloat(t[3]);
                        this.s2d.model.addRectangularPart(x, y, w, h);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                    }
                    return;
                }
            } else if (s.toLowerCase().startsWith("ellipse")) {
                s = s.substring(7).trim();
                t = (s = s.substring(1, s.length() - 1)).split("[,\\s&&[^\\r\\n]]+");
                if (t.length == 4) {
                    try {
                        float x = Float.parseFloat(t[0]);
                        float y = this.convertVerticalCoordinate(Float.parseFloat(t[1]));
                        float a = Float.parseFloat(t[2]);
                        float b = Float.parseFloat(t[3]);
                        this.s2d.model.addEllipticalPart(x, y, a, b);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                    }
                    return;
                }
            } else if (s.toLowerCase().startsWith("ring")) {
                s = s.substring(4).trim();
                t = (s = s.substring(1, s.length() - 1)).split("[,\\s&&[^\\r\\n]]+");
                if (t.length == 4) {
                    try {
                        float xcenter = Float.parseFloat(t[0]);
                        float ycenter = this.convertVerticalCoordinate(Float.parseFloat(t[1]));
                        float inner = Float.parseFloat(t[2]);
                        float outer = Float.parseFloat(t[3]);
                        this.s2d.model.addRingPart(xcenter, ycenter, inner, outer);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                    }
                    return;
                }
            } else if (s.toLowerCase().startsWith("polygon")) {
                s = s.substring(7).trim();
                t = (s = s.substring(1, s.length() - 1)).split("[,\\s&&[^\\r\\n]]+");
                int n = t.length;
                if (n >= 6) {
                    float[] x = new float[n / 2];
                    float[] y = new float[n / 2];
                    int i = 0;
                    while (i < x.length) {
                        try {
                            x[i] = Float.parseFloat(t[2 * i]);
                            y[i] = this.convertVerticalCoordinate(Float.parseFloat(t[2 * i + 1]));
                        }
                        catch (NumberFormatException e) {
                            this.showException(ci, e);
                            return;
                        }
                        ++i;
                    }
                    this.s2d.model.addPolygonPart(x, y);
                    return;
                }
            }
            this.arrayUpdateRequested = true;
        }
        if ((matcher = BOUNDARY.matcher(ci)).find()) {
            s = ci.substring(matcher.end()).trim().toLowerCase();
            if (s.startsWith("temperature")) {
                s = s.substring(11).trim();
                t = (s = s.substring(1, s.length() - 1)).split("[,\\s&&[^\\r\\n]]+");
                if (t.length == 4) {
                    DirichletThermalBoundary b = null;
                    ThermalBoundary boundary = this.s2d.model.getThermalBoundary();
                    if (boundary instanceof DirichletThermalBoundary) {
                        b = (DirichletThermalBoundary)boundary;
                    } else {
                        b = new DirichletThermalBoundary();
                        this.s2d.model.setThermalBoundary(b);
                    }
                    try {
                        float tN = Float.parseFloat(t[0]);
                        float tE = Float.parseFloat(t[1]);
                        float tS = Float.parseFloat(t[2]);
                        float tW = Float.parseFloat(t[3]);
                        b.setTemperatureAtBorder((byte)0, tN);
                        b.setTemperatureAtBorder((byte)1, tE);
                        b.setTemperatureAtBorder((byte)2, tS);
                        b.setTemperatureAtBorder((byte)3, tW);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                    }
                    return;
                }
            } else if (s.startsWith("flux")) {
                s = s.substring(4).trim();
                t = (s = s.substring(1, s.length() - 1)).split("[,\\s&&[^\\r\\n]]+");
                if (t.length == 4) {
                    NeumannThermalBoundary b = null;
                    ThermalBoundary boundary = this.s2d.model.getThermalBoundary();
                    if (boundary instanceof NeumannThermalBoundary) {
                        b = (NeumannThermalBoundary)boundary;
                    } else {
                        b = new NeumannThermalBoundary();
                        this.s2d.model.setThermalBoundary(b);
                    }
                    try {
                        float fN = Float.parseFloat(t[0]);
                        float fE = Float.parseFloat(t[1]);
                        float fS = Float.parseFloat(t[2]);
                        float fW = Float.parseFloat(t[3]);
                        b.setFluxAtBorder((byte)0, fN);
                        b.setFluxAtBorder((byte)1, fE);
                        b.setFluxAtBorder((byte)2, fS);
                        b.setFluxAtBorder((byte)3, fW);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                    }
                    return;
                }
            } else if (s.startsWith("mass")) {
                MassBoundary boundary;
                s = s.substring(4).trim();
                t = (s = s.substring(1, s.length() - 1)).split("[,\\s&&[^\\r\\n]]+");
                if (t.length == 4 && (boundary = this.s2d.model.getMassBoundary()) instanceof SimpleMassBoundary) {
                    SimpleMassBoundary b = (SimpleMassBoundary)boundary;
                    try {
                        byte mN = (byte)Float.parseFloat(t[0]);
                        byte mE = (byte)Float.parseFloat(t[1]);
                        byte mS = (byte)Float.parseFloat(t[2]);
                        byte mW = (byte)Float.parseFloat(t[3]);
                        b.setFlowTypeAtBorder((byte)0, mN);
                        b.setFlowTypeAtBorder((byte)1, mE);
                        b.setFlowTypeAtBorder((byte)2, mS);
                        b.setFlowTypeAtBorder((byte)3, mW);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                    }
                    return;
                }
            }
        }
        if ((matcher = SET.matcher(ci)).find()) {
            s = ci.substring(matcher.end()).trim();
            t = s.split("[\\s&&[^\\r\\n]]+");
            if (t.length >= 2) {
                if (t[0].equalsIgnoreCase("sunny")) {
                    this.s2d.model.setSunny("true".equalsIgnoreCase(t[1]));
                    this.arrayUpdateRequested = true;
                } else if (t[0].equalsIgnoreCase("action")) {
                    int mode = 0;
                    if ("selection".equalsIgnoreCase(t[1])) {
                        mode = 0;
                    } else if ("rectangle".equalsIgnoreCase(t[1])) {
                        mode = 1;
                    } else if ("ellipse".equalsIgnoreCase(t[1])) {
                        mode = 2;
                    } else if ("polygon".equalsIgnoreCase(t[1])) {
                        mode = 3;
                    } else if ("blob".equalsIgnoreCase(t[1])) {
                        mode = 4;
                    } else if ("heating".equalsIgnoreCase(t[1])) {
                        mode = 21;
                    } else if ("thermometer".equalsIgnoreCase(t[1])) {
                        mode = 11;
                    }
                    this.s2d.view.setActionMode((byte)mode);
                } else if (t[0].equalsIgnoreCase("temperature_increment")) {
                    float temperatureIncrement = 0.0f;
                    try {
                        temperatureIncrement = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.view.setTemperatureIncrement(temperatureIncrement);
                } else if (t[0].equalsIgnoreCase("sun_angle")) {
                    float angle = 0.0f;
                    try {
                        angle = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setSunAngle((float)((double)angle / 180.0 * Math.PI));
                    this.arrayUpdateRequested = true;
                } else if (t[0].equalsIgnoreCase("solar_power")) {
                    float solarPower = 0.0f;
                    try {
                        solarPower = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setSolarPowerDensity(solarPower);
                } else if (t[0].equalsIgnoreCase("emission_interval")) {
                    int emissionInterval = 20;
                    try {
                        emissionInterval = Integer.parseInt(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setPhotonEmissionInterval(emissionInterval);
                } else if (t[0].equalsIgnoreCase("ray_speed")) {
                    float raySpeed = 0.1f;
                    try {
                        raySpeed = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setSolarRaySpeed(raySpeed);
                } else if (t[0].equalsIgnoreCase("ray_count")) {
                    int rayCount = 0;
                    try {
                        rayCount = Integer.parseInt(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setSolarRayCount(rayCount);
                    this.arrayUpdateRequested = true;
                } else if (t[0].equalsIgnoreCase("convective")) {
                    this.s2d.model.setConvective("true".equalsIgnoreCase(t[1]));
                } else if (t[0].equalsIgnoreCase("thermal_buoyancy") || t[0].equalsIgnoreCase("thermal_expansion_coefficient")) {
                    float thermalExpansionCoefficient = 0.0f;
                    try {
                        thermalExpansionCoefficient = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setThermalExpansionCoefficient(thermalExpansionCoefficient);
                } else if (t[0].equalsIgnoreCase("buoyancy_approximation")) {
                    int buoyancyApproximation = 0;
                    try {
                        buoyancyApproximation = Integer.parseInt(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setBuoyancyApproximation((byte)buoyancyApproximation);
                } else if (t[0].equalsIgnoreCase("velocity")) {
                    this.s2d.view.setVelocityOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("heat_flux_arrow")) {
                    this.s2d.view.setHeatFluxArrowsOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("heat_flux_line")) {
                    this.s2d.view.setHeatFluxLinesOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("clock")) {
                    this.s2d.view.setClockOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("fahrenheit")) {
                    this.s2d.view.setFahrenheitUsed("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("ruler")) {
                    this.s2d.view.setBorderTickmarksOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("graph")) {
                    this.s2d.view.setGraphOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("graph_xlabel")) {
                    this.s2d.view.setGraphXLabel(t[1]);
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("graph_ylabel")) {
                    this.s2d.view.setGraphYLabel(t[1]);
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("grid")) {
                    this.s2d.view.setGridOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("view_factor_lines")) {
                    this.s2d.view.setViewFactorLinesOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("grid_size")) {
                    int gridSize = 0;
                    try {
                        gridSize = Integer.parseInt(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.view.setGridSize(gridSize);
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("color_palette")) {
                    this.s2d.view.setColorPaletteOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("color_palette_type")) {
                    if ("RAINBOW".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setColorPaletteType((byte)0);
                        this.s2d.view.repaint();
                    } else if ("IRON".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setColorPaletteType((byte)1);
                        this.s2d.view.repaint();
                    } else if ("GRAY".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setColorPaletteType((byte)2);
                        this.s2d.view.repaint();
                    } else {
                        this.showError(ci, "color palette type not supported");
                    }
                } else if (t[0].equalsIgnoreCase("seethrough")) {
                    this.s2d.view.setSeeThrough("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("isotherm")) {
                    this.s2d.view.setIsothermOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("streamline")) {
                    this.s2d.view.setStreamlineOn("true".equalsIgnoreCase(t[1]));
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("color_palette_rectangle")) {
                    if (t.length > 4) {
                        float x = 0.0f;
                        float y = 0.0f;
                        float w = 0.0f;
                        float h = 0.0f;
                        try {
                            x = Float.parseFloat(t[1]);
                            y = Float.parseFloat(t[2]);
                            w = Float.parseFloat(t[3]);
                            h = Float.parseFloat(t[4]);
                        }
                        catch (NumberFormatException e) {
                            this.showException(ci, e);
                            return;
                        }
                        final float x1 = x;
                        final float y1 = y;
                        final float w1 = w;
                        final float h1 = h;
                        final Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                float x2 = ((Scripter2D)Scripter2D.this).s2d.view.convertPointToPixelX(x1) / ((Scripter2D)Scripter2D.this).s2d.view.getWidth();
                                float y2 = ((Scripter2D)Scripter2D.this).s2d.view.convertPointToPixelY(y1) / ((Scripter2D)Scripter2D.this).s2d.view.getHeight();
                                float w2 = ((Scripter2D)Scripter2D.this).s2d.view.convertLengthToPixelX(w1) / ((Scripter2D)Scripter2D.this).s2d.view.getWidth();
                                float h2 = ((Scripter2D)Scripter2D.this).s2d.view.convertLengthToPixelY(h1) / ((Scripter2D)Scripter2D.this).s2d.view.getHeight();
                                ((Scripter2D)Scripter2D.this).s2d.view.setColorPaletteRectangle(x2, y2, w2, h2);
                                ((Scripter2D)Scripter2D.this).s2d.view.repaint();
                            }
                        };
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                EventQueue.invokeLater(r);
                            }
                        });
                    }
                } else if (t[0].equalsIgnoreCase("minimum_temperature")) {
                    float min = 0.0f;
                    try {
                        min = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.view.setMinimumTemperature(min);
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("maximum_temperature")) {
                    float max = 0.0f;
                    try {
                        max = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.view.setMaximumTemperature(max);
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("heat_map")) {
                    if ("NONE".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setHeatMapType((byte)0);
                    } else if ("TEMPERATURE".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setHeatMapType((byte)1);
                    } else if ("THERMAL_ENERGY".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setHeatMapType((byte)2);
                    } else {
                        this.showError(ci, "heat map type not supported");
                    }
                } else if (t[0].equalsIgnoreCase("mouse_read")) {
                    if ("NOTHING".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setMouseReadType((byte)0);
                    } else if ("TEMPERATURE".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setMouseReadType((byte)1);
                    } else if ("THERMAL_ENERGY".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setMouseReadType((byte)2);
                    } else if ("VELOCITY".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setMouseReadType((byte)3);
                    } else if ("HEAT_FLUX".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setMouseReadType((byte)4);
                    } else if ("COORDINATES".equalsIgnoreCase(t[1])) {
                        this.s2d.view.setMouseReadType((byte)5);
                    } else {
                        this.showError(ci, "mouse read type not supported");
                    }
                } else if (t[0].equalsIgnoreCase("isotherm_resolution")) {
                    float resolution = 0.0f;
                    try {
                        resolution = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.view.setIsothermResolution(resolution);
                    this.s2d.view.repaint();
                } else if (t[0].equalsIgnoreCase("timestep")) {
                    float timestep = 0.0f;
                    try {
                        timestep = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setTimeStep(timestep);
                } else if (t[0].equalsIgnoreCase("viewupdate")) {
                    int viewUpdateInterval = 0;
                    try {
                        viewUpdateInterval = Integer.parseInt(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.repaint.setInterval(viewUpdateInterval);
                } else if (t[0].equalsIgnoreCase("measurement_interval")) {
                    int measurementInterval = 0;
                    try {
                        measurementInterval = Integer.parseInt(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.measure.setInterval(measurementInterval);
                } else if (t[0].equalsIgnoreCase("control_interval")) {
                    int controlInterval = 0;
                    try {
                        controlInterval = Integer.parseInt(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.control.setInterval(controlInterval);
                } else if (t[0].equalsIgnoreCase("width")) {
                    float width = 0.0f;
                    try {
                        width = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setLx(width);
                    this.s2d.view.setArea(0.0f, width, 0.0f, this.s2d.model.getLy());
                    this.temperatureInitializationRequested = true;
                    this.arrayUpdateRequested = true;
                } else if (t[0].equalsIgnoreCase("height")) {
                    float height = 0.0f;
                    try {
                        height = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setLy(height);
                    this.s2d.view.setArea(0.0f, this.s2d.model.getLx(), 0.0f, height);
                    this.temperatureInitializationRequested = true;
                    this.arrayUpdateRequested = true;
                } else if (t[0].equalsIgnoreCase("z_heat_diffusivity")) {
                    float zHeatDiffusivity = 0.0f;
                    try {
                        zHeatDiffusivity = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setZHeatDiffusivity(zHeatDiffusivity);
                } else if (t[0].equalsIgnoreCase("gravitational_acceleration")) {
                    float gravitationalAcceleration = 0.0f;
                    try {
                        gravitationalAcceleration = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setGravitationalAcceleration(gravitationalAcceleration);
                } else if (t[0].equalsIgnoreCase("thermophoretic_coefficient")) {
                    float thermophoreticCoefficient = 0.0f;
                    try {
                        thermophoreticCoefficient = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setThermophoreticCoefficient(thermophoreticCoefficient);
                } else if (t[0].equalsIgnoreCase("particle_drag")) {
                    float particleDrag = 0.0f;
                    try {
                        particleDrag = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setParticleDrag(particleDrag);
                } else if (t[0].equalsIgnoreCase("particle_hardness")) {
                    float particleHardness = 0.0f;
                    try {
                        particleHardness = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setParticleHardness(particleHardness);
                } else if (t[0].equalsIgnoreCase("background_viscosity")) {
                    float viscosity = 0.0f;
                    try {
                        viscosity = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setBackgroundViscosity(viscosity);
                } else if (t[0].equalsIgnoreCase("background_conductivity")) {
                    float x = 0.0f;
                    try {
                        x = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setBackgroundConductivity(x);
                    this.arrayUpdateRequested = true;
                } else if (t[0].equalsIgnoreCase("background_capacity")) {
                    float x = 0.0f;
                    try {
                        x = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setBackgroundSpecificHeat(x);
                    this.arrayUpdateRequested = true;
                } else if (t[0].equalsIgnoreCase("background_specific_heat")) {
                    float x = 0.0f;
                    try {
                        x = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setBackgroundSpecificHeat(x);
                    this.arrayUpdateRequested = true;
                } else if (t[0].equalsIgnoreCase("background_density")) {
                    float x = 0.0f;
                    try {
                        x = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setBackgroundDensity(x);
                    this.arrayUpdateRequested = true;
                } else if (t[0].equalsIgnoreCase("background_temperature")) {
                    float x = 0.0f;
                    try {
                        x = Float.parseFloat(t[1]);
                    }
                    catch (NumberFormatException e) {
                        this.showException(ci, e);
                        return;
                    }
                    this.s2d.model.setBackgroundTemperature(x);
                    this.temperatureInitializationRequested = true;
                } else if (t[0].equalsIgnoreCase("bgcolor")) {
                    final Color c = MiscUtil.parseRGBColor(t[1]);
                    if (c != null) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((Scripter2D)Scripter2D.this).s2d.view.setBackground(c);
                            }
                        });
                    }
                } else {
                    matcher = TASK_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setTaskField(s1, s2, s3);
                        return;
                    }
                    matcher = PART_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setPartField(s1, s2, s3);
                        return;
                    }
                    matcher = PARTICLE_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setParticleField(s1, s2, s3);
                        return;
                    }
                    matcher = PARTICLE_FEEDER_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setParticleFeederField(s1, s2, s3);
                        return;
                    }
                    matcher = FAN_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setFanField(s1, s2, s3);
                        return;
                    }
                    matcher = THERMOMETER_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setThermometerField(s1, s2, s3);
                        return;
                    }
                    matcher = ANEMOMETER_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setAnemometerField(s1, s2, s3);
                        return;
                    }
                    matcher = HEAT_FLUX_SENSOR_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setHeatFluxSensorField(s1, s2, s3);
                        return;
                    }
                    matcher = BOUNDARY_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setBoundaryField(s1, s2, s3);
                        return;
                    }
                    matcher = TEXT_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setTextField(s1, s2, s3);
                        this.s2d.view.repaint();
                        return;
                    }
                    matcher = IMAGE_FIELD.matcher(s);
                    if (matcher.find()) {
                        int end = matcher.end();
                        String s1 = s.substring(end).trim();
                        int i = s1.indexOf(" ");
                        if (i < 0) {
                            return;
                        }
                        String s2 = s1.substring(0, i).trim();
                        String s3 = s1.substring(i + 1).trim();
                        s1 = s.substring(0, end - 1);
                        this.setImageField(s1, s2, s3);
                        this.s2d.view.repaint();
                        return;
                    }
                }
            }
            return;
        }
        this.out((byte)2, "Command not recognized");
    }

    private void setPartField(String str1, String str2, String str3) {
        Part part = null;
        int lb = str1.indexOf("[");
        int rb = str1.indexOf("]");
        String s = str1.substring(lb + 1, rb).trim();
        float z = Float.NaN;
        try {
            z = Float.parseFloat(s);
        }
        catch (Exception e) {
            z = Float.NaN;
        }
        Part part2 = part = Float.isNaN(z) ? this.s2d.model.getPart(s) : this.s2d.model.getPart(Math.round(z));
        if (part == null) {
            this.showError(str1, "Part " + s + " not found");
            return;
        }
        s = str2.toLowerCase().intern();
        if (str3.startsWith("#")) {
            try {
                z = Integer.parseInt(str3.substring(1), 16);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
        }
        if (str3.startsWith("0X") || str3.startsWith("0x")) {
            try {
                z = Integer.parseInt(str3.substring(2), 16);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
        }
        if (str3.equalsIgnoreCase("true")) {
            z = 1.0f;
        } else if (str3.equalsIgnoreCase("false")) {
            z = 0.0f;
        } else {
            if (s == "label") {
                part.setLabel(str3);
                return;
            }
            if (s == "uid") {
                part.setUid(str3);
                return;
            }
            try {
                z = Float.parseFloat(str3);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
        }
        if (s == "conductivity") {
            part.setThermalConductivity(z);
            this.arrayUpdateRequested = true;
        } else if (s == "thermal_conductivity") {
            part.setThermalConductivity(z);
            this.arrayUpdateRequested = true;
        } else if (s == "capacity") {
            part.setSpecificHeat(z);
            this.arrayUpdateRequested = true;
        } else if (s == "specific_heat") {
            part.setSpecificHeat(z);
            this.arrayUpdateRequested = true;
        } else if (s == "density") {
            part.setDensity(z);
            this.arrayUpdateRequested = true;
        } else if (s == "elasticity") {
            part.setElasticity(z);
        } else if (s == "power") {
            part.setPower(z);
            this.arrayUpdateRequested = true;
        } else if (s == "wind_speed") {
            part.setWindSpeed(z);
            this.arrayUpdateRequested = true;
        } else if (s == "wind_angle") {
            part.setWindAngle((float)Math.toRadians(z));
            this.arrayUpdateRequested = true;
        } else if (s == "temperature") {
            part.setTemperature(z);
            this.arrayUpdateRequested = true;
        } else if (s == "color") {
            part.setFillPattern(new ColorFill(new Color((int)z)));
        } else if (s == "filled") {
            part.setFilled(z > 0.0f);
        } else if (s == "draggable") {
            part.setDraggable(z > 0.0f);
        } else if (s == "transmission" || s == "transmissivity") {
            part.setTransmissivity(z);
            this.arrayUpdateRequested = true;
        } else if (s == "absorption" || s == "absorptivity") {
            part.setAbsorptivity(z);
            this.arrayUpdateRequested = true;
        } else if (s == "reflection" || s == "reflectivity") {
            part.setReflectivity(z);
            this.arrayUpdateRequested = true;
        } else if (s == "scattering") {
            part.setScattering(z == 1.0f);
        } else if (s == "scattering_visible") {
            part.setScatteringVisible(z == 1.0f);
        } else if (s == "emissivity") {
            part.setEmissivity(z);
            this.arrayUpdateRequested = true;
        } else if (s == "constant_temperature") {
            part.setConstantTemperature(z > 0.0f);
            this.arrayUpdateRequested = true;
        }
        Shape shape = part.getShape();
        if (shape instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)shape;
            if (s == "x") {
                r.x = z;
                this.arrayUpdateRequested = true;
            } else if (s == "y") {
                r.y = this.convertVerticalCoordinate(z);
                this.arrayUpdateRequested = true;
            } else if (s == "width") {
                r.width = z;
                this.arrayUpdateRequested = true;
            } else if (s == "height") {
                r.height = z;
                this.arrayUpdateRequested = true;
            }
        } else if (shape instanceof Ellipse2D.Float) {
            Ellipse2D.Float e = (Ellipse2D.Float)shape;
            if (s == "x") {
                e.x = z;
                this.arrayUpdateRequested = true;
            } else if (s == "y") {
                e.y = this.convertVerticalCoordinate(z);
                this.arrayUpdateRequested = true;
            } else if (s == "width") {
                e.width = z;
                this.arrayUpdateRequested = true;
            } else if (s == "height") {
                e.height = z;
                this.arrayUpdateRequested = true;
            }
        } else if (shape instanceof Polygon2D) {
            Polygon2D p = (Polygon2D)shape;
            if (s == "rotation_angle") {
                p.rotateBy(z);
                this.arrayUpdateRequested = true;
            } else if (s == "x") {
                p.translateBy(z - p.getCenter().x, 0.0f);
                this.arrayUpdateRequested = true;
            } else if (s == "y") {
                p.flipY();
                p.translateBy(0.0f, z - p.getCenter().y);
                float ly = this.s2d.model.getLy();
                int n = p.getVertexCount();
                int i = 0;
                while (i < n) {
                    Point2D.Float v = p.getVertex(i);
                    v.y = ly - v.y;
                    ++i;
                }
                this.arrayUpdateRequested = true;
            }
        } else if (shape instanceof Blob2D) {
            Blob2D b = (Blob2D)shape;
            if (s == "rotation_angle") {
                b.rotateBy(z);
                b.update();
                this.arrayUpdateRequested = true;
            } else if (s == "x") {
                b.translateBy(z - b.getCenter().x, 0.0f);
                b.update();
                this.arrayUpdateRequested = true;
            } else if (s == "y") {
                b.flipY();
                b.translateBy(0.0f, z - b.getCenter().y);
                float ly = this.s2d.model.getLy();
                int n = b.getPointCount();
                int i = 0;
                while (i < n) {
                    Point2D.Float v = b.getPoint(i);
                    v.y = ly - v.y;
                    ++i;
                }
                b.update();
                this.arrayUpdateRequested = true;
            }
        }
        if (part.isSelected()) {
            this.s2d.view.setSelectedManipulable(part);
        }
    }

    private void setParticleField(String str1, String str2, String str3) {
        Particle particle = null;
        int lb = str1.indexOf("[");
        int rb = str1.indexOf("]");
        String s = str1.substring(lb + 1, rb).trim();
        float z = Float.NaN;
        try {
            z = Float.parseFloat(s);
        }
        catch (Exception e) {
            z = Float.NaN;
        }
        Particle particle2 = particle = Float.isNaN(z) ? this.s2d.model.getParticle(s) : this.s2d.model.getParticle(Math.round(z));
        if (particle == null) {
            this.showError(str1, "Particle " + s + " not found");
            return;
        }
        s = str2.toLowerCase().intern();
        if (str3.startsWith("#")) {
            try {
                z = Integer.parseInt(str3.substring(1), 16);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
        }
        if (str3.startsWith("0X") || str3.startsWith("0x")) {
            try {
                z = Integer.parseInt(str3.substring(2), 16);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
        }
        if (str3.equalsIgnoreCase("true")) {
            z = 1.0f;
        } else if (str3.equalsIgnoreCase("false")) {
            z = 0.0f;
        } else {
            if (s == "label") {
                particle.setLabel(str3);
                return;
            }
            if (s == "uid") {
                particle.setUid(str3);
                return;
            }
            try {
                z = Float.parseFloat(str3);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
        }
        if (s == "rx") {
            particle.setRx(z);
        } else if (s == "ry") {
            particle.setRy(z);
        } else if (s == "vx") {
            particle.setVx(z);
        } else if (s == "vy") {
            particle.setVy(z);
        } else if (s == "mass") {
            particle.setMass(z);
        } else if (s == "radius") {
            particle.setRadius(z);
        } else if (s == "temperature") {
            particle.setTemperature(z);
        } else if (s == "color") {
            particle.setColor(new Color((int)z));
        } else if (s == "movable") {
            particle.setMovable(z > 0.0f);
        } else if (s == "draggable") {
            particle.setDraggable(z > 0.0f);
        }
    }

    private void setParticleFeederField(String str1, String str2, String str3) {
        ParticleFeeder feeder = null;
        int lb = str1.indexOf("[");
        int rb = str1.indexOf("]");
        String s = str1.substring(lb + 1, rb).trim();
        float z = Float.NaN;
        try {
            z = Float.parseFloat(s);
        }
        catch (Exception e) {
            z = Float.NaN;
        }
        ParticleFeeder particleFeeder = feeder = Float.isNaN(z) ? this.s2d.model.getParticleFeeder(s) : this.s2d.model.getParticleFeeder(Math.round(z));
        if (feeder == null) {
            this.showError(str1, "Particle feeder " + s + " not found");
            return;
        }
        s = str2.toLowerCase().intern();
        if (str3.startsWith("#")) {
            try {
                z = Integer.parseInt(str3.substring(1), 16);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
        }
        if (str3.startsWith("0X") || str3.startsWith("0x")) {
            try {
                z = Integer.parseInt(str3.substring(2), 16);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
        }
        if (str3.equalsIgnoreCase("true")) {
            z = 1.0f;
        } else if (str3.equalsIgnoreCase("false")) {
            z = 0.0f;
        } else {
            if (s == "label") {
                feeder.setLabel(str3);
                return;
            }
            if (s == "uid") {
                feeder.setUid(str3);
                return;
            }
            try {
                z = Float.parseFloat(str3);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
        }
        if (s == "x") {
            feeder.setX(z);
        } else if (s == "y") {
            feeder.setY(z);
        } else if (s == "period") {
            feeder.setPeriod(z);
        } else if (s == "maximum") {
            feeder.setMaximum(Math.round(z));
        } else if (s == "color") {
            feeder.setColor(new Color((int)z));
        } else if (s == "velocitycolor") {
            feeder.setVelocityColor(new Color((int)z));
        } else if (s == "draggable") {
            feeder.setDraggable(z > 0.0f);
        }
    }

    private void setFanField(String str1, String str2, String str3) {
        Fan fan = null;
        int lb = str1.indexOf("[");
        int rb = str1.indexOf("]");
        String s = str1.substring(lb + 1, rb).trim();
        float z = Float.NaN;
        try {
            z = Float.parseFloat(s);
        }
        catch (Exception e) {
            z = Float.NaN;
        }
        Fan fan2 = fan = Float.isNaN(z) ? this.s2d.model.getFan(s) : this.s2d.model.getFan(Math.round(z));
        if (fan == null) {
            this.showError(str1, "Fan " + s + " not found");
            return;
        }
        s = str2.toLowerCase().intern();
        if (str3.equalsIgnoreCase("true")) {
            z = 1.0f;
        } else if (str3.equalsIgnoreCase("false")) {
            z = 0.0f;
        } else {
            if (s == "label") {
                fan.setLabel(str3);
                return;
            }
            if (s == "uid") {
                fan.setUid(str3);
                return;
            }
            try {
                z = Float.parseFloat(str3);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
        }
        if (s == "x") {
            Shape shape = fan.getShape();
            if (shape instanceof Rectangle2D.Float) {
                ((Rectangle2D.Float)shape).x = z;
            }
        } else if (s == "y") {
            Shape shape = fan.getShape();
            if (shape instanceof Rectangle2D.Float) {
                ((Rectangle2D.Float)shape).y = this.s2d.model.getLy() - z;
            }
        } else if (s == "width") {
            Shape shape = fan.getShape();
            if (shape instanceof Rectangle2D.Float) {
                ((Rectangle2D.Float)shape).width = z;
            }
        } else if (s == "height") {
            Shape shape = fan.getShape();
            if (shape instanceof Rectangle2D.Float) {
                ((Rectangle2D.Float)shape).height = z;
            }
        } else if (s == "speed") {
            fan.setSpeed(z);
        } else if (s == "angle") {
            fan.setAngle(z);
        } else if (s == "draggable") {
            fan.setDraggable(z > 0.0f);
        }
    }

    private void setBoundaryField(String str1, String str2, String str3) {
        MassBoundary b;
        int rb;
        int lb = str1.indexOf("[");
        String side = str1.substring(lb + 1, rb = str1.indexOf("]"));
        if (!(side.equalsIgnoreCase("LEFT") || side.equalsIgnoreCase("RIGHT") || side.equalsIgnoreCase("LOWER") || side.equalsIgnoreCase("UPPER"))) {
            this.showError(String.valueOf(str1) + str2 + str3, "Side parameter of boundary not recognized: must be LEFT, RIGHT, UPPER, or LOWER.");
        }
        float z = 0.0f;
        try {
            z = Float.parseFloat(str3);
        }
        catch (Exception e) {
            this.showException(str3, e);
            return;
        }
        String s = str2.toLowerCase().intern();
        if (s == "temperature") {
            ThermalBoundary b2 = this.s2d.model.getThermalBoundary();
            if (b2 instanceof DirichletThermalBoundary) {
                DirichletThermalBoundary db = (DirichletThermalBoundary)b2;
                if (side.equalsIgnoreCase("LEFT")) {
                    db.setTemperatureAtBorder((byte)3, z);
                } else if (side.equalsIgnoreCase("RIGHT")) {
                    db.setTemperatureAtBorder((byte)1, z);
                } else if (side.equalsIgnoreCase("LOWER")) {
                    db.setTemperatureAtBorder((byte)2, z);
                } else if (side.equalsIgnoreCase("UPPER")) {
                    db.setTemperatureAtBorder((byte)0, z);
                }
            }
        } else if (s == "flux") {
            ThermalBoundary b3 = this.s2d.model.getThermalBoundary();
            if (b3 instanceof NeumannThermalBoundary) {
                NeumannThermalBoundary db = (NeumannThermalBoundary)b3;
                if (side.equalsIgnoreCase("LEFT")) {
                    db.setFluxAtBorder((byte)3, z);
                } else if (side.equalsIgnoreCase("RIGHT")) {
                    db.setFluxAtBorder((byte)1, z);
                } else if (side.equalsIgnoreCase("LOWER")) {
                    db.setFluxAtBorder((byte)2, z);
                } else if (side.equalsIgnoreCase("UPPER")) {
                    db.setFluxAtBorder((byte)0, z);
                }
            }
        } else if (s == "mass_flow_type" && (b = this.s2d.model.getMassBoundary()) instanceof SimpleMassBoundary) {
            byte z2 = (byte)z;
            if (z2 == 0 || z2 == 1) {
                SimpleMassBoundary db = (SimpleMassBoundary)b;
                if (side.equalsIgnoreCase("LEFT")) {
                    db.setFlowTypeAtBorder((byte)3, z2);
                } else if (side.equalsIgnoreCase("RIGHT")) {
                    db.setFlowTypeAtBorder((byte)1, z2);
                } else if (side.equalsIgnoreCase("LOWER")) {
                    db.setFlowTypeAtBorder((byte)2, z2);
                } else if (side.equalsIgnoreCase("UPPER")) {
                    db.setFlowTypeAtBorder((byte)0, z2);
                }
            } else {
                this.showError(String.valueOf(str1) + str2 + str3, "Property value not recognized.");
            }
        }
    }

    private void setThermometerField(String str1, String str2, String str3) {
        Thermometer sensor = null;
        int lb = str1.indexOf("[");
        int rb = str1.indexOf("]");
        String s = str1.substring(lb + 1, rb).trim();
        float z = Float.NaN;
        try {
            z = Float.parseFloat(s);
        }
        catch (Exception e) {
            z = Float.NaN;
        }
        Thermometer thermometer = sensor = Float.isNaN(z) ? this.s2d.model.getThermometer(s) : this.s2d.model.getThermometer(Math.round(z));
        if (sensor == null) {
            this.showError(str1, "Thermometer " + s + " not found");
            return;
        }
        s = str2.toLowerCase().intern();
        if (s == "label") {
            sensor.setLabel(str3);
            return;
        }
        if (s == "uid") {
            sensor.setUid(str3);
            return;
        }
        try {
            z = Float.parseFloat(str3);
        }
        catch (Exception e) {
            this.showException(str3, e);
            return;
        }
        if (s == "x") {
            sensor.setX(z);
        } else if (s == "y") {
            sensor.setY(this.convertVerticalCoordinate(z));
        }
    }

    private void setAnemometerField(String str1, String str2, String str3) {
        Anemometer sensor = null;
        int lb = str1.indexOf("[");
        int rb = str1.indexOf("]");
        String s = str1.substring(lb + 1, rb).trim();
        float z = Float.NaN;
        try {
            z = Float.parseFloat(s);
        }
        catch (Exception e) {
            z = Float.NaN;
        }
        Anemometer anemometer = sensor = Float.isNaN(z) ? this.s2d.model.getAnemometer(s) : this.s2d.model.getAnemometer(Math.round(z));
        if (sensor == null) {
            this.showError(str1, "Anemometer " + s + " not found");
            return;
        }
        s = str2.toLowerCase().intern();
        if (s == "label") {
            sensor.setLabel(str3);
            return;
        }
        if (s == "uid") {
            sensor.setUid(str3);
            return;
        }
        try {
            z = Float.parseFloat(str3);
        }
        catch (Exception e) {
            this.showException(str3, e);
            return;
        }
        if (s == "x") {
            sensor.setX(z);
        } else if (s == "y") {
            sensor.setY(this.convertVerticalCoordinate(z));
        }
    }

    private void setHeatFluxSensorField(String str1, String str2, String str3) {
        HeatFluxSensor sensor = null;
        int lb = str1.indexOf("[");
        int rb = str1.indexOf("]");
        String s = str1.substring(lb + 1, rb).trim();
        float z = Float.NaN;
        try {
            z = Float.parseFloat(s);
        }
        catch (Exception e) {
            z = Float.NaN;
        }
        HeatFluxSensor heatFluxSensor = sensor = Float.isNaN(z) ? this.s2d.model.getHeatFluxSensor(s) : this.s2d.model.getHeatFluxSensor(Math.round(z));
        if (sensor == null) {
            this.showError(str1, "Heat flux sensor " + s + " not found");
            return;
        }
        s = str2.toLowerCase().intern();
        if (s == "label") {
            sensor.setLabel(str3);
            return;
        }
        if (s == "uid") {
            sensor.setUid(str3);
            return;
        }
        try {
            z = Float.parseFloat(str3);
        }
        catch (Exception e) {
            this.showException(str3, e);
            return;
        }
        if (s == "x") {
            sensor.setX(z);
        } else if (s == "y") {
            sensor.setY(this.convertVerticalCoordinate(z));
        } else if (s == "angle") {
            sensor.setAngle((float)Math.toRadians(z));
        }
    }

    private void setTaskField(String str1, String str2, String str3) {
        int rb;
        int lb = str1.indexOf("[");
        String s = str1.substring(lb + 1, rb = str1.indexOf("]")).trim();
        Task task = this.s2d.taskManager.getTaskByUid(s);
        if (task == null) {
            this.showError(str1, "Task " + s + " not found");
            return;
        }
        s = str2.toLowerCase().intern();
        if (s == "enabled") {
            task.setEnabled("true".equalsIgnoreCase(str3));
            return;
        }
        if (s == "interval") {
            int z = 0;
            try {
                z = Integer.parseInt(str3);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
            if (z > 0) {
                task.setInterval(z);
            }
            return;
        }
    }

    private void setTextField(String str1, String str2, String str3) {
        TextBox text;
        int lb = str1.indexOf("[");
        int rb = str1.indexOf("]");
        String s = str1.substring(lb + 1, rb);
        float z = Float.NaN;
        try {
            z = Float.parseFloat(s);
        }
        catch (Exception e) {
            this.showException(str1, e);
            return;
        }
        TextBox textBox = text = z != Float.NaN ? this.s2d.view.getTextBox(Math.round(z)) : this.s2d.view.getTextBoxByUid(s);
        if (text == null) {
            return;
        }
        s = str2.toLowerCase().intern();
        if (s == "face") {
            text.setFace(str3);
        } else if (s == "text") {
            text.setLabel(str3);
        } else if (s == "border") {
            text.setBorder("true".equalsIgnoreCase(str3));
        } else if (s == "visible") {
            text.setVisible("true".equalsIgnoreCase(str3));
        } else if (s == "draggable") {
            text.setDraggable("true".equalsIgnoreCase(str3));
        } else {
            if (str3.startsWith("#")) {
                try {
                    z = Integer.parseInt(str3.substring(1), 16);
                }
                catch (Exception e) {
                    this.showException(str3, e);
                    return;
                }
            }
            if (str3.startsWith("0X") || str3.startsWith("0x")) {
                try {
                    z = Integer.parseInt(str3.substring(2), 16);
                }
                catch (Exception e) {
                    this.showException(str3, e);
                    return;
                }
            }
            try {
                z = Float.parseFloat(str3);
            }
            catch (Exception e) {
                this.showException(str3, e);
                return;
            }
            if (s == "color") {
                text.setColor(new Color((int)z));
            } else if (s == "size") {
                text.setSize((int)z);
            } else if (s == "style") {
                text.setStyle((int)z);
            } else if (s == "x") {
                final float z2 = z;
                final Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        text.setX(z2);
                        ((Scripter2D)Scripter2D.this).s2d.view.repaint();
                    }
                };
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EventQueue.invokeLater(r);
                    }
                });
            } else if (s == "y") {
                final float z2 = z;
                final Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        text.setY(z2);
                        ((Scripter2D)Scripter2D.this).s2d.view.repaint();
                    }
                };
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EventQueue.invokeLater(r);
                    }
                });
            }
        }
        this.s2d.view.repaint();
    }

    private void setImageField(String str1, String str2, String str3) {
        int lb = str1.indexOf("[");
        int rb = str1.indexOf("]");
        float z = 0.0f;
        try {
            z = Float.parseFloat(str1.substring(lb + 1, rb));
        }
        catch (Exception e) {
            this.showException(str1, e);
            return;
        }
        int i = Math.round(z);
        if (i < 0 || i >= this.s2d.view.getPictureCount()) {
            return;
        }
        try {
            z = Float.parseFloat(str3);
        }
        catch (Exception e) {
            this.showException(str3, e);
            return;
        }
        String s = str2.toLowerCase().intern();
        final Picture picture = this.s2d.view.getPicture(i);
        if (picture == null) {
            return;
        }
        if (s == "x") {
            final float z2 = z;
            final Runnable r = new Runnable(){

                @Override
                public void run() {
                    picture.setX(z2);
                }
            };
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventQueue.invokeLater(r);
                }
            });
        } else if (s == "y") {
            final float z2 = z;
            final Runnable r = new Runnable(){

                @Override
                public void run() {
                    picture.setY(z2);
                }
            };
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventQueue.invokeLater(r);
                }
            });
        }
    }

    private float convertVerticalCoordinate(float y) {
        return this.s2d.model.getLy() - y;
    }
}

