/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.concord.energy2d.event.ScriptEvent;
import org.concord.energy2d.event.ScriptListener;
import org.concord.energy2d.system.ConsoleTextPane;
import org.concord.energy2d.system.EnterListener;
import org.concord.energy2d.system.System2D;

class ScriptDialog
extends JDialog
implements EnterListener,
ScriptListener {
    private ConsoleTextPane console;
    private System2D box;

    ScriptDialog(System2D s2d) {
        super(JOptionPane.getFrameForComponent(s2d.view), "Script Console", false);
        this.setDefaultCloseOperation(2);
        this.box = s2d;
        this.console = new ConsoleTextPane(this);
        this.console.setPreferredSize(new Dimension(500, 400));
        this.console.setBorder(BorderFactory.createLoweredBevelBorder());
        this.console.setPrompt();
        this.console.appendNewline();
        this.console.setPrompt();
        this.add((Component)new JScrollPane(this.console), "Center");
        JPanel p = new JPanel(new FlowLayout(2));
        this.add((Component)p, "South");
        JButton button = new JButton("Clear");
        button.setToolTipText("Clear the console");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDialog.this.clear();
            }
        });
        p.add(button);
        button = new JButton("Close");
        button.setToolTipText("Close the console");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDialog.this.box.getScripter().removeScriptListener(ScriptDialog.this);
                ScriptDialog.this.dispose();
            }
        });
        p.add(button);
        this.box.getScripter().addScriptListener(this);
    }

    public void scriptEcho(String strEcho) {
        if (strEcho != null) {
            this.console.outputEcho(strEcho);
        }
    }

    public void scriptStatus(String strStatus) {
        if (strStatus != null) {
            this.console.outputStatus(strStatus);
        }
    }

    public void notifyScriptTermination(String strMsg, int msWalltime) {
        if (strMsg != null) {
            this.console.outputError(strMsg);
        }
    }

    private void clear() {
        this.console.clearContent();
        this.console.appendNewline();
        this.console.setPrompt();
    }

    private void executeCommand() {
        String strCommand = this.console.getCommandString().trim();
        if (strCommand.length() == 0) {
            return;
        }
        this.console.requestFocusInWindow();
        if (strCommand.equalsIgnoreCase("clear") || strCommand.equalsIgnoreCase("cls")) {
            this.clear();
            return;
        }
        this.console.appendNewline();
        this.console.setPrompt();
        String strErrorMessage = this.box.runNativeScript(strCommand);
        if (strErrorMessage != null) {
            this.console.outputError(strErrorMessage);
        }
    }

    @Override
    public void enterPressed() {
        this.executeCommand();
    }

    @Override
    public void outputScriptResult(final ScriptEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (e.getStatus()) {
                    case 1: 
                    case 2: {
                        ScriptDialog.this.console.outputError(e.getDescription());
                        break;
                    }
                    case 0: {
                        ScriptDialog.this.console.outputEcho(e.getDescription());
                    }
                }
            }
        });
    }
}

