/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.concord.energy2d.model.Sensor;
import org.concord.energy2d.system.System2D;
import org.concord.energy2d.util.MiscUtil;

class PreferencesDialog
extends JDialog {
    private Window owner;
    private JCheckBox snapToGridCheckBox;
    private JTextField perimeterStepField;
    private JTextField maximumDataPointsField;
    private JComboBox<String> timeUnitComboBox;
    private ActionListener okListener;

    PreferencesDialog(final System2D s2d, boolean modal) {
        super(JOptionPane.getFrameForComponent(s2d.view), "Preferences", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                s2d.view.notifyManipulationListeners(null, (byte)3);
                s2d.view.repaint();
                PreferencesDialog.this.dispose();
            }
        });
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = PreferencesDialog.this.parse(PreferencesDialog.this.perimeterStepField.getText());
                if (Float.isNaN(x)) {
                    return;
                }
                if (x < 1.0f || x > 20.0f) {
                    JOptionPane.showMessageDialog(PreferencesDialog.this.owner, "Perimeter step cannot be smaller than 1% or larger than 20%.", "Error", 0);
                    return;
                }
                s2d.model.setPerimeterStepSize(0.01f * x);
                if (s2d.view.isViewFactorLinesOn()) {
                    s2d.model.generateViewFactorMesh();
                }
                if (Float.isNaN(x = PreferencesDialog.this.parse(PreferencesDialog.this.maximumDataPointsField.getText()))) {
                    return;
                }
                if (x < 100.0f || x > 100000.0f) {
                    JOptionPane.showMessageDialog(PreferencesDialog.this.owner, "Maximum data points should be at least 100 and at most 100000.", "Error", 0);
                    return;
                }
                Sensor.setMaximumDataPoints((int)x);
                s2d.view.setGraphTimeUnit((byte)PreferencesDialog.this.timeUnitComboBox.getSelectedIndex());
                s2d.view.setSnapToGrid(PreferencesDialog.this.snapToGridCheckBox.isSelected());
                s2d.view.notifyManipulationListeners(null, (byte)3);
                s2d.view.repaint();
                PreferencesDialog.this.dispose();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)box, "Center");
        JPanel p = new JPanel(new FlowLayout(0));
        p.setBorder(BorderFactory.createTitledBorder("Edit Mode"));
        box.add(p);
        this.snapToGridCheckBox = new JCheckBox("Snap to computational grid (" + s2d.model.getNx() + " x " + s2d.model.getNy() + ")", s2d.view.isSnapToGrid());
        this.snapToGridCheckBox.setToolTipText("Should objects' shapes and coordinates be snapped to the computational grid?");
        p.add(this.snapToGridCheckBox);
        p = new JPanel(new GridLayout(2, 2, 10, 5));
        p.setBorder(BorderFactory.createTitledBorder("Graphs"));
        box.add(p);
        p.add(new JLabel("Sensor Maximum Data Points:"));
        this.maximumDataPointsField = new JTextField("" + Sensor.getMaximumDataPoints(), 10);
        this.maximumDataPointsField.setToolTipText("Set the maximum number of data points sensors will collect");
        this.maximumDataPointsField.addActionListener(this.okListener);
        p.add(this.maximumDataPointsField);
        p.add(new JLabel("Unit of Time Axis:"));
        this.timeUnitComboBox = new JComboBox<String>(new String[]{"Hour", "Minute", "Second"});
        this.timeUnitComboBox.setSelectedIndex(s2d.view.getGraphTimeUnit());
        this.timeUnitComboBox.setToolTipText("Select the unit for the time axis of the graph");
        this.timeUnitComboBox.addActionListener(this.okListener);
        p.add(this.timeUnitComboBox);
        p = new JPanel(new FlowLayout(0));
        p.setBorder(BorderFactory.createTitledBorder("Perimeter Step"));
        box.add(p);
        p.add(new JLabel("Percentage of the box size:"));
        this.perimeterStepField = new JTextField("" + Math.round(100.0f * s2d.model.getPerimeterStepSize()), 10);
        this.perimeterStepField.setToolTipText("Set the step size for the perimeter of a radiation body");
        this.perimeterStepField.addActionListener(this.okListener);
        p.add(this.perimeterStepField);
        this.pack();
        this.setLocationRelativeTo(s2d.view);
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

