/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.concord.energy2d.system.Helper;
import org.concord.energy2d.system.LinksDialog;
import org.concord.energy2d.system.PreferencesDialog;
import org.concord.energy2d.system.System2D;
import org.concord.energy2d.system.ToolBarEvent;
import org.concord.energy2d.system.XmlDecoder;
import org.concord.energy2d.undo.UndoClearAll;
import org.concord.energy2d.undo.UndoClearAllParticles;
import org.concord.energy2d.undo.UndoColorPalette;
import org.concord.energy2d.undo.UndoControlPanel;
import org.concord.energy2d.undo.UndoGridLines;
import org.concord.energy2d.undo.UndoGridSize;
import org.concord.energy2d.undo.UndoHeatFluxArrows;
import org.concord.energy2d.undo.UndoHeatFluxLines;
import org.concord.energy2d.undo.UndoIsotherm;
import org.concord.energy2d.undo.UndoMouseReadType;
import org.concord.energy2d.undo.UndoScaleAll;
import org.concord.energy2d.undo.UndoSeeThrough;
import org.concord.energy2d.undo.UndoStreamlines;
import org.concord.energy2d.undo.UndoTickmarks;
import org.concord.energy2d.undo.UndoVelocity;
import org.concord.energy2d.undo.UndoViewFactorLines;
import org.concord.energy2d.util.FileChooser;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.util.ScreenshotSaver;

class MenuBar
extends JMenuBar {
    private static final boolean IS_MAC = System.getProperty("os.name").startsWith("Mac");
    FileChooser e2dFileChooser;
    private FileChooser htmFileChooser;
    private FileFilter e2dFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName();
            int index = filename.lastIndexOf(46);
            if (index == -1) {
                return false;
            }
            String postfix = filename.substring(index + 1);
            return "e2d".equalsIgnoreCase(postfix);
        }

        @Override
        public String getDescription() {
            return "Energy2D";
        }
    };
    private FileFilter htmFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName();
            int index = filename.lastIndexOf(46);
            if (index == -1) {
                return false;
            }
            String postfix = filename.substring(index + 1);
            return "htm".equalsIgnoreCase(postfix);
        }

        @Override
        public String getDescription() {
            return "HTML";
        }
    };
    private Action openAction;
    private Action saveAction;
    private Action saveAsAction;
    private Action saveAsAppletAction;
    private Action exitAction;
    private ScreenshotSaver screenshotSaver;
    private int fileMenuItemCount;
    private List<JComponent> recentFileMenuItems;

    MenuBar(final System2D box, final JFrame frame) {
        this.e2dFileChooser = new FileChooser();
        this.htmFileChooser = new FileChooser();
        this.recentFileMenuItems = new ArrayList<JComponent>();
        final JMenu fileMenu = new JMenu("File");
        fileMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                int n;
                String[] recentFiles;
                if (!MenuBar.this.recentFileMenuItems.isEmpty()) {
                    for (JComponent x : MenuBar.this.recentFileMenuItems) {
                        fileMenu.remove(x);
                    }
                }
                if ((recentFiles = MenuBar.this.getRecentFiles()) != null && (n = recentFiles.length) > 0) {
                    int i = 0;
                    while (i < n) {
                        JMenuItem x = new JMenuItem(String.valueOf(i + 1) + "  " + MiscUtil.getFileName(recentFiles[i]));
                        x.setToolTipText(recentFiles[i]);
                        final File rf = new File(recentFiles[i]);
                        x.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (!box.askSaveBeforeLoading()) {
                                    return;
                                }
                                box.loadFile(rf);
                                (this).MenuBar.this.e2dFileChooser.rememberFile(rf.getPath());
                            }
                        });
                        fileMenu.insert(x, MenuBar.this.fileMenuItemCount + i);
                        MenuBar.this.recentFileMenuItems.add(x);
                        ++i;
                    }
                    JSeparator s = new JSeparator();
                    fileMenu.add((Component)s, MenuBar.this.fileMenuItemCount + n);
                    MenuBar.this.recentFileMenuItems.add(s);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.add(fileMenu);
        JMenuItem mi = new JMenuItem("New");
        mi.setToolTipText("Create a new simulation");
        KeyStroke ks = IS_MAC ? KeyStroke.getKeyStroke(78, 4) : KeyStroke.getKeyStroke(78, 2);
        mi.setAccelerator(ks);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!box.askSaveBeforeLoading()) {
                    return;
                }
                box.model.clear();
                box.model.refreshMaterialPropertyArrays();
                box.model.refreshPowerArray();
                box.model.refreshTemperatureBoundaryArray();
                box.view.clear();
                box.setCurrentFile(null);
                box.setCurrentModel(null);
                box.setFrameTitle();
                XmlDecoder x = new XmlDecoder(box);
                x.startDocument();
                x.endDocument();
                box.view.setGridOn(true);
                box.view.setBorderTickmarksOn(true);
                box.view.repaint();
                box.notifyToolBarListener(new ToolBarEvent(3, MenuBar.this));
                box.setSaved(true);
                box.view.getUndoManager().die();
            }
        });
        fileMenu.add(mi);
        ++this.fileMenuItemCount;
        this.openAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!box.askSaveBeforeLoading()) {
                    return;
                }
                MenuBar.this.e2dFileChooser.setAcceptAllFileFilterUsed(false);
                MenuBar.this.e2dFileChooser.addChoosableFileFilter(MenuBar.this.e2dFilter);
                MenuBar.this.e2dFileChooser.setDialogType(0);
                MenuBar.this.e2dFileChooser.setDialogTitle("Open");
                MenuBar.this.e2dFileChooser.setApproveButtonMnemonic('O');
                MenuBar.this.e2dFileChooser.setAccessory(null);
                if (MenuBar.this.e2dFileChooser.showOpenDialog(frame) == 0) {
                    File file = MenuBar.this.e2dFileChooser.getSelectedFile();
                    if (!file.toString().endsWith(".e2d")) {
                        file = new File(String.valueOf(file.toString()) + ".e2d");
                    }
                    if (file.exists()) {
                        box.loadFile(file);
                    } else {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(box), "File " + file + " was not found.", "File not found", 0);
                    }
                    MenuBar.this.e2dFileChooser.rememberFile(file.getPath());
                }
                MenuBar.this.e2dFileChooser.resetChoosableFileFilters();
            }
        };
        this.openAction.putValue("ShortDescription", "Open a simulation");
        ks = IS_MAC ? KeyStroke.getKeyStroke(79, 4) : KeyStroke.getKeyStroke(79, 2);
        box.view.getInputMap().put(ks, "Open");
        box.view.getActionMap().put("Open", this.openAction);
        mi = new JMenuItem("Open...");
        mi.setAccelerator(ks);
        mi.setToolTipText((String)this.openAction.getValue("ShortDescription"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.openAction.actionPerformed(e);
            }
        });
        fileMenu.add(mi);
        ++this.fileMenuItemCount;
        this.saveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (box.getCurrentFile() == null) {
                    MenuBar.this.saveAs(box, frame);
                } else {
                    MenuBar.this.save(box);
                }
            }
        };
        this.saveAction.putValue("ShortDescription", "Save a simulation");
        ks = IS_MAC ? KeyStroke.getKeyStroke(83, 4) : KeyStroke.getKeyStroke(83, 2);
        box.view.getInputMap().put(ks, "Save");
        box.view.getActionMap().put("Save", this.saveAction);
        mi = new JMenuItem("Save");
        mi.setAccelerator(ks);
        mi.setToolTipText((String)this.saveAction.getValue("ShortDescription"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.saveAction.actionPerformed(e);
            }
        });
        fileMenu.add(mi);
        ++this.fileMenuItemCount;
        this.saveAsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.saveAs(box, frame);
            }
        };
        this.saveAsAction.putValue("ShortDescription", "Save a simulation as");
        ks = IS_MAC ? KeyStroke.getKeyStroke(65, 4) : KeyStroke.getKeyStroke(65, 2);
        box.view.getInputMap().put(ks, "SaveAs");
        box.view.getActionMap().put("SaveAs", this.saveAsAction);
        mi = new JMenuItem("Save As...");
        mi.setAccelerator(ks);
        mi.setToolTipText((String)this.saveAsAction.getValue("ShortDescription"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.saveAsAction.actionPerformed(e);
            }
        });
        fileMenu.add(mi);
        ++this.fileMenuItemCount;
        this.screenshotSaver = new ScreenshotSaver(box.view, true);
        fileMenu.add(this.screenshotSaver);
        ++this.fileMenuItemCount;
        this.saveAsAppletAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (box.getCurrentFile() == null) {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(box.view), "Sorry, you have to save the current model as a local file in order to create an applet for it.", "Applet not allowed", 0);
                    return;
                }
                MenuBar.this.saveAsApplet(box, frame);
            }
        };
        this.saveAsAppletAction.putValue("ShortDescription", "Export this simulation as an applet");
        mi = new JMenuItem("Save As Applet...");
        mi.setToolTipText((String)this.saveAsAppletAction.getValue("ShortDescription"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.saveAsAppletAction.actionPerformed(e);
            }
        });
        fileMenu.add(mi);
        ++this.fileMenuItemCount;
        fileMenu.addSeparator();
        ++this.fileMenuItemCount;
        final Action propertyAction = box.view.getActionMap().get("Property");
        mi = new JMenuItem("Properties...");
        mi.setAccelerator((KeyStroke)propertyAction.getValue("AcceleratorKey"));
        mi.setToolTipText((String)propertyAction.getValue("ShortDescription"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                propertyAction.actionPerformed(e);
            }
        });
        fileMenu.add(mi);
        ++this.fileMenuItemCount;
        final Action scriptAction = box.view.getActionMap().get("Script");
        mi = new JMenuItem("Script Console...");
        mi.setAccelerator((KeyStroke)scriptAction.getValue("AcceleratorKey"));
        mi.setToolTipText((String)scriptAction.getValue("ShortDescription"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scriptAction.actionPerformed(e);
            }
        });
        fileMenu.add(mi);
        ++this.fileMenuItemCount;
        final Action taskAction = box.view.getActionMap().get("Task_Manager");
        mi = new JMenuItem("Task Manager...");
        mi.setAccelerator((KeyStroke)taskAction.getValue("AcceleratorKey"));
        mi.setToolTipText((String)taskAction.getValue("ShortDescription"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                taskAction.actionPerformed(e);
            }
        });
        fileMenu.add(mi);
        ++this.fileMenuItemCount;
        if (!IS_MAC) {
            fileMenu.addSeparator();
            ++this.fileMenuItemCount;
        }
        this.exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (box.askSaveOption()) {
                    case 0: {
                        Action a = null;
                        a = box.getCurrentFile() != null ? box.view.getActionMap().get("Save") : box.view.getActionMap().get("SaveAs");
                        if (a != null) {
                            a.actionPerformed(null);
                        }
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                box.shutdown();
                                System.exit(0);
                            }
                        });
                        break;
                    }
                    case 1: {
                        box.shutdown();
                        System.exit(0);
                        break;
                    }
                }
            }
        };
        this.exitAction.putValue("ShortDescription", "Close Energy2D V2.3");
        ks = IS_MAC ? KeyStroke.getKeyStroke(81, 4) : KeyStroke.getKeyStroke(81, 2);
        box.view.getInputMap().put(ks, "Quit");
        box.view.getActionMap().put("Quit", this.exitAction);
        if (!IS_MAC) {
            mi = new JMenuItem("Exit");
            mi.setAccelerator(ks);
            mi.setToolTipText((String)this.exitAction.getValue("ShortDescription"));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuBar.this.exitAction.actionPerformed(e);
                }
            });
            fileMenu.add(mi);
        }
        JMenu menu = new JMenu("Insert");
        this.add(menu);
        menu.add(box.view.getActionMap().get("Insert Thermometer"));
        menu.add(box.view.getActionMap().get("Insert Heat Flux Sensor"));
        menu.add(box.view.getActionMap().get("Insert Anemometer"));
        menu.addSeparator();
        menu.add(box.view.getActionMap().get("Insert Particle"));
        menu.add(box.view.getActionMap().get("Insert Particle Feeder"));
        menu.addSeparator();
        menu.add(box.view.getActionMap().get("Insert Fan"));
        menu.add(box.view.getActionMap().get("Insert Heliostat"));
        menu.addSeparator();
        menu.add(box.view.getActionMap().get("Insert Cloud"));
        menu.add(box.view.getActionMap().get("Insert Tree"));
        menu.add(box.view.getActionMap().get("Insert Text Box"));
        menu = new JMenu("Edit");
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JMenu src = (JMenu)e.getSource();
                int n = src.getMenuComponentCount();
                int i = 0;
                while (i < n) {
                    Component c = src.getMenuComponent(i);
                    if (c instanceof JMenuItem) {
                        JMenuItem mi = (JMenuItem)c;
                        String text = mi.getText();
                        if (text.equals("Cut") || text.equals("Copy")) {
                            mi.setEnabled(box.view.getSelectedManipulable() != null);
                        } else if (text.equals("Paste")) {
                            mi.setEnabled(box.view.getBufferedManipulable() != null);
                        }
                        if (text.startsWith("Undo")) {
                            mi.setEnabled(box.view.getUndoManager().canUndo());
                            mi.setText(box.view.getUndoManager().getUndoPresentationName());
                        }
                        if (text.startsWith("Redo")) {
                            mi.setEnabled(box.view.getUndoManager().canRedo());
                            mi.setText(box.view.getUndoManager().getRedoPresentationName());
                        }
                    }
                    ++i;
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.add(menu);
        menu.add(box.view.getActionMap().get("Undo"));
        menu.add(box.view.getActionMap().get("Redo"));
        menu.addSeparator();
        menu.add(box.view.getActionMap().get("Cut"));
        menu.add(box.view.getActionMap().get("Copy"));
        menu.add(box.view.getActionMap().get("Paste"));
        menu.addSeparator();
        mi = new JMenuItem("Clear All");
        mi.setToolTipText("Remove all the model elements");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(box.view), "Are you sure you want to remove all objects?", "Confirm", 0) == 0) {
                    box.view.getUndoManager().addEdit(new UndoClearAll(box.view));
                    box.model.clear();
                    box.model.refreshMaterialPropertyArrays();
                    box.model.refreshPowerArray();
                    box.model.refreshTemperatureBoundaryArray();
                    box.view.clear();
                    box.view.repaint();
                }
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Clear All Particles");
        mi.setToolTipText("Remove all particles");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (box.model.getParticles().isEmpty()) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(box.view), "Are you sure you want to remove all particles?", "Confirm", 0) == 0) {
                    box.view.getUndoManager().addEdit(new UndoClearAllParticles(box.view));
                    box.model.getParticles().clear();
                    box.model.refreshMaterialPropertyArrays();
                    box.model.refreshPowerArray();
                    box.model.refreshTemperatureBoundaryArray();
                    box.view.repaint();
                    box.setSaved(false);
                }
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Translate All");
        mi.setToolTipText("Translate all the model elements");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(box.view), "<html>Hold down the ALT key and use the arrow keys to move around.<br>To move more slowly, also hold down the " + (IS_MAC ? "Command" : "CTRL") + " key.", "Translate all elements", 1);
                box.view.requestFocusInWindow();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Scale All");
        mi.setToolTipText("Scale all the model elements");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(JOptionPane.getFrameForComponent(box.view), "Type a scale factor (must be a positive number):", "Scale All", 3);
                if (s == null || s.trim().equals("")) {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(box.view), "Please type a positive number.", "Scale factor error", 0);
                    return;
                }
                float x = MenuBar.this.parse(s);
                if (Float.isNaN(x)) {
                    return;
                }
                if (x <= 0.0f) {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(box.view), "Scale factor must be a positive number.", "Scale factor error", 0);
                    return;
                }
                box.view.scaleAll(x);
                box.view.getUndoManager().addEdit(new UndoScaleAll(box.view, x));
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Links");
        mi.setToolTipText("Set links to previous and next simulations");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinksDialog d = new LinksDialog(box, true);
                d.setVisible(true);
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Preferences");
        mi.setToolTipText("Set preferences");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog d = new PreferencesDialog(box, true);
                d.setVisible(true);
            }
        });
        menu.add(mi);
        final JCheckBoxMenuItem miSeeThrough = new JCheckBoxMenuItem("See-Through");
        final JCheckBoxMenuItem miIsotherm = new JCheckBoxMenuItem("Isotherm");
        final JCheckBoxMenuItem miVelocity = new JCheckBoxMenuItem("Velocity");
        final JCheckBoxMenuItem miStreamline = new JCheckBoxMenuItem("Streamlines");
        final JCheckBoxMenuItem miHeatFluxArrow = new JCheckBoxMenuItem("Heat Flux Arrows");
        final JCheckBoxMenuItem miHeatFluxLine = new JCheckBoxMenuItem("Heat Flux Lines");
        final JCheckBoxMenuItem miColorPalette = new JCheckBoxMenuItem("Color Palette");
        final JCheckBoxMenuItem miViewFactorLines = new JCheckBoxMenuItem("View Factor Lines");
        final JCheckBoxMenuItem miTickmarks = new JCheckBoxMenuItem("Border Tickmarks");
        final JCheckBoxMenuItem miGrid = new JCheckBoxMenuItem("Grid");
        final JMenuItem miIncrGrid = new JMenuItem("Increase Grid Lines");
        final JMenuItem miDecrGrid = new JMenuItem("Decrease Grid Lines");
        final JCheckBoxMenuItem miControlPanel = new JCheckBoxMenuItem("Control Panel");
        menu = new JMenu("View");
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                MiscUtil.setSelectedSilently(miSeeThrough, box.view.getSeeThrough());
                MiscUtil.setSelectedSilently(miIsotherm, box.view.isIsothermOn());
                MiscUtil.setSelectedSilently(miVelocity, box.view.isVelocityOn());
                MiscUtil.setSelectedSilently(miStreamline, box.view.isStreamlineOn());
                MiscUtil.setSelectedSilently(miHeatFluxArrow, box.view.isHeatFluxArrowsOn());
                MiscUtil.setSelectedSilently(miHeatFluxLine, box.view.isHeatFluxLinesOn());
                MiscUtil.setSelectedSilently(miColorPalette, box.view.isColorPaletteOn());
                MiscUtil.setSelectedSilently(miViewFactorLines, box.view.isViewFactorLinesOn());
                MiscUtil.setSelectedSilently(miTickmarks, box.view.isBorderTickmarksOn());
                MiscUtil.setSelectedSilently(miGrid, box.view.isGridOn());
                miIncrGrid.setEnabled(box.view.isGridOn());
                miDecrGrid.setEnabled(box.view.isGridOn());
                MiscUtil.setSelectedSilently(miControlPanel, box.view.isControlPanelVisible());
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.add(menu);
        miSeeThrough.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoSeeThrough(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setSeeThrough(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miSeeThrough.setToolTipText("Make all parts transparent to see heat flows inside them");
        menu.add(miSeeThrough);
        miIsotherm.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoIsotherm(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setIsothermOn(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miIsotherm.setToolTipText("Show isotherm lines");
        menu.add(miIsotherm);
        miHeatFluxLine.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoHeatFluxLines(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setHeatFluxLinesOn(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miHeatFluxLine.setToolTipText("Show heat flux lines");
        menu.add(miHeatFluxLine);
        miHeatFluxArrow.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoHeatFluxArrows(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setHeatFluxArrowsOn(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miHeatFluxArrow.setToolTipText("Show heat flux arrows");
        menu.add(miHeatFluxArrow);
        miVelocity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoVelocity(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setVelocityOn(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miVelocity.setToolTipText("Show velocity vectors");
        menu.add(miVelocity);
        miStreamline.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoStreamlines(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setStreamlineOn(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miStreamline.setToolTipText("Show streamlines");
        menu.add(miStreamline);
        miViewFactorLines.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoViewFactorLines(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setViewFactorLinesOn(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miViewFactorLines.setToolTipText("Show the view factor lines");
        menu.add(miViewFactorLines);
        JRadioButtonMenuItem miMouseDefafult = new JRadioButtonMenuItem("Default");
        JRadioButtonMenuItem miMouseTemperature = new JRadioButtonMenuItem("Temperature");
        JRadioButtonMenuItem miMouseEnergy = new JRadioButtonMenuItem("Thermal Energy");
        JRadioButtonMenuItem miMouseVelocity = new JRadioButtonMenuItem("Velocity");
        JRadioButtonMenuItem miMouseHeatFlux = new JRadioButtonMenuItem("Heat Flux");
        JRadioButtonMenuItem miMouseCoordinates = new JRadioButtonMenuItem("Coordinates");
        ButtonGroup bg = new ButtonGroup();
        bg.add(miMouseDefafult);
        bg.add(miMouseTemperature);
        bg.add(miMouseEnergy);
        bg.add(miMouseVelocity);
        bg.add(miMouseHeatFlux);
        bg.add(miMouseCoordinates);
        final JMenu mouseMenu = new JMenu("Mouse Reading");
        mouseMenu.setToolTipText("Select a property the value of which at a mouse position will be shown when it moves");
        mouseMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JRadioButtonMenuItem x = (JRadioButtonMenuItem)mouseMenu.getMenuComponent(box.view.getMouseReadType());
                MiscUtil.setSelectedSilently(x, true);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        menu.add(mouseMenu);
        menu.addSeparator();
        miMouseDefafult.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    box.view.getUndoManager().addEdit(new UndoMouseReadType(box.view));
                    box.view.setMouseReadType((byte)0);
                }
            }
        });
        mouseMenu.add(miMouseDefafult);
        miMouseTemperature.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    box.view.getUndoManager().addEdit(new UndoMouseReadType(box.view));
                    box.view.setMouseReadType((byte)1);
                }
            }
        });
        mouseMenu.add(miMouseTemperature);
        miMouseEnergy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    box.view.getUndoManager().addEdit(new UndoMouseReadType(box.view));
                    box.view.setMouseReadType((byte)2);
                }
            }
        });
        mouseMenu.add(miMouseEnergy);
        miMouseVelocity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    box.view.getUndoManager().addEdit(new UndoMouseReadType(box.view));
                    box.view.setMouseReadType((byte)3);
                }
            }
        });
        mouseMenu.add(miMouseVelocity);
        miMouseHeatFlux.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    box.view.getUndoManager().addEdit(new UndoMouseReadType(box.view));
                    box.view.setMouseReadType((byte)4);
                }
            }
        });
        mouseMenu.add(miMouseHeatFlux);
        miMouseCoordinates.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    box.view.getUndoManager().addEdit(new UndoMouseReadType(box.view));
                    box.view.setMouseReadType((byte)5);
                }
            }
        });
        mouseMenu.add(miMouseCoordinates);
        miColorPalette.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoColorPalette(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setColorPaletteOn(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miColorPalette.setToolTipText("Show the Color Palette");
        menu.add(miColorPalette);
        miControlPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoControlPanel(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setControlPanelVisible(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miControlPanel.setToolTipText("Show the built-in control panel");
        menu.add(miControlPanel);
        menu.addSeparator();
        miTickmarks.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoTickmarks(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setBorderTickmarksOn(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miTickmarks.setToolTipText("Show the tickmarks on borders");
        menu.add(miTickmarks);
        miGrid.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                box.view.getUndoManager().addEdit(new UndoGridLines(box.view));
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                box.view.setGridOn(src.isSelected());
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miGrid.setToolTipText("Show grid lines");
        menu.add(miGrid);
        ks = KeyStroke.getKeyStroke(91, 8);
        miIncrGrid.setAccelerator(ks);
        miIncrGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                box.view.getUndoManager().addEdit(new UndoGridSize(box.view));
                int gridSize = box.view.getGridSize();
                if (gridSize > 2) {
                    box.view.setGridSize(--gridSize);
                }
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miIncrGrid.setToolTipText("Increase grid lines");
        menu.add(miIncrGrid);
        ks = KeyStroke.getKeyStroke(93, 8);
        miDecrGrid.setAccelerator(ks);
        miDecrGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                box.view.getUndoManager().addEdit(new UndoGridSize(box.view));
                int gridSize = box.view.getGridSize();
                if (gridSize < 25) {
                    box.view.setGridSize(++gridSize);
                }
                box.view.repaint();
                box.view.notifyManipulationListeners(null, (byte)3);
            }
        });
        miDecrGrid.setToolTipText("Decrease grid lines");
        menu.add(miDecrGrid);
        menu.addSeparator();
        mi = new JMenuItem("More...");
        mi.setToolTipText("Open the View Options");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                box.view.createDialog(box.view, false);
            }
        });
        menu.add(mi);
        menu = new JMenu("Examples");
        this.add(menu);
        JMenu subMenu = new JMenu("Heat and Temperature");
        menu.add(subMenu);
        LinkedHashMap<String, String> examples = new LinkedHashMap<String, String>();
        examples.put("Thermal Equilibrium Between Identical Objects", "examples/identical-heat-capacity.e2d");
        examples.put("Thermal Equilibrium Between Objects with Different Specific Heats", "examples/different-specific-heat1.e2d");
        examples.put("Thermal Equilibrium Between Objects with Different Densities", "examples/different-density1.e2d");
        examples.put("The Effect of Thermal Conductivity on Equilibration Speed", "examples/different-conductivity.e2d");
        examples.put("The Zeroth Law of Thermodynamics", "examples/zeroth.e2d");
        examples.put("The First Law of Thermodynamics", "examples/conservation-of-energy.e2d");
        this.createMenu(box, subMenu, examples);
        subMenu = new JMenu("Conduction");
        menu.add(subMenu);
        examples.put("Comparing Thermal Conductivities", "examples/conduction1.e2d");
        examples.put("Comparing Conduction Areas", "examples/conduction2.e2d");
        examples.put("Comparing Temperature Differences", "examples/conduction3.e2d");
        examples.put("Comparing Conducting Distances", "examples/conduction4.e2d");
        examples.put("Comparing Specific Heats", "examples/conduction5.e2d");
        examples.put("The Series Circuit Analogy", "examples/series-circuit-analogy.e2d");
        examples.put("The Parallel Circuit Analogy", "examples/parallel-circuit-analogy.e2d");
        examples.put("Why We Feel Hot or Cold When Touching Something", "examples/hand.e2d");
        examples.put("Wood Spoon vs. Metal Spoon", "examples/spoon.e2d");
        this.createMenu(box, subMenu, examples);
        subMenu = new JMenu("Convection");
        menu.add(subMenu);
        examples.put("Natural Convection", "examples/natural-convection.e2d");
        examples.put("Natural Convection with Different Temperatures", "examples/natural-convection-temperature.e2d");
        examples.put("Comparing Natural Convection and Conduction", "examples/compare-convection-conduction.e2d");
        examples.put("Comparing Forced Convection and Conduction", "examples/forced-convection.e2d");
        examples.put("Comparing Forced Convection at Different Temperatures", "examples/forced-convection1.e2d");
        examples.put("Stack Effect", "examples/stack-effect.e2d");
        this.createMenu(box, subMenu, examples);
        subMenu = new JMenu("Radiation");
        menu.add(subMenu);
        examples.put("Temperature Dependence", "examples/stefan.e2d");
        examples.put("Angular Dependence", "examples/viewfactor.e2d");
        examples.put("Symmetry Test Case", "examples/radiation-symmetry-test.e2d");
        examples.put("Radiation in a Box", "examples/radiation-box.e2d");
        examples.put("Radiation to a Ring", "examples/radiation-ring.e2d");
        examples.put("Concave Radiators", "examples/concave.e2d");
        examples.put("Reflective Radiation Heat Transfer", "examples/radiation-reflection.e2d");
        this.createMenu(box, subMenu, examples);
        subMenu = new JMenu("Fluid Dynamics");
        menu.add(subMenu);
        examples.put("B\u00e9nard Cell", "examples/benard-cell.e2d");
        examples.put("Lid-Driven Cavity", "examples/lid-driven-cavity.e2d");
        examples.put("Smoke in Wind", "examples/smoke-in-wind.e2d");
        examples.put("Laminar/Turbulent Flow", "examples/reynolds.e2d");
        examples.put("Von K\u00e1rm\u00e1n Vortex Street", "examples/vortex-street.e2d");
        examples.put("Double Vortex Streets", "examples/double-vortex-streets.e2d");
        examples.put("Eddy", "examples/eddy1.e2d");
        examples.put("Nozzle", "examples/nozzle.e2d");
        this.createMenu(box, subMenu, examples);
        subMenu = new JMenu("Particle Coupling");
        menu.add(subMenu);
        examples.put("Elasticity", "examples/compare-elasticity.e2d");
        examples.put("Inelastic Collisions", "examples/inelastic-collision.e2d");
        examples.put("Fireballs", "examples/fireballs.e2d");
        examples.put("Advection", "examples/advect1.e2d");
        examples.put("Convective Lift", "examples/particles.e2d");
        examples.put("Thermophoresis", "examples/thermophoresis.e2d");
        this.createMenu(box, subMenu, examples);
        subMenu = new JMenu("Building Energy Analysis");
        menu.add(subMenu);
        examples.put("Thermal Bridge", "examples/thermal-bridge.e2d");
        examples.put("Thermal Ghosting", "examples/ghosting.e2d");
        examples.put("Heat Loss through Basement", "examples/basement.e2d");
        examples.put("Fireplace", "examples/fireplace-on.e2d");
        examples.put("Thermostats", "examples/thermostat2.e2d");
        examples.put("Infiltration", "examples/infiltration.e2d");
        examples.put("Wind Effect", "examples/wind-effect.e2d");
        examples.put("Solar Heating: Gable Roof", "examples/solar-heating-gable-roof.e2d");
        examples.put("Solar Heating: Shed Roof", "examples/solar-heating-skillion-roof.e2d");
        examples.put("Solar Heating: Two Stories", "examples/solar-heating-two-story.e2d");
        examples.put("Solar Heating: Convection", "examples/solar-heating-convection.e2d");
        examples.put("Solar Heating: Thermostat", "examples/thermostat1.e2d");
        this.createMenu(box, subMenu, examples);
        subMenu = new JMenu("Industrial Applications");
        menu.add(subMenu);
        examples.put("Solar Oven", "examples/solar-oven.e2d");
        examples.put("Solar Chimney", "examples/solar-chimney.e2d");
        examples.put("Trombe Wall", "examples/trombe-wall-closeup.e2d");
        examples.put("Solar Updraft Tower", "examples/solar-updraft-tower.e2d");
        examples.put("Solar Thermal Power Plant", "examples/solar-thermal-power-plant.e2d");
        examples.put("Jet Impingement Cooling", "examples/jet-impingement.e2d");
        examples.put("Heat Fins", "examples/fin1.e2d");
        examples.put("Coaxial Cable", "examples/cable.e2d");
        examples.put("NTC/PTC Thermistors", "examples/thermistors.e2d");
        this.createMenu(box, subMenu, examples);
        subMenu = new JMenu("Earth Science");
        menu.add(subMenu);
        examples.put("Solar Cycles", "examples/solar-cycles-shadow.e2d");
        examples.put("Sun & Clouds", "examples/solar-cycles.e2d");
        examples.put("USA Isotherm", "examples/usa-isotherm.e2d");
        examples.put("Mantle Convection", "examples/mantle.e2d");
        this.createMenu(box, subMenu, examples);
        subMenu = new JMenu("Boundary Conditions");
        menu.add(subMenu);
        examples.put("Fixed Temperature Boundary", "examples/fixed-temperature-boundary.e2d");
        examples.put("Fixed Heat Flux Boundary", "examples/fixed-flux-boundary.e2d");
        this.createMenu(box, subMenu, examples);
        subMenu = new JMenu("Miscellaneous");
        menu.add(subMenu);
        examples.put("Complex Shapes", "examples/frigate.e2d");
        examples.put("Collision Detection", "examples/collision.e2d");
        examples.put("Ray Optics", "examples/ray-tracing.e2d");
        examples.put("Natural Daylighting", "examples/natural-daylighting.e2d");
        examples.put("Thermoregulation", "examples/thermoregulation.e2d");
        this.createMenu(box, subMenu, examples);
        menu.addSeparator();
        mi = new JMenuItem("More...");
        mi.setToolTipText("Open the Online Model Repository");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Helper.openBrowser("http://energy.concord.org/energy2d/models.html");
            }
        });
        menu.add(mi);
        menu = new JMenu("Help");
        this.add(menu);
        mi = new JMenuItem("Keyboard Shortcuts...");
        mi.setToolTipText("See what keyboard shortcuts are supported");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Helper.showKeyboardShortcuts(frame);
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Online Manual...");
        mi.setAccelerator(KeyStroke.getKeyStroke(112, 0, true));
        mi.setToolTipText("Open the Online Manual");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Helper.openBrowser("http://energy.concord.org/energy2d/manual");
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Contact Us...");
        mi.setToolTipText("Contact us");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Helper.openBrowser("http://energy.concord.org/energy2d/contact.html");
            }
        });
        menu.add(mi);
        if (!System.getProperty("os.name").startsWith("Mac")) {
            menu.addSeparator();
            mi = new JMenuItem("About...");
            mi.setToolTipText("About Energy2D V2.3");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Helper.showAbout(frame);
                }
            });
            menu.add(mi);
        }
    }

    private void createMenu(final System2D box, JMenu menu, LinkedHashMap<String, String> templates) {
        for (Map.Entry<String, String> x : templates.entrySet()) {
            JMenuItem mi = new JMenuItem(x.getKey());
            final String val = x.getValue();
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    box.loadModel(val);
                }
            });
            menu.add(mi);
        }
        templates.clear();
    }

    void setLatestPath(String latestPath, String type) {
        if (latestPath != null) {
            if ("htm".equalsIgnoreCase(type)) {
                this.htmFileChooser.setCurrentDirectory(new File(latestPath));
            } else if ("png".equalsIgnoreCase(type)) {
                this.screenshotSaver.setCurrentDirectory(new File(latestPath));
            } else if ("e2d".equalsIgnoreCase(type)) {
                this.e2dFileChooser.setCurrentDirectory(new File(latestPath));
            }
        }
    }

    String getLatestPath(String type) {
        if ("htm".equalsIgnoreCase(type)) {
            return this.htmFileChooser.getLatestPath();
        }
        if ("png".equalsIgnoreCase(type)) {
            return this.screenshotSaver.getLatestPath();
        }
        return this.e2dFileChooser.getLatestPath();
    }

    void addRecentFile(String path) {
        if (path != null) {
            this.e2dFileChooser.addRecentFile(path);
        }
    }

    String[] getRecentFiles() {
        return this.e2dFileChooser.getRecentFiles();
    }

    private void save(System2D box) {
        try {
            box.saveState(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(box.getCurrentFile()), "UTF-8")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveAs(System2D box, JFrame frame) {
        this.e2dFileChooser.setAcceptAllFileFilterUsed(false);
        this.e2dFileChooser.addChoosableFileFilter(this.e2dFilter);
        this.e2dFileChooser.setDialogType(1);
        this.e2dFileChooser.setDialogTitle("Save");
        this.e2dFileChooser.setApproveButtonMnemonic('S');
        if (this.e2dFileChooser.showSaveDialog(frame) == 0) {
            File file = this.e2dFileChooser.getSelectedFile();
            if (!file.toString().toLowerCase().endsWith(".e2d")) {
                file = new File(file.getParentFile(), String.valueOf(MiscUtil.getFileName(file.toString())) + ".e2d");
            }
            boolean b = true;
            if (file.exists() && JOptionPane.showConfirmDialog(frame, "File " + file.getName() + " exists, overwrite?", "File exists", 0) != 0) {
                b = false;
            }
            if (b) {
                box.setCurrentFile(file);
                try {
                    box.saveState(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(box.getCurrentFile()), "UTF-8")));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.e2dFileChooser.rememberFile(file.getPath());
        }
    }

    private void saveAsApplet(System2D box, JFrame frame) {
        this.htmFileChooser.setAcceptAllFileFilterUsed(false);
        this.htmFileChooser.addChoosableFileFilter(this.htmFilter);
        this.htmFileChooser.setDialogType(1);
        this.htmFileChooser.setDialogTitle("Save As Applet");
        this.htmFileChooser.setApproveButtonMnemonic('S');
        if (this.htmFileChooser.showSaveDialog(frame) == 0) {
            File file = this.htmFileChooser.getSelectedFile();
            if (!file.toString().toLowerCase().endsWith(".htm")) {
                file = new File(file.getParentFile(), String.valueOf(MiscUtil.getFileName(file.toString())) + ".htm");
            }
            boolean b = true;
            if (file.exists() && JOptionPane.showConfirmDialog(frame, "File " + file.getName() + " exists, overwrite?", "File exists", 0) != 0) {
                b = false;
            }
            if (b) {
                box.saveApplet(file);
            }
            this.htmFileChooser.rememberFile(file.getPath());
        }
    }

    private float parse(String s) {
        float x = Float.NaN;
        try {
            x = Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), "Cannot parse: " + s, "Error", 0);
        }
        return x;
    }
}

