/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.concord.energy2d.system.System2D;

class LinksDialog
extends JDialog {
    private JTextField prevSimField;
    private JTextField nextSimField;
    private ActionListener okListener;

    LinksDialog(final System2D s2d, boolean modal) {
        super(JOptionPane.getFrameForComponent(s2d.view), "Links", modal);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                s2d.view.notifyManipulationListeners(null, (byte)3);
                s2d.view.repaint();
                LinksDialog.this.dispose();
            }
        });
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nextSim;
                String prevSim = LinksDialog.this.prevSimField.getText();
                if (prevSim != null) {
                    if (prevSim.trim().equals("")) {
                        s2d.setPreviousSimulation(null);
                    } else {
                        if (!prevSim.endsWith(".e2d")) {
                            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(s2d.view), "Previous simulation name must end with .e2d: \"" + prevSim + "\"", "Error", 0);
                            return;
                        }
                        s2d.setPreviousSimulation(prevSim);
                    }
                }
                if ((nextSim = LinksDialog.this.nextSimField.getText()) != null) {
                    if (nextSim.trim().equals("")) {
                        s2d.setNextSimulation(null);
                    } else {
                        if (!nextSim.endsWith(".e2d")) {
                            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(s2d.view), "Next simulation name must end with .e2d: \"" + nextSim + "\"", "Error", 0);
                            return;
                        }
                        s2d.setNextSimulation(nextSim);
                    }
                }
                s2d.view.notifyManipulationListeners(null, (byte)3);
                s2d.view.repaint();
                LinksDialog.this.dispose();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinksDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)box, "Center");
        JPanel p = new JPanel(new FlowLayout(0));
        p.setBorder(BorderFactory.createTitledBorder("Type file names (.e2d)"));
        box.add(p);
        p.add(new JLabel("Previous simulation:"));
        this.prevSimField = new JTextField(s2d.getPreviousSimulation(), 15);
        this.prevSimField.addActionListener(this.okListener);
        p.add(this.prevSimField);
        p.add(new JLabel("Next simulation:"));
        this.nextSimField = new JTextField(s2d.getNextSimulation(), 15);
        this.nextSimField.addActionListener(this.okListener);
        p.add(this.nextSimField);
        p = new JPanel(new FlowLayout(0));
        box.add(p);
        p.add(new JLabel("<html><hr width=100 align=left>* When the Control Panel is present on the screen, its Previous and Next Buttons<br>will be set to link to the above files.</html>"));
        this.pack();
        this.setLocationRelativeTo(s2d.view);
    }
}

