/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import org.concord.energy2d.system.CommandHistory;
import org.concord.energy2d.system.ConsoleDocument;
import org.concord.energy2d.system.EnterListener;
import org.concord.energy2d.util.PastableTextPane;

class ConsoleTextPane
extends PastableTextPane {
    private CommandHistory commandHistory = new CommandHistory(20);
    private ConsoleDocument consoleDoc = (ConsoleDocument)this.getDocument();
    private EnterListener enterListener;

    ConsoleTextPane(EnterListener enterListener) {
        super(new ConsoleDocument());
        this.consoleDoc.setConsoleTextPane(this);
        this.enterListener = enterListener;
    }

    public String getCommandString() {
        String cmd = this.consoleDoc.getCommandString();
        this.commandHistory.addCommand(cmd);
        return cmd;
    }

    public void setPrompt() {
        this.consoleDoc.setPrompt();
    }

    public void appendNewline() {
        this.consoleDoc.appendNewline();
    }

    public void outputError(final String strError) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsoleTextPane.this.consoleDoc.outputError(strError);
            }
        });
    }

    public void outputErrorForeground(final String strError) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsoleTextPane.this.consoleDoc.outputErrorForeground(strError);
            }
        });
    }

    public void outputEcho(final String strEcho) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsoleTextPane.this.consoleDoc.outputEcho(strEcho);
            }
        });
    }

    public void outputStatus(final String strStatus) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsoleTextPane.this.consoleDoc.outputStatus(strStatus);
            }
        });
    }

    public void enterPressed() {
        if (this.enterListener != null) {
            this.enterListener.enterPressed();
        }
    }

    public void clearContent() {
        this.consoleDoc.clearContent();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 38 && e.getID() == 401 && !e.isControlDown()) {
            this.recallCommand(true);
        } else if (e.getKeyCode() == 40 && e.getID() == 401 && !e.isControlDown()) {
            this.recallCommand(false);
        } else if ((e.getKeyCode() == 40 || e.getKeyCode() == 38) && e.getID() == 401 && e.isControlDown()) {
            super.processKeyEvent(new KeyEvent((Component)e.getSource(), e.getID(), e.getWhen(), 0, e.getKeyCode(), e.getKeyChar(), e.getKeyLocation()));
        } else {
            super.processKeyEvent(e);
        }
    }

    private final void recallCommand(boolean up) {
        String cmd = up ? this.commandHistory.getCommandUp() : this.commandHistory.getCommandDown();
        try {
            this.consoleDoc.replaceCommand(cmd);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

