/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.concord.energy2d.system.ConsoleTextPane;

class ConsoleDocument
extends DefaultStyledDocument {
    private ConsoleTextPane consoleTextPane;
    private static SimpleAttributeSet attError;
    private static SimpleAttributeSet attEcho;
    private static SimpleAttributeSet attPrompt;
    private static SimpleAttributeSet attUserInput;
    private static SimpleAttributeSet attStatus;
    private Position positionBeforePrompt;
    private Position positionAfterPrompt;
    private int offsetAfterPrompt;

    ConsoleDocument() {
        if (attError == null) {
            attError = new SimpleAttributeSet();
            StyleConstants.setForeground(attError, Color.red);
        }
        if (attPrompt == null) {
            attPrompt = new SimpleAttributeSet();
            StyleConstants.setForeground(attPrompt, Color.magenta);
        }
        if (attUserInput == null) {
            attUserInput = new SimpleAttributeSet();
            StyleConstants.setForeground(attUserInput, Color.black);
        }
        if (attEcho == null) {
            attEcho = new SimpleAttributeSet();
            StyleConstants.setForeground(attEcho, Color.blue);
            StyleConstants.setBold(attEcho, true);
        }
        if (attStatus == null) {
            attStatus = new SimpleAttributeSet();
            StyleConstants.setForeground(attStatus, Color.black);
            StyleConstants.setItalic(attStatus, true);
        }
    }

    void setConsoleTextPane(ConsoleTextPane consoleTextPane) {
        this.consoleTextPane = consoleTextPane;
    }

    void clearContent() {
        try {
            super.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.setPrompt();
    }

    void setPrompt() {
        try {
            super.insertString(this.getLength(), "$ ", attPrompt);
            this.offsetAfterPrompt = this.getLength();
            this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
            this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
            this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    void outputBeforePrompt(String str, SimpleAttributeSet attribute) {
        try {
            Position caretPosition = this.createPosition(this.consoleTextPane.getCaretPosition());
            super.insertString(this.positionBeforePrompt.getOffset(), String.valueOf(str) + "\n", attribute);
            this.offsetAfterPrompt = this.positionBeforePrompt.getOffset() + 2;
            this.consoleTextPane.setCaretPosition(caretPosition.getOffset());
        }
        catch (BadLocationException e) {
            e.printStackTrace(System.err);
        }
    }

    void outputError(String strError) {
        this.outputBeforePrompt(strError, attError);
    }

    void outputErrorForeground(String strError) {
        try {
            super.insertString(this.getLength(), String.valueOf(strError) + "\n", attError);
            this.consoleTextPane.setCaretPosition(this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    void outputEcho(String strEcho) {
        this.outputBeforePrompt(strEcho, attEcho);
    }

    void outputStatus(String strStatus) {
        this.outputBeforePrompt(strStatus, attStatus);
    }

    void appendNewline() {
        try {
            super.insertString(this.getLength(), "\n", attUserInput);
            this.consoleTextPane.setCaretPosition(this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int ichNewline = str.indexOf(10);
        if (ichNewline > 0) {
            str = str.substring(0, ichNewline);
        }
        if (ichNewline != 0) {
            if (offs < this.offsetAfterPrompt) {
                offs = this.getLength();
            }
            super.insertString(offs, str, attUserInput);
            this.consoleTextPane.setCaretPosition(offs + str.length());
        }
        if (ichNewline >= 0) {
            this.consoleTextPane.enterPressed();
        }
    }

    String getCommandString() {
        String strCommand = "";
        try {
            int cmdStart = this.positionAfterPrompt.getOffset();
            strCommand = this.getText(cmdStart, this.getLength() - cmdStart).trim();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return strCommand;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (offs < this.offsetAfterPrompt) {
            if ((len -= this.offsetAfterPrompt - offs) <= 0) {
                return;
            }
            offs = this.offsetAfterPrompt;
        }
        super.remove(offs, len);
    }

    @Override
    public void replace(int offs, int length, String str, AttributeSet attrs) throws BadLocationException {
        if (offs < this.offsetAfterPrompt) {
            if (offs + length < this.offsetAfterPrompt) {
                offs = this.getLength();
                length = 0;
            } else {
                length -= this.offsetAfterPrompt - offs;
                offs = this.offsetAfterPrompt;
            }
        }
        super.replace(offs, length, str, attUserInput);
    }

    void replaceCommand(String newCommand) throws BadLocationException {
        this.replace(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, newCommand, attUserInput);
    }
}

