/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.system;

import java.util.LinkedList;

final class CommandHistory {
    private LinkedList<String> commandList = new LinkedList();
    private int maxSize;
    private int pos = 0;

    CommandHistory(int maxSize) {
        this.maxSize = maxSize;
    }

    String getCommandUp() {
        if (this.commandList.size() > 0) {
            --this.pos;
        }
        return this.getCommand();
    }

    String getCommandDown() {
        if (this.commandList.size() > 0) {
            ++this.pos;
        }
        return this.getCommand();
    }

    private String getCommand() {
        if (this.pos == 0) {
            return "";
        }
        int size = this.commandList.size();
        if (size > 0) {
            if (this.pos == size + 1) {
                return "";
            }
            if (this.pos > size) {
                this.pos = 1;
            } else if (this.pos < 0) {
                this.pos = size;
            }
            return this.commandList.get(this.pos - 1);
        }
        return "";
    }

    void addCommand(String command) {
        if (this.commandList.contains(command)) {
            this.commandList.remove(command);
        }
        this.pos = 0;
        this.commandList.addLast(command);
        if (this.commandList.size() > this.maxSize) {
            this.commandList.removeFirst();
        }
    }

    void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        while (maxSize < this.commandList.size()) {
            this.commandList.removeFirst();
        }
    }

    void reset(int maxSize) {
        this.maxSize = maxSize;
        this.commandList = new LinkedList();
    }
}

