/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class Tree
extends Manipulable {
    public static final byte REGULAR = 0;
    public static final byte PINE = 1;
    private byte type = 1;
    private float x;
    private float y;
    private Color color = Color.GREEN.darker();
    private Rectangle2D.Float boundingBox;

    public Tree(Shape bb, byte type) {
        super(bb);
        if (!(bb instanceof Rectangle2D.Float)) {
            throw new IllegalArgumentException("Shape must be a Rectangle2D.Float");
        }
        this.setType(type);
        Rectangle2D.Float r = (Rectangle2D.Float)bb;
        this.setDimension(r.width, r.height);
    }

    public static Area getShape(Rectangle2D.Float r, byte type) {
        Area a = new Area(new Rectangle2D.Float(r.x + r.width * 0.45f, r.y + r.height * 0.5f, r.width * 0.1f, r.height * 0.5f));
        switch (type) {
            case 0: {
                float p = Math.min(r.width, r.height) * 0.6f;
                float q = p * 0.8f;
                a.add(new Area(new Ellipse2D.Float(r.x + (r.width - p) * 0.5f, r.y, p, p)));
                a.add(new Area(new Ellipse2D.Float(r.x, r.y + p * 0.8f, q, q)));
                a.add(new Area(new Ellipse2D.Float(r.x + r.width - q, r.y + p * 0.8f, q, q)));
                break;
            }
            case 1: {
                GeneralPath path = new GeneralPath();
                path.moveTo(r.x + r.width * 0.5f, r.y);
                path.lineTo(r.x + r.width * 0.3f, r.y + r.height * 0.3f);
                path.lineTo(r.x + r.width * 0.7f, r.y + r.height * 0.3f);
                a.add(new Area(path));
                path.reset();
                path.moveTo(r.x + r.width * 0.5f, r.y + r.height * 0.2f);
                path.lineTo(r.x + r.width * 0.2f, r.y + r.height * 0.5f);
                path.lineTo(r.x + r.width * 0.8f, r.y + r.height * 0.5f);
                a.add(new Area(path));
                path.reset();
                path.moveTo(r.x + r.width * 0.5f, r.y + r.height * 0.3f);
                path.lineTo(r.x, r.y + r.height * 0.8f);
                path.lineTo(r.x + r.width, r.y + r.height * 0.8f);
                a.add(new Area(path));
            }
        }
        return a;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void translateBy(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public Point2D.Float getCenter() {
        Rectangle2D bound = this.getShape().getBounds2D();
        return new Point2D.Float((float)bound.getCenterX() + this.x, (float)bound.getCenterY() + this.y);
    }

    @Override
    public boolean contains(float rx, float ry) {
        return this.getShape().contains(rx - this.x, ry - this.y);
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getX() {
        return this.x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getY() {
        return this.y;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public void setDimension(float w, float h) {
        this.boundingBox = new Rectangle2D.Float(0.0f, 0.0f, w, h);
        this.setShape(Tree.getShape(this.boundingBox, this.type));
    }

    public float getWidth() {
        return this.boundingBox.width;
    }

    public float getHeight() {
        return this.boundingBox.height;
    }

    @Override
    public Tree duplicate(float x, float y) {
        Tree t = new Tree(new Rectangle2D.Float(0.0f, 0.0f, this.boundingBox.width, this.boundingBox.height), this.type);
        t.setLabel(this.getLabel());
        t.color = this.color;
        t.setX(x - this.boundingBox.width / 2.0f);
        t.setY(y - this.boundingBox.height / 2.0f);
        return t;
    }

    public String toXml() {
        String label;
        XmlCharacterEncoder xce = new XmlCharacterEncoder();
        String xml = "<tree";
        String uid = this.getUid();
        if (uid != null && !uid.trim().equals("")) {
            xml = String.valueOf(xml) + " uid=\"" + xce.encode(uid) + "\"";
        }
        if ((label = this.getLabel()) != null && !label.trim().equals("")) {
            xml = String.valueOf(xml) + " label=\"" + xce.encode(label) + "\"";
        }
        if (!Color.GREEN.darker().equals(this.color)) {
            xml = String.valueOf(xml) + " color=\"" + Integer.toHexString(0xFFFFFF & this.color.getRGB()) + "\"";
        }
        xml = String.valueOf(xml) + " x=\"" + this.x + "\"";
        xml = String.valueOf(xml) + " y=\"" + this.y + "\"";
        xml = String.valueOf(xml) + " width=\"" + this.boundingBox.width + "\"";
        xml = String.valueOf(xml) + " height=\"" + this.boundingBox.height + "\"";
        xml = String.valueOf(xml) + " type=\"" + this.type + "\"/>";
        return xml;
    }
}

