/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.geom.Rectangle2D;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Thermometer;

public class Thermostat {
    private Thermometer thermometer;
    private Part powerSource;
    private float setpoint = 20.0f;
    private float deadband = 1.0f;

    public Thermostat(Part powerSource) {
        if (powerSource == null) {
            throw new IllegalArgumentException("A thermostat must be connected to a power source.");
        }
        this.powerSource = powerSource;
    }

    public Thermostat(Thermometer thermometer, Part powerSource) {
        this(powerSource);
        this.thermometer = thermometer;
    }

    public boolean onoff(Model2D model) {
        float power = this.powerSource.getPower();
        if (power == 0.0f) {
            return false;
        }
        boolean refresh = false;
        float t = 0.0f;
        if (this.thermometer != null) {
            t = this.thermometer.getCurrentData();
        } else {
            Rectangle2D bounds = this.powerSource.getShape().getBounds2D();
            t = model.getTemperatureAt((float)bounds.getCenterX(), (float)bounds.getCenterY());
        }
        if (power > 0.0f) {
            if (t > this.setpoint + this.deadband) {
                this.powerSource.setPowerSwitch(false);
                refresh = true;
            } else if (t < this.setpoint - this.deadband) {
                this.powerSource.setPowerSwitch(true);
                refresh = true;
            }
        } else if (t < this.setpoint - this.deadband) {
            this.powerSource.setPowerSwitch(false);
            refresh = true;
        } else if (t > this.setpoint + this.deadband) {
            this.powerSource.setPowerSwitch(true);
            refresh = true;
        }
        return refresh;
    }

    public Thermometer getThermometer() {
        return this.thermometer;
    }

    public Part getPowerSource() {
        return this.powerSource;
    }

    public void setDeadband(float deadband) {
        this.deadband = deadband;
    }

    public float getDeadband() {
        return this.deadband;
    }

    public void setSetPoint(float setpoint) {
        this.setpoint = setpoint;
    }

    public float getSetPoint() {
        return this.setpoint;
    }

    public String toXml() {
        String xml = "<thermostat";
        xml = String.valueOf(xml) + " set_point=\"" + this.setpoint + "\"";
        xml = String.valueOf(xml) + " deadband=\"" + this.deadband + "\"";
        if (this.thermometer != null) {
            xml = String.valueOf(xml) + " thermometer=\"" + this.thermometer.getUid() + "\"";
        }
        xml = String.valueOf(xml) + " power_source=\"" + this.powerSource.getUid() + "\"/>";
        return xml;
    }
}

