/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.geom.Rectangle2D;
import org.concord.energy2d.model.Sensor;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class Thermometer
extends Sensor {
    public static final float RELATIVE_WIDTH = 0.01f;
    public static final float RELATIVE_HEIGHT = 0.05f;

    public Thermometer(float x, float y) {
        super(new Rectangle2D.Float());
        this.setCenter(x, y);
    }

    public Thermometer(float x, float y, String label) {
        this(x, y);
        this.setLabel(label);
    }

    @Override
    public Thermometer duplicate(float x, float y) {
        return new Thermometer(x, y);
    }

    public float getCurrentDataInFahrenheit() {
        return this.getCurrentData() * 1.8f + 32.0f;
    }

    @Override
    public String getName() {
        return "Thermometer (\u2103)";
    }

    @Override
    public String toXml() {
        String label;
        String uid;
        XmlCharacterEncoder xce = new XmlCharacterEncoder();
        String xml = "<thermometer";
        if (this.stencil != 1) {
            xml = String.valueOf(xml) + " stencil=\"" + this.stencil + "\"";
        }
        if ((uid = this.getUid()) != null && !uid.trim().equals("")) {
            xml = String.valueOf(xml) + " uid=\"" + xce.encode(uid) + "\"";
        }
        if (this.attachID != null && !this.attachID.trim().equals("")) {
            xml = String.valueOf(xml) + " attach=\"" + this.attachID + "\"";
        }
        if ((label = this.getLabel()) != null && !label.trim().equals("")) {
            xml = String.valueOf(xml) + " label=\"" + xce.encode(label) + "\"";
        }
        xml = String.valueOf(xml) + " x=\"" + this.getX() + "\"";
        xml = String.valueOf(xml) + " y=\"" + this.getY() + "\"/>";
        return xml;
    }
}

