/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import org.concord.energy2d.model.MassBoundary;

public class SimpleMassBoundary
implements MassBoundary {
    private byte[] flowType = new byte[4];

    public SimpleMassBoundary() {
        this.setFlowTypeAtBorder((byte)0, (byte)0);
        this.setFlowTypeAtBorder((byte)2, (byte)0);
        this.setFlowTypeAtBorder((byte)3, (byte)0);
        this.setFlowTypeAtBorder((byte)1, (byte)0);
    }

    public void setFlowTypeAtBorder(byte side, byte value) {
        if (side < 0 || side > 3) {
            throw new IllegalArgumentException("side parameter illegal");
        }
        this.flowType[side] = value;
    }

    public byte getFlowTypeAtBorder(byte side) {
        if (side < 0 || side > 3) {
            throw new IllegalArgumentException("side parameter illegal");
        }
        return this.flowType[side];
    }

    @Override
    public String toXml() {
        String s = "<mass_flow_at_border upper=\"" + this.flowType[0] + "\"";
        s = String.valueOf(s) + " lower=\"" + this.flowType[2] + "\"";
        s = String.valueOf(s) + " left=\"" + this.flowType[3] + "\"";
        s = String.valueOf(s) + " right=\"" + this.flowType[1] + "\"";
        s = String.valueOf(s) + "/>\n";
        return s;
    }
}

