/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.concord.energy2d.event.MeasurementEvent;
import org.concord.energy2d.event.MeasurementListener;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.TimedData;

public abstract class Sensor
extends Manipulable {
    public static final byte ONE_POINT = 1;
    public static final byte FIVE_POINT = 5;
    public static final byte NINE_POINT = 9;
    byte stencil = 1;
    private static int maximumDataPoints = 1000;
    List<TimedData> data = Collections.synchronizedList(new ArrayList());
    private List<MeasurementListener> listeners = new ArrayList<MeasurementListener>();
    String attachID;
    private float sensingSpotX;
    private float sensingSpotY;

    public Sensor(Shape shape) {
        super(shape);
    }

    public static void setMaximumDataPoints(int n) {
        maximumDataPoints = n;
    }

    public static int getMaximumDataPoints() {
        return maximumDataPoints;
    }

    public void setCenter(float x, float y) {
        if (this.getShape() instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
            r.x = x - 0.5f * r.width;
            r.y = y - 0.5f * r.height;
        }
    }

    public void translateBy(float dx, float dy) {
        if (this.getShape() instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
            r.x += dx;
            r.y += dy;
        }
    }

    public void setX(float x) {
        if (this.getShape() instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
            r.x = x - 0.5f * r.width;
        }
    }

    public void setY(float y) {
        if (this.getShape() instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
            r.y = y - 0.5f * r.height;
        }
    }

    public float getX() {
        if (this.getShape() instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
            return r.x + 0.5f * r.width;
        }
        return (float)this.getShape().getBounds2D().getCenterX();
    }

    public float getY() {
        if (this.getShape() instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
            return r.y + 0.5f * r.height;
        }
        return (float)this.getShape().getBounds2D().getCenterY();
    }

    public void setSensingSpotX(float sensingSpotX) {
        this.sensingSpotX = sensingSpotX;
    }

    public float getSensingSpotX() {
        return this.sensingSpotX;
    }

    public void setSensingSpotY(float sensingSpotY) {
        this.sensingSpotY = sensingSpotY;
    }

    public float getSensingSpotY() {
        return this.sensingSpotY;
    }

    public void setAttachID(String attachID) {
        this.attachID = attachID;
    }

    public String getAttachID() {
        return this.attachID;
    }

    public void setStencil(byte stencil) {
        this.stencil = stencil;
    }

    public byte getStencil() {
        return this.stencil;
    }

    public void addMeasurementListener(MeasurementListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeMeasurementListener(MeasurementListener l) {
        this.listeners.remove(l);
    }

    private void notifyMeasurementListeners() {
        if (this.listeners.isEmpty()) {
            return;
        }
        MeasurementEvent e = new MeasurementEvent(this);
        for (MeasurementListener x : this.listeners) {
            x.measurementTaken(e);
        }
    }

    public void clear() {
        this.data.clear();
        this.notifyMeasurementListeners();
    }

    public List<TimedData> getData() {
        return this.data;
    }

    public float getCurrentData() {
        if (this.data.isEmpty()) {
            return Float.NaN;
        }
        return this.data.get(this.data.size() - 1).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getDataMinimum() {
        if (this.data.isEmpty()) {
            return Float.NaN;
        }
        float min = Float.MAX_VALUE;
        List<TimedData> list = this.data;
        synchronized (list) {
            for (TimedData d : this.data) {
                if (!(min > d.getValue())) continue;
                min = d.getValue();
            }
        }
        return min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getDataMaximum() {
        if (this.data.isEmpty()) {
            return Float.NaN;
        }
        float max = -3.4028235E38f;
        List<TimedData> list = this.data;
        synchronized (list) {
            for (TimedData d : this.data) {
                if (!(max < d.getValue())) continue;
                max = d.getValue();
            }
        }
        return max;
    }

    public void addData(float time, float x) {
        this.data.add(new TimedData(time, x));
        this.notifyMeasurementListeners();
        if (this.data.size() > maximumDataPoints) {
            this.data.remove(0);
        }
    }

    public abstract String toXml();

    public abstract String getName();
}

