/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.concord.energy2d.math.Vector2D;
import org.concord.energy2d.model.Part;

public class Segment {
    public float x1;
    public float y1;
    public float x2;
    public float y2;
    public float radiation;
    public float absorption;
    public float emission;
    private Part part;

    public Segment(float x1, float y1, float x2, float y2, Part part) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.part = part;
        if (x1 == x2 && y1 == y2) {
            throw new RuntimeException("segment cannot be a point: " + this);
        }
    }

    public Part getPart() {
        return this.part;
    }

    public float length() {
        return (float)Math.hypot(this.x2 - this.x1, this.y2 - this.y1);
    }

    public boolean intersectsLine(float x3, float y3, float x4, float y4) {
        return Line2D.linesIntersect(this.x1, this.y1, this.x2, this.y2, x3, y3, x4, y4);
    }

    public Vector2D getNormalVector() {
        return new Vector2D(this.y1 - this.y2, this.x2 - this.x1);
    }

    public Point2D.Float getCenter() {
        return new Point2D.Float(0.5f * (this.x1 + this.x2), 0.5f * (this.y1 + this.y2));
    }

    public float getViewFactor(Segment s) {
        Point2D.Float p1 = this.getCenter();
        Point2D.Float p2 = s.getCenter();
        Vector2D r = new Vector2D(p2.x - p1.x, p2.y - p1.y);
        float r2 = r.x * r.x + r.y * r.y;
        r.normalize();
        Vector2D n1 = this.getNormalVector();
        n1.normalize();
        Vector2D n2 = s.getNormalVector();
        n2.normalize();
        float dot = -r.dotProduct(n1) * r.dotProduct(n2);
        dot = Math.abs(dot);
        return dot * s.length() / (float)(Math.PI * Math.sqrt(r2));
    }

    public String toString() {
        return "(" + this.x1 + ", " + this.y1 + ") - (" + this.x2 + ", " + this.y2 + ")";
    }
}

