/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.Polygon2D;
import org.concord.energy2d.math.Ring2D;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Segment;

class RadiositySolver2D {
    private Model2D model;
    private List<Segment> segments = Collections.synchronizedList(new ArrayList());
    private float patchSize;
    private float patchSizePercentage = 0.05f;
    private float[][] reflection;
    private float[][] absorption;
    private int relaxationSteps = 2;

    RadiositySolver2D(Model2D model) {
        this.model = model;
    }

    void setPatchSizePercentage(float patchSizePercentage) {
        this.patchSizePercentage = patchSizePercentage;
    }

    float getPatchSizePercentage() {
        return this.patchSizePercentage;
    }

    void reset() {
    }

    float measure(HeatFluxSensor sensor) {
        float measurement = 0.0f;
        float dx = this.patchSize * 0.5f * (float)Math.cos(sensor.getAngle());
        float dy = this.patchSize * 0.5f * (float)Math.sin(sensor.getAngle());
        float x1 = sensor.getX() - dx;
        float x2 = sensor.getX() + dx;
        float y1 = sensor.getY() - dy;
        float y2 = sensor.getY() + dy;
        Segment ss = new Segment(x1, y1, x2, y2, null);
        for (Segment s : this.segments) {
            if (!this.isVisible(s, ss)) continue;
            float vf = s.getViewFactor(ss);
            if (vf > 1.0f) {
                vf = 1.0f;
            }
            measurement += s.radiation * vf;
        }
        return measurement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void solve() {
        int n = this.segments.size();
        if (n <= 0) {
            return;
        }
        List<Segment> list = this.segments;
        synchronized (list) {
            Segment s;
            int i = 0;
            while (i < n) {
                s = this.segments.get(i);
                if (s.getPart().getEmissivity() > 0.0f) {
                    Point2D.Float c = s.getCenter();
                    float temp = s.getPart().getConstantTemperature() ? s.getPart().getTemperature() + 273.0f : this.model.getTemperatureAt(c.x, c.y, (byte)9) + 273.0f;
                    temp *= temp;
                    s.emission = s.getPart().getEmissivity() * 5.67E-8f * temp * temp;
                    temp = this.model.getBackgroundTemperature() + 273.0f;
                    temp *= temp;
                    s.emission -= s.getPart().getEmissivity() * 5.67E-8f * temp * temp;
                }
                ++i;
            }
            int k = 0;
            while (k < this.relaxationSteps) {
                int i2 = 0;
                while (i2 < n) {
                    s = this.segments.get(i2);
                    s.radiation = s.emission;
                    int j = 0;
                    while (j < n) {
                        if (j != i2) {
                            s.radiation -= this.reflection[i2][j] * this.segments.get((int)j).radiation;
                        }
                        ++j;
                    }
                    s.radiation /= this.reflection[i2][i2];
                    ++i2;
                }
                ++k;
            }
            i = 0;
            while (i < n) {
                s = this.segments.get(i);
                s.absorption = 0.0f;
                int j = 0;
                while (j < n) {
                    if (j != i) {
                        s.absorption += this.absorption[i][j] * this.segments.get((int)j).radiation;
                    }
                    ++j;
                }
                ++i;
            }
            float gx = (float)this.model.getNx() / this.model.getLx();
            float gy = (float)this.model.getNy() / this.model.getLy();
            int i3 = 0;
            while (i3 < n) {
                s = this.segments.get(i3);
                float length = s.length();
                int m = (int)(length * Math.max(gx, gy));
                if (m > 1) {
                    float power = (s.absorption - s.emission) / (float)(m - 1);
                    float dx = (s.x2 - s.x1) / (float)m;
                    float dy = (s.y2 - s.y1) / (float)m;
                    int a = 1;
                    while (a < m) {
                        this.model.changePowerAt(s.x1 + dx * (float)a, s.y1 + dy * (float)a, power);
                        ++a;
                    }
                }
                ++i3;
            }
        }
    }

    private void computeReflectionAndAbsorptionMatrices() {
        int j;
        int n = this.segments.size();
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                this.reflection[i][j] = i == j ? 1 : 0;
                this.absorption[i][j] = 0.0f;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n - 1) {
            Segment s1 = this.segments.get(i);
            j = i + 1;
            while (j < n) {
                Segment s2 = this.segments.get(j);
                if (this.isVisible(s1, s2)) {
                    float vf = s1.getViewFactor(s2);
                    if (vf > 1.0f) {
                        vf = 1.0f;
                    }
                    float lengthRatio = s1.length() / s2.length();
                    this.reflection[i][j] = -s1.getPart().getReflectivity() * vf;
                    this.reflection[j][i] = -s2.getPart().getReflectivity() * vf * lengthRatio;
                    this.absorption[i][j] = s1.getPart().getAbsorptivity() * vf;
                    this.absorption[j][i] = s2.getPart().getAbsorptivity() * vf * lengthRatio;
                }
                ++j;
            }
            ++i;
        }
    }

    void segmentizePerimeters() {
        this.segments.clear();
        this.patchSize = this.model.getLx() * this.patchSizePercentage;
        for (Part part : this.model.getParts()) {
            if ((double)part.getTransmissivity() > 0.9999) continue;
            this.segmentizePerimeter(part);
        }
        int n = this.segments.size();
        this.reflection = new float[n][n];
        this.absorption = new float[n][n];
        this.computeReflectionAndAbsorptionMatrices();
    }

    List<Segment> getSegments() {
        return this.segments;
    }

    private void segmentizePerimeter(Part part) {
        Shape shape = part.getShape();
        if (shape instanceof Rectangle2D.Float) {
            int i;
            int n;
            Rectangle2D.Float r = (Rectangle2D.Float)shape;
            float x0 = r.x;
            float y0 = r.y;
            float x1 = r.x + r.width;
            float y1 = r.y + r.height;
            if (r.width <= this.patchSize) {
                this.segments.add(new Segment(x0, y0, x1, y0, part));
            } else {
                n = (int)(r.width / this.patchSize);
                i = 0;
                while (i < n) {
                    this.segments.add(new Segment(x0 + (float)i * this.patchSize, y0, x0 + (float)(i + 1) * this.patchSize, y0, part));
                    ++i;
                }
                if (Math.abs(x0 + (float)n * this.patchSize - x1) > 0.05f * this.patchSize) {
                    this.segments.add(new Segment(x0 + (float)n * this.patchSize, y0, x1, y0, part));
                }
            }
            if (r.height <= this.patchSize) {
                this.segments.add(new Segment(x1, y0, x1, y1, part));
            } else {
                n = (int)(r.height / this.patchSize);
                i = 0;
                while (i < n) {
                    this.segments.add(new Segment(x1, y0 + (float)i * this.patchSize, x1, y0 + (float)(i + 1) * this.patchSize, part));
                    ++i;
                }
                if (Math.abs(y0 + (float)n * this.patchSize - y1) > 0.05f * this.patchSize) {
                    this.segments.add(new Segment(x1, y0 + (float)n * this.patchSize, x1, y1, part));
                }
            }
            if (r.width <= this.patchSize) {
                this.segments.add(new Segment(x1, y1, x0, y1, part));
            } else {
                n = (int)(r.width / this.patchSize);
                i = 0;
                while (i < n) {
                    this.segments.add(new Segment(x1 - (float)i * this.patchSize, y1, x1 - (float)(i + 1) * this.patchSize, y1, part));
                    ++i;
                }
                if (Math.abs(x1 - (float)n * this.patchSize - x0) > 0.05f * this.patchSize) {
                    this.segments.add(new Segment(x1 - (float)n * this.patchSize, y1, x0, y1, part));
                }
            }
            if (r.height <= this.patchSize) {
                this.segments.add(new Segment(x0, y1, x0, y0, part));
            } else {
                n = (int)(r.height / this.patchSize);
                i = 0;
                while (i < n) {
                    this.segments.add(new Segment(x0, y1 - (float)i * this.patchSize, x0, y1 - (float)(i + 1) * this.patchSize, part));
                    ++i;
                }
                if (Math.abs(y1 - (float)n * this.patchSize - y0) > 0.05f * this.patchSize) {
                    this.segments.add(new Segment(x0, y1 - (float)n * this.patchSize, x0, y0, part));
                }
            }
        } else if (shape instanceof Ellipse2D.Float) {
            double perimeter;
            int n;
            Ellipse2D.Float e = (Ellipse2D.Float)shape;
            float a = e.width * 0.5f;
            float b = e.height * 0.5f;
            float x = e.x + a;
            float y = e.y + b;
            float h = (a - b) / (a + b);
            if ((n = (int)((perimeter = Math.PI * (double)(a + b) * (1.0 + (double)(3.0f * (h *= h)) / (10.0 + Math.sqrt(4.0f - 3.0f * h)))) / (double)this.patchSize)) <= 0) {
                return;
            }
            float[] vx = new float[n];
            float[] vy = new float[n];
            float delta = (float)(Math.PI * 2 / (double)n);
            int i = 0;
            while (i < n) {
                float theta = delta * (float)i;
                vx[i] = (float)((double)x + (double)a * Math.cos(theta));
                vy[i] = (float)((double)y + (double)b * Math.sin(theta));
                ++i;
            }
            i = 0;
            while (i < n - 1) {
                this.segments.add(new Segment(vx[i], vy[i], vx[i + 1], vy[i + 1], part));
                ++i;
            }
            if (vx[n - 1] != vx[0] || vy[n - 1] != vy[0]) {
                this.segments.add(new Segment(vx[n - 1], vy[n - 1], vx[0], vy[0], part));
            }
        } else if (shape instanceof Polygon2D) {
            Point2D.Float v1;
            Polygon2D r = (Polygon2D)shape;
            int n = r.getVertexCount();
            Point2D.Float v2 = null;
            Line2D.Float line = new Line2D.Float();
            int i = 0;
            while (i < n - 1) {
                v1 = r.getVertex(i);
                v2 = r.getVertex(i + 1);
                line.setLine(v1, v2);
                this.segmentize(line, part);
                ++i;
            }
            if (v2 != null) {
                v1 = r.getVertex(0);
                line.setLine(v1, v2);
                this.segmentize(line, part);
            }
        } else if (shape instanceof Blob2D) {
            Point2D.Float v1;
            Blob2D b = (Blob2D)shape;
            int n = b.getPathPointCount();
            int m = (int)((float)n / b.getPerimeter() * this.patchSize);
            Point2D.Float v2 = null;
            int i = 0;
            while (i < n - m) {
                if (i % m == 0) {
                    v1 = b.getPathPoint(i);
                    v2 = b.getPathPoint(i + m);
                    if (v1.x != v2.x || v1.y != v2.y) {
                        this.segments.add(new Segment(v1.x, v1.y, v2.x, v2.y, part));
                    }
                }
                ++i;
            }
            if (v2 != null) {
                v1 = b.getPathPoint(0);
                if (v1.x != v2.x || v1.y != v2.y) {
                    this.segments.add(new Segment(v1.x, v1.y, v2.x, v2.y, part));
                }
            }
        } else if (shape instanceof Ring2D) {
            float theta;
            Ring2D r = (Ring2D)shape;
            double perimeter = Math.PI * (double)r.getInnerDiameter();
            int n = (int)(perimeter / (double)this.patchSize);
            if (n <= 0) {
                return;
            }
            float[] vx = new float[n];
            float[] vy = new float[n];
            float delta = (float)(Math.PI * 2 / (double)n);
            float radius = 0.5f * r.getInnerDiameter();
            int i = 0;
            while (i < n) {
                theta = delta * (float)i;
                vx[i] = (float)((double)r.getX() + (double)radius * Math.cos(theta));
                vy[i] = (float)((double)r.getY() + (double)radius * Math.sin(theta));
                ++i;
            }
            i = 0;
            while (i < n - 1) {
                this.segments.add(new Segment(vx[i], vy[i], vx[i + 1], vy[i + 1], part));
                ++i;
            }
            if (vx[n - 1] != vx[0] || vy[n - 1] != vy[0]) {
                this.segments.add(new Segment(vx[n - 1], vy[n - 1], vx[0], vy[0], part));
            }
            perimeter = Math.PI * (double)r.getOuterDiameter();
            n = (int)(perimeter / (double)this.patchSize);
            vx = new float[n];
            vy = new float[n];
            delta = (float)(Math.PI * 2 / (double)n);
            radius = 0.5f * r.getOuterDiameter();
            i = 0;
            while (i < n) {
                theta = delta * (float)i;
                vx[i] = (float)((double)r.getX() + (double)radius * Math.cos(theta));
                vy[i] = (float)((double)r.getY() + (double)radius * Math.sin(theta));
                ++i;
            }
            i = 0;
            while (i < n - 1) {
                this.segments.add(new Segment(vx[i], vy[i], vx[i + 1], vy[i + 1], part));
                ++i;
            }
            if (vx[n - 1] != vx[0] || vy[n - 1] != vy[0]) {
                this.segments.add(new Segment(vx[n - 1], vy[n - 1], vx[0], vy[0], part));
            }
        }
    }

    private void segmentize(Line2D.Float line, Part part) {
        float length = (float)Math.hypot(line.x1 - line.x2, line.y1 - line.y2);
        if (length <= this.patchSize) {
            if (line.x1 != line.x2 || line.y1 != line.y2) {
                this.segments.add(new Segment(line.x1, line.y1, line.x2, line.y2, part));
            }
        } else {
            float cos = (line.x2 - line.x1) / length;
            float sin = (line.y2 - line.y1) / length;
            int n = (int)(length / this.patchSize);
            float xj = 0.0f;
            float yj = 0.0f;
            int i = 0;
            while (i < n) {
                float xi = line.x1 + (float)i * this.patchSize * cos;
                float yi = line.y1 + (float)i * this.patchSize * sin;
                xj = xi + this.patchSize * cos;
                yj = yi + this.patchSize * sin;
                this.segments.add(new Segment(xi, yi, xj, yj, part));
                ++i;
            }
            if (xj != line.x2 || yj != line.y2) {
                this.segments.add(new Segment(xj, yj, line.x2, line.y2, part));
            }
        }
    }

    boolean isVisible(Segment s1, Segment s2) {
        for (Part part : this.model.getParts()) {
            if ((double)part.getTransmissivity() > 0.9999 || !part.intersectsLine(s1, s2)) continue;
            return false;
        }
        return true;
    }
}

