/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.util.Iterator;
import java.util.List;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Photon;
import org.concord.energy2d.model.Tree;

class PhotonSolver2D {
    private static final int DEFAULT_RAY_COUNT = 24;
    private float[][] q;
    private float deltaX;
    private float deltaY;
    private float lx;
    private float ly;
    private float sunAngle = 1.5707964f;
    private int rayCount = 24;
    private float solarPowerDensity;
    private float rayPower = this.solarPowerDensity = 2000.0f;
    private float raySpeed = 0.1f;

    PhotonSolver2D(float lx, float ly) {
        this.setLx(lx);
        this.setLy(ly);
    }

    void setLx(float lx) {
        this.lx = lx;
    }

    void setLy(float ly) {
        this.ly = ly;
    }

    void setSolarRaySpeed(float raySpeed) {
        this.raySpeed = raySpeed;
    }

    float getSolarRaySpeed() {
        return this.raySpeed;
    }

    void setSolarPowerDensity(float solarPowerDensity) {
        this.solarPowerDensity = solarPowerDensity;
        this.rayPower = solarPowerDensity * 24.0f / (float)this.rayCount;
    }

    float getSolarPowerDensity() {
        return this.solarPowerDensity;
    }

    void setSolarRayCount(int solarRayCount) {
        this.rayCount = solarRayCount;
        this.rayPower = this.solarPowerDensity * 24.0f / (float)this.rayCount;
    }

    int getSolarRayCount() {
        return this.rayCount;
    }

    void setGridCellSize(float deltaX, float deltaY) {
        this.deltaX = deltaX;
        this.deltaY = deltaY;
    }

    void setPower(float[][] q) {
        this.q = q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void solve(Model2D model) {
        List<Photon> photons = model.getPhotons();
        if (photons.isEmpty()) {
            return;
        }
        float timeStep = model.getTimeStep();
        float factor = 1.0f / (timeStep * (float)model.getPhotonEmissionInterval());
        float idx = 1.0f / this.deltaX;
        float idy = 1.0f / this.deltaY;
        int nx = this.q.length - 1;
        int ny = this.q[0].length - 1;
        boolean remove = false;
        List<Photon> list = photons;
        synchronized (list) {
            Iterator<Photon> it = photons.iterator();
            while (it.hasNext()) {
                List<Manipulable> list2;
                Photon p = it.next();
                p.move(timeStep);
                remove = false;
                if (model.getPartCount() > 0) {
                    list2 = model.getParts();
                    synchronized (list2) {
                        for (Part part : model.getParts()) {
                            if (part.getScattering()) {
                                if (part.isScatteringVisible()) {
                                    if (!part.reflect(p, true)) continue;
                                    break;
                                }
                                if (!part.contains(p.getRx(), p.getRy())) continue;
                                remove = true;
                                break;
                            }
                            if (Math.abs(part.getReflectivity() - 1.0f) < 0.001f) {
                                if (!part.reflect(p, false)) continue;
                                break;
                            }
                            if (!(Math.abs(part.getAbsorptivity() - 1.0f) < 0.001f) || !part.contains(p)) continue;
                            int i = Math.min(nx, Math.round(p.getRx() * idx));
                            int j = Math.min(ny, Math.round(p.getRy() * idy));
                            if (i < 0) {
                                i = 0;
                            }
                            if (j < 0) {
                                j = 0;
                            }
                            this.q[i][j] = p.getEnergy() * factor;
                            remove = true;
                            break;
                        }
                    }
                }
                if (!model.getClouds().isEmpty()) {
                    list2 = model.getClouds();
                    synchronized (list2) {
                        for (Cloud c : model.getClouds()) {
                            if (!c.contains(p.getRx(), p.getRy())) continue;
                            remove = true;
                            break;
                        }
                    }
                }
                if (!model.getTrees().isEmpty()) {
                    list2 = model.getTrees();
                    synchronized (list2) {
                        for (Tree t : model.getTrees()) {
                            if (!t.contains(p.getRx(), p.getRy())) continue;
                            remove = true;
                            break;
                        }
                    }
                }
                if (!model.getHeliostats().isEmpty()) {
                    list2 = model.getHeliostats();
                    synchronized (list2) {
                        for (Heliostat h : model.getHeliostats()) {
                            if (h.reflect(p)) break;
                        }
                    }
                }
                if (!remove) continue;
                it.remove();
            }
        }
        this.applyBoundary(photons);
    }

    void setSunAngle(float sunAngle) {
        this.sunAngle = (float)Math.PI - sunAngle;
    }

    float getSunAngle() {
        return (float)Math.PI - this.sunAngle;
    }

    void sunShine(List<Photon> photons, List<Part> parts) {
        float c;
        if ((double)this.sunAngle < -0.001 || (double)this.sunAngle > 3.142592653589793) {
            return;
        }
        float s = (float)Math.abs(Math.sin(this.sunAngle));
        float spacing = s * this.ly < (c = (float)Math.abs(Math.cos(this.sunAngle))) * this.lx ? this.ly / c : this.lx / s;
        this.shootAtAngle((spacing /= (float)this.rayCount) / s, spacing / c, photons, parts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isContained(float x, float y, List<Part> parts) {
        List<Part> list = parts;
        synchronized (list) {
            Part p;
            Iterator<Part> iterator = parts.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((double)(p = iterator.next()).getTransmissivity() < 0.9999) || !p.contains(x, y));
            return true;
        }
    }

    private void shootAtAngle(float dx, float dy, List<Photon> photons, List<Part> parts) {
        block17: {
            float x;
            int n;
            int m;
            block19: {
                float x2;
                block18: {
                    float x3;
                    block16: {
                        float x4;
                        m = Math.round(this.lx / dx);
                        n = Math.round(this.ly / dy);
                        if (!(this.sunAngle >= 0.0f) || !((double)this.sunAngle < 1.5707963267948966)) break block16;
                        float y = 0.0f;
                        int i = 1;
                        while (i <= m) {
                            x4 = dx * (float)i;
                            if (!PhotonSolver2D.isContained(x4, y, parts)) {
                                photons.add(new Photon(x4, y, this.rayPower, this.sunAngle, this.raySpeed));
                            }
                            ++i;
                        }
                        x4 = 0.0f;
                        i = 0;
                        while (i <= n) {
                            y = dy * (float)i;
                            if (!PhotonSolver2D.isContained(x4, y, parts)) {
                                photons.add(new Photon(x4, y, this.rayPower, this.sunAngle, this.raySpeed));
                            }
                            ++i;
                        }
                        break block17;
                    }
                    if (!(this.sunAngle < 0.0f) || !((double)this.sunAngle >= -1.5707963267948966)) break block18;
                    float y = this.ly;
                    int i = 1;
                    while (i <= m) {
                        x3 = dx * (float)i;
                        if (!PhotonSolver2D.isContained(x3, y, parts)) {
                            photons.add(new Photon(x3, y, this.rayPower, this.sunAngle, this.raySpeed));
                        }
                        ++i;
                    }
                    x3 = 0.0f;
                    i = 0;
                    while (i <= n) {
                        y = this.ly - dy * (float)i;
                        if (!PhotonSolver2D.isContained(x3, y, parts)) {
                            photons.add(new Photon(x3, y, this.rayPower, this.sunAngle, this.raySpeed));
                        }
                        ++i;
                    }
                    break block17;
                }
                if (!((double)this.sunAngle < 3.142592653589793) || !((double)this.sunAngle >= 1.5707963267948966)) break block19;
                float y = 0.0f;
                int i = 0;
                while (i <= m) {
                    x2 = this.lx - dx * (float)i;
                    if (!PhotonSolver2D.isContained(x2, y, parts)) {
                        photons.add(new Photon(x2, y, this.rayPower, this.sunAngle, this.raySpeed));
                    }
                    ++i;
                }
                x2 = this.lx;
                i = 1;
                while (i <= n) {
                    y = dy * (float)i;
                    if (!PhotonSolver2D.isContained(x2, y, parts)) {
                        photons.add(new Photon(x2, y, this.rayPower, this.sunAngle, this.raySpeed));
                    }
                    ++i;
                }
                break block17;
            }
            if (!((double)this.sunAngle >= -Math.PI) || !((double)this.sunAngle < -1.5707963267948966)) break block17;
            float y = this.ly;
            int i = 0;
            while (i <= m) {
                x = this.lx - dx * (float)i;
                if (!PhotonSolver2D.isContained(x, y, parts)) {
                    photons.add(new Photon(x, y, this.rayPower, this.sunAngle, this.raySpeed));
                }
                ++i;
            }
            x = this.lx;
            i = 1;
            while (i <= n) {
                y = this.ly - dy * (float)i;
                if (!PhotonSolver2D.isContained(x, y, parts)) {
                    photons.add(new Photon(x, y, this.rayPower, this.sunAngle, this.raySpeed));
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyBoundary(List<Photon> photons) {
        List<Photon> list = photons;
        synchronized (list) {
            Iterator<Photon> it = photons.iterator();
            while (it.hasNext()) {
                if (it.next().isContained(0.0f, this.lx, 0.0f, this.ly)) continue;
                it.remove();
            }
        }
    }
}

