/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import org.concord.energy2d.model.Discrete;

public class Photon
implements Discrete {
    private float rx;
    private float ry;
    private float vx;
    private float vy;
    private float energy;
    private float c;

    Photon(float rx, float ry, float energy, float c) {
        this.rx = rx;
        this.ry = ry;
        this.energy = energy;
        this.c = c;
    }

    public Photon(float rx, float ry, float energy, float angle, float c) {
        this(rx, ry, energy, c);
        this.setVelocityAngle(angle);
    }

    @Override
    public float getSpeed() {
        return this.c;
    }

    public float getEnergy() {
        return this.energy;
    }

    @Override
    public void setVelocityAngle(float angle) {
        this.vx = (float)(Math.cos(angle) * (double)this.c);
        this.vy = (float)(Math.sin(angle) * (double)this.c);
    }

    @Override
    public float getVx() {
        return this.vx;
    }

    @Override
    public void setVx(float vx) {
        this.vx = vx;
    }

    @Override
    public float getVy() {
        return this.vy;
    }

    @Override
    public void setVy(float vy) {
        this.vy = vy;
    }

    public boolean isContained(float xmin, float xmax, float ymin, float ymax) {
        return this.rx >= xmin && this.rx <= xmax && this.ry >= ymin && this.ry <= ymax;
    }

    public void setRx(float rx) {
        this.rx = rx;
    }

    @Override
    public float getRx() {
        return this.rx;
    }

    public void setRy(float ry) {
        this.ry = ry;
    }

    @Override
    public float getRy() {
        return this.ry;
    }

    public void move(float dt) {
        this.rx += this.vx * dt;
        this.ry += this.vy * dt;
    }
}

