/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.util.Iterator;
import java.util.List;
import org.concord.energy2d.model.MassBoundary;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.SimpleMassBoundary;

class ParticleSolver2D {
    private static final float INTERNAL_GRAVITY_UNIT = 1.0E-4f;
    float epsilon = 1.0E-6f;
    float rCutOffSquare = 2.0f;
    float g = 9.8f;
    float drag = 0.01f;
    float thermophoreticCoefficient = 0.0f;
    private float particleFluidTransfer = 0.05f;
    private float attractive = 0.0f;
    private float timeStep = 0.1f;
    private boolean convective;
    private List<Particle> particles;
    private float[][] u;
    private float[][] v;
    private float[][] t;
    private List<Part> parts;
    private float lx;
    private float ly;
    private int nx;
    private int ny;
    private float sigma;
    private float fxi;
    private float fyi;
    private float rxij;
    private float ryij;
    private float rijsq;
    private float sr2;
    private float sr6;
    private float sr12;
    private float fij;
    private float fxij;
    private float fyij;

    public ParticleSolver2D(Model2D model) {
        this.particles = model.getParticles();
        this.parts = model.getParts();
        this.u = model.getXVelocity();
        this.v = model.getYVelocity();
        this.t = model.getTemperature();
        this.nx = model.getNx();
        this.ny = model.getNy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void move(Model2D model) {
        this.lx = model.getLx();
        this.ly = model.getLy();
        this.timeStep = model.getTimeStep();
        this.convective = model.isConvective();
        float fluidDensity = model.getBackgroundDensity();
        float fluidConductivity = model.getBackgroundConductivity();
        List<Particle> list = this.particles;
        synchronized (list) {
            Iterator<Particle> it = this.particles.iterator();
            while (it.hasNext()) {
                Particle p = it.next();
                if (!this.interactWithBoundary(p, model.getMassBoundary())) continue;
                it.remove();
            }
            for (Particle p : this.particles) {
                p.fy = 0.0f;
                p.fx = 0.0f;
                p.predict(this.timeStep);
                this.interactWithFluid(p, fluidDensity);
            }
            if (this.epsilon > 0.0f) {
                this.computeParticleCollisions();
            }
            for (Particle p : this.particles) {
                p.correct(this.timeStep);
                p.fx /= p.mass;
                p.fy /= p.mass;
                this.interactWithParts(p);
                if (Float.isNaN(p.temperature)) continue;
                float txy = this.particleFluidTransfer * fluidConductivity * (p.temperature - model.getTemperatureAt(p.rx, p.ry));
                int n = Math.max(1, (int)((float)(8 * this.nx) * p.radius / this.lx));
                int i = 0;
                while (i < n) {
                    float theta = (float)Math.PI * 2 / (float)n * (float)i;
                    model.changeTemperatureAt((float)((double)p.rx + (double)p.radius * Math.cos(theta)), (float)((double)p.ry + (double)p.radius * Math.sin(theta)), txy);
                    ++i;
                }
            }
        }
    }

    private void interactWithFluid(Particle p, float fluidDensity) {
        int j;
        int i;
        float volume = (float)Math.PI * p.radius * p.radius;
        float buoyantForce = 1.0E-4f * this.g * (p.mass - fluidDensity * volume);
        if (this.convective) {
            i = (int)(p.rx / this.lx * (float)this.nx);
            j = (int)(p.ry / this.ly * (float)this.ny);
            if (i < 0) {
                i = 0;
            } else if (i >= this.nx) {
                i = this.nx - 1;
            }
            if (j < 0) {
                j = 0;
            } else if (j >= this.ny) {
                j = this.ny - 1;
            }
            p.fx += this.drag * (this.u[i][j] - p.vx);
            p.fy += this.drag * (this.v[i][j] - p.vy) + buoyantForce;
            float[] fArray = this.v[i];
            int n = j;
            fArray[n] = fArray[n] - buoyantForce * this.timeStep;
        } else {
            p.fx += -this.drag * p.vx;
            p.fy += -this.drag * p.vy + buoyantForce;
        }
        if (this.thermophoreticCoefficient > 0.0f) {
            i = (int)(p.rx / this.lx * (float)this.nx);
            j = (int)(p.ry / this.ly * (float)this.ny);
            if (i < 0) {
                i = 0;
            } else if (i >= this.nx) {
                i = this.nx - 1;
            }
            if (j < 0) {
                j = 0;
            } else if (j >= this.ny) {
                j = this.ny - 1;
            }
            if (Math.abs(this.t[i][j]) > 0.1f) {
                int i1 = (int)((p.rx - p.radius) / this.lx * (float)this.nx);
                int i2 = (int)((p.rx + p.radius) / this.lx * (float)this.nx);
                int j1 = (int)((p.ry - p.radius) / this.ly * (float)this.ny);
                int j2 = (int)((p.ry + p.radius) / this.ly * (float)this.ny);
                if (i1 < 0) {
                    i1 = 0;
                } else if (i1 >= this.nx) {
                    i1 = this.nx - 1;
                }
                if (i2 < 0) {
                    i2 = 0;
                } else if (i2 >= this.nx) {
                    i2 = this.nx - 1;
                }
                if (j1 < 0) {
                    j1 = 0;
                } else if (j1 >= this.ny) {
                    j1 = this.ny - 1;
                }
                if (j2 < 0) {
                    j2 = 0;
                } else if (j2 >= this.ny) {
                    j2 = this.ny - 1;
                }
                p.fx -= this.thermophoreticCoefficient / p.mass * (this.t[i2][j] - this.t[i1][j]) / this.t[i][j];
                p.fy -= this.thermophoreticCoefficient / p.mass * (this.t[i][j2] - this.t[i][j1]) / this.t[i][j];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interactWithParts(Particle p) {
        List<Part> list = this.parts;
        synchronized (list) {
            for (Part part : this.parts) {
                if (part.reflect(p, false)) break;
            }
        }
    }

    private boolean interactWithBoundary(Particle p, MassBoundary boundary) {
        float dt2 = this.timeStep * this.timeStep * 0.5f;
        float predictedX = p.rx + p.vx * this.timeStep + p.ax * dt2;
        float predictedY = p.ry + p.vy * this.timeStep + p.ay * dt2;
        if (boundary instanceof SimpleMassBoundary) {
            SimpleMassBoundary b = (SimpleMassBoundary)boundary;
            if (predictedX + p.radius > this.lx) {
                switch (b.getFlowTypeAtBorder((byte)1)) {
                    case 0: {
                        p.vx = -Math.abs(p.vx);
                        break;
                    }
                    case 2: {
                        p.vx = 0.0f;
                        break;
                    }
                    case 3: {
                        p.rx -= this.lx - p.radius;
                        break;
                    }
                    case 1: {
                        return true;
                    }
                }
            } else if (predictedX - p.radius < 0.0f) {
                switch (b.getFlowTypeAtBorder((byte)3)) {
                    case 0: {
                        p.vx = Math.abs(p.vx);
                        break;
                    }
                    case 2: {
                        p.vx = 0.0f;
                        break;
                    }
                    case 3: {
                        p.rx += this.lx - p.radius;
                        break;
                    }
                    case 1: {
                        return true;
                    }
                }
            }
            if (predictedY + p.radius > this.ly) {
                switch (b.getFlowTypeAtBorder((byte)2)) {
                    case 0: {
                        p.vy = -Math.abs(p.vy);
                        break;
                    }
                    case 2: {
                        p.vy = 0.0f;
                        break;
                    }
                    case 3: {
                        p.ry -= this.ly - p.radius;
                        break;
                    }
                    case 1: {
                        return true;
                    }
                }
            } else if (predictedY - p.radius < 0.0f) {
                switch (b.getFlowTypeAtBorder((byte)0)) {
                    case 0: {
                        p.vy = Math.abs(p.vy);
                        break;
                    }
                    case 2: {
                        p.vy = 0.0f;
                        break;
                    }
                    case 3: {
                        p.ry += this.ly - p.radius;
                        break;
                    }
                    case 1: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeParticleCollisions() {
        int n = this.particles.size();
        if (n <= 0) {
            return;
        }
        List<Particle> list = this.particles;
        synchronized (list) {
            int i = 0;
            while (i < n - 1) {
                Particle pi = this.particles.get(i);
                this.fxi = pi.fx;
                this.fyi = pi.fy;
                int j = i + 1;
                while (j < n) {
                    Particle pj = this.particles.get(j);
                    this.rxij = pi.rx - pj.rx;
                    this.ryij = pi.ry - pj.ry;
                    this.rijsq = this.rxij * this.rxij + this.ryij * this.ryij;
                    if (this.rijsq < this.rCutOffSquare * 4.0f * pi.radius * pj.radius) {
                        this.sigma = pi.radius + pj.radius;
                        this.sigma *= this.sigma;
                        this.sr2 = this.sigma / this.rijsq;
                        if (this.sr2 > 10.0f) {
                            this.sr2 = 10.0f;
                            this.rijsq = this.sigma * this.sigma;
                        }
                        this.sr6 = this.sr2 * this.sr2 * this.sr2;
                        this.sr12 = this.sr6 * this.sr6;
                        this.fij = 6.0f * this.epsilon / this.rijsq * (2.0f * this.sr12 - this.attractive * this.sr6);
                        this.fxij = this.fij * this.rxij;
                        this.fyij = this.fij * this.ryij;
                        this.fxi += this.fxij;
                        this.fyi += this.fyij;
                        pj.fx -= this.fxij;
                        pj.fy -= this.fyij;
                    }
                    ++j;
                }
                pi.fx = this.fxi;
                pi.fy = this.fyi;
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        List<Particle> list = this.particles;
        synchronized (list) {
            Iterator<Particle> it = this.particles.iterator();
            while (it.hasNext()) {
                Particle p = it.next();
                if (p.restoreState()) continue;
                it.remove();
            }
        }
    }
}

