/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class ParticleFeeder
extends Manipulable {
    public static final float RELATIVE_WIDTH = 0.02f;
    public static final float RELATIVE_HEIGHT = 0.02f;
    private float period = 100.0f;
    private int maximum = 100;
    private float mass = 0.1f;
    private float radius = 0.04f;
    private Color color = Color.WHITE;
    private Color velocityColor = Color.BLACK;
    private float randomSpeed = 0.01f;

    public ParticleFeeder(float x, float y) {
        super(new Rectangle2D.Float());
        this.setCenter(x, y);
    }

    @Override
    public ParticleFeeder duplicate(float x, float y) {
        ParticleFeeder pf = new ParticleFeeder(x, y);
        pf.mass = this.mass;
        pf.radius = this.radius;
        pf.period = this.period;
        pf.maximum = this.maximum;
        pf.color = this.color;
        pf.velocityColor = this.velocityColor;
        return pf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feed(Model2D model) {
        List<Particle> particles = model.getParticles();
        if (particles.size() >= this.maximum) {
            return;
        }
        float x = this.getX();
        float y = this.getY();
        List<Particle> list = particles;
        synchronized (list) {
            for (Particle p : particles) {
                if (!(p.distanceSq(x, y) <= 4.0f * p.radius * this.radius)) continue;
                return;
            }
        }
        Particle p = new Particle(x, y);
        p.setMass(this.mass);
        p.setRadius(this.radius);
        p.setVx((float)((Math.random() - 0.5) * (double)this.randomSpeed));
        p.setVy((float)((Math.random() - 0.5) * (double)this.randomSpeed));
        p.setColor(this.color);
        p.setVelocityColor(this.velocityColor);
        model.addParticle(p);
    }

    public void translateBy(float dx, float dy) {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            r.x += dx;
            r.y += dy;
        }
    }

    public void setCenter(float x, float y) {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            r.x = x - 0.5f * r.width;
            r.y = y - 0.5f * r.height;
        }
    }

    public void setX(float x) {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            r.x = x - 0.5f * r.width;
        }
    }

    public void setY(float y) {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            r.y = y - 0.5f * r.height;
        }
    }

    public float getX() {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            return r.x + 0.5f * r.width;
        }
        return (float)s.getBounds2D().getCenterX();
    }

    public float getY() {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            return r.y + 0.5f * r.height;
        }
        return (float)s.getBounds2D().getCenterY();
    }

    public void setPeriod(float period) {
        this.period = period;
    }

    public float getPeriod() {
        return this.period;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setVelocityColor(Color color) {
        this.velocityColor = color;
    }

    public Color getVelocityColor() {
        return this.velocityColor;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }

    public float getMass() {
        return this.mass;
    }

    public String toXml() {
        String label;
        XmlCharacterEncoder xce = new XmlCharacterEncoder();
        String xml = "<particle_feeder";
        String uid = this.getUid();
        if (uid != null && !uid.trim().equals("")) {
            xml = String.valueOf(xml) + " uid=\"" + xce.encode(uid) + "\"";
        }
        if ((label = this.getLabel()) != null && !label.trim().equals("")) {
            xml = String.valueOf(xml) + " label=\"" + xce.encode(label) + "\"";
        }
        if (!Color.WHITE.equals(this.color)) {
            xml = String.valueOf(xml) + " color=\"" + Integer.toHexString(0xFFFFFF & this.color.getRGB()) + "\"";
        }
        if (!Color.BLACK.equals(this.color)) {
            xml = String.valueOf(xml) + " velocity_color=\"" + Integer.toHexString(0xFFFFFF & this.velocityColor.getRGB()) + "\"";
        }
        xml = String.valueOf(xml) + " radius=\"" + this.radius + "\"";
        xml = String.valueOf(xml) + " mass=\"" + this.mass + "\"";
        xml = String.valueOf(xml) + " x=\"" + this.getX() + "\"";
        xml = String.valueOf(xml) + " y=\"" + this.getY() + "\"";
        xml = String.valueOf(xml) + " maximum=\"" + this.maximum + "\"";
        xml = String.valueOf(xml) + " period=\"" + this.period + "\"/>";
        return xml;
    }

    public String toString() {
        return this.getUid() == null ? super.toString() : this.getUid();
    }
}

