/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import org.concord.energy2d.model.Discrete;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class Particle
extends Manipulable
implements Discrete {
    float mass = 0.1f;
    float radius = 0.04f;
    float rx;
    float ry;
    float vx;
    float vy;
    float ax;
    float ay;
    float fx;
    float fy;
    float theta;
    float omega;
    float alpha;
    float temperature = Float.NaN;
    boolean movable = true;
    private float rx0 = Float.NaN;
    private float ry0 = Float.NaN;
    private float vx0 = Float.NaN;
    private float vy0 = Float.NaN;
    private float theta0 = Float.NaN;
    private float omega0 = Float.NaN;
    private Color color = Color.WHITE;
    private Color velocityColor = Color.BLACK;

    public Particle() {
        super(new Ellipse2D.Float());
    }

    public Particle(float rx, float ry) {
        this();
        this.setLocation(rx, ry);
    }

    private void updateShape() {
        Ellipse2D.Float e = (Ellipse2D.Float)this.getShape();
        e.x = this.rx - this.radius;
        e.y = this.ry - this.radius;
        e.width = e.height = this.radius * 2.0f;
    }

    @Override
    public Particle duplicate(float x, float y) {
        Particle p = new Particle(x, y);
        p.color = this.color;
        p.velocityColor = this.velocityColor;
        p.mass = this.mass;
        p.radius = this.radius;
        p.vx = this.vx;
        p.vy = this.vy;
        p.temperature = this.temperature;
        p.updateShape();
        return p;
    }

    public float distanceSq(float x, float y) {
        float dx = this.rx - x;
        float dy = this.ry - y;
        return dx * dx + dy * dy;
    }

    public void setLocation(float rx, float ry) {
        this.rx = rx;
        this.ry = ry;
        this.updateShape();
    }

    public void storeState() {
        this.rx0 = this.rx;
        this.ry0 = this.ry;
        this.vx0 = this.vx;
        this.vy0 = this.vy;
        this.theta0 = this.theta;
        this.omega0 = this.omega;
    }

    public boolean restoreState() {
        if (Float.isNaN(this.rx0)) {
            return false;
        }
        this.rx = this.rx0;
        if (Float.isNaN(this.ry0)) {
            return false;
        }
        this.ry = this.ry0;
        if (Float.isNaN(this.vx0)) {
            return false;
        }
        this.vx = this.vx0;
        if (Float.isNaN(this.vy0)) {
            return false;
        }
        this.vy = this.vy0;
        if (Float.isNaN(this.theta0)) {
            return false;
        }
        this.theta = this.theta0;
        if (Float.isNaN(this.omega0)) {
            return false;
        }
        this.omega = this.omega0;
        this.ax = 0.0f;
        this.ay = 0.0f;
        this.fx = 0.0f;
        this.fy = 0.0f;
        this.updateShape();
        return true;
    }

    public void translateBy(float deltaX, float deltaY) {
        this.rx += deltaX;
        this.ry += deltaY;
        this.updateShape();
    }

    void predict(float dt) {
        if (!this.movable) {
            return;
        }
        float dt2 = 0.5f * dt * dt;
        this.rx += this.vx * dt + this.ax * dt2;
        this.ry += this.vy * dt + this.ay * dt2;
        this.vx += this.ax * dt;
        this.vy += this.ay * dt;
        this.theta += this.omega * dt + this.alpha * dt2;
        this.omega += this.alpha * dt;
        this.theta = (float)((double)this.theta % (Math.PI * 2));
    }

    void correct(float dt) {
        if (!this.movable) {
            return;
        }
        this.vx += 0.5f * dt * (this.fx - this.ax);
        this.vy += 0.5f * dt * (this.fy - this.ay);
        this.ax = this.fx;
        this.ay = this.fy;
        this.fx *= this.mass;
        this.fy *= this.mass;
        this.updateShape();
    }

    @Override
    public float getSpeed() {
        return (float)Math.hypot(this.vx, this.vy);
    }

    @Override
    public void setVelocityAngle(float angle) {
        float c = this.getSpeed();
        this.vx = (float)(Math.cos(angle) * (double)c);
        this.vy = (float)(Math.sin(angle) * (double)c);
    }

    public void setRx(float rx) {
        this.rx = rx;
        this.updateShape();
    }

    @Override
    public float getRx() {
        return this.rx;
    }

    public void setRy(float ry) {
        this.ry = ry;
        this.updateShape();
    }

    @Override
    public float getRy() {
        return this.ry;
    }

    @Override
    public void setVx(float vx) {
        this.vx = vx;
    }

    @Override
    public float getVx() {
        return this.vx;
    }

    @Override
    public void setVy(float vy) {
        this.vy = vy;
    }

    @Override
    public float getVy() {
        return this.vy;
    }

    public float getAx() {
        return this.ax;
    }

    public float getAy() {
        return this.ay;
    }

    public void setTheta(float theta) {
        this.theta = theta;
    }

    public float getTheta() {
        return this.theta;
    }

    public void setOmega(float omega) {
        this.omega = omega;
    }

    public float getOmega() {
        return this.omega;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.updateShape();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }

    public float getMass() {
        return this.mass;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setVelocityColor(Color color) {
        this.velocityColor = color;
    }

    public Color getVelocityColor() {
        return this.velocityColor;
    }

    public String toXml() {
        String label;
        XmlCharacterEncoder xce = new XmlCharacterEncoder();
        String xml = "<particle>\n";
        xml = String.valueOf(xml) + "<rx>" + this.rx + "</rx>\n";
        xml = String.valueOf(xml) + "<ry>" + this.ry + "</ry>\n";
        if (this.vx != 0.0f) {
            xml = String.valueOf(xml) + "<vx>" + this.vx + "</vx>\n";
        }
        if (this.vy != 0.0f) {
            xml = String.valueOf(xml) + "<vy>" + this.vy + "</vy>\n";
        }
        if (this.theta != 0.0f) {
            xml = String.valueOf(xml) + "<theta>" + this.theta + "</theta>\n";
        }
        if (this.omega != 0.0f) {
            xml = String.valueOf(xml) + "<omega>" + this.omega + "</omega>\n";
        }
        xml = String.valueOf(xml) + "<radius>" + this.radius + "</radius>\n";
        xml = String.valueOf(xml) + "<mass>" + this.mass + "</mass>\n";
        String uid = this.getUid();
        if (uid != null && !uid.trim().equals("")) {
            xml = String.valueOf(xml) + "<uid>" + xce.encode(uid) + "</uid>\n";
        }
        if ((label = this.getLabel()) != null && !label.trim().equals("")) {
            xml = String.valueOf(xml) + "<label>" + xce.encode(label) + "</label>\n";
        }
        if (!Color.WHITE.equals(this.color)) {
            xml = String.valueOf(xml) + "<color>" + Integer.toHexString(0xFFFFFF & this.color.getRGB()) + "</color>\n";
        }
        if (!Color.BLACK.equals(this.color)) {
            xml = String.valueOf(xml) + "<velocity_color>" + Integer.toHexString(0xFFFFFF & this.velocityColor.getRGB()) + "</velocity_color>\n";
        }
        if (!Float.isNaN(this.temperature)) {
            xml = String.valueOf(xml) + "<temperature>" + this.temperature + "</temperature>\n";
        }
        if (!this.isDraggable()) {
            xml = String.valueOf(xml) + "<draggable>false</draggable>\n";
        }
        if (!this.isMovable()) {
            xml = String.valueOf(xml) + "<movable>false</movable>\n";
        }
        xml = String.valueOf(xml) + "</particle>\n";
        return xml;
    }
}

