/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import org.concord.energy2d.model.Model2D;

public class PartFactory {
    private Model2D model;

    public PartFactory(Model2D model) {
        this.model = model;
    }

    public void addParabola(float a, float b) {
        int nx = this.model.getNx();
        float lx = this.model.getLx();
        float ly = this.model.getLy();
        float[] x = new float[nx * 2];
        float[] y = new float[nx * 2];
        int i = 0;
        while (i < nx) {
            x[i] = lx / (float)nx * (float)i;
            y[i] = ly - a * (x[i] - lx * 0.5f) * (x[i] - lx * 0.5f);
            x[2 * nx - 1 - i] = x[i];
            y[2 * nx - 1 - i] = y[i] + b;
            ++i;
        }
        this.model.addPolygonPart(x, y);
    }

    public void addStair(float x, float y, float w, float h, int n) {
        float dx = w / (float)n;
        float dy = h / (float)n;
        float[] sx = new float[n * 2 + 3];
        float[] sy = new float[n * 2 + 3];
        int i = 0;
        while (i < n) {
            sx[i * 2] = x + (float)i * dx;
            sy[i * 2] = y + (float)i * dy;
            sx[i * 2 + 1] = x + (float)(i + 1) * dx;
            sy[i * 2 + 1] = y + (float)i * dy;
            ++i;
        }
        sx[n * 2] = x + w;
        sy[n * 2] = y + h;
        sx[n * 2 + 1] = x + w - dx;
        sy[n * 2 + 1] = y + h;
        sx[n * 2 + 2] = x;
        sy[n * 2 + 2] = y + dy;
        this.model.addPolygonPart(sx, sy);
    }
}

