/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.List;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.Polygon2D;
import org.concord.energy2d.math.Ring2D;
import org.concord.energy2d.math.TransformableShape;
import org.concord.energy2d.model.Discrete;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.Photon;
import org.concord.energy2d.model.Segment;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.util.FillPattern;
import org.concord.energy2d.util.Texture;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class Part
extends Manipulable {
    private float power;
    private boolean powerSwitch = true;
    private float thermistorTemperatureCoefficient = 0.0f;
    private float thermistorReferenceTemperature = 0.0f;
    private float temperature;
    private boolean constantTemperature;
    private float thermalConductivity = 1.0f;
    private float specificHeat = 1300.0f;
    private float density = 25.0f;
    private float absorptivity = 1.0f;
    private float transmissivity;
    private float reflectivity;
    private float emissivity;
    private boolean scattering;
    private boolean scatteringVisible = true;
    private float elasticity = 1.0f;
    private float windSpeed;
    private float windAngle;
    private static final DecimalFormat LABEL_FORMAT = new DecimalFormat("####.######");
    private static final DecimalFormat SHORT_LABEL_FORMAT = new DecimalFormat("###.##");
    private FillPattern fillPattern;
    private boolean filled = true;
    private Model2D model;

    public Part(Shape shape, Model2D model) {
        super(shape);
        this.model = model;
        this.fillPattern = new ColorFill(Color.gray);
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFillPattern(FillPattern fillPattern) {
        this.fillPattern = fillPattern;
    }

    public FillPattern getFillPattern() {
        return this.fillPattern;
    }

    @Override
    public Part duplicate(float x, float y) {
        Rectangle2D r;
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            r = (Rectangle2D.Float)s;
            s = new Rectangle2D.Float(x - 0.5f * ((Rectangle2D.Float)r).width, y - 0.5f * ((Rectangle2D.Float)r).height, ((Rectangle2D.Float)r).width, ((Rectangle2D.Float)r).height);
        } else if (s instanceof Ellipse2D.Float) {
            Ellipse2D.Float e = (Ellipse2D.Float)s;
            s = new Ellipse2D.Float(x - 0.5f * e.width, y - 0.5f * e.height, e.width, e.height);
        } else if (s instanceof Ring2D) {
            s = new Ring2D((Ring2D)s);
            r = s.getBounds2D();
            ((Ring2D)s).translateBy(x - (float)r.getCenterX(), y - (float)r.getCenterY());
        } else if (s instanceof Polygon2D) {
            s = ((Polygon2D)s).duplicate();
            r = s.getBounds2D();
            float dx = x - (float)r.getCenterX();
            float dy = y - (float)r.getCenterY();
            ((Polygon2D)s).translateBy(dx, dy);
        } else if (s instanceof Blob2D) {
            s = ((Blob2D)s).duplicate();
            r = s.getBounds2D();
            float dx = x - (float)r.getCenterX();
            float dy = y - (float)r.getCenterY();
            ((Blob2D)s).translateBy(dx, dy);
            ((Blob2D)s).update();
        }
        Part p = new Part(s, this.model);
        this.copyPropertiesTo(p);
        return p;
    }

    public void copyPropertiesTo(Part p) {
        p.filled = this.filled;
        p.fillPattern = this.fillPattern;
        p.power = this.power;
        p.elasticity = this.elasticity;
        p.thermistorTemperatureCoefficient = this.thermistorTemperatureCoefficient;
        p.thermistorReferenceTemperature = this.thermistorReferenceTemperature;
        p.temperature = this.temperature;
        p.constantTemperature = this.constantTemperature;
        p.thermalConductivity = this.thermalConductivity;
        p.specificHeat = this.specificHeat;
        p.density = this.density;
        p.absorptivity = this.absorptivity;
        p.reflectivity = this.reflectivity;
        p.scattering = this.scattering;
        p.scatteringVisible = this.scatteringVisible;
        p.transmissivity = this.transmissivity;
        p.emissivity = this.emissivity;
        p.windAngle = this.windAngle;
        p.windSpeed = this.windSpeed;
        p.setLabel(this.getLabel());
    }

    public void translateBy(float dx, float dy) {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            r.x += dx;
            r.y += dy;
        } else if (s instanceof Ellipse2D.Float) {
            Ellipse2D.Float e = (Ellipse2D.Float)s;
            e.x += dx;
            e.y += dy;
        } else if (s instanceof Ring2D) {
            ((Ring2D)s).translateBy(dx, dy);
        } else if (s instanceof Polygon2D) {
            ((Polygon2D)s).translateBy(dx, dy);
        } else if (s instanceof Blob2D) {
            ((Blob2D)s).translateBy(dx, dy);
            ((Blob2D)s).update();
        }
    }

    public void setWindSpeed(float windSpeed) {
        this.windSpeed = windSpeed;
    }

    public float getWindSpeed() {
        return this.windSpeed;
    }

    public void setWindAngle(float windAngle) {
        this.windAngle = windAngle;
    }

    public float getWindAngle() {
        return this.windAngle;
    }

    public void setEmissivity(float emissivity) {
        this.emissivity = emissivity;
    }

    public float getEmissivity() {
        return this.emissivity;
    }

    public void setTransmissivity(float transmission) {
        this.transmissivity = transmission;
    }

    public float getTransmissivity() {
        return this.transmissivity;
    }

    public void setAbsorptivity(float absorption) {
        this.absorptivity = absorption;
    }

    public float getAbsorptivity() {
        return this.absorptivity;
    }

    public void setReflectivity(float reflectivity) {
        this.reflectivity = reflectivity;
    }

    public float getReflectivity() {
        return this.reflectivity;
    }

    public void setScattering(boolean scattering) {
        this.scattering = scattering;
    }

    public boolean getScattering() {
        return this.scattering;
    }

    public void setScatteringVisible(boolean scatteringVisible) {
        this.scatteringVisible = scatteringVisible;
    }

    public boolean isScatteringVisible() {
        return this.scatteringVisible;
    }

    public void setElasticity(float elasticity) {
        this.elasticity = elasticity;
    }

    public float getElasticity() {
        return this.elasticity;
    }

    public void setConstantTemperature(boolean b) {
        this.constantTemperature = b;
    }

    public boolean getConstantTemperature() {
        return this.constantTemperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setPower(float power) {
        this.power = power;
    }

    public float getPower() {
        return this.power;
    }

    public void setPowerSwitch(boolean b) {
        this.powerSwitch = b;
    }

    public boolean getPowerSwitch() {
        return this.powerSwitch;
    }

    public void setThermistorTemperatureCoefficient(float temperatureCoefficient) {
        this.thermistorTemperatureCoefficient = temperatureCoefficient;
    }

    public float getThermistorTemperatureCoefficient() {
        return this.thermistorTemperatureCoefficient;
    }

    public void setThermistorReferenceTemperature(float referenceTemperature) {
        this.thermistorReferenceTemperature = referenceTemperature;
    }

    public float getThermistorReferenceTemperature() {
        return this.thermistorReferenceTemperature;
    }

    public void setThermalConductivity(float thermalConductivity) {
        this.thermalConductivity = thermalConductivity;
    }

    public float getThermalConductivity() {
        return this.thermalConductivity;
    }

    public void setSpecificHeat(float specificHeat) {
        this.specificHeat = specificHeat;
    }

    public float getSpecificHeat() {
        return this.specificHeat;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public float getDensity() {
        return this.density;
    }

    boolean contains(Photon p) {
        return this.getShape().contains(p.getRx(), p.getRy());
    }

    boolean intersectsLine(Segment s1, Segment s2) {
        Point2D.Float p2;
        Point2D.Float p1 = s1.getCenter();
        if (p1.distanceSq(p2 = s2.getCenter()) < (double)(1.0E-6f * this.model.getLx())) {
            return true;
        }
        Shape shape = this.getShape();
        if (shape instanceof Rectangle2D.Float) {
            if (s1.getPart() == this && s2.getPart() == this) {
                return true;
            }
            Rectangle2D.Float r0 = (Rectangle2D.Float)shape;
            float indent = 0.001f;
            float x0 = r0.x + indent * r0.width;
            float y0 = r0.y + indent * r0.height;
            float x1 = r0.x + (1.0f - indent) * r0.width;
            float y1 = r0.y + (1.0f - indent) * r0.height;
            if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, x0, y0, x1, y0)) {
                return true;
            }
            if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, x1, y0, x1, y1)) {
                return true;
            }
            if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, x1, y1, x0, y1)) {
                return true;
            }
            if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, x0, y1, x0, y0)) {
                return true;
            }
        } else if (shape instanceof Polygon2D || shape instanceof Blob2D) {
            float delta = this.model.getLx() / (float)this.model.getNx();
            float indent = 0.001f * delta;
            float x3 = p1.x;
            float y3 = p1.y;
            float x4 = p2.x;
            float y4 = p2.y;
            if (Math.abs(p1.x - p2.x) < indent) {
                delta = Math.signum(p2.y - p1.y) * indent;
                y3 += delta;
                y4 -= delta;
            } else if (Math.abs(p1.y - p2.y) < indent) {
                delta = Math.signum(p2.x - p1.x) * indent;
                x3 += delta;
                x4 -= delta;
            } else {
                float k = (p2.y - p1.y) / (p2.x - p1.x);
                delta = Math.signum(p2.x - p1.x) * indent;
                y3 = p1.y + k * ((x3 += delta) - p1.x);
                y4 = p1.y + k * ((x4 -= delta) - p1.x);
            }
            List<Segment> partSegments = this.model.getPerimeterSegments(this);
            int n = partSegments.size();
            if (n > 0) {
                boolean bothBelongToThisPart = s1.getPart() == this && s2.getPart() == this;
                Shape shape2 = shape;
                if (shape instanceof Blob2D) {
                    Path2D.Float path = new Path2D.Float();
                    Object s = partSegments.get(0);
                    path.moveTo(((Segment)s).x1, ((Segment)s).y1);
                    path.lineTo(((Segment)s).x2, ((Segment)s).y2);
                    if (n > 1) {
                        int i = 1;
                        while (i < n) {
                            s = partSegments.get(i);
                            path.lineTo(((Segment)s).x2, ((Segment)s).y2);
                            ++i;
                        }
                    }
                    path.closePath();
                    shape2 = path;
                }
                for (Segment s : partSegments) {
                    if (bothBelongToThisPart && (shape2.contains(x3, y3) || shape2.contains(x4, y4))) {
                        return true;
                    }
                    if (!s.intersectsLine(x3, y3, x4, y4)) continue;
                    return true;
                }
            }
        } else if (shape instanceof Ellipse2D.Float) {
            float patchSize;
            double perimeter;
            int n;
            if (s1.getPart() == this && s2.getPart() == this) {
                return true;
            }
            Ellipse2D.Float e0 = (Ellipse2D.Float)shape;
            float indent = 0.01f;
            float ex = e0.x + indent * e0.width;
            float ey = e0.y + indent * e0.height;
            float ew = (1.0f - 2.0f * indent) * e0.width;
            float eh = (1.0f - 2.0f * indent) * e0.height;
            float a = ew * 0.5f;
            float b = eh * 0.5f;
            float x = ex + a;
            float y = ey + b;
            float h = (a - b) / (a + b);
            if ((n = (int)((perimeter = Math.PI * (double)(a + b) * (1.0 + (double)(3.0f * (h *= h)) / (10.0 + Math.sqrt(4.0f - 3.0f * h)))) / (double)(patchSize = this.model.getLx() * this.model.getPerimeterStepSize()))) > 0) {
                float[] vx = new float[n];
                float[] vy = new float[n];
                float delta = (float)(Math.PI * 2 / (double)n);
                int i = 0;
                while (i < n) {
                    float theta = delta * (float)i;
                    vx[i] = (float)((double)x + (double)a * Math.cos(theta));
                    vy[i] = (float)((double)y + (double)b * Math.sin(theta));
                    ++i;
                }
                i = 0;
                while (i < n - 1) {
                    if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, vx[i], vy[i], vx[i + 1], vy[i + 1])) {
                        return true;
                    }
                    ++i;
                }
                if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, vx[n - 1], vy[n - 1], vx[0], vy[0])) {
                    return true;
                }
            }
        } else if (shape instanceof Ring2D) {
            float patchSize;
            Ring2D r0 = (Ring2D)shape;
            float indent = 0.01f;
            float x = r0.getX();
            float y = r0.getY();
            float d = r0.getOuterDiameter() * (1.0f - indent);
            double perimeter = Math.PI * (double)d;
            int n = (int)(perimeter / (double)(patchSize = this.model.getLx() * this.model.getPerimeterStepSize()));
            if (n > 0) {
                float theta;
                float[] vx = new float[n];
                float[] vy = new float[n];
                float delta = (float)(Math.PI * 2 / (double)n);
                d /= 2.0f;
                int i = 0;
                while (i < n) {
                    theta = delta * (float)i;
                    vx[i] = (float)((double)x + (double)d * Math.cos(theta));
                    vy[i] = (float)((double)y + (double)d * Math.sin(theta));
                    ++i;
                }
                i = 0;
                while (i < n - 1) {
                    if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, vx[i], vy[i], vx[i + 1], vy[i + 1])) {
                        return true;
                    }
                    ++i;
                }
                if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, vx[n - 1], vy[n - 1], vx[0], vy[0])) {
                    return true;
                }
                d = r0.getInnerDiameter() * (1.0f + indent);
                perimeter = Math.PI * (double)d;
                n = (int)(perimeter / (double)patchSize);
                vx = new float[n];
                vy = new float[n];
                delta = (float)(Math.PI * 2 / (double)n);
                d /= 2.0f;
                i = 0;
                while (i < n) {
                    theta = delta * (float)i;
                    vx[i] = (float)((double)x + (double)d * Math.cos(theta));
                    vy[i] = (float)((double)y + (double)d * Math.sin(theta));
                    ++i;
                }
                i = 0;
                while (i < n - 1) {
                    if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, vx[i], vy[i], vx[i + 1], vy[i + 1])) {
                        return true;
                    }
                    ++i;
                }
                if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, vx[n - 1], vy[n - 1], vx[0], vy[0])) {
                    return true;
                }
            }
        }
        return false;
    }

    boolean reflect(Discrete p, boolean scatter) {
        float dt = this.model.getTimeStep();
        float predictedX = p.getRx() + p.getVx() * dt;
        float predictedY = p.getRy() + p.getVy() * dt;
        if (p instanceof Particle) {
            float dt2 = 0.5f * dt * dt;
            predictedX += ((Particle)p).ax * dt2;
            predictedY += ((Particle)p).ay * dt2;
        }
        Shape shape = this.getShape();
        boolean predictedToBeInShape = true;
        if (p instanceof Photon) {
            predictedToBeInShape = shape.contains(predictedX, predictedY);
        }
        if (shape instanceof Rectangle2D.Float) {
            if (predictedToBeInShape) {
                return this.reflect((Rectangle2D.Float)shape, p, predictedX, predictedY, scatter);
            }
        } else if (shape instanceof Polygon2D) {
            if (predictedToBeInShape) {
                return this.reflect((Polygon2D)shape, p, predictedX, predictedY, scatter);
            }
        } else if (shape instanceof Blob2D) {
            if (predictedToBeInShape) {
                return this.reflect((Blob2D)shape, p, predictedX, predictedY, scatter);
            }
        } else if (shape instanceof Ellipse2D.Float) {
            if (predictedToBeInShape) {
                return this.reflect((Ellipse2D.Float)shape, p, predictedX, predictedY, scatter);
            }
        } else if (shape instanceof Ring2D && predictedToBeInShape) {
            return this.reflect((Ring2D)shape, p, predictedX, predictedY, scatter);
        }
        return false;
    }

    private boolean reflect(Rectangle2D.Float r, Discrete p, float predictedX, float predictedY, boolean scatter) {
        if (p instanceof Particle) {
            boolean predictedToHit;
            Particle particle = (Particle)p;
            float radius = particle.radius;
            float x0 = r.x;
            float y0 = r.y;
            float x1 = r.x + r.width;
            float y1 = r.y + r.height;
            boolean bl = predictedToHit = predictedX - radius <= x1 && predictedX + radius >= x0 && predictedY - radius <= y1 && predictedY + radius >= y0;
            if (predictedToHit) {
                float impulse = 0.0f;
                float hitX = predictedX;
                float hitY = predictedY;
                if (particle.rx - radius <= x0) {
                    impulse = Math.abs(particle.vx);
                    particle.vx = -impulse * this.elasticity;
                    hitX += radius + 0.5f * this.model.getLy() / (float)this.model.getNy();
                } else if (particle.rx + radius >= x1) {
                    impulse = Math.abs(particle.vx);
                    particle.vx = impulse * this.elasticity;
                    hitX -= radius + 0.5f * this.model.getLy() / (float)this.model.getNy();
                }
                if (particle.ry - radius <= y0) {
                    impulse = Math.abs(particle.vy);
                    particle.vy = -impulse * this.elasticity;
                    hitY += radius + 0.5f * this.model.getLy() / (float)this.model.getNy();
                } else if (particle.ry + radius >= y1) {
                    impulse = Math.abs(particle.vy);
                    particle.vy = impulse * this.elasticity;
                    hitY -= radius + 0.5f * this.model.getLy() / (float)this.model.getNy();
                }
                if (this.elasticity < 1.0f) {
                    float energy = 0.5f * particle.mass * impulse * impulse * (1.0f - this.elasticity * this.elasticity);
                    float volume = this.model.getLx() * this.model.getLy() / (float)(this.model.getNx() * this.model.getNy());
                    this.model.changeTemperatureAt(hitX, hitY, energy / (this.specificHeat * this.density * volume));
                }
                return true;
            }
        } else if (p instanceof Photon) {
            if (p.getRx() <= r.x) {
                if (scatter) {
                    p.setVelocityAngle((float)(Math.PI * (0.5 + Math.random())));
                } else {
                    p.setVx(-Math.abs(p.getVx()));
                }
            } else if (p.getRx() >= r.x + r.width) {
                if (scatter) {
                    p.setVelocityAngle((float)(Math.PI * (0.5 - Math.random())));
                } else {
                    p.setVx(Math.abs(p.getVx()));
                }
            }
            if (p.getRy() <= r.y) {
                if (scatter) {
                    p.setVelocityAngle((float)(Math.PI * (1.0 + Math.random())));
                } else {
                    p.setVy(-Math.abs(p.getVy()));
                }
            } else if (p.getRy() >= r.y + r.height) {
                if (scatter) {
                    p.setVelocityAngle((float)(Math.PI * Math.random()));
                } else {
                    p.setVy(Math.abs(p.getVy()));
                }
            }
            return true;
        }
        return false;
    }

    private boolean reflect(Blob2D b, Discrete p, float predictedX, float predictedY, boolean scatter) {
        Point2D.Float v2;
        Point2D.Float v1;
        boolean clockwise = b.isClockwise();
        int n = b.getPathPointCount();
        Line2D.Float line = new Line2D.Float();
        int i = 0;
        while (i < n - 1) {
            v1 = b.getPathPoint(i);
            v2 = b.getPathPoint(i + 1);
            line.setLine(v1, v2);
            if (this.reflectFromLine(p, line, predictedX, predictedY, scatter, clockwise)) {
                return true;
            }
            ++i;
        }
        v1 = b.getPathPoint(n - 1);
        v2 = b.getPathPoint(0);
        line.setLine(v1, v2);
        return this.reflectFromLine(p, line, predictedX, predictedY, scatter, clockwise);
    }

    private boolean reflect(Ellipse2D.Float e, Discrete p, float predictedX, float predictedY, boolean scatter) {
        float a = e.width * 0.5f;
        float b = e.height * 0.5f;
        float x = e.x + a;
        float y = e.y + b;
        int polygonize = 50;
        float[] vx = new float[polygonize];
        float[] vy = new float[polygonize];
        float delta = (float)(Math.PI * 2 / (double)polygonize);
        int i = 0;
        while (i < polygonize) {
            float theta = -delta * (float)i;
            vx[i] = (float)((double)x + (double)a * Math.cos(theta));
            vy[i] = (float)((double)y + (double)b * Math.sin(theta));
            ++i;
        }
        Line2D.Float line = new Line2D.Float();
        int i2 = 0;
        while (i2 < polygonize - 1) {
            line.setLine(vx[i2], vy[i2], vx[i2 + 1], vy[i2 + 1]);
            if (this.reflectFromLine(p, line, predictedX, predictedY, scatter, true)) {
                return true;
            }
            ++i2;
        }
        line.setLine(vx[polygonize - 1], vy[polygonize - 1], vx[0], vy[0]);
        return this.reflectFromLine(p, line, predictedX, predictedY, scatter, true);
    }

    private boolean reflect(Ring2D e, Discrete p, float predictedX, float predictedY, boolean scatter) {
        float y;
        float rInner = e.getInnerDiameter() * 0.5f;
        float rOuter = e.getOuterDiameter() * 0.5f;
        float x = e.getX();
        boolean inside = new Ellipse2D.Float(x - rInner, (y = e.getY()) - rInner, 2.0f * rInner, 2.0f * rInner).contains(p.getRx(), p.getRy());
        float a = inside ? rInner : rOuter;
        int polygonize = 50;
        float[] vx = new float[polygonize];
        float[] vy = new float[polygonize];
        float delta = (float)(Math.PI * 2 / (double)polygonize);
        int i = 0;
        while (i < polygonize) {
            float theta = -delta * (float)i;
            vx[i] = (float)((double)x + (double)a * Math.cos(theta));
            vy[i] = (float)((double)y + (double)a * Math.sin(theta));
            ++i;
        }
        Line2D.Float line = new Line2D.Float();
        int i2 = 0;
        while (i2 < polygonize - 1) {
            line.setLine(vx[i2], vy[i2], vx[i2 + 1], vy[i2 + 1]);
            if (this.reflectFromLine(p, line, predictedX, predictedY, scatter, !inside)) {
                return true;
            }
            ++i2;
        }
        line.setLine(vx[polygonize - 1], vy[polygonize - 1], vx[0], vy[0]);
        return this.reflectFromLine(p, line, predictedX, predictedY, scatter, !inside);
    }

    private boolean reflect(Polygon2D r, Discrete p, float predictedX, float predictedY, boolean scatter) {
        Point2D.Float v2;
        Point2D.Float v1;
        boolean clockwise = r.isClockwise();
        int n = r.getVertexCount();
        Line2D.Float line = new Line2D.Float();
        int i = 0;
        while (i < n - 1) {
            v1 = r.getVertex(i);
            v2 = r.getVertex(i + 1);
            line.setLine(v1, v2);
            if (this.reflectFromLine(p, line, predictedX, predictedY, scatter, clockwise)) {
                return true;
            }
            ++i;
        }
        v1 = r.getVertex(n - 1);
        v2 = r.getVertex(0);
        line.setLine(v1, v2);
        return this.reflectFromLine(p, line, predictedX, predictedY, scatter, clockwise);
    }

    private boolean reflectFromLine(Discrete p, Line2D.Float line, float predictedX, float predictedY, boolean scatter, boolean clockwise) {
        if (line.x1 == line.x2 && line.y1 == line.y2) {
            return false;
        }
        boolean hit = false;
        if (p instanceof Photon) {
            hit = line.intersectsLine(p.getRx(), p.getRy(), predictedX, predictedY);
        } else if (p instanceof Particle) {
            Particle particle = (Particle)p;
            float r = particle.radius;
            boolean bl = hit = Line2D.ptSegDistSq(line.x1, line.y1, line.x2, line.y2, predictedX, predictedY) <= (double)(r * r);
        }
        if (hit) {
            float d12 = (float)Math.hypot(line.x1 - line.x2, line.y1 - line.y2);
            float sin = (clockwise ? line.y2 - line.y1 : line.y1 - line.y2) / d12;
            float cos = (clockwise ? line.x2 - line.x1 : line.x1 - line.x2) / d12;
            if (scatter) {
                double angle = -Math.PI * Math.random();
                double cos1 = Math.cos(angle);
                double sin1 = Math.sin(angle);
                double cos2 = cos1 * (double)cos - sin1 * (double)sin;
                double sin2 = sin1 * (double)cos + cos1 * (double)sin;
                p.setVx((float)((double)p.getSpeed() * cos2));
                p.setVy((float)((double)p.getSpeed() * sin2));
            } else {
                float w;
                Particle particle;
                if (p instanceof Particle) {
                    particle = (Particle)p;
                    float u = particle.vx * cos + particle.vy * sin;
                    w = particle.vy * cos - particle.vx * sin;
                    if (Math.abs(w *= this.elasticity) < 0.01f) {
                        w = -Math.abs(w);
                    }
                    p.setVx(u * cos + w * sin);
                    p.setVy(u * sin - w * cos);
                } else {
                    float u = p.getVx() * cos + p.getVy() * sin;
                    w = p.getVy() * cos - p.getVx() * sin;
                    p.setVx(u * cos + w * sin);
                    p.setVy(u * sin - w * cos);
                }
                if (p instanceof Particle && this.elasticity < 1.0f) {
                    particle = (Particle)p;
                    float hitX = predictedX + (particle.radius + 0.5f * this.model.getLx() / (float)this.model.getNx()) * sin;
                    float hitY = predictedY - (particle.radius + 0.5f * this.model.getLy() / (float)this.model.getNy()) * cos;
                    float energy = 0.5f * particle.mass * w * w * (1.0f - this.elasticity * this.elasticity);
                    float volume = this.model.getLx() * this.model.getLy() / (float)(this.model.getNx() * this.model.getNy());
                    this.model.changeTemperatureAt(hitX, hitY, energy / (this.specificHeat * this.density * volume));
                }
            }
            return true;
        }
        return false;
    }

    public String toXml() {
        String label;
        int n;
        XmlCharacterEncoder xce = new XmlCharacterEncoder();
        String xml = "<part>\n";
        if (this.getShape() instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
            xml = String.valueOf(xml) + "<rectangle";
            xml = String.valueOf(xml) + " x=\"" + r.x + "\"";
            xml = String.valueOf(xml) + " y=\"" + r.y + "\"";
            xml = String.valueOf(xml) + " width=\"" + r.width + "\"";
            xml = String.valueOf(xml) + " height=\"" + r.height + "\"/>";
        } else if (this.getShape() instanceof Ellipse2D.Float) {
            Ellipse2D.Float e = (Ellipse2D.Float)this.getShape();
            xml = String.valueOf(xml) + "<ellipse";
            xml = String.valueOf(xml) + " x=\"" + e.getCenterX() + "\"";
            xml = String.valueOf(xml) + " y=\"" + e.getCenterY() + "\"";
            xml = String.valueOf(xml) + " a=\"" + e.width + "\"";
            xml = String.valueOf(xml) + " b=\"" + e.height + "\"/>";
        } else if (this.getShape() instanceof Polygon2D) {
            Point2D.Float p2d;
            Polygon2D p = (Polygon2D)this.getShape();
            xml = String.valueOf(xml) + "<polygon count=\"" + p.getVertexCount() + "\" vertices=\"";
            n = p.getVertexCount();
            int i = 0;
            while (i < n - 1) {
                p2d = p.getVertex(i);
                xml = String.valueOf(xml) + p2d.x + ", " + p2d.y + ", ";
                ++i;
            }
            p2d = p.getVertex(n - 1);
            xml = String.valueOf(xml) + p2d.x + ", " + p2d.y + "\"/>\n";
        } else if (this.getShape() instanceof Blob2D) {
            Point2D.Float p2d;
            Blob2D b = (Blob2D)this.getShape();
            xml = String.valueOf(xml) + "<blob count=\"" + b.getPointCount() + "\" points=\"";
            n = b.getPointCount();
            int i = 0;
            while (i < n - 1) {
                p2d = b.getPoint(i);
                xml = String.valueOf(xml) + p2d.x + ", " + p2d.y + ", ";
                ++i;
            }
            p2d = b.getPoint(n - 1);
            xml = String.valueOf(xml) + p2d.x + ", " + p2d.y + "\"/>\n";
        } else if (this.getShape() instanceof Ring2D) {
            Ring2D ring = (Ring2D)this.getShape();
            xml = String.valueOf(xml) + "<ring";
            xml = String.valueOf(xml) + " x=\"" + ring.getX() + "\"";
            xml = String.valueOf(xml) + " y=\"" + ring.getY() + "\"";
            xml = String.valueOf(xml) + " inner=\"" + ring.getInnerDiameter() + "\"";
            xml = String.valueOf(xml) + " outer=\"" + ring.getOuterDiameter() + "\"/>";
        }
        xml = String.valueOf(xml) + "<elasticity>" + this.elasticity + "</elasticity>\n";
        xml = String.valueOf(xml) + "<thermal_conductivity>" + this.thermalConductivity + "</thermal_conductivity>\n";
        xml = String.valueOf(xml) + "<specific_heat>" + this.specificHeat + "</specific_heat>\n";
        xml = String.valueOf(xml) + "<density>" + this.density + "</density>\n";
        xml = String.valueOf(xml) + "<transmission>" + this.transmissivity + "</transmission>\n";
        xml = String.valueOf(xml) + "<reflection>" + this.reflectivity + "</reflection>\n";
        xml = String.valueOf(xml) + "<scattering>" + this.scattering + "</scattering>\n";
        if (!this.scatteringVisible) {
            xml = String.valueOf(xml) + "<scattering_visible>false</scattering_visible>\n";
        }
        xml = String.valueOf(xml) + "<absorption>" + this.absorptivity + "</absorption>\n";
        xml = String.valueOf(xml) + "<emissivity>" + this.emissivity + "</emissivity>\n";
        xml = String.valueOf(xml) + "<temperature>" + this.temperature + "</temperature>\n";
        xml = String.valueOf(xml) + "<constant_temperature>" + this.constantTemperature + "</constant_temperature>\n";
        if (this.power != 0.0f) {
            xml = String.valueOf(xml) + "<power>" + this.power + "</power>\n";
        }
        if (this.thermistorTemperatureCoefficient != 0.0f) {
            xml = String.valueOf(xml) + "<temperature_coefficient>" + this.thermistorTemperatureCoefficient + "</temperature_coefficient>\n";
        }
        if (this.thermistorReferenceTemperature != 0.0f) {
            xml = String.valueOf(xml) + "<reference_temperature>" + this.thermistorReferenceTemperature + "</reference_temperature>\n";
        }
        if (this.windSpeed != 0.0f) {
            xml = String.valueOf(xml) + "<wind_speed>" + this.windSpeed + "</wind_speed>\n";
        }
        if (this.windAngle != 0.0f) {
            xml = String.valueOf(xml) + "<wind_angle>" + this.windAngle + "</wind_angle>\n";
        }
        if (this.getUid() != null && !this.getUid().trim().equals("")) {
            xml = String.valueOf(xml) + "<uid>" + xce.encode(this.getUid()) + "</uid>\n";
        }
        if (this.fillPattern instanceof ColorFill) {
            Color color = ((ColorFill)this.fillPattern).getColor();
            if (!color.equals(Color.gray)) {
                xml = String.valueOf(xml) + "<color>" + Integer.toHexString(0xFFFFFF & color.getRGB()) + "</color>\n";
            }
        } else if (this.fillPattern instanceof Texture) {
            Texture pf = (Texture)this.fillPattern;
            xml = String.valueOf(xml) + "<texture>";
            int i = pf.getForeground();
            xml = String.valueOf(xml) + "<texture_fg>" + Integer.toString(i, 16) + "</texture_fg>\n";
            i = pf.getBackground();
            xml = String.valueOf(xml) + "<texture_bg>" + Integer.toString(i, 16) + "</texture_bg>\n";
            i = ((Texture)this.fillPattern).getStyle();
            xml = String.valueOf(xml) + "<texture_style>" + i + "</texture_style>\n";
            i = pf.getCellWidth();
            xml = String.valueOf(xml) + "<texture_width>" + i + "</texture_width>\n";
            i = pf.getCellHeight();
            xml = String.valueOf(xml) + "<texture_height>" + i + "</texture_height>\n";
            xml = String.valueOf(xml) + "</texture>\n";
        }
        if (!this.isFilled()) {
            xml = String.valueOf(xml) + "<filled>false</filled>\n";
        }
        if ((label = this.getLabel()) != null && !label.trim().equals("")) {
            xml = String.valueOf(xml) + "<label>" + xce.encode(label) + "</label>\n";
        }
        if (!this.isVisible()) {
            xml = String.valueOf(xml) + "<visible>false</visible>\n";
        }
        if (!this.isDraggable()) {
            xml = String.valueOf(xml) + "<draggable>false</draggable>\n";
        }
        xml = String.valueOf(xml) + "</part>\n";
        return xml;
    }

    public String getLabel(String label, Model2D model, boolean useFahrenheit) {
        if (label == null) {
            return null;
        }
        if (label.indexOf(37) == -1) {
            return label;
        }
        String s = null;
        if (label.equalsIgnoreCase("%temperature")) {
            Rectangle2D bounds = this.getShape().getBounds2D();
            float temp = model.getTemperatureAt((float)bounds.getCenterX(), (float)bounds.getCenterY());
            s = useFahrenheit ? String.valueOf(Math.round(temp * 1.8f + 32.0f)) + " \u00b0F" : String.valueOf(Math.round(temp)) + " \u00b0C";
        } else if (label.equalsIgnoreCase("%thermal_energy")) {
            s = String.valueOf(Math.round(model.getThermalEnergy(this))) + " J";
        } else if (label.equalsIgnoreCase("%density")) {
            s = String.valueOf((int)this.density) + " kg/m\u00b3";
        } else if (label.equalsIgnoreCase("%elasticity")) {
            s = String.valueOf(SHORT_LABEL_FORMAT.format(this.elasticity));
        } else if (label.equalsIgnoreCase("%specific_heat")) {
            s = String.valueOf((int)this.specificHeat) + " J/(kg\u00d7\u00b0C)";
        } else if (label.equalsIgnoreCase("%heat_capacity")) {
            s = String.valueOf(SHORT_LABEL_FORMAT.format(this.specificHeat * this.density * this.getArea())) + " J/\u00b0C";
        } else if (label.equalsIgnoreCase("%volumetric_heat_capacity")) {
            s = String.valueOf(SHORT_LABEL_FORMAT.format(this.specificHeat * this.density)) + " J/(m\u00b3\u00d7\u00b0C)";
        } else if (label.equalsIgnoreCase("%thermal_diffusivity")) {
            s = String.valueOf(LABEL_FORMAT.format(this.thermalConductivity / (this.specificHeat * this.density))) + " m\u00b2/s";
        } else if (label.equalsIgnoreCase("%thermal_conductivity")) {
            s = String.valueOf(this.thermalConductivity) + " W/(m\u00d7\u00b0C)";
        } else if (label.equalsIgnoreCase("%power_density")) {
            s = String.valueOf((int)this.power) + " W/m\u00b3";
        } else if (label.equalsIgnoreCase("%area")) {
            s = this.getAreaString();
        } else if (label.equalsIgnoreCase("%width")) {
            s = this.getWidthString();
        } else if (label.equalsIgnoreCase("%height")) {
            s = this.getHeightString();
        } else {
            s = label.replace("%temperature", useFahrenheit ? String.valueOf((int)(this.temperature * 1.8f + 32.0f)) + " \u00b0F" : String.valueOf((int)this.temperature) + " \u00b0C");
            s = s.replace("%thermal_energy", String.valueOf(Math.round(model.getThermalEnergy(this))) + " J");
            s = s.replace("%density", String.valueOf((int)this.density) + " kg/m\u00b3");
            s = s.replace("%specific_heat", String.valueOf((int)this.specificHeat) + " J/(kg\u00d7\u00b0C)");
            s = s.replace("%heat_capacity", String.valueOf(SHORT_LABEL_FORMAT.format(this.specificHeat * this.density * this.getArea())) + " J/\u00b0C");
            s = s.replace("%volumetric_heat_capacity", String.valueOf(SHORT_LABEL_FORMAT.format(this.specificHeat * this.density)) + " J/(m\u00b3\u00d7\u00b0C)");
            s = s.replace("%thermal_diffusivity", String.valueOf(LABEL_FORMAT.format(this.thermalConductivity / (this.specificHeat * this.density))) + " m\u00b2/s");
            s = s.replace("%thermal_conductivity", String.valueOf(this.thermalConductivity) + " W/(m\u00d7\u00b0C)");
            s = s.replace("%power_density", String.valueOf((int)this.power) + " W/m\u00b3");
            s = s.replace("%area", this.getAreaString());
            s = s.replace("%width", this.getWidthString());
            s = s.replace("%height", this.getHeightString());
        }
        return s;
    }

    private float getArea() {
        float area = -1.0f;
        if (this.getShape() instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
            area = r.width * r.height;
        } else if (this.getShape() instanceof Ellipse2D.Float) {
            Ellipse2D.Float e = (Ellipse2D.Float)this.getShape();
            area = (float)((double)(e.width * e.height) * 0.25 * Math.PI);
        } else if (this.getShape() instanceof TransformableShape) {
            area = ((TransformableShape)this.getShape()).getArea();
        } else if (this.getShape() instanceof Ring2D) {
            area = ((Ring2D)this.getShape()).getArea();
        }
        return area;
    }

    private String getAreaString() {
        float area = this.getArea();
        return area < 0.0f ? "Unknown" : String.valueOf(LABEL_FORMAT.format(area)) + " m\u00b2";
    }

    private String getWidthString() {
        if (this.getShape() instanceof Rectangle2D.Float) {
            return String.valueOf(LABEL_FORMAT.format(((Rectangle2D.Float)this.getShape()).width)) + " m";
        }
        if (this.getShape() instanceof Ellipse2D.Float) {
            return String.valueOf(LABEL_FORMAT.format(((Ellipse2D.Float)this.getShape()).width)) + " m";
        }
        return "Unknown";
    }

    private String getHeightString() {
        if (this.getShape() instanceof Rectangle2D.Float) {
            return String.valueOf(LABEL_FORMAT.format(((Rectangle2D.Float)this.getShape()).height)) + " m";
        }
        if (this.getShape() instanceof Ellipse2D.Float) {
            return String.valueOf(LABEL_FORMAT.format(((Ellipse2D.Float)this.getShape()).height)) + " m";
        }
        return "Unknown";
    }

    public String toString() {
        return this.getUid() == null ? super.toString() : this.getUid();
    }
}

