/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import org.concord.energy2d.model.ThermalBoundary;

public class NeumannThermalBoundary
implements ThermalBoundary {
    private float[] fluxAtBorder = new float[4];

    public NeumannThermalBoundary() {
        this.setFluxAtBorder((byte)0, 0.0f);
        this.setFluxAtBorder((byte)2, 0.0f);
        this.setFluxAtBorder((byte)3, 0.0f);
        this.setFluxAtBorder((byte)1, 0.0f);
    }

    public void setFluxAtBorder(byte side, float value) {
        if (side < 0 || side > 3) {
            throw new IllegalArgumentException("side parameter illegal");
        }
        this.fluxAtBorder[side] = value;
    }

    public float getFluxAtBorder(byte side) {
        if (side < 0 || side > 3) {
            throw new IllegalArgumentException("side parameter illegal");
        }
        return this.fluxAtBorder[side];
    }

    @Override
    public String toXml() {
        String s = "<flux_at_border upper=\"" + this.fluxAtBorder[0] + "\"";
        s = String.valueOf(s) + " lower=\"" + this.fluxAtBorder[2] + "\"";
        s = String.valueOf(s) + " left=\"" + this.fluxAtBorder[3] + "\"";
        s = String.valueOf(s) + " right=\"" + this.fluxAtBorder[1] + "\"";
        s = String.valueOf(s) + "/>\n";
        return s;
    }
}

