/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.concord.energy2d.event.ManipulationEvent;
import org.concord.energy2d.event.ManipulationListener;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.Polygon2D;
import org.concord.energy2d.math.Ring2D;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.FluidSolver2D;
import org.concord.energy2d.model.FluidSolver2DImpl;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.HeatSolver2D;
import org.concord.energy2d.model.HeatSolver2DImpl;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.MassBoundary;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.model.ParticleSolver2D;
import org.concord.energy2d.model.Photon;
import org.concord.energy2d.model.PhotonSolver2D;
import org.concord.energy2d.model.RadiositySolver2D;
import org.concord.energy2d.model.Segment;
import org.concord.energy2d.model.Sensor;
import org.concord.energy2d.model.ThermalBoundary;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.Thermostat;
import org.concord.energy2d.model.Tree;

public class Model2D {
    static final float STEFAN_CONSTANT = 5.67E-8f;
    public static final byte BUOYANCY_AVERAGE_ALL = 0;
    public static final byte BUOYANCY_AVERAGE_COLUMN = 1;
    public static final byte GRAVITY_UNIFORM = 0;
    public static final byte GRAVITY_CENTRIC = 1;
    private int indexOfStep;
    private float backgroundConductivity = 0.25f;
    private float backgroundSpecificHeat = 1012.0f;
    private float backgroundDensity = 1.204f;
    private float backgroundTemperature;
    private float maximumHeatCapacity = -1.0f;
    private float[][] t;
    private float[][] u;
    private float[][] v;
    private float[][] tb;
    private float[][] q;
    private float[][] uWind;
    private float[][] vWind;
    private float[][] conductivity;
    private float[][] specificHeat;
    private float[][] density;
    private boolean[][] fluidity;
    private List<HeatFluxSensor> heatFluxSensors;
    private List<Anemometer> anemometers;
    private List<Thermometer> thermometers;
    private List<Thermostat> thermostats;
    private List<Part> parts;
    private List<Particle> particles;
    private List<Photon> photons;
    private List<Cloud> clouds;
    private List<Tree> trees;
    private List<Fan> fans;
    private List<Heliostat> heliostats;
    private List<ParticleFeeder> particleFeeders;
    private PhotonSolver2D photonSolver;
    private RadiositySolver2D radiositySolver;
    private FluidSolver2D fluidSolver;
    private HeatSolver2D heatSolver;
    private ParticleSolver2D particleSolver;
    private boolean sunny;
    private int photonEmissionInterval = 20;
    private int radiosityInterval = 20;
    private int nx = 100;
    private int ny = 100;
    private float lx = 10.0f;
    private float ly = 10.0f;
    private float deltaX = this.lx / (float)this.nx;
    private float deltaY = this.ly / (float)this.ny;
    private boolean running;
    private boolean notifyReset;
    private boolean hasPartPower;
    private boolean radiative;
    private boolean convective = true;
    private List<PropertyChangeListener> propertyChangeListeners;
    private List<ManipulationListener> manipulationListeners;
    private Runnable tasks;

    public Model2D() {
        this.t = new float[this.nx][this.ny];
        this.u = new float[this.nx][this.ny];
        this.v = new float[this.nx][this.ny];
        this.q = new float[this.nx][this.ny];
        this.tb = new float[this.nx][this.ny];
        this.uWind = new float[this.nx][this.ny];
        this.vWind = new float[this.nx][this.ny];
        this.conductivity = new float[this.nx][this.ny];
        this.specificHeat = new float[this.nx][this.ny];
        this.density = new float[this.nx][this.ny];
        this.fluidity = new boolean[this.nx][this.ny];
        this.parts = Collections.synchronizedList(new ArrayList());
        this.particles = Collections.synchronizedList(new ArrayList());
        this.heatFluxSensors = Collections.synchronizedList(new ArrayList());
        this.anemometers = Collections.synchronizedList(new ArrayList());
        this.thermometers = Collections.synchronizedList(new ArrayList());
        this.thermostats = Collections.synchronizedList(new ArrayList());
        this.photons = Collections.synchronizedList(new ArrayList());
        this.clouds = Collections.synchronizedList(new ArrayList());
        this.trees = Collections.synchronizedList(new ArrayList());
        this.fans = Collections.synchronizedList(new ArrayList());
        this.heliostats = Collections.synchronizedList(new ArrayList());
        this.particleFeeders = Collections.synchronizedList(new ArrayList());
        this.init();
        this.heatSolver = new HeatSolver2DImpl(this.nx, this.ny);
        this.heatSolver.setSpecificHeat(this.specificHeat);
        this.heatSolver.setConductivity(this.conductivity);
        this.heatSolver.setDensity(this.density);
        this.heatSolver.setPower(this.q);
        this.heatSolver.setVelocity(this.u, this.v);
        this.heatSolver.setTemperatureBoundary(this.tb);
        this.heatSolver.setFluidity(this.fluidity);
        this.fluidSolver = new FluidSolver2DImpl(this.nx, this.ny);
        this.fluidSolver.setFluidity(this.fluidity);
        this.fluidSolver.setTemperature(this.t);
        this.fluidSolver.setWindSpeed(this.uWind, this.vWind);
        this.photonSolver = new PhotonSolver2D(this.lx, this.ly);
        this.photonSolver.setPower(this.q);
        this.radiositySolver = new RadiositySolver2D(this);
        this.particleSolver = new ParticleSolver2D(this);
        this.setGridCellSize();
        this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        this.manipulationListeners = new ArrayList<ManipulationListener>();
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public void setTasks(Runnable r) {
        this.tasks = r;
    }

    public void setConvective(boolean convective) {
        this.convective = convective;
    }

    public boolean isConvective() {
        return this.convective;
    }

    public void setZHeatDiffusivity(float zHeatDiffusivity) {
        this.heatSolver.zHeatDiffusivity = zHeatDiffusivity;
    }

    public float getZHeatDiffusivity() {
        return this.heatSolver.zHeatDiffusivity;
    }

    public void setThermophoreticCoefficient(float thermophoreticCoefficient) {
        this.particleSolver.thermophoreticCoefficient = thermophoreticCoefficient;
    }

    public float getThermophoreticCoefficient() {
        return this.particleSolver.thermophoreticCoefficient;
    }

    public void setGravitationalAcceleration(float g) {
        this.particleSolver.g = g;
    }

    public float getGravitationalAcceleration() {
        return this.particleSolver.g;
    }

    public void setParticleDrag(float drag) {
        this.particleSolver.drag = drag;
    }

    public float getParticleDrag() {
        return this.particleSolver.drag;
    }

    public void setParticleHardness(float epsilon) {
        this.particleSolver.epsilon = epsilon;
    }

    public float getParticleHardness() {
        return this.particleSolver.epsilon;
    }

    public void setGravityType(byte gravityType) {
        this.fluidSolver.setGravityType(gravityType);
    }

    public byte getGravityType() {
        return this.fluidSolver.getGravityType();
    }

    public void setThermalExpansionCoefficient(float thermalExpansionCoefficient) {
        this.fluidSolver.setThermalExpansionCoefficient(thermalExpansionCoefficient);
    }

    public float getThermalExpansionCoefficient() {
        return this.fluidSolver.getThermalExpansionCoefficient();
    }

    public void setBuoyancyApproximation(byte buoyancyApproximation) {
        this.fluidSolver.setBuoyancyApproximation(buoyancyApproximation);
    }

    public byte getBuoyancyApproximation() {
        return this.fluidSolver.getBuoyancyApproximation();
    }

    public void setBackgroundViscosity(float viscosity) {
        this.fluidSolver.setBackgroundViscosity(viscosity);
    }

    public float getBackgroundViscosity() {
        return this.fluidSolver.getViscosity();
    }

    public void setSunny(boolean sunny) {
        this.sunny = sunny;
        if (sunny) {
            this.radiative = true;
        } else {
            this.photons.clear();
        }
    }

    public boolean isSunny() {
        return this.sunny;
    }

    public void moveSun(float sunrise, float sunset) {
        float hour = this.getTime() / 3600.0f;
        int i = (int)hour;
        this.photonSolver.setSunAngle(((hour += (float)(i % 24 - i)) - sunrise) / (sunset - sunrise) * (float)Math.PI);
        this.refreshPowerArray();
        if (this.getSunAngle() >= 0.0f && (double)this.getSunAngle() <= Math.PI) {
            this.refreshHeliostats();
        }
    }

    public void setSunAngle(float sunAngle) {
        this.photonSolver.setSunAngle(sunAngle);
        if (!this.heliostats.isEmpty()) {
            for (Heliostat h : this.heliostats) {
                h.setAngle();
            }
        }
        if (Math.abs(sunAngle - this.photonSolver.getSunAngle()) > 0.001f) {
            this.photons.clear();
        }
    }

    public float getSunAngle() {
        return this.photonSolver.getSunAngle();
    }

    public void setSolarPowerDensity(float solarPowerDensity) {
        this.photonSolver.setSolarPowerDensity(solarPowerDensity);
    }

    public float getSolarPowerDensity() {
        return this.photonSolver.getSolarPowerDensity();
    }

    public void setSolarRayCount(int solarRayCount) {
        if (solarRayCount == this.photonSolver.getSolarRayCount()) {
            return;
        }
        this.photons.clear();
        this.photonSolver.setSolarRayCount(solarRayCount);
    }

    public int getSolarRayCount() {
        return this.photonSolver.getSolarRayCount();
    }

    public void setSolarRaySpeed(float raySpeed) {
        this.photonSolver.setSolarRaySpeed(raySpeed);
    }

    public float getSolarRaySpeed() {
        return this.photonSolver.getSolarRaySpeed();
    }

    public void setPhotonEmissionInterval(int photonEmissionInterval) {
        this.photonEmissionInterval = photonEmissionInterval;
    }

    public int getPhotonEmissionInterval() {
        return this.photonEmissionInterval;
    }

    public void addPhoton(Photon p) {
        if (p != null) {
            this.photons.add(p);
        }
    }

    public void removePhoton(Photon p) {
        this.photons.remove(p);
    }

    public List<Photon> getPhotons() {
        return this.photons;
    }

    private void setGridCellSize() {
        this.heatSolver.setGridCellSize(this.deltaX, this.deltaY);
        this.fluidSolver.setGridCellSize(this.deltaX, this.deltaY);
        this.photonSolver.setGridCellSize(this.deltaX, this.deltaY);
    }

    public void setLx(float lx) {
        this.lx = lx;
        this.deltaX = lx / (float)this.nx;
        this.setGridCellSize();
        this.photonSolver.setLx(lx);
    }

    public float getLx() {
        return this.lx;
    }

    public void setLy(float ly) {
        this.ly = ly;
        this.deltaY = ly / (float)this.ny;
        this.setGridCellSize();
        this.photonSolver.setLy(ly);
    }

    public float getLy() {
        return this.ly;
    }

    public void translateAllBy(float dx, float dy) {
        if (!this.thermometers.isEmpty()) {
            for (Thermometer thermometer : this.thermometers) {
                thermometer.translateBy(dx, dy);
            }
        }
        if (!this.anemometers.isEmpty()) {
            for (Anemometer anemometer : this.anemometers) {
                anemometer.translateBy(dx, dy);
            }
        }
        if (!this.heatFluxSensors.isEmpty()) {
            for (HeatFluxSensor heatFluxSensor : this.heatFluxSensors) {
                heatFluxSensor.translateBy(dx, dy);
            }
        }
        if (!this.clouds.isEmpty()) {
            for (Cloud cloud : this.clouds) {
                cloud.translateBy(dx, dy);
            }
        }
        if (!this.trees.isEmpty()) {
            for (Tree tree : this.trees) {
                tree.translateBy(dx, dy);
            }
        }
        for (Part part : this.parts) {
            part.translateBy(dx, dy);
        }
        for (Particle particle : this.particles) {
            particle.translateBy(dx, dy);
        }
        for (ParticleFeeder particleFeeder : this.particleFeeders) {
            particleFeeder.translateBy(dx, dy);
        }
        for (Fan fan : this.fans) {
            fan.translateBy(dx, dy);
        }
        for (Heliostat heliostat : this.heliostats) {
            heliostat.translateBy(dx, dy);
        }
    }

    public boolean scaleAll(float scale) {
        Rectangle2D.Float r;
        Shape s;
        Rectangle2D.Float bound = new Rectangle2D.Float(0.0f, 0.0f, this.lx, this.ly);
        boolean out = false;
        if (!this.thermometers.isEmpty()) {
            for (Thermometer thermometer : this.thermometers) {
                thermometer.setCenter(scale * thermometer.getX(), this.ly - scale * (this.ly - thermometer.getY()));
                if (bound.intersects(thermometer.getShape().getBounds2D())) continue;
                out = true;
            }
        }
        if (!this.anemometers.isEmpty()) {
            for (Anemometer anemometer : this.anemometers) {
                anemometer.setCenter(scale * anemometer.getX(), this.ly - scale * (this.ly - anemometer.getY()));
                if (bound.intersects(anemometer.getShape().getBounds2D())) continue;
                out = true;
            }
        }
        if (!this.heatFluxSensors.isEmpty()) {
            for (HeatFluxSensor heatFluxSensor : this.heatFluxSensors) {
                heatFluxSensor.setCenter(scale * heatFluxSensor.getX(), this.ly - scale * (this.ly - heatFluxSensor.getY()));
                if (bound.intersects(heatFluxSensor.getShape().getBounds2D())) continue;
                out = true;
            }
        }
        if (!this.clouds.isEmpty()) {
            for (Cloud cloud : this.clouds) {
                cloud.setLocation(scale * cloud.getX(), this.ly - scale * (this.ly - cloud.getY()));
                cloud.setDimension(cloud.getWidth() * scale, cloud.getHeight() * scale);
                if (bound.intersects(cloud.getShape().getBounds2D())) continue;
                out = true;
            }
        }
        if (!this.trees.isEmpty()) {
            for (Tree tree : this.trees) {
                tree.setLocation(scale * tree.getX(), this.ly - scale * (this.ly - tree.getY()));
                tree.setDimension(tree.getWidth() * scale, tree.getHeight() * scale);
                if (bound.intersects(tree.getShape().getBounds2D())) continue;
                out = true;
            }
        }
        if (!this.particles.isEmpty()) {
            for (Particle particle : this.particles) {
                particle.setLocation(scale * particle.getRx(), this.ly - scale * (this.ly - particle.getRy()));
                particle.setRadius(particle.getRadius() * scale);
                if (bound.intersects(particle.getShape().getBounds2D())) continue;
                out = true;
            }
        }
        if (!this.particleFeeders.isEmpty()) {
            for (ParticleFeeder particleFeeder : this.particleFeeders) {
                particleFeeder.setCenter(scale * particleFeeder.getX(), this.ly - scale * (this.ly - particleFeeder.getY()));
                if (bound.intersects(particleFeeder.getShape().getBounds2D())) continue;
                out = true;
            }
        }
        for (Part part : this.parts) {
            s = part.getShape();
            if (s instanceof Rectangle2D.Float) {
                r = (Rectangle2D.Float)s;
                r.x = scale * r.x;
                r.y = this.ly - scale * (this.ly - r.y);
                r.width *= scale;
                r.height *= scale;
                if (bound.intersects(r)) continue;
                out = true;
                continue;
            }
            if (s instanceof Ellipse2D.Float) {
                Ellipse2D.Float e = (Ellipse2D.Float)s;
                e.x = scale * e.x;
                e.y = this.ly - scale * (this.ly - e.y);
                e.width *= scale;
                e.height *= scale;
                if (bound.intersects(e.getBounds2D())) continue;
                out = true;
                continue;
            }
            if (s instanceof Ring2D) {
                Ring2D a = (Ring2D)s;
                float x = scale * a.getX();
                float y = this.ly - scale * (this.ly - a.getY());
                float innerDiameter = a.getInnerDiameter() * scale;
                float outerDiameter = a.getOuterDiameter() * scale;
                a.setRing(x, y, innerDiameter, outerDiameter);
                if (bound.intersects(a.getBounds2D())) continue;
                out = true;
                continue;
            }
            if (s instanceof Polygon2D) {
                Polygon2D g = (Polygon2D)s;
                int n = g.getVertexCount();
                int i = 0;
                while (i < n) {
                    Point2D.Float h = g.getVertex(i);
                    h.x = scale * h.x;
                    h.y = this.ly - scale * (this.ly - h.y);
                    ++i;
                }
                if (bound.intersects(g.getBounds2D())) continue;
                out = true;
                continue;
            }
            if (!(s instanceof Blob2D)) continue;
            Blob2D b = (Blob2D)s;
            int n = b.getPointCount();
            int i = 0;
            while (i < n) {
                Point2D.Float h = b.getPoint(i);
                h.x = scale * h.x;
                h.y = this.ly - scale * (this.ly - h.y);
                ++i;
            }
            if (bound.intersects(b.getBounds2D())) continue;
            out = true;
        }
        for (Fan fan : this.fans) {
            s = fan.getShape();
            if (!(s instanceof Rectangle2D.Float)) continue;
            r = (Rectangle2D.Float)s;
            r.x = scale * r.x;
            r.y = this.ly - scale * (this.ly - r.y);
            r.width *= scale;
            r.height *= scale;
            if (bound.intersects(r)) continue;
            out = true;
        }
        for (Heliostat heliostat : this.heliostats) {
            s = heliostat.getShape();
            if (!(s instanceof Rectangle2D.Float)) continue;
            r = (Rectangle2D.Float)s;
            r.x = scale * r.x;
            r.y = this.ly - scale * (this.ly - r.y);
            r.width *= scale;
            r.height *= scale;
            if (bound.intersects(r)) continue;
            out = true;
        }
        return out;
    }

    public ThermalBoundary getThermalBoundary() {
        return this.heatSolver.getBoundary();
    }

    public void setThermalBoundary(ThermalBoundary b) {
        this.heatSolver.setBoundary(b);
    }

    public MassBoundary getMassBoundary() {
        return this.fluidSolver.getBoundary();
    }

    public void setMassBoundary(MassBoundary b) {
        this.fluidSolver.setBoundary(b);
    }

    public void setBackgroundTemperature(float backgroundTemperature) {
        this.backgroundTemperature = backgroundTemperature;
        this.heatSolver.backgroundTemperature = backgroundTemperature;
    }

    public float getBackgroundTemperature() {
        return this.backgroundTemperature;
    }

    public void setBackgroundConductivity(float backgroundConductivity) {
        this.backgroundConductivity = backgroundConductivity;
    }

    public float getBackgroundConductivity() {
        return this.backgroundConductivity;
    }

    public void setBackgroundSpecificHeat(float backgroundSpecificHeat) {
        this.backgroundSpecificHeat = backgroundSpecificHeat;
    }

    public float getBackgroundSpecificHeat() {
        return this.backgroundSpecificHeat;
    }

    public void setBackgroundDensity(float backgroundDensity) {
        this.backgroundDensity = backgroundDensity;
    }

    public float getBackgroundDensity() {
        return this.backgroundDensity;
    }

    public float getPrandtlNumber() {
        return this.getBackgroundViscosity() * this.backgroundDensity * this.backgroundSpecificHeat / this.backgroundConductivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thermostat addThermostat(Thermometer t, Part p) {
        Iterator<Thermostat> i = this.thermostats.iterator();
        List<Thermostat> list = this.thermostats;
        synchronized (list) {
            while (i.hasNext()) {
                Thermostat x = i.next();
                if (x.getThermometer() != t || x.getPowerSource() != p) continue;
                return x;
            }
        }
        Thermostat x = new Thermostat(t, p);
        this.thermostats.add(x);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThermostat(Thermometer t, Part p) {
        if (this.thermostats.isEmpty()) {
            return;
        }
        List<Thermostat> list = this.thermostats;
        synchronized (list) {
            Iterator<Thermostat> i = this.thermostats.iterator();
            while (i.hasNext()) {
                Thermostat x = i.next();
                if (x.getThermometer() != t || x.getPowerSource() != p) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnected(Thermometer t, Part p) {
        Iterator<Thermostat> i = this.thermostats.iterator();
        List<Thermostat> list = this.thermostats;
        synchronized (list) {
            Thermostat x;
            do {
                if (i.hasNext()) continue;
                return false;
            } while ((x = i.next()).getThermometer() != t || x.getPowerSource() != p);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thermostat getThermostat(Object o) {
        Iterator<Thermostat> i = this.thermostats.iterator();
        List<Thermostat> list = this.thermostats;
        synchronized (list) {
            while (i.hasNext()) {
                Thermostat x = i.next();
                if (x.getThermometer() != o && x.getPowerSource() != o) continue;
                return x;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thermostat getThermostat(Thermometer t, Part p) {
        Iterator<Thermostat> i = this.thermostats.iterator();
        List<Thermostat> list = this.thermostats;
        synchronized (list) {
            while (i.hasNext()) {
                Thermostat x = i.next();
                if (x.getThermometer() != t || x.getPowerSource() != p) continue;
                return x;
            }
        }
        return null;
    }

    public List<Thermostat> getThermostats() {
        return this.thermostats;
    }

    public void addThermometer(Thermometer t) {
        this.thermometers.add(t);
    }

    public void addThermometer(Thermometer t, int index) {
        this.thermometers.add(index, t);
    }

    public void addThermometer(float x, float y) {
        this.thermometers.add(new Thermometer(x, y));
    }

    public Thermometer addThermometer(float x, float y, String uid, String label, byte stencil) {
        Thermometer t = new Thermometer(x, y);
        t.setUid(uid);
        t.setLabel(label);
        t.setStencil(stencil);
        this.thermometers.add(t);
        return t;
    }

    public void removeThermometer(Thermometer t) {
        this.thermometers.remove(t);
        if (!this.thermostats.isEmpty()) {
            Iterator<Thermostat> i = this.thermostats.iterator();
            while (i.hasNext()) {
                Thermostat x = i.next();
                if (x.getThermometer() != t) continue;
                i.remove();
            }
        }
    }

    public List<Thermometer> getThermometers() {
        return this.thermometers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thermometer getThermometer(String uid) {
        if (uid == null) {
            return null;
        }
        List<Thermometer> list = this.thermometers;
        synchronized (list) {
            for (Thermometer t : this.thermometers) {
                if (!uid.equals(t.getUid())) continue;
                return t;
            }
        }
        return null;
    }

    public Thermometer getThermometer(int i) {
        if (i < 0 || i >= this.thermometers.size()) {
            return null;
        }
        return this.thermometers.get(i);
    }

    public void addAnemometer(Anemometer a) {
        this.anemometers.add(a);
    }

    public void addAnemometer(Anemometer a, int index) {
        this.anemometers.add(index, a);
    }

    public void addAnemometer(float x, float y) {
        this.anemometers.add(new Anemometer(x, y));
    }

    public Anemometer addAnemometer(float x, float y, String uid, String label, byte stencil) {
        Anemometer a = new Anemometer(x, y);
        a.setUid(uid);
        a.setLabel(label);
        a.setStencil(stencil);
        this.anemometers.add(a);
        return a;
    }

    public void removeAnemometer(Anemometer a) {
        this.anemometers.remove(a);
    }

    public List<Anemometer> getAnemometers() {
        return this.anemometers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Anemometer getAnemometer(String uid) {
        if (uid == null) {
            return null;
        }
        List<Anemometer> list = this.anemometers;
        synchronized (list) {
            for (Anemometer a : this.anemometers) {
                if (!uid.equals(a.getUid())) continue;
                return a;
            }
        }
        return null;
    }

    public Anemometer getAnemometer(int i) {
        if (i < 0 || i >= this.anemometers.size()) {
            return null;
        }
        return this.anemometers.get(i);
    }

    public void addHeatFluxSensor(HeatFluxSensor h) {
        this.heatFluxSensors.add(h);
    }

    public void addHeatFluxSensor(HeatFluxSensor h, int index) {
        this.heatFluxSensors.add(index, h);
    }

    public void addHeatFluxSensor(float x, float y) {
        this.heatFluxSensors.add(new HeatFluxSensor(x, y));
    }

    public HeatFluxSensor addHeatFluxSensor(float x, float y, String uid, String label, float angle) {
        HeatFluxSensor h = new HeatFluxSensor(x, y);
        h.setUid(uid);
        h.setLabel(label);
        h.setAngle(angle);
        this.heatFluxSensors.add(h);
        return h;
    }

    public void removeHeatFluxSensor(HeatFluxSensor h) {
        this.heatFluxSensors.remove(h);
    }

    public List<HeatFluxSensor> getHeatFluxSensors() {
        return this.heatFluxSensors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeatFluxSensor getHeatFluxSensor(String uid) {
        if (uid == null) {
            return null;
        }
        List<HeatFluxSensor> list = this.heatFluxSensors;
        synchronized (list) {
            for (HeatFluxSensor h : this.heatFluxSensors) {
                if (!uid.equals(h.getUid())) continue;
                return h;
            }
        }
        return null;
    }

    public HeatFluxSensor getHeatFluxSensor(int i) {
        if (i < 0 || i >= this.heatFluxSensors.size()) {
            return null;
        }
        return this.heatFluxSensors.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSensorData() {
        List<Sensor> list;
        this.indexOfStep = 0;
        if (!this.thermometers.isEmpty()) {
            list = this.thermometers;
            synchronized (list) {
                for (Thermometer t : this.thermometers) {
                    t.clear();
                }
            }
        }
        if (!this.anemometers.isEmpty()) {
            list = this.anemometers;
            synchronized (list) {
                for (Anemometer a : this.anemometers) {
                    a.clear();
                }
            }
        }
        if (!this.heatFluxSensors.isEmpty()) {
            list = this.heatFluxSensors;
            synchronized (list) {
                for (HeatFluxSensor h : this.heatFluxSensors) {
                    h.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float[] getSensorDataBounds(byte type) {
        switch (type) {
            case 0: {
                if (this.thermometers.isEmpty()) return null;
                float[] bounds = new float[]{Float.MAX_VALUE, -3.4028235E38f};
                List<Thermometer> list = this.thermometers;
                synchronized (list) {
                    Iterator<Thermometer> iterator = this.thermometers.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return bounds;
                        }
                        Thermometer t = iterator.next();
                        float min = t.getDataMinimum();
                        if (Float.isNaN(min)) {
                            return null;
                        }
                        float max = t.getDataMaximum();
                        if (bounds[0] > min) {
                            bounds[0] = min;
                        }
                        if (!(bounds[1] < max)) continue;
                        bounds[1] = max;
                    }
                }
            }
            case 1: {
                if (this.heatFluxSensors.isEmpty()) return null;
                float[] bounds = new float[]{Float.MAX_VALUE, -3.4028235E38f};
                List<HeatFluxSensor> list = this.heatFluxSensors;
                synchronized (list) {
                    Iterator<HeatFluxSensor> iterator = this.heatFluxSensors.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return bounds;
                        }
                        HeatFluxSensor f = iterator.next();
                        float min = f.getDataMinimum();
                        if (Float.isNaN(min)) {
                            return null;
                        }
                        float max = f.getDataMaximum();
                        if (bounds[0] > min) {
                            bounds[0] = min;
                        }
                        if (!(bounds[1] < max)) continue;
                        bounds[1] = max;
                    }
                }
            }
            case 2: {
                if (this.anemometers.isEmpty()) return null;
                float[] bounds = new float[]{Float.MAX_VALUE, -3.4028235E38f};
                List<Anemometer> list = this.anemometers;
                synchronized (list) {
                    Iterator<Anemometer> iterator = this.anemometers.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return bounds;
                        }
                        Anemometer a = iterator.next();
                        float min = a.getDataMinimum();
                        if (Float.isNaN(min)) {
                            return null;
                        }
                        float max = a.getDataMaximum();
                        if (bounds[0] > min) {
                            bounds[0] = min;
                        }
                        if (!(bounds[1] < max)) continue;
                        bounds[1] = max;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUidUsed(String uid) {
        Iterator<Manipulable> iterator;
        List<Manipulable> list;
        block39: {
            Manipulable t;
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                Manipulable p;
                                block33: {
                                    if (uid == null) throw new IllegalArgumentException("UID cannot be null or an empty string.");
                                    if (uid.trim().equals("")) {
                                        throw new IllegalArgumentException("UID cannot be null or an empty string.");
                                    }
                                    list = this.parts;
                                    synchronized (list) {
                                        iterator = this.parts.iterator();
                                        do {
                                            if (iterator.hasNext()) continue;
                                            break block33;
                                        } while (!uid.equals((p = iterator.next()).getUid()));
                                        return true;
                                    }
                                }
                                list = this.particles;
                                synchronized (list) {
                                    iterator = this.particles.iterator();
                                    do {
                                        if (iterator.hasNext()) continue;
                                        break block34;
                                    } while (!uid.equals((p = (Particle)iterator.next()).getUid()));
                                    return true;
                                }
                            }
                            list = this.thermometers;
                            synchronized (list) {
                                iterator = this.thermometers.iterator();
                                do {
                                    if (iterator.hasNext()) continue;
                                    break block35;
                                } while (!uid.equals((t = (Thermometer)iterator.next()).getUid()));
                                return true;
                            }
                        }
                        list = this.anemometers;
                        synchronized (list) {
                            Anemometer a;
                            iterator = this.anemometers.iterator();
                            do {
                                if (iterator.hasNext()) continue;
                                break block36;
                            } while (!uid.equals((a = (Anemometer)iterator.next()).getUid()));
                            return true;
                        }
                    }
                    list = this.heatFluxSensors;
                    synchronized (list) {
                        HeatFluxSensor h;
                        iterator = this.heatFluxSensors.iterator();
                        do {
                            if (iterator.hasNext()) continue;
                            break block37;
                        } while (!uid.equals((h = (HeatFluxSensor)iterator.next()).getUid()));
                        return true;
                    }
                }
                list = this.clouds;
                synchronized (list) {
                    Cloud c;
                    iterator = this.clouds.iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        break block38;
                    } while (!uid.equals((c = (Cloud)iterator.next()).getUid()));
                    return true;
                }
            }
            list = this.trees;
            synchronized (list) {
                iterator = this.trees.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    break block39;
                } while (!uid.equals((t = (Tree)iterator.next()).getUid()));
                return true;
            }
        }
        list = this.fans;
        synchronized (list) {
            Fan f;
            iterator = this.fans.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!uid.equals((f = (Fan)iterator.next()).getUid()));
            return true;
        }
    }

    public Part addRectangularPart(float x, float y, float w, float h) {
        Part p = new Part(new Rectangle2D.Float(x, y, w, h), this);
        this.addPart(p);
        return p;
    }

    public Part addRectangularPart(float x, float y, float w, float h, float temperature) {
        Part p = this.addRectangularPart(x, y, w, h);
        p.setTemperature(temperature);
        return p;
    }

    public Part addEllipticalPart(float x, float y, float a, float b) {
        Part p = new Part(new Ellipse2D.Float(x - 0.5f * a, y - 0.5f * b, a, b), this);
        this.addPart(p);
        return p;
    }

    public Part addEllipticalPart(float x, float y, float a, float b, float temperature) {
        Part p = this.addEllipticalPart(x, y, a, b);
        p.setTemperature(temperature);
        return p;
    }

    public Part addRingPart(float x, float y, float inner, float outer) {
        Part p = new Part(new Ring2D(x, y, inner, outer), this);
        this.addPart(p);
        return p;
    }

    public Part addPolygonPart(Polygon2D polygon) {
        Part p = new Part(polygon, this);
        this.addPart(p);
        return p;
    }

    public Part addPolygonPart(float[] x, float[] y) {
        return this.addPolygonPart(new Polygon2D(x, y));
    }

    public Part addPolygonPart(float[] x, float[] y, float temperature) {
        Part p = this.addPolygonPart(x, y);
        p.setTemperature(temperature);
        return p;
    }

    public Part addBlobPart(Blob2D blob) {
        Part p = new Part(blob, this);
        this.addPart(p);
        return p;
    }

    public Part addBlobPart(float[] x, float[] y) {
        return this.addBlobPart(new Blob2D(x, y));
    }

    public Part addBlobPart(float[] x, float[] y, float temperature) {
        Part p = this.addBlobPart(x, y);
        p.setTemperature(temperature);
        return p;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Part getPart(String uid) {
        if (uid == null) {
            return null;
        }
        List<Part> list = this.parts;
        synchronized (list) {
            for (Part p : this.parts) {
                if (!uid.equals(p.getUid())) continue;
                return p;
            }
        }
        return null;
    }

    public Part getPart(int i) {
        if (i < 0 || i >= this.parts.size()) {
            return null;
        }
        return this.parts.get(i);
    }

    public int getPartCount() {
        return this.parts.size();
    }

    public void addPart(Part p) {
        if (!this.parts.contains(p)) {
            this.parts.add(p);
            if (p.getPower() != 0.0f) {
                this.hasPartPower = true;
            }
            if (p.getEmissivity() > 0.0f) {
                this.radiative = true;
            }
        }
    }

    public void addPart(Part p, int index) {
        if (!this.parts.contains(p)) {
            this.parts.add(index, p);
            if (p.getPower() != 0.0f) {
                this.hasPartPower = true;
            }
            if (p.getEmissivity() > 0.0f) {
                this.radiative = true;
            }
        }
    }

    public void removePart(Part p) {
        this.parts.remove(p);
        if (!this.thermostats.isEmpty()) {
            Iterator<Thermostat> i = this.thermostats.iterator();
            while (i.hasNext()) {
                Thermostat x = i.next();
                if (x.getPowerSource() != p) continue;
                i.remove();
            }
        }
        this.checkPartPower();
        this.checkPartRadiation();
    }

    public List<Particle> getParticles() {
        return this.particles;
    }

    public Particle getParticle(int i) {
        if (i < 0 || i >= this.particles.size()) {
            return null;
        }
        return this.particles.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Particle getParticle(String uid) {
        if (uid == null) {
            return null;
        }
        List<Particle> list = this.particles;
        synchronized (list) {
            for (Particle p : this.particles) {
                if (!uid.equals(p.getUid())) continue;
                return p;
            }
        }
        return null;
    }

    public void addParticle(Particle p) {
        if (!this.particles.contains(p)) {
            this.particles.add(p);
        }
    }

    public void addParticle(Particle p, int index) {
        if (!this.particles.contains(p)) {
            this.particles.add(index, p);
        }
    }

    public void removeParticle(Particle p) {
        this.particles.remove(p);
    }

    public void addParticleFeeder(ParticleFeeder pf) {
        this.particleFeeders.add(pf);
    }

    public void addParticleFeeder(ParticleFeeder pf, int index) {
        this.particleFeeders.add(index, pf);
    }

    public void addParticleFeeder(float x, float y) {
        this.particleFeeders.add(new ParticleFeeder(x, y));
    }

    public void removeParticleFeeder(ParticleFeeder pf) {
        this.particleFeeders.remove(pf);
    }

    public List<ParticleFeeder> getParticleFeeders() {
        return this.particleFeeders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParticleFeeder getParticleFeeder(String uid) {
        if (uid == null) {
            return null;
        }
        List<ParticleFeeder> list = this.particleFeeders;
        synchronized (list) {
            for (ParticleFeeder pf : this.particleFeeders) {
                if (!uid.equals(pf.getUid())) continue;
                return pf;
            }
        }
        return null;
    }

    public ParticleFeeder getParticleFeeder(int i) {
        if (i < 0 || i >= this.particleFeeders.size()) {
            return null;
        }
        return this.particleFeeders.get(i);
    }

    public void addFan(Fan f) {
        if (f != null && !this.fans.contains(f)) {
            this.fans.add(f);
        }
    }

    public void addFan(Fan f, int index) {
        if (f != null && !this.fans.contains(f)) {
            this.fans.add(index, f);
        }
    }

    public void removeFan(Fan f) {
        this.fans.remove(f);
    }

    public List<Fan> getFans() {
        return this.fans;
    }

    public Fan getFan(int i) {
        if (i < 0 || i >= this.fans.size()) {
            return null;
        }
        return this.fans.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fan getFan(String uid) {
        if (uid == null) {
            return null;
        }
        List<Fan> list = this.fans;
        synchronized (list) {
            for (Fan f : this.fans) {
                if (!uid.equals(f.getUid())) continue;
                return f;
            }
        }
        return null;
    }

    public void refreshHeliostats() {
        if (this.heliostats.isEmpty()) {
            return;
        }
        for (Heliostat h : this.heliostats) {
            h.setAngle();
        }
    }

    public void refreshHeliostatsAimedAt(Part target) {
        if (this.heliostats.isEmpty()) {
            return;
        }
        for (Heliostat h : this.heliostats) {
            if (target != h.getTarget()) continue;
            h.setAngle();
        }
    }

    public void addHeliostat(Heliostat h) {
        if (h != null && !this.heliostats.contains(h)) {
            h.setAngle();
            this.heliostats.add(h);
        }
    }

    public void addHeliostat(Heliostat h, int index) {
        if (h != null && !this.heliostats.contains(h)) {
            this.heliostats.add(index, h);
        }
    }

    public void removeHeliostat(Heliostat h) {
        this.heliostats.remove(h);
    }

    public List<Heliostat> getHeliostats() {
        return this.heliostats;
    }

    public Heliostat getHeliostat(int i) {
        if (i < 0 || i >= this.heliostats.size()) {
            return null;
        }
        return this.heliostats.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Heliostat getHeliostat(String uid) {
        if (uid == null) {
            return null;
        }
        List<Heliostat> list = this.heliostats;
        synchronized (list) {
            for (Heliostat h : this.heliostats) {
                if (!uid.equals(h.getUid())) continue;
                return h;
            }
        }
        return null;
    }

    public void addCloud(Cloud c) {
        if (c != null && !this.clouds.contains(c)) {
            this.clouds.add(c);
        }
    }

    public void addCloud(Cloud c, int index) {
        if (c != null && !this.clouds.contains(c)) {
            this.clouds.add(index, c);
        }
    }

    public void removeCloud(Cloud c) {
        this.clouds.remove(c);
    }

    public List<Cloud> getClouds() {
        return this.clouds;
    }

    public void addTree(Tree t) {
        if (t != null && !this.trees.contains(t)) {
            this.trees.add(t);
        }
    }

    public void addTree(Tree t, int index) {
        if (t != null && !this.trees.contains(t)) {
            this.trees.add(index, t);
        }
    }

    public void removeTree(Tree t) {
        this.trees.remove(t);
    }

    public List<Tree> getTrees() {
        return this.trees;
    }

    public List<Segment> getPerimeterSegments() {
        return this.radiositySolver.getSegments();
    }

    List<Segment> getPerimeterSegments(Part part) {
        ArrayList<Segment> list = new ArrayList<Segment>();
        for (Segment s : this.radiositySolver.getSegments()) {
            if (s.getPart() != part) continue;
            list.add(s);
        }
        return list;
    }

    public void generateViewFactorMesh() {
        this.radiositySolver.segmentizePerimeters();
    }

    public void setPerimeterStepSize(float size) {
        this.radiositySolver.setPatchSizePercentage(size);
    }

    public float getPerimeterStepSize() {
        return this.radiositySolver.getPatchSizePercentage();
    }

    public boolean isVisible(Segment s1, Segment s2) {
        return this.radiositySolver.isVisible(s1, s2);
    }

    public float getMaximumHeatCapacity() {
        return this.maximumHeatCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMaterialPropertyArrays() {
        float windSpeed = 0.0f;
        boolean initial = this.indexOfStep == 0;
        this.maximumHeatCapacity = this.backgroundDensity * this.backgroundSpecificHeat;
        float heatCapacity = 0.0f;
        int i = 0;
        while (i < this.nx) {
            float x = (float)i * this.deltaX;
            int j = 0;
            while (j < this.ny) {
                Part p;
                ListIterator<Part> li;
                float y = (float)j * this.deltaY;
                this.conductivity[i][j] = this.backgroundConductivity;
                this.specificHeat[i][j] = this.backgroundSpecificHeat;
                this.density[i][j] = this.backgroundDensity;
                this.fluidity[i][j] = true;
                this.vWind[i][j] = 0.0f;
                this.uWind[i][j] = 0.0f;
                List<Manipulable> list = this.parts;
                synchronized (list) {
                    li = this.parts.listIterator(this.parts.size());
                    while (li.hasPrevious()) {
                        p = li.previous();
                        if (!this.contains(p.getShape(), x, y, this.convective)) continue;
                        this.conductivity[i][j] = p.getThermalConductivity();
                        this.specificHeat[i][j] = p.getSpecificHeat();
                        this.density[i][j] = p.getDensity();
                        this.fluidity[i][j] = false;
                        break;
                    }
                }
                list = this.parts;
                synchronized (list) {
                    li = this.parts.listIterator(this.parts.size());
                    while (li.hasPrevious()) {
                        p = li.previous();
                        if (!this.contains(p.getShape(), x, y, false)) continue;
                        if (!initial && p.getConstantTemperature()) {
                            this.t[i][j] = p.getTemperature();
                        }
                        if ((windSpeed = p.getWindSpeed()) == 0.0f) break;
                        this.uWind[i][j] = (float)((double)windSpeed * Math.cos(p.getWindAngle()));
                        this.vWind[i][j] = (float)((double)windSpeed * Math.sin(p.getWindAngle()));
                        break;
                    }
                }
                list = this.fans;
                synchronized (list) {
                    for (Fan f : this.fans) {
                        if (!this.contains(f.getShape(), x, y, false)) continue;
                        windSpeed = f.getSpeed();
                        if (windSpeed == 0.0f) break;
                        this.uWind[i][j] = (float)((double)windSpeed * Math.cos(f.getAngle()));
                        this.vWind[i][j] = (float)((double)windSpeed * Math.sin(f.getAngle()));
                        break;
                    }
                }
                heatCapacity = this.specificHeat[i][j] * this.density[i][j];
                if (this.maximumHeatCapacity < heatCapacity) {
                    this.maximumHeatCapacity = heatCapacity;
                }
                ++j;
            }
            ++i;
        }
        if (initial) {
            this.setInitialTemperature();
            this.setInitialVelocity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPowerArray() {
        this.checkPartPower();
        int i = 0;
        while (i < this.nx) {
            float x = (float)i * this.deltaX;
            int j = 0;
            while (j < this.ny) {
                float y = (float)j * this.deltaY;
                this.q[i][j] = 0.0f;
                if (this.hasPartPower) {
                    int count = 0;
                    List<Part> list = this.parts;
                    synchronized (list) {
                        for (Part p : this.parts) {
                            if (p.getPower() == 0.0f || !p.getPowerSwitch() || !this.contains(p.getShape(), x, y, false)) continue;
                            float power = p.getPower();
                            if (p.getThermistorTemperatureCoefficient() != 0.0f) {
                                power *= 1.0f + p.getThermistorTemperatureCoefficient() * (this.t[i][j] - p.getThermistorReferenceTemperature());
                            }
                            float[] fArray = this.q[i];
                            int n = j;
                            fArray[n] = fArray[n] + power;
                            ++count;
                        }
                    }
                    if (count > 0) {
                        float[] fArray = this.q[i];
                        int n = j;
                        fArray[n] = fArray[n] / (float)count;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTemperatureBoundaryArray() {
        int i = 0;
        while (i < this.nx) {
            float x = (float)i * this.deltaX;
            int j = 0;
            while (j < this.ny) {
                float y = (float)j * this.deltaY;
                this.tb[i][j] = 0.0f;
                int count = 0;
                List<Part> list = this.parts;
                synchronized (list) {
                    for (Part p : this.parts) {
                        if (!p.getConstantTemperature() || !this.contains(p.getShape(), x, y, false)) continue;
                        float[] fArray = this.tb[i];
                        int n = j;
                        fArray[n] = fArray[n] + p.getTemperature();
                        ++count;
                    }
                }
                if (count > 0) {
                    float[] fArray = this.tb[i];
                    int n = j;
                    fArray[n] = fArray[n] / (float)count;
                } else {
                    this.tb[i][j] = Float.NaN;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean contains(Shape shape, float x, float y, boolean tolerateRoundOffError) {
        if (tolerateRoundOffError) {
            return shape.contains(x, y);
        }
        float tol = 0.001f;
        return shape.contains(x, y) || shape.contains(x - this.deltaX * tol, y) || shape.contains(x + this.deltaX * tol, y) || shape.contains(x, y - this.deltaY * tol) || shape.contains(x, y + this.deltaY * tol);
    }

    public float getThermalEnergy() {
        float energy = 0.0f;
        int i = 1;
        while (i < this.nx - 1) {
            int j = 1;
            while (j < this.ny - 1) {
                energy += this.t[i][j] * this.density[i][j] * this.specificHeat[i][j];
                ++j;
            }
            ++i;
        }
        return energy * this.deltaX * this.deltaY;
    }

    public float getThermalEnergy(Part p) {
        if (p == null) {
            return 0.0f;
        }
        float energy = 0.0f;
        int i = 0;
        while (i < this.nx) {
            float x = (float)i * this.deltaX;
            int j = 0;
            while (j < this.ny) {
                float y = (float)j * this.deltaY;
                if (this.contains(p.getShape(), x, y, false)) {
                    energy += this.t[i][j] * this.density[i][j] * this.specificHeat[i][j];
                }
                ++j;
            }
            ++i;
        }
        return energy * this.deltaX * this.deltaY;
    }

    public float getThermalEnergyAt(float x, float y) {
        int i = Math.round(x / this.deltaX);
        if (i < 0 || i >= this.nx) {
            return -1.0f;
        }
        int j = Math.round(y / this.deltaY);
        if (j < 0 || j >= this.ny) {
            return -1.0f;
        }
        return this.t[i][j] * this.density[i][j] * this.specificHeat[i][j] * this.deltaX * this.deltaY;
    }

    private void init() {
        int i = 0;
        while (i < this.nx) {
            Arrays.fill(this.conductivity[i], this.backgroundConductivity);
            Arrays.fill(this.specificHeat[i], this.backgroundSpecificHeat);
            Arrays.fill(this.density[i], this.backgroundDensity);
            ++i;
        }
        this.setInitialTemperature();
    }

    public void clear() {
        this.parts.clear();
        this.particles.clear();
        this.particleFeeders.clear();
        this.photons.clear();
        this.anemometers.clear();
        this.thermometers.clear();
        this.heatFluxSensors.clear();
        this.thermostats.clear();
        this.clouds.clear();
        this.trees.clear();
        this.fans.clear();
        this.heliostats.clear();
        this.maximumHeatCapacity = -1.0f;
    }

    public void removeAllParticles() {
        this.particles.clear();
    }

    private void setInitialVelocity() {
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                if (this.fluidity[i][j]) {
                    this.v[i][j] = 0.0f;
                    this.u[i][j] = 0.0f;
                } else {
                    this.u[i][j] = this.uWind[i][j];
                    this.v[i][j] = this.vWind[i][j];
                }
                ++j;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialTemperature() {
        if (this.parts == null || this.parts.isEmpty()) {
            int i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    this.t[i][j] = this.backgroundTemperature;
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nx) {
                float x = (float)i * this.deltaX;
                int j = 0;
                while (j < this.ny) {
                    float y = (float)j * this.deltaY;
                    int count = 0;
                    this.t[i][j] = 0.0f;
                    List<Part> list = this.parts;
                    synchronized (list) {
                        for (Part p : this.parts) {
                            if (!this.contains(p.getShape(), x, y, false)) continue;
                            ++count;
                            float[] fArray = this.t[i];
                            int n = j;
                            fArray[n] = fArray[n] + p.getTemperature();
                        }
                    }
                    if (count > 0) {
                        float[] fArray = this.t[i];
                        int n = j;
                        fArray[n] = fArray[n] / (float)count;
                    } else {
                        this.t[i][j] = this.backgroundTemperature;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.clearSensorData();
    }

    public void run() {
        this.checkPartPower();
        this.checkPartRadiation();
        this.refreshPowerArray();
        if (!this.running) {
            this.running = true;
            while (this.running) {
                this.nextStep();
                if (this.fatalErrorOccurred()) {
                    this.notifyManipulationListeners((byte)12);
                    this.notifyManipulationListeners((byte)99);
                    break;
                }
                if (this.tasks == null) continue;
                this.tasks.run();
            }
            if (this.notifyReset) {
                this.indexOfStep = 0;
                this.reallyReset();
                this.notifyReset = false;
                this.notifyManipulationListeners((byte)18);
            }
        }
    }

    public boolean fatalErrorOccurred() {
        return Float.isNaN(this.t[this.nx / 2][this.ny / 2]);
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void reset() {
        if (this.running) {
            this.stop();
            this.notifyReset = true;
        } else {
            this.reallyReset();
        }
        this.running = false;
        this.indexOfStep = 0;
    }

    private void reallyReset() {
        this.setInitialTemperature();
        this.setInitialVelocity();
        for (Part p : this.parts) {
            p.setPowerSwitch(true);
        }
        if (!this.anemometers.isEmpty()) {
            for (Anemometer a : this.anemometers) {
                a.setAngle(0.0f);
            }
        }
        this.photons.clear();
        this.heatSolver.reset();
        this.fluidSolver.reset();
        this.particleSolver.reset();
        this.radiositySolver.reset();
        this.attachSensors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPartPower() {
        this.hasPartPower = false;
        List<Part> list = this.parts;
        synchronized (list) {
            for (Part p : this.parts) {
                if (p.getPower() == 0.0f) continue;
                this.hasPartPower = true;
                break;
            }
        }
    }

    public boolean isRadiative() {
        this.checkPartRadiation();
        return this.radiative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPartRadiation() {
        this.radiative = false;
        List<Part> list = this.parts;
        synchronized (list) {
            for (Part p : this.parts) {
                if (!(p.getEmissivity() > 0.0f)) continue;
                this.radiative = true;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextStep() {
        List<Manipulable> list;
        if (this.sunny && this.indexOfStep % this.photonEmissionInterval == 0) {
            this.photonSolver.sunShine(this.photons, this.parts);
            this.refreshPowerArray();
        }
        this.photonSolver.solve(this);
        if (this.radiative && this.indexOfStep % this.radiosityInterval == 0) {
            this.refreshPowerArray();
            this.radiositySolver.solve();
        }
        if (this.convective) {
            this.fluidSolver.solve(this.u, this.v);
            if (!this.fans.isEmpty()) {
                this.applyFans();
            }
        }
        this.heatSolver.solve(this.convective, this.t);
        if (!this.particles.isEmpty()) {
            this.particleSolver.move(this);
        }
        if (!this.particleFeeders.isEmpty()) {
            list = this.particleFeeders;
            synchronized (list) {
                for (ParticleFeeder pf : this.particleFeeders) {
                    if (this.indexOfStep % Math.round(pf.getPeriod() / this.getTimeStep()) != 0) continue;
                    pf.feed(this);
                }
            }
        }
        if (!this.clouds.isEmpty()) {
            list = this.clouds;
            synchronized (list) {
                for (Cloud c : this.clouds) {
                    c.move(this.heatSolver.getTimeStep(), this.lx);
                }
            }
        }
        ++this.indexOfStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFans() {
        List<Fan> list = this.fans;
        synchronized (list) {
            int i = 0;
            while (i < this.nx) {
                float x = (float)i * this.deltaX;
                int j = 0;
                while (j < this.ny) {
                    float y = (float)j * this.deltaY;
                    for (Fan f : this.fans) {
                        if (!this.contains(f.getShape(), x, y, false) || f.getSpeed() == 0.0f) continue;
                        this.u[i][j] = this.uWind[i][j];
                        this.v[i][j] = this.vWind[i][j];
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public float getTime() {
        return (float)this.indexOfStep * this.heatSolver.getTimeStep();
    }

    public int getIndexOfStep() {
        return this.indexOfStep;
    }

    public void setTimeStep(float timeStep) {
        this.notifyPropertyChangeListeners("Time step", Float.valueOf(this.getTimeStep()), Float.valueOf(timeStep));
        this.heatSolver.setTimeStep(timeStep);
        this.fluidSolver.setTimeStep(timeStep);
    }

    public float getTimeStep() {
        return this.heatSolver.getTimeStep();
    }

    void changePowerAt(float x, float y, float increment) {
        int j;
        int i = Math.min(this.t.length - 1, Math.round(x / this.deltaX));
        if (i < 0) {
            i = 0;
        }
        if ((j = Math.min(this.t[0].length - 1, Math.round(y / this.deltaY))) < 0) {
            j = 0;
        }
        float[] fArray = this.q[i];
        int n = j;
        fArray[n] = fArray[n] + increment;
    }

    public void setTemperature(float[][] t) {
        this.t = t;
    }

    public float getTemperatureAt(float x, float y) {
        int j;
        int i = Math.min(this.t.length - 1, Math.round(x / this.deltaX));
        if (i < 0) {
            i = 0;
        }
        if ((j = Math.min(this.t[0].length - 1, Math.round(y / this.deltaY))) < 0) {
            j = 0;
        }
        return this.t[i][j];
    }

    public float getTemperatureAt(float x, float y, byte stencil) {
        int j;
        int i = Math.min(this.t.length - 1, Math.round(x / this.deltaX));
        if (i < 0) {
            i = 0;
        }
        if ((j = Math.min(this.t[0].length - 1, Math.round(y / this.deltaY))) < 0) {
            j = 0;
        }
        return this.getTemperature(i, j, stencil);
    }

    public float getTemperature(int i, int j, byte stencil) {
        if (i < 0) {
            i = 0;
        } else if (i > this.nx - 1) {
            i = this.nx - 1;
        }
        if (j < 0) {
            j = 0;
        } else if (j > this.ny - 1) {
            j = this.ny - 1;
        }
        switch (stencil) {
            case 1: {
                return this.t[i][j];
            }
            case 5: {
                float temp = this.t[i][j];
                int count = 1;
                if (i > 0) {
                    temp += this.t[i - 1][j];
                    ++count;
                }
                if (i < this.nx - 1) {
                    temp += this.t[i + 1][j];
                    ++count;
                }
                if (j > 0) {
                    temp += this.t[i][j - 1];
                    ++count;
                }
                if (j < this.ny - 1) {
                    temp += this.t[i][j + 1];
                    ++count;
                }
                return temp / (float)count;
            }
            case 9: {
                float temp = this.t[i][j];
                int count = 1;
                if (i > 0) {
                    temp += this.t[i - 1][j];
                    ++count;
                }
                if (i < this.nx - 1) {
                    temp += this.t[i + 1][j];
                    ++count;
                }
                if (j > 0) {
                    temp += this.t[i][j - 1];
                    ++count;
                }
                if (j < this.ny - 1) {
                    temp += this.t[i][j + 1];
                    ++count;
                }
                if (i > 0 && j > 0) {
                    temp += this.t[i - 1][j - 1];
                    ++count;
                }
                if (i > 0 && j < this.ny - 1) {
                    temp += this.t[i - 1][j + 1];
                    ++count;
                }
                if (i < this.nx - 1 && j > 0) {
                    temp += this.t[i + 1][j - 1];
                    ++count;
                }
                if (i < this.nx - 1 && j < this.ny - 1) {
                    temp += this.t[i + 1][j + 1];
                    ++count;
                }
                return temp / (float)count;
            }
        }
        return this.t[i][j];
    }

    public void setTemperatureAt(float x, float y, float temperature) {
        int i = Math.min(this.t.length - 1, Math.round(x / this.deltaX));
        if (i < 0) {
            return;
        }
        int j = Math.min(this.t[0].length - 1, Math.round(y / this.deltaY));
        if (j < 0) {
            return;
        }
        this.t[i][j] = temperature;
    }

    public void changeTemperatureAt(float x, float y, float increment) {
        int i = Math.min(this.t.length - 1, Math.round(x / this.deltaX));
        if (i < 0) {
            return;
        }
        int j = Math.min(this.t[0].length - 1, Math.round(y / this.deltaY));
        if (j < 0) {
            return;
        }
        float[] fArray = this.t[i];
        int n = j;
        fArray[n] = fArray[n] + increment;
    }

    float getAverageTemperatureAt(float x, float y) {
        float temp = 0.0f;
        int i0 = Math.round(x / this.deltaX);
        int j0 = Math.round(y / this.deltaY);
        int i = Math.min(this.t.length - 1, i0);
        int j = Math.min(this.t[0].length - 1, j0);
        if (i < 0) {
            i = 0;
        }
        if (j < 0) {
            j = 0;
        }
        temp += this.t[i][j];
        i = Math.min(this.t.length - 1, i0 + 1);
        j = Math.min(this.t[0].length - 1, j0);
        if (i < 0) {
            i = 0;
        }
        if (j < 0) {
            j = 0;
        }
        temp += this.t[i][j];
        i = Math.min(this.t.length - 1, i0 - 1);
        j = Math.min(this.t[0].length - 1, j0);
        if (i < 0) {
            i = 0;
        }
        if (j < 0) {
            j = 0;
        }
        temp += this.t[i][j];
        i = Math.min(this.t.length - 1, i0);
        j = Math.min(this.t[0].length - 1, j0 + 1);
        if (i < 0) {
            i = 0;
        }
        if (j < 0) {
            j = 0;
        }
        temp += this.t[i][j];
        i = Math.min(this.t.length - 1, i0);
        j = Math.min(this.t[0].length - 1, j0 - 1);
        if (i < 0) {
            i = 0;
        }
        if (j < 0) {
            j = 0;
        }
        return (temp += this.t[i][j]) * 0.2f;
    }

    void changeAverageTemperatureAt(float x, float y, float increment) {
        increment *= 0.2f;
        int i0 = Math.round(x / this.deltaX);
        int j0 = Math.round(y / this.deltaY);
        int i = Math.min(this.t.length - 1, i0);
        int j = Math.min(this.t[0].length - 1, j0);
        if (i >= 0 && j >= 0) {
            float[] fArray = this.t[i];
            int n = j;
            fArray[n] = fArray[n] + increment;
        }
        i = Math.min(this.t.length - 1, i0 + 1);
        j = Math.min(this.t[0].length - 1, j0);
        if (i >= 0 && j >= 0) {
            float[] fArray = this.t[i];
            int n = j;
            fArray[n] = fArray[n] + increment;
        }
        i = Math.min(this.t.length - 1, i0 - 1);
        j = Math.min(this.t[0].length - 1, j0);
        if (i >= 0 && j >= 0) {
            float[] fArray = this.t[i];
            int n = j;
            fArray[n] = fArray[n] + increment;
        }
        i = Math.min(this.t.length - 1, i0);
        j = Math.min(this.t[0].length - 1, j0 + 1);
        if (i >= 0 && j >= 0) {
            float[] fArray = this.t[i];
            int n = j;
            fArray[n] = fArray[n] + increment;
        }
        i = Math.min(this.t.length - 1, i0);
        j = Math.min(this.t[0].length - 1, j0 - 1);
        if (i >= 0 && j >= 0) {
            float[] fArray = this.t[i];
            int n = j;
            fArray[n] = fArray[n] + increment;
        }
    }

    public float[][] getTemperature() {
        return this.t;
    }

    public float[] getHeatFlux(int i, int j) {
        if (i < 1) {
            i = 1;
        } else if (i > this.nx - 2) {
            i = this.nx - 2;
        }
        if (j < 1) {
            j = 1;
        } else if (j > this.ny - 2) {
            j = this.ny - 2;
        }
        float fx = -this.conductivity[i][j] * (this.t[i + 1][j] - this.t[i - 1][j]) / (2.0f * this.deltaX);
        float fy = -this.conductivity[i][j] * (this.t[i][j + 1] - this.t[i][j - 1]) / (2.0f * this.deltaY);
        return new float[]{fx, fy};
    }

    public float[] getHeatFluxAt(float x, float y) {
        return this.getHeatFlux(Math.round(x / this.deltaX), Math.round(y / this.deltaY));
    }

    public float[][] getXVelocity() {
        return this.u;
    }

    public float[][] getYVelocity() {
        return this.v;
    }

    public float[] getVelocityAt(float x, float y) {
        int j;
        int i = Math.min(this.t.length - 1, Math.round(x / this.deltaX));
        if (i < 0) {
            i = 0;
        }
        if ((j = Math.min(this.t[0].length - 1, Math.round(y / this.deltaY))) < 0) {
            j = 0;
        }
        return new float[]{this.u[i][j], this.v[i][j]};
    }

    public float getVorticityAt(float x, float y) {
        return this.getVorticity(Math.round(x / this.deltaX), Math.round(y / this.deltaY));
    }

    public float getVorticity(int i, int j) {
        if (i < 1) {
            i = 1;
        } else if (i > this.nx - 2) {
            i = this.nx - 2;
        }
        if (j < 1) {
            j = 1;
        } else if (j > this.ny - 2) {
            j = this.ny - 2;
        }
        if (!this.fluidity[i][j]) {
            return 0.0f;
        }
        float du_dy = (this.u[i][j + 1] - this.u[i][j - 1]) / this.deltaY;
        float dv_dx = (this.v[i + 1][j] - this.v[i - 1][j]) / this.deltaX;
        return 0.5f * (du_dy - dv_dx);
    }

    public float getVorticity(int i, int j, byte stencil) {
        switch (stencil) {
            case 5: {
                float vor = this.getVorticity(i, j);
                vor += this.getVorticity(i - 1, j);
                vor += this.getVorticity(i + 1, j);
                vor += this.getVorticity(i, j - 1);
                return (vor += this.getVorticity(i, j + 1)) / 5.0f;
            }
            case 9: {
                float vor = this.getVorticity(i, j);
                vor += this.getVorticity(i - 1, j);
                vor += this.getVorticity(i + 1, j);
                vor += this.getVorticity(i, j - 1);
                vor += this.getVorticity(i, j + 1);
                vor += this.getVorticity(i - 1, j - 1);
                vor += this.getVorticity(i - 1, j + 1);
                vor += this.getVorticity(i + 1, j - 1);
                return (vor += this.getVorticity(i + 1, j + 1)) / 9.0f;
            }
        }
        return this.getVorticity(i, j);
    }

    public float[][] getStreamFunction() {
        return this.fluidSolver.getStreamFunction(this.u, this.v);
    }

    public float[][] getSpecificHeat() {
        return this.specificHeat;
    }

    public float[][] getDensity() {
        return this.density;
    }

    public float[][] getConductivity() {
        return this.conductivity;
    }

    public boolean hasSensor() {
        return !this.thermometers.isEmpty() || !this.heatFluxSensors.isEmpty() || !this.anemometers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachSensors() {
        Particle host;
        List<Sensor> list;
        if (!this.thermometers.isEmpty()) {
            list = this.thermometers;
            synchronized (list) {
                for (Thermometer m : this.thermometers) {
                    if (m.getAttachID() == null || (host = this.getParticle(m.getAttachID())) == null) continue;
                    m.setX(host.rx);
                    m.setY(host.ry - m.getSensingSpotY());
                }
            }
        }
        if (!this.heatFluxSensors.isEmpty()) {
            list = this.heatFluxSensors;
            synchronized (list) {
                for (HeatFluxSensor f : this.heatFluxSensors) {
                    if (f.getAttachID() == null || (host = this.getParticle(f.getAttachID())) == null) continue;
                    f.setX(host.rx);
                    f.setY(host.ry);
                    f.setAngle(host.getTheta());
                }
            }
        }
        if (!this.anemometers.isEmpty()) {
            list = this.anemometers;
            synchronized (list) {
                for (Anemometer a : this.anemometers) {
                    if (a.getAttachID() == null || (host = this.getParticle(a.getAttachID())) == null) continue;
                    a.setX(host.rx);
                    a.setY(host.ry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeMeasurement() {
        int j;
        int i;
        this.attachSensors();
        if (!this.thermometers.isEmpty()) {
            int offset = Math.round(this.thermometers.get(0).getSensingSpotY() / this.ly * (float)this.ny);
            List<Thermometer> list = this.thermometers;
            synchronized (list) {
                for (Thermometer m : this.thermometers) {
                    i = Math.round(m.getX() / this.deltaX);
                    j = Math.round(m.getY() / this.deltaY);
                    if (i < 0 || i >= this.nx || j < 0 || j >= this.ny) continue;
                    m.addData(this.getTime(), this.getTemperature(i, j + offset, m.getStencil()));
                }
            }
        }
        if (!this.heatFluxSensors.isEmpty()) {
            List<HeatFluxSensor> list = this.heatFluxSensors;
            synchronized (list) {
                for (HeatFluxSensor f : this.heatFluxSensors) {
                    i = Math.round(f.getX() / this.deltaX);
                    j = Math.round(f.getY() / this.deltaY);
                    if (i < 0 || i >= this.nx || j < 0 || j >= this.ny) continue;
                    float[] h = this.getHeatFlux(i, j);
                    float flux = (float)((double)h[0] * Math.sin(f.getAngle()) + (double)h[1] * Math.cos(f.getAngle()));
                    if (this.radiative) {
                        flux += this.radiositySolver.measure(f);
                    }
                    f.setValue(flux);
                    f.addData(this.getTime(), flux);
                }
            }
        }
        if (!this.anemometers.isEmpty()) {
            List<Anemometer> list = this.anemometers;
            synchronized (list) {
                for (Anemometer a : this.anemometers) {
                    i = Math.round(a.getX() / this.deltaX);
                    j = Math.round(a.getY() / this.deltaY);
                    if (i < 0 || i >= this.nx || j < 0 || j >= this.ny) continue;
                    a.addData(this.getTime(), (float)Math.hypot(this.u[i][j], this.v[i][j]));
                }
            }
        }
    }

    public void control() {
        boolean refresh = false;
        for (Thermostat x : this.thermostats) {
            if (!x.onoff(this)) continue;
            refresh = true;
        }
        for (Part p : this.parts) {
            if (p.getThermistorTemperatureCoefficient() == 0.0f) continue;
            refresh = true;
            break;
        }
        if (refresh) {
            this.refreshPowerArray();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    private void notifyPropertyChangeListeners(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChangeListeners.isEmpty()) {
            return;
        }
        PropertyChangeEvent e = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener x : this.propertyChangeListeners) {
            x.propertyChange(e);
        }
    }

    public void addManipulationListener(ManipulationListener listener) {
        if (!this.manipulationListeners.contains(listener)) {
            this.manipulationListeners.add(listener);
        }
    }

    public void removeManipulationListener(ManipulationListener listener) {
        if (listener != null) {
            this.manipulationListeners.remove(listener);
        }
    }

    private void notifyManipulationListeners(byte type) {
        if (this.manipulationListeners.isEmpty()) {
            return;
        }
        ManipulationEvent e = new ManipulationEvent(this, type);
        for (ManipulationListener x : this.manipulationListeners) {
            x.manipulationOccured(e);
        }
    }
}

