/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Photon;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class Heliostat
extends Manipulable {
    public static final byte MIRROR = 0;
    public static final byte PHOTOVOLTAIC = 1;
    private byte type = 0;
    private Part target;
    private float angle;
    private Model2D model;

    public Heliostat(Shape s, Model2D model) {
        super(s);
        this.model = model;
    }

    @Override
    public Heliostat duplicate(float x, float y) {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            s = new Rectangle2D.Float(x - 0.5f * r.width, y - 0.5f * r.height, r.width, r.height);
        }
        Heliostat h = new Heliostat(s, this.model);
        h.target = this.target;
        h.setAngle();
        h.setLabel(this.getLabel());
        return h;
    }

    public void translateBy(float dx, float dy) {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            r.x += dx;
            r.y += dy;
        }
        if (this.target != null) {
            this.setAngle();
        }
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public void setTarget(Part target) {
        this.target = target;
    }

    public Part getTarget() {
        return this.target;
    }

    public void setAngle() {
        float theta;
        if (this.target != null) {
            Point2D.Float c1 = this.target.getCenter();
            Point2D.Float c2 = this.getCenter();
            float dx = c1.x - c2.x;
            float dy = c1.y - c2.y;
            theta = 0.5f * ((float)Math.acos((double)dx / Math.hypot(dx, dy)) + this.model.getSunAngle());
        } else {
            theta = this.model.getSunAngle();
        }
        this.angle = 1.5707964f - theta;
    }

    public float getAngle() {
        return this.angle;
    }

    public static Area getShape(Rectangle2D.Float r, float angle) {
        Area a = new Area(new Rectangle2D.Float(r.x + r.width * 0.45f, r.y + r.height * 0.5f, r.width * 0.1f, r.height * 0.5f));
        Area mirror = new Area(new Rectangle2D.Float(r.x, r.y + r.height * 0.45f, r.width, r.height * 0.1f));
        mirror.add(new Area(new Rectangle2D.Float(r.x + 0.3f * r.width, r.y + r.height * 0.54f, r.width * 0.4f, r.height * 0.05f)));
        mirror.transform(AffineTransform.getRotateInstance(angle, (double)r.x + (double)r.width * 0.5, (double)r.y + (double)r.height * 0.5));
        a.add(mirror);
        return a;
    }

    public boolean reflect(Photon p) {
        Rectangle2D.Float shape = (Rectangle2D.Float)this.getShape();
        float lenx = (float)(0.5 * (double)shape.width * Math.cos(this.angle));
        float leny = (float)(0.5 * (double)shape.width * Math.sin(this.angle));
        float cenx = 0.5f * shape.width + shape.x;
        float ceny = 0.5f * shape.height + shape.y;
        Line2D.Float line = new Line2D.Float(cenx - lenx, ceny - leny, cenx + lenx, ceny + leny);
        float dt = this.model.getTimeStep();
        float predictedX = p.getRx() + p.getVx() * dt;
        float predictedY = p.getRy() + p.getVy() * dt;
        boolean hit = line.intersectsLine(p.getRx(), p.getRy(), predictedX, predictedY);
        if (hit) {
            float d12 = (float)(1.0 / Math.hypot(line.x1 - line.x2, line.y1 - line.y2));
            float sin = (line.y2 - line.y1) * d12;
            float cos = (line.x2 - line.x1) * d12;
            float u = p.getVx() * cos + p.getVy() * sin;
            float w = p.getVy() * cos - p.getVx() * sin;
            p.setVx(u * cos + w * sin);
            p.setVy(u * sin - w * cos);
            return true;
        }
        return false;
    }

    public String toXml() {
        String label;
        XmlCharacterEncoder xce = new XmlCharacterEncoder();
        String xml = "<heliostat";
        String uid = this.getUid();
        if (uid != null && !uid.trim().equals("")) {
            xml = String.valueOf(xml) + " uid=\"" + xce.encode(uid) + "\"";
        }
        if ((label = this.getLabel()) != null && !label.trim().equals("")) {
            xml = String.valueOf(xml) + " label=\"" + xce.encode(label) + "\"";
        }
        if (this.type != 0) {
            xml = String.valueOf(xml) + " type=\"" + this.type + "\"";
        }
        if (this.getShape() instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
            xml = String.valueOf(xml) + " x=\"" + r.x + "\"";
            xml = String.valueOf(xml) + " y=\"" + r.y + "\"";
            xml = String.valueOf(xml) + " width=\"" + r.width + "\"";
            xml = String.valueOf(xml) + " height=\"" + r.height + "\"";
        }
        if (this.target != null && this.target.getUid() != null && !this.target.getUid().trim().equals("")) {
            xml = String.valueOf(xml) + " target=\"" + this.target.getUid() + "\"";
        }
        xml = String.valueOf(xml) + "/>";
        return xml;
    }

    public String toString() {
        return this.getUid() == null ? super.toString() : this.getUid();
    }
}

