/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import org.concord.energy2d.model.HeatSolver2D;
import org.concord.energy2d.util.MiscUtil;

class HeatSolver2DImpl
extends HeatSolver2D {
    private static byte relaxationSteps = (byte)5;

    HeatSolver2DImpl(int nx, int ny) {
        super(nx, ny);
    }

    @Override
    void solve(boolean convective, float[][] t) {
        MiscUtil.copy(this.t0, t);
        float hx = 0.5f / (this.deltaX * this.deltaX);
        float hy = 0.5f / (this.deltaY * this.deltaY);
        float invTimeStep = 1.0f / this.timeStep;
        boolean solveZ = this.zHeatDiffusivity != 0.0f;
        int k = 0;
        while (k < relaxationSteps) {
            int i = 1;
            while (i < this.nx1) {
                int j = 1;
                while (j < this.ny1) {
                    if (Float.isNaN(this.tb[i][j])) {
                        float sij = this.specificHeat[i][j] * this.density[i][j] * invTimeStep;
                        float rij = this.conductivity[i][j];
                        float axij = hx * (rij + this.conductivity[i - 1][j]);
                        float bxij = hx * (rij + this.conductivity[i + 1][j]);
                        float ayij = hy * (rij + this.conductivity[i][j - 1]);
                        float byij = hy * (rij + this.conductivity[i][j + 1]);
                        t[i][j] = (this.t0[i][j] * sij + this.q[i][j] + axij * t[i - 1][j] + bxij * t[i + 1][j] + ayij * t[i][j - 1] + byij * t[i][j + 1]) / (sij + axij + bxij + ayij + byij);
                        if (solveZ && k == relaxationSteps - 1) {
                            float[] fArray = t[i];
                            int n = j;
                            fArray[n] = fArray[n] - this.zHeatDiffusivity * this.timeStep * (this.t0[i][j] - this.backgroundTemperature);
                        }
                    } else {
                        t[i][j] = this.tb[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            this.applyBoundary(t);
            ++k;
        }
        if (convective) {
            this.advect(t);
        }
    }

    private void advect(float[][] t) {
        this.macCormack(t);
    }

    private void macCormack(float[][] t) {
        int j;
        float tx = 0.5f * this.timeStep / this.deltaX;
        float ty = 0.5f * this.timeStep / this.deltaY;
        int i = 1;
        while (i < this.nx1) {
            j = 1;
            while (j < this.ny1) {
                if (this.fluidity[i][j]) {
                    this.t0[i][j] = t[i][j] - tx * (this.u[i + 1][j] * t[i + 1][j] - this.u[i - 1][j] * t[i - 1][j]) - ty * (this.v[i][j + 1] * t[i][j + 1] - this.v[i][j - 1] * t[i][j - 1]);
                }
                ++j;
            }
            ++i;
        }
        this.applyBoundary(this.t0);
        i = 1;
        while (i < this.nx1) {
            j = 1;
            while (j < this.ny1) {
                if (this.fluidity[i][j]) {
                    t[i][j] = 0.5f * (t[i][j] + this.t0[i][j]) - 0.5f * tx * this.u[i][j] * (this.t0[i + 1][j] - this.t0[i - 1][j]) - 0.5f * ty * this.v[i][j] * (this.t0[i][j + 1] - this.t0[i][j - 1]);
                }
                ++j;
            }
            ++i;
        }
        this.applyBoundary(t);
    }
}

