/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.util.Arrays;
import org.concord.energy2d.model.ComplexDirichletThermalBoundary;
import org.concord.energy2d.model.DirichletThermalBoundary;
import org.concord.energy2d.model.NeumannThermalBoundary;
import org.concord.energy2d.model.ThermalBoundary;

abstract class HeatSolver2D {
    int nx;
    int ny;
    int nx1;
    int ny1;
    int nx2;
    int ny2;
    ThermalBoundary boundary;
    float[][] conductivity;
    float[][] specificHeat;
    float[][] density;
    float[][] q;
    float[][] u;
    float[][] v;
    float[][] tb;
    float[][] t0;
    boolean[][] fluidity;
    float deltaX;
    float deltaY;
    float timeStep = 0.1f;
    float backgroundTemperature;
    float zHeatDiffusivity;

    HeatSolver2D(int nx, int ny) {
        this.nx = nx;
        this.ny = ny;
        this.nx1 = nx - 1;
        this.ny1 = ny - 1;
        this.nx2 = nx - 2;
        this.ny2 = ny - 2;
        this.t0 = new float[nx][ny];
        this.boundary = new DirichletThermalBoundary();
    }

    void reset() {
        int i = 0;
        while (i < this.nx) {
            Arrays.fill(this.t0[i], 0.0f);
            ++i;
        }
    }

    void setTimeStep(float timeStep) {
        this.timeStep = timeStep;
    }

    float getTimeStep() {
        return this.timeStep;
    }

    void setFluidity(boolean[][] fluidity) {
        this.fluidity = fluidity;
    }

    void setGridCellSize(float deltaX, float deltaY) {
        this.deltaX = deltaX;
        this.deltaY = deltaY;
    }

    void setBoundary(ThermalBoundary boundary) {
        this.boundary = boundary;
    }

    ThermalBoundary getBoundary() {
        return this.boundary;
    }

    void setVelocity(float[][] u, float[][] v) {
        this.u = u;
        this.v = v;
    }

    void setConductivity(float[][] conductivity) {
        this.conductivity = conductivity;
    }

    void setSpecificHeat(float[][] specificHeat) {
        this.specificHeat = specificHeat;
    }

    void setDensity(float[][] density) {
        this.density = density;
    }

    void setPower(float[][] q) {
        this.q = q;
    }

    void setTemperatureBoundary(float[][] tb) {
        this.tb = tb;
    }

    abstract void solve(boolean var1, float[][] var2);

    void applyBoundary(float[][] t) {
        block7: {
            block8: {
                block6: {
                    if (!(this.boundary instanceof DirichletThermalBoundary)) break block6;
                    DirichletThermalBoundary b = (DirichletThermalBoundary)this.boundary;
                    float tUpper = b.getTemperatureAtBorder((byte)0);
                    float tLower = b.getTemperatureAtBorder((byte)2);
                    float tLeft = b.getTemperatureAtBorder((byte)3);
                    float tRight = b.getTemperatureAtBorder((byte)1);
                    int i = 0;
                    while (i < this.nx) {
                        t[i][0] = tUpper;
                        t[i][this.ny1] = tLower;
                        ++i;
                    }
                    int j = 0;
                    while (j < this.ny) {
                        t[0][j] = tLeft;
                        t[this.nx1][j] = tRight;
                        ++j;
                    }
                    break block7;
                }
                if (!(this.boundary instanceof ComplexDirichletThermalBoundary)) break block8;
                ComplexDirichletThermalBoundary b = (ComplexDirichletThermalBoundary)this.boundary;
                float[] tUpper = b.getTemperaturesAtBorder((byte)0);
                float[] tLower = b.getTemperaturesAtBorder((byte)2);
                float[] tLeft = b.getTemperaturesAtBorder((byte)3);
                float[] tRight = b.getTemperaturesAtBorder((byte)1);
                int i = 0;
                while (i < this.nx) {
                    t[i][0] = tUpper[i];
                    t[i][this.ny1] = tLower[i];
                    ++i;
                }
                int j = 0;
                while (j < this.ny) {
                    t[0][j] = tLeft[j];
                    t[this.nx1][j] = tRight[j];
                    ++j;
                }
                break block7;
            }
            if (!(this.boundary instanceof NeumannThermalBoundary)) break block7;
            NeumannThermalBoundary b = (NeumannThermalBoundary)this.boundary;
            float fN = b.getFluxAtBorder((byte)0);
            float fS = b.getFluxAtBorder((byte)2);
            float fW = b.getFluxAtBorder((byte)3);
            float fE = b.getFluxAtBorder((byte)1);
            float minConductivity = 0.001f;
            int i = 0;
            while (i < this.nx) {
                t[i][0] = t[i][1] + fN * this.deltaY / Math.max(this.conductivity[i][0], minConductivity);
                t[i][this.ny1] = t[i][this.ny2] - fS * this.deltaY / Math.max(this.conductivity[i][this.ny1], minConductivity);
                ++i;
            }
            int j = 0;
            while (j < this.ny) {
                t[0][j] = t[1][j] - fW * this.deltaX / Math.max(this.conductivity[0][j], minConductivity);
                t[this.nx1][j] = t[this.nx2][j] + fE * this.deltaX / Math.max(this.conductivity[this.nx1][j], minConductivity);
                ++j;
            }
        }
    }
}

