/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.geom.Rectangle2D;
import org.concord.energy2d.model.Sensor;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class HeatFluxSensor
extends Sensor {
    public static final float RELATIVE_WIDTH = 0.036f;
    public static final float RELATIVE_HEIGHT = 0.012f;
    private float angle;
    private float value;

    public HeatFluxSensor(float x, float y) {
        super(new Rectangle2D.Float());
        this.setCenter(x, y);
    }

    public HeatFluxSensor(float x, float y, String label, float angle) {
        this(x, y);
        this.angle = angle;
        this.setLabel(label);
    }

    @Override
    public HeatFluxSensor duplicate(float x, float y) {
        return new HeatFluxSensor(x, y, null, this.angle);
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle() {
        return this.angle;
    }

    @Override
    public String getName() {
        return "Heat Flux Sensor (W/m\u00b2)";
    }

    @Override
    public String toXml() {
        String label;
        XmlCharacterEncoder xce = new XmlCharacterEncoder();
        String xml = "<heat_flux_sensor";
        String uid = this.getUid();
        if (uid != null && !uid.trim().equals("")) {
            xml = String.valueOf(xml) + " uid=\"" + xce.encode(uid) + "\"";
        }
        if (this.attachID != null && !this.attachID.trim().equals("")) {
            xml = String.valueOf(xml) + " attach=\"" + xce.encode(this.attachID) + "\"";
        }
        if ((label = this.getLabel()) != null && !label.trim().equals("")) {
            xml = String.valueOf(xml) + " label=\"" + xce.encode(label) + "\"";
        }
        xml = String.valueOf(xml) + " angle=\"" + this.angle + "\"";
        xml = String.valueOf(xml) + " x=\"" + this.getX() + "\"";
        xml = String.valueOf(xml) + " y=\"" + this.getY() + "\"/>";
        return xml;
    }
}

