/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import org.concord.energy2d.model.FluidSolver2D;
import org.concord.energy2d.util.MiscUtil;

class FluidSolver2DImpl
extends FluidSolver2D {
    FluidSolver2DImpl(int nx, int ny) {
        super(nx, ny);
    }

    @Override
    void diffuse(int b, float[][] f0, float[][] f) {
        MiscUtil.copy(f0, f);
        float hx = this.timeStep * this.viscosity * this.idxsq;
        float hy = this.timeStep * this.viscosity * this.idysq;
        float dn = 1.0f / (1.0f + 2.0f * (hx + hy));
        int k = 0;
        while (k < relaxationSteps) {
            int i = 1;
            while (i < this.nx1) {
                int j = 1;
                while (j < this.ny1) {
                    if (this.fluidity[i][j]) {
                        f[i][j] = (f0[i][j] + hx * (f[i - 1][j] + f[i + 1][j]) + hy * (f[i][j - 1] + f[i][j + 1])) * dn;
                    }
                    ++j;
                }
                ++i;
            }
            this.applyBoundary(b, f);
            ++k;
        }
    }

    @Override
    void advect(int b, float[][] f0, float[][] f) {
        this.macCormack(b, f0, f);
    }

    private void macCormack(int b, float[][] f0, float[][] f) {
        int j;
        float tx = 0.5f * this.timeStep / this.deltaX;
        float ty = 0.5f * this.timeStep / this.deltaY;
        int i = 1;
        while (i < this.nx1) {
            j = 1;
            while (j < this.ny1) {
                if (this.fluidity[i][j]) {
                    f[i][j] = f0[i][j] - tx * (this.u0[i + 1][j] * f0[i + 1][j] - this.u0[i - 1][j] * f0[i - 1][j]) - ty * (this.v0[i][j + 1] * f0[i][j + 1] - this.v0[i][j - 1] * f0[i][j - 1]);
                }
                ++j;
            }
            ++i;
        }
        this.applyBoundary(b, f);
        i = 1;
        while (i < this.nx1) {
            j = 1;
            while (j < this.ny1) {
                if (this.fluidity[i][j]) {
                    f0[i][j] = 0.5f * (f0[i][j] + f[i][j]) - 0.5f * tx * this.u0[i][j] * (f[i + 1][j] - f[i - 1][j]) - 0.5f * ty * this.v0[i][j] * (f[i][j + 1] - f[i][j - 1]);
                }
                ++j;
            }
            ++i;
        }
        MiscUtil.copy(f, f0);
        this.applyBoundary(b, f);
    }
}

