/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.util.Arrays;
import org.concord.energy2d.math.MathUtil;
import org.concord.energy2d.model.MassBoundary;
import org.concord.energy2d.model.SimpleMassBoundary;
import org.concord.energy2d.util.MiscUtil;

abstract class FluidSolver2D {
    static byte relaxationSteps = (byte)5;
    private float thermalExpansionCoefficient = 2.5E-4f;
    private float gravity = 0.0f;
    private byte buoyancyApproximation = 0;
    private byte gravityType = 0;
    float viscosity = 1.568E-4f;
    int nx;
    int ny;
    int nx1;
    int ny1;
    int nx2;
    int ny2;
    float[][] u0;
    float[][] v0;
    float timeStep = 0.1f;
    float deltaX;
    float deltaY;
    boolean[][] fluidity;
    MassBoundary boundary;
    float[][] t;
    float[][] uWind;
    float[][] vWind;
    private float[][] vorticity;
    private float[][] stream;
    private float i2dx;
    private float i2dy;
    float idxsq;
    float idysq;

    FluidSolver2D(int nx, int ny) {
        this.nx = nx;
        this.ny = ny;
        this.nx1 = nx - 1;
        this.ny1 = ny - 1;
        this.nx2 = nx - 2;
        this.ny2 = ny - 2;
        this.u0 = new float[nx][ny];
        this.v0 = new float[nx][ny];
        this.boundary = new SimpleMassBoundary();
    }

    void reset() {
        int i = 0;
        while (i < this.nx) {
            Arrays.fill(this.u0[i], 0.0f);
            Arrays.fill(this.v0[i], 0.0f);
            ++i;
        }
        if (this.vorticity != null) {
            i = 0;
            while (i < this.nx) {
                Arrays.fill(this.vorticity[i], 0.0f);
                ++i;
            }
        }
        if (this.stream != null) {
            i = 0;
            while (i < this.nx) {
                Arrays.fill(this.stream[i], 0.0f);
                ++i;
            }
        }
    }

    void setBoundary(MassBoundary boundary) {
        this.boundary = boundary;
    }

    MassBoundary getBoundary() {
        return this.boundary;
    }

    void setGravityType(byte gravityType) {
        this.gravityType = gravityType;
    }

    byte getGravityType() {
        return this.gravityType;
    }

    void setBuoyancyApproximation(byte buoyancyApproximation) {
        this.buoyancyApproximation = buoyancyApproximation;
    }

    byte getBuoyancyApproximation() {
        return this.buoyancyApproximation;
    }

    void setThermalExpansionCoefficient(float thermalExpansionCoefficient) {
        this.thermalExpansionCoefficient = thermalExpansionCoefficient;
    }

    float getThermalExpansionCoefficient() {
        return this.thermalExpansionCoefficient;
    }

    void setWindSpeed(float[][] uWind, float[][] vWind) {
        this.uWind = uWind;
        this.vWind = vWind;
    }

    void setBackgroundViscosity(float viscosity) {
        this.viscosity = viscosity;
    }

    float getViscosity() {
        return this.viscosity;
    }

    void setTemperature(float[][] t) {
        this.t = t;
    }

    void setFluidity(boolean[][] fluidity) {
        this.fluidity = fluidity;
    }

    void setGridCellSize(float deltaX, float deltaY) {
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.i2dx = 0.5f / deltaX;
        this.i2dy = 0.5f / deltaY;
        this.idxsq = 1.0f / (deltaX * deltaX);
        this.idysq = 1.0f / (deltaY * deltaY);
    }

    void setTimeStep(float timeStep) {
        this.timeStep = timeStep;
    }

    float getTimeStep() {
        return this.timeStep;
    }

    private void setObstacleVelocity(float[][] u, float[][] v) {
        int count = 0;
        int i = 1;
        while (i < this.nx1) {
            int j = 1;
            while (j < this.ny1) {
                if (!this.fluidity[i][j]) {
                    float uw = this.uWind[i][j];
                    float vw = this.vWind[i][j];
                    count = 0;
                    if (this.fluidity[i - 1][j]) {
                        ++count;
                        u[i][j] = uw - u[i - 1][j];
                        v[i][j] = vw + v[i - 1][j];
                    } else if (this.fluidity[i + 1][j]) {
                        ++count;
                        u[i][j] = uw - u[i + 1][j];
                        v[i][j] = vw + v[i + 1][j];
                    }
                    if (this.fluidity[i][j - 1]) {
                        ++count;
                        u[i][j] = uw + u[i][j - 1];
                        v[i][j] = vw - v[i][j - 1];
                    } else if (this.fluidity[i][j + 1]) {
                        ++count;
                        u[i][j] = uw + u[i][j + 1];
                        v[i][j] = vw - v[i][j + 1];
                    }
                    if (count == 0) {
                        u[i][j] = uw;
                        v[i][j] = vw;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void setObstacleBoundary(float[][] x) {
        int i = 1;
        while (i < this.nx1) {
            int j = 1;
            while (j < this.ny1) {
                if (!this.fluidity[i][j]) {
                    if (this.fluidity[i - 1][j]) {
                        x[i][j] = x[i - 1][j];
                    } else if (this.fluidity[i + 1][j]) {
                        x[i][j] = x[i + 1][j];
                    }
                    if (this.fluidity[i][j - 1]) {
                        x[i][j] = x[i][j - 1];
                    } else if (this.fluidity[i][j + 1]) {
                        x[i][j] = x[i][j + 1];
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private float getMeanTemperature(int i, int j) {
        int lowerBound = 0;
        int k = j - 1;
        while (k > 0) {
            if (!this.fluidity[i][k]) {
                lowerBound = k;
                break;
            }
            --k;
        }
        int upperBound = this.ny;
        int k2 = j + 1;
        while (k2 < this.ny) {
            if (!this.fluidity[i][k2]) {
                upperBound = k2;
                break;
            }
            ++k2;
        }
        float t0 = 0.0f;
        int k3 = lowerBound;
        while (k3 < upperBound) {
            t0 += this.t[i][k3];
            ++k3;
        }
        return t0 / (float)(upperBound - lowerBound);
    }

    private void applyBuoyancy(float[][] f) {
        float g = this.gravity * this.timeStep;
        float b = this.thermalExpansionCoefficient * this.timeStep;
        switch (this.buoyancyApproximation) {
            case 0: {
                float t0 = MathUtil.getAverage(this.t);
                int i = 1;
                while (i < this.nx1) {
                    int j = 1;
                    while (j < this.ny1) {
                        if (this.fluidity[i][j]) {
                            float[] fArray = f[i];
                            int n = j;
                            fArray[n] = fArray[n] + ((g - b) * this.t[i][j] + b * t0);
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 1;
                while (i < this.nx1) {
                    int j = 1;
                    while (j < this.ny1) {
                        if (this.fluidity[i][j]) {
                            float t0 = this.getMeanTemperature(i, j);
                            float[] fArray = f[i];
                            int n = j;
                            fArray[n] = fArray[n] + ((g - b) * this.t[i][j] + b * t0);
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void applySphericalBuoyancy(float[][] u, float[][] v) {
        float g = this.gravity * this.timeStep;
        float b = this.thermalExpansionCoefficient * this.timeStep;
        float t0 = MathUtil.getAverage(this.t);
        float dx = 0.0f;
        float dy = 0.0f;
        float dr = 0.0f;
        float cx = this.nx / 2;
        float cy = this.ny / 2;
        int i = 1;
        while (i < this.nx1) {
            int j = 1;
            while (j < this.ny1) {
                if (this.fluidity[i][j]) {
                    dx = ((float)i - cx) * this.deltaX;
                    dy = ((float)j - cy) * this.deltaY;
                    dr = (float)(1.0 / Math.hypot(dx, dy));
                    dx *= dr;
                    dy *= dr;
                    dr = (g - b) * this.t[i][j] + b * t0;
                    float[] fArray = u[i];
                    int n = j;
                    fArray[n] = fArray[n] - dr * dx;
                    float[] fArray2 = v[i];
                    int n2 = j;
                    fArray2[n2] = fArray2[n2] - dr * dy;
                }
                ++j;
            }
            ++i;
        }
    }

    abstract void diffuse(int var1, float[][] var2, float[][] var3);

    abstract void advect(int var1, float[][] var2, float[][] var3);

    void solve(float[][] u, float[][] v) {
        if (this.thermalExpansionCoefficient != 0.0f) {
            switch (this.gravityType) {
                case 0: {
                    this.applyBuoyancy(v);
                    break;
                }
                case 1: {
                    this.applySphericalBuoyancy(u, v);
                }
            }
        }
        this.setObstacleVelocity(u, v);
        if (this.viscosity > 0.0f) {
            this.diffuse(1, this.u0, u);
            this.diffuse(2, this.v0, v);
            this.conserve(u, v, this.u0, this.v0);
            this.setObstacleVelocity(u, v);
        }
        MiscUtil.copy(this.u0, u);
        MiscUtil.copy(this.v0, v);
        this.advect(1, this.u0, u);
        this.advect(2, this.v0, v);
        this.conserve(u, v, this.u0, this.v0);
        this.setObstacleVelocity(u, v);
    }

    void conserve(float[][] u, float[][] v, float[][] phi, float[][] div) {
        int i = 1;
        while (i < this.nx1) {
            int j = 1;
            while (j < this.ny1) {
                if (this.fluidity[i][j]) {
                    div[i][j] = (u[i + 1][j] - u[i - 1][j]) * this.i2dx + (v[i][j + 1] - v[i][j - 1]) * this.i2dy;
                    phi[i][j] = 0.0f;
                }
                ++j;
            }
            ++i;
        }
        this.applyBoundary(0, div);
        this.applyBoundary(0, phi);
        this.setObstacleBoundary(div);
        this.setObstacleBoundary(phi);
        float s = 0.5f / (this.idxsq + this.idysq);
        int k = 0;
        while (k < relaxationSteps) {
            int i2 = 1;
            while (i2 < this.nx1) {
                int j = 1;
                while (j < this.ny1) {
                    if (this.fluidity[i2][j]) {
                        phi[i2][j] = s * ((phi[i2 - 1][j] + phi[i2 + 1][j]) * this.idxsq + (phi[i2][j - 1] + phi[i2][j + 1]) * this.idysq - div[i2][j]);
                    }
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
        int i3 = 1;
        while (i3 < this.nx1) {
            int j = 1;
            while (j < this.ny1) {
                if (this.fluidity[i3][j]) {
                    float[] fArray = u[i3];
                    int n = j;
                    fArray[n] = fArray[n] - (phi[i3 + 1][j] - phi[i3 - 1][j]) * this.i2dx;
                    float[] fArray2 = v[i3];
                    int n2 = j;
                    fArray2[n2] = fArray2[n2] - (phi[i3][j + 1] - phi[i3][j - 1]) * this.i2dy;
                }
                ++j;
            }
            ++i3;
        }
        this.applyBoundary(1, u);
        this.applyBoundary(2, v);
    }

    float[][] getStreamFunction(float[][] u, float[][] v) {
        if (this.vorticity == null) {
            this.vorticity = new float[this.nx][this.ny];
        }
        if (this.stream == null) {
            this.stream = new float[this.nx][this.ny];
        }
        this.calculateVorticity(u, v);
        this.calculateStreamFunction();
        return this.stream;
    }

    private void calculateStreamFunction() {
        float s = 0.5f / (this.idxsq + this.idysq);
        int i = 0;
        while (i < this.nx) {
            Arrays.fill(this.stream[i], 0.0f);
            ++i;
        }
        int k = 0;
        while (k < relaxationSteps) {
            int i2 = 1;
            while (i2 < this.nx1) {
                int j = 1;
                while (j < this.ny1) {
                    if (this.fluidity[i2][j]) {
                        this.stream[i2][j] = s * ((this.stream[i2 - 1][j] + this.stream[i2 + 1][j]) * this.idxsq + (this.stream[i2][j - 1] + this.stream[i2][j + 1]) * this.idysq + this.vorticity[i2][j]);
                    }
                    ++j;
                }
                ++i2;
            }
            this.applyBoundary(0, this.stream);
            this.setObstacleBoundary(this.stream);
            ++k;
        }
    }

    private void calculateVorticity(float[][] u, float[][] v) {
        int i = 1;
        while (i < this.nx1) {
            int j = 1;
            while (j < this.ny1) {
                if (this.fluidity[i][j]) {
                    float du_dy = (u[i][j + 1] - u[i][j - 1]) / (2.0f * this.deltaY);
                    float dv_dx = (v[i + 1][j] - v[i - 1][j]) / (2.0f * this.deltaX);
                    this.vorticity[i][j] = du_dy - dv_dx;
                }
                ++j;
            }
            ++i;
        }
        this.applyBoundary(0, this.vorticity);
        this.setObstacleBoundary(this.vorticity);
    }

    void applyBoundary(int direction, float[][] f) {
        SimpleMassBoundary b = (SimpleMassBoundary)this.boundary;
        boolean horizontal = direction == 1;
        boolean vertical = direction == 2;
        int i = 1;
        while (i < this.nx1) {
            if (vertical) {
                switch (b.getFlowTypeAtBorder((byte)0)) {
                    case 2: {
                        f[i][0] = 0.0f;
                        break;
                    }
                    case 0: {
                        f[i][0] = -f[i][1];
                    }
                }
            } else {
                f[i][0] = f[i][1];
            }
            if (vertical) {
                switch (b.getFlowTypeAtBorder((byte)2)) {
                    case 2: {
                        f[i][this.ny1] = 0.0f;
                        break;
                    }
                    case 0: {
                        f[i][this.ny1] = -f[i][this.ny2];
                    }
                }
            } else {
                f[i][this.ny1] = f[i][this.ny2];
            }
            ++i;
        }
        int j = 1;
        while (j < this.ny1) {
            if (horizontal) {
                switch (b.getFlowTypeAtBorder((byte)3)) {
                    case 2: {
                        f[0][j] = 0.0f;
                        break;
                    }
                    case 0: {
                        f[0][j] = -f[1][j];
                    }
                }
            } else {
                f[0][j] = f[1][j];
            }
            if (horizontal) {
                switch (b.getFlowTypeAtBorder((byte)1)) {
                    case 2: {
                        f[this.nx1][j] = 0.0f;
                        break;
                    }
                    case 0: {
                        f[this.nx1][j] = -f[this.nx2][j];
                    }
                }
            } else {
                f[this.nx1][j] = f[this.nx2][j];
            }
            ++j;
        }
        f[0][0] = 0.5f * (f[1][0] + f[0][1]);
        f[this.nx1][0] = 0.5f * (f[this.nx2][0] + f[this.nx1][1]);
        f[0][this.ny1] = 0.5f * (f[1][this.ny1] + f[0][this.ny2]);
        f[this.nx1][this.ny1] = 0.5f * (f[this.nx2][this.ny1] + f[this.nx1][this.ny2]);
    }
}

