/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class Fan
extends Manipulable {
    private float speed;
    private float angle;

    public Fan(Shape s) {
        super(s);
    }

    @Override
    public Fan duplicate(float x, float y) {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            s = new Rectangle2D.Float(x - 0.5f * r.width, y - 0.5f * r.height, r.width, r.height);
        }
        Fan f = new Fan(s);
        f.angle = this.angle;
        f.speed = this.speed;
        f.setLabel(this.getLabel());
        return f;
    }

    public void translateBy(float dx, float dy) {
        Shape s = this.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            r.x += dx;
            r.y += dy;
        }
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle() {
        return this.angle;
    }

    public static Area getShape(Rectangle2D.Float r, float speed, float angle, float delta) {
        if (r.height > r.width) {
            float d1 = 0.5f * r.height * delta;
            float d2 = d1 * 2.0f;
            float deg = (float)Math.toDegrees(0.5 * Math.asin((double)r.height / Math.hypot(r.width, r.height)));
            Area a = new Area(new Arc2D.Float(r.x + r.width / 4.0f, r.y + d1, r.width / 2.0f, r.height - d2, deg, 180.0f - 2.0f * deg, 2));
            a.add(new Area(new Arc2D.Float(r.x + r.width / 4.0f, r.y + d1, r.width / 2.0f, r.height - d2, -deg, 2.0f * deg - 180.0f, 2)));
            a.add(new Area(new Rectangle2D.Float((double)speed * Math.cos(angle) >= 0.0 ? r.x : r.x + r.width * 0.5f, r.y + r.height * 0.475f, r.width * 0.5f, 0.05f * r.height)));
            return a;
        }
        float d1 = 0.5f * r.width * delta;
        float d2 = d1 * 2.0f;
        float deg = (float)Math.toDegrees(0.5 * Math.asin((double)r.width / Math.hypot(r.width, r.height)));
        Area a = new Area(new Arc2D.Float(r.x + d1, r.y + r.height / 4.0f, r.width - d2, r.height / 2.0f, deg, -2.0f * deg, 2));
        a.add(new Area(new Arc2D.Float(r.x + d1, r.y + r.height / 4.0f, r.width - d2, r.height / 2.0f, 180.0f - deg, 2.0f * deg, 2)));
        a.add(new Area(new Rectangle2D.Float(r.x + r.width * 0.475f, (double)speed * Math.sin(angle) > 0.0 ? r.y : r.y + r.height * 0.5f, 0.05f * r.width, r.height * 0.5f)));
        return a;
    }

    public String toXml() {
        String label;
        XmlCharacterEncoder xce = new XmlCharacterEncoder();
        String xml = "<fan";
        String uid = this.getUid();
        if (uid != null && !uid.trim().equals("")) {
            xml = String.valueOf(xml) + " uid=\"" + xce.encode(uid) + "\"";
        }
        if ((label = this.getLabel()) != null && !label.trim().equals("")) {
            xml = String.valueOf(xml) + " label=\"" + xce.encode(label) + "\"";
        }
        if (this.getShape() instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
            xml = String.valueOf(xml) + " x=\"" + r.x + "\"";
            xml = String.valueOf(xml) + " y=\"" + r.y + "\"";
            xml = String.valueOf(xml) + " width=\"" + r.width + "\"";
            xml = String.valueOf(xml) + " height=\"" + r.height + "\"";
        }
        xml = String.valueOf(xml) + " speed=\"" + this.speed + "\"";
        xml = String.valueOf(xml) + " angle=\"" + this.angle + "\"/>";
        return xml;
    }

    public String toString() {
        return this.getUid() == null ? super.toString() : this.getUid();
    }
}

