/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import org.concord.energy2d.model.ThermalBoundary;

public class DirichletThermalBoundary
implements ThermalBoundary {
    private float[] temperatureAtBorder = new float[4];

    public DirichletThermalBoundary() {
        this.setTemperatureAtBorder((byte)0, 0.0f);
        this.setTemperatureAtBorder((byte)2, 0.0f);
        this.setTemperatureAtBorder((byte)3, 0.0f);
        this.setTemperatureAtBorder((byte)1, 0.0f);
    }

    public void setTemperatureAtBorder(byte side, float value) {
        if (side < 0 || side > 3) {
            throw new IllegalArgumentException("side parameter illegal");
        }
        this.temperatureAtBorder[side] = value;
    }

    public float getTemperatureAtBorder(byte side) {
        if (side < 0 || side > 3) {
            throw new IllegalArgumentException("side parameter illegal");
        }
        return this.temperatureAtBorder[side];
    }

    @Override
    public String toXml() {
        String s = "<temperature_at_border upper=\"" + this.temperatureAtBorder[0] + "\"";
        s = String.valueOf(s) + " lower=\"" + this.temperatureAtBorder[2] + "\"";
        s = String.valueOf(s) + " left=\"" + this.temperatureAtBorder[3] + "\"";
        s = String.valueOf(s) + " right=\"" + this.temperatureAtBorder[1] + "\"";
        s = String.valueOf(s) + "/>\n";
        return s;
    }
}

