/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.util.Arrays;
import org.concord.energy2d.model.ThermalBoundary;

public class ComplexDirichletThermalBoundary
implements ThermalBoundary {
    private float[] temperatureLeft;
    private float[] temperatureRight;
    private float[] temperatureUpper;
    private float[] temperatureLower;

    public ComplexDirichletThermalBoundary(int nx, int ny) {
        this.temperatureLeft = new float[ny];
        this.temperatureRight = new float[ny];
        this.temperatureUpper = new float[nx];
        this.temperatureLower = new float[nx];
        Arrays.fill(this.temperatureLeft, 0.0f);
        Arrays.fill(this.temperatureRight, 0.0f);
        Arrays.fill(this.temperatureUpper, 0.0f);
        Arrays.fill(this.temperatureLower, 0.0f);
    }

    public void setTemperaturesAtBorder(byte side, float[] value) {
        if (side < 0 || side > 3) {
            throw new IllegalArgumentException("side parameter illegal");
        }
        switch (side) {
            case 3: {
                if (value.length != this.temperatureLeft.length) {
                    throw new IllegalArgumentException("array lengths do not match: left boundary temperatures");
                }
                int i = 0;
                while (i < this.temperatureLeft.length) {
                    this.temperatureLeft[i] = value[i];
                    ++i;
                }
                break;
            }
            case 1: {
                if (value.length != this.temperatureRight.length) {
                    throw new IllegalArgumentException("array lengths do not match: right boundary temperatures");
                }
                int i = 0;
                while (i < this.temperatureRight.length) {
                    this.temperatureRight[i] = value[i];
                    ++i;
                }
                break;
            }
            case 0: {
                if (value.length != this.temperatureUpper.length) {
                    throw new IllegalArgumentException("array lengths do not match: upper boundary temperatures");
                }
                int i = 0;
                while (i < this.temperatureUpper.length) {
                    this.temperatureUpper[i] = value[i];
                    ++i;
                }
                break;
            }
            case 2: {
                if (value.length != this.temperatureLower.length) {
                    throw new IllegalArgumentException("array lengths do not match: lower boundary temperatures");
                }
                int i = 0;
                while (i < this.temperatureLower.length) {
                    this.temperatureLower[i] = value[i];
                    ++i;
                }
                break;
            }
        }
    }

    public float[] getTemperaturesAtBorder(byte side) {
        if (side < 0 || side > 3) {
            throw new IllegalArgumentException("side parameter illegal");
        }
        switch (side) {
            case 3: {
                return this.temperatureLeft;
            }
            case 1: {
                return this.temperatureRight;
            }
            case 0: {
                return this.temperatureUpper;
            }
        }
        return this.temperatureLower;
    }

    @Override
    public String toXml() {
        String s = "<temperature_at_border upper=\"" + Arrays.toString(this.temperatureUpper) + "\"";
        s = String.valueOf(s) + " lower=\"" + Arrays.toString(this.temperatureLower) + "\"";
        s = String.valueOf(s) + " left=\"" + Arrays.toString(this.temperatureLeft) + "\"";
        s = String.valueOf(s) + " right=\"" + Arrays.toString(this.temperatureRight) + "\"";
        s = String.valueOf(s) + "/>\n";
        return s;
    }
}

