/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class Cloud
extends Manipulable {
    private float x;
    private float y;
    private float speed;
    private Color color = Color.WHITE;
    private Rectangle2D.Float boundingBox;

    public Cloud(Shape bb) {
        super(bb);
        if (!(bb instanceof Rectangle2D.Float)) {
            throw new IllegalArgumentException("Shape must be a Rectangle2D.Float");
        }
        Rectangle2D.Float r = (Rectangle2D.Float)bb;
        this.setDimension(r.width, r.height);
    }

    public static Area getShape(Rectangle2D.Float r) {
        float max = Math.max(r.width, r.height);
        Area a = new Area(new Ellipse2D.Float(r.x + r.width / 6.0f, r.y, max / 2.0f, max / 2.0f));
        a.add(new Area(new Ellipse2D.Float(r.x, r.y + r.height / 2.0f, max / 3.0f, max / 3.0f)));
        a.add(new Area(new Ellipse2D.Float(r.x + r.width / 3.0f, r.y + r.height / 3.0f, max / 2.0f, max / 2.0f)));
        a.add(new Area(new Ellipse2D.Float(r.x + 2.0f * r.width / 3.0f, r.y + 2.0f * r.height / 3.0f, r.width / 3.0f, r.width / 3.0f)));
        a.intersect(new Area(r));
        return a;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void move(float timeStep, float lx) {
        if (this.speed == 0.0f) {
            return;
        }
        this.x += this.speed * timeStep;
        if (this.x > lx) {
            this.x -= lx + this.boundingBox.width;
        } else if (this.x < -this.boundingBox.width) {
            this.x += lx + this.boundingBox.width;
        }
    }

    public void translateBy(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public Point2D.Float getCenter() {
        Rectangle2D bound = this.getShape().getBounds2D();
        return new Point2D.Float((float)bound.getCenterX() + this.x, (float)bound.getCenterY() + this.y);
    }

    @Override
    public boolean contains(float rx, float ry) {
        return this.getShape().contains(rx - this.x, ry - this.y);
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getX() {
        return this.x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getY() {
        return this.y;
    }

    public void setDimension(float w, float h) {
        this.boundingBox = new Rectangle2D.Float(0.0f, 0.0f, w, h);
        this.setShape(Cloud.getShape(this.boundingBox));
    }

    public float getWidth() {
        return this.boundingBox.width;
    }

    public float getHeight() {
        return this.boundingBox.height;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    @Override
    public Cloud duplicate(float x, float y) {
        Cloud c = new Cloud(new Rectangle2D.Float(0.0f, 0.0f, this.boundingBox.width, this.boundingBox.height));
        c.speed = this.speed;
        c.setLabel(this.getLabel());
        c.color = this.color;
        c.setX(x - this.boundingBox.width / 2.0f);
        c.setY(y - this.boundingBox.height / 2.0f);
        return c;
    }

    public String toXml() {
        String label;
        XmlCharacterEncoder xce = new XmlCharacterEncoder();
        String xml = "<cloud";
        String uid = this.getUid();
        if (uid != null && !uid.trim().equals("")) {
            xml = String.valueOf(xml) + " uid=\"" + xce.encode(uid) + "\"";
        }
        if ((label = this.getLabel()) != null && !label.trim().equals("")) {
            xml = String.valueOf(xml) + " label=\"" + xce.encode(label) + "\"";
        }
        if (!Color.WHITE.equals(this.color)) {
            xml = String.valueOf(xml) + " color=\"" + Integer.toHexString(0xFFFFFF & this.color.getRGB()) + "\"";
        }
        xml = String.valueOf(xml) + " x=\"" + this.x + "\"";
        xml = String.valueOf(xml) + " y=\"" + this.y + "\"";
        xml = String.valueOf(xml) + " width=\"" + this.boundingBox.width + "\"";
        xml = String.valueOf(xml) + " height=\"" + this.boundingBox.height + "\"";
        xml = String.valueOf(xml) + " speed=\"" + this.speed + "\"/>";
        return xml;
    }
}

