/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.model;

import java.awt.geom.Rectangle2D;
import org.concord.energy2d.model.Sensor;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class Anemometer
extends Sensor {
    public static final float RELATIVE_WIDTH = 0.05f;
    public static final float RELATIVE_HEIGHT = 0.05f;
    private float angle;

    public Anemometer(float x, float y) {
        super(new Rectangle2D.Float());
        this.setCenter(x, y);
    }

    public Anemometer(float x, float y, String label) {
        this(x, y);
        this.setLabel(label);
    }

    @Override
    public Anemometer duplicate(float x, float y) {
        return new Anemometer(x, y);
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle() {
        return this.angle;
    }

    @Override
    public String getName() {
        return "Anemometer (m/s)";
    }

    @Override
    public String toXml() {
        String label;
        String uid;
        XmlCharacterEncoder xce = new XmlCharacterEncoder();
        String xml = "<anemometer";
        if (this.stencil != 1) {
            xml = String.valueOf(xml) + " stencil=\"" + this.stencil + "\"";
        }
        if ((uid = this.getUid()) != null && !uid.trim().equals("")) {
            xml = String.valueOf(xml) + " uid=\"" + xce.encode(uid) + "\"";
        }
        if (this.attachID != null && !this.attachID.trim().equals("")) {
            xml = String.valueOf(xml) + " attach=\"" + xce.encode(this.attachID) + "\"";
        }
        if ((label = this.getLabel()) != null && !label.trim().equals("")) {
            xml = String.valueOf(xml) + " label=\"" + xce.encode(label) + "\"";
        }
        xml = String.valueOf(xml) + " x=\"" + this.getX() + "\"";
        xml = String.valueOf(xml) + " y=\"" + this.getY() + "\"/>";
        return xml;
    }
}

