/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.math;

public class Vector2D {
    public float x = 1.0f;
    public float y = 0.0f;

    public Vector2D(float x, float y) {
        this.set(x, y);
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float length() {
        return (float)Math.hypot(this.x, this.y);
    }

    public void normalize() {
        float r = this.length();
        if (r == 0.0f) {
            throw new RuntimeException("vector cannot have zero length: " + this);
        }
        this.x /= r;
        this.y /= r;
    }

    public float dotProduct(Vector2D v) {
        return this.x * v.x + this.y * v.y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

