/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.math;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;

public class Ring2D
extends Area {
    private float x;
    private float y;
    private float outerDiameter;
    private float innerDiameter;

    public Ring2D(float x, float y, float innerDiameter, float outerDiameter) {
        super(new Ellipse2D.Float(x - 0.5f * outerDiameter, y - 0.5f * outerDiameter, outerDiameter, outerDiameter));
        this.subtract(new Area(new Ellipse2D.Float(x - 0.5f * innerDiameter, y - 0.5f * innerDiameter, innerDiameter, innerDiameter)));
        this.x = x;
        this.y = y;
        this.innerDiameter = innerDiameter;
        this.outerDiameter = outerDiameter;
    }

    public Ring2D(Ring2D ring) {
        this(ring.x, ring.y, ring.innerDiameter, ring.outerDiameter);
    }

    public void translateBy(float dx, float dy) {
        this.transform(AffineTransform.getTranslateInstance(dx, dy));
        this.x += dx;
        this.y += dy;
    }

    public void translateTo(float x, float y) {
        this.translateBy(x - this.x, y - this.y);
    }

    public void setRing(float x, float y, float innerDiameter, float outerDiameter) {
        this.reset();
        this.add(new Area(new Ellipse2D.Float(x - 0.5f * outerDiameter, y - 0.5f * outerDiameter, outerDiameter, outerDiameter)));
        this.subtract(new Area(new Ellipse2D.Float(x - 0.5f * innerDiameter, y - 0.5f * innerDiameter, innerDiameter, innerDiameter)));
        this.x = x;
        this.y = y;
        this.innerDiameter = innerDiameter;
        this.outerDiameter = outerDiameter;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getInnerDiameter() {
        return this.innerDiameter;
    }

    public float getOuterDiameter() {
        return this.outerDiameter;
    }

    public float getArea() {
        return (float)(0.7853981633974483 * (double)(this.outerDiameter * this.outerDiameter - this.innerDiameter * this.innerDiameter));
    }
}

