/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.math;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.concord.energy2d.math.TransformableShape;

public class Polygon2D
implements TransformableShape {
    private Point2D.Float[] vertex;
    private GeneralPath path;

    public Polygon2D(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("the number of x coodinates must be equal to that of the y coordinates.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("the number of vertices must be no less than 3.");
        }
        this.vertex = new Point2D.Float[x.length];
        int i = 0;
        while (i < x.length) {
            this.setVertex(i, x[i], y[i]);
            ++i;
        }
        this.path = new GeneralPath();
    }

    public Polygon2D duplicate() {
        int n = this.vertex.length;
        float[] x = new float[n];
        float[] y = new float[n];
        int i = 0;
        while (i < n) {
            x[i] = this.vertex[i].x;
            y[i] = this.vertex[i].y;
            ++i;
        }
        return new Polygon2D(x, y);
    }

    public Polygon2D insertVertexBefore(int k) {
        int n = this.vertex.length;
        float[] x = new float[n + 1];
        float[] y = new float[n + 1];
        if (k > 0 && k < n) {
            int i = 0;
            while (i < k) {
                x[i] = this.vertex[i].x;
                y[i] = this.vertex[i].y;
                ++i;
            }
            x[k] = 0.5f * (this.vertex[k].x + this.vertex[k - 1].x);
            y[k] = 0.5f * (this.vertex[k].y + this.vertex[k - 1].y);
            i = k + 1;
            while (i < n + 1) {
                x[i] = this.vertex[i - 1].x;
                y[i] = this.vertex[i - 1].y;
                ++i;
            }
        } else if (k == 0) {
            x[0] = 0.5f * (this.vertex[0].x + this.vertex[n - 1].x);
            y[0] = 0.5f * (this.vertex[0].y + this.vertex[n - 1].y);
            int i = 1;
            while (i < n + 1) {
                x[i] = this.vertex[i - 1].x;
                y[i] = this.vertex[i - 1].y;
                ++i;
            }
        } else {
            return this;
        }
        return new Polygon2D(x, y);
    }

    public Polygon2D deleteVertexBefore(int k) {
        int n = this.vertex.length;
        if (n < 4) {
            return this;
        }
        float[] x = new float[n - 1];
        float[] y = new float[n - 1];
        if (k > 0 && k < n) {
            int i = 0;
            while (i < k) {
                x[i] = this.vertex[i].x;
                y[i] = this.vertex[i].y;
                ++i;
            }
            i = k + 1;
            while (i < n) {
                x[i - 1] = this.vertex[i].x;
                y[i - 1] = this.vertex[i].y;
                ++i;
            }
        } else if (k == 0) {
            int i = 1;
            while (i < n) {
                x[i - 1] = this.vertex[i - 1].x;
                y[i - 1] = this.vertex[i - 1].y;
                ++i;
            }
        } else {
            return this;
        }
        return new Polygon2D(x, y);
    }

    public boolean isClockwise() {
        float sum = 0.0f;
        int n = this.vertex.length;
        int i = 0;
        while (i < n - 1) {
            sum += (this.vertex[i + 1].x - this.vertex[i].x) * (this.vertex[i + 1].y + this.vertex[i].y);
            ++i;
        }
        return (sum += (this.vertex[0].x - this.vertex[n - 1].x) * (this.vertex[0].y + this.vertex[n - 1].y)) > 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        GeneralPath generalPath = this.path;
        synchronized (generalPath) {
            this.path.reset();
            this.path.moveTo(this.vertex[0].x, this.vertex[0].y);
            int i = 1;
            while (i < this.vertex.length) {
                this.path.lineTo(this.vertex[i].x, this.vertex[i].y);
                ++i;
            }
            this.path.closePath();
        }
    }

    public void setVertices(List<Point2D.Float> points) {
        if (points.size() < 3) {
            throw new IllegalArgumentException("the number of vertices must be no less than 3.");
        }
        if (this.vertex == null || points.size() != this.vertex.length) {
            this.path = new GeneralPath();
        }
        this.vertex = new Point2D.Float[points.size()];
        int i = 0;
        while (i < this.vertex.length) {
            Point2D.Float pi = points.get(i);
            this.setVertex(i, pi.x, pi.y);
            ++i;
        }
    }

    public void setVertex(int i, float x, float y) {
        if (i < 0 || i >= this.vertex.length) {
            throw new IllegalArgumentException("index of vertex is out of bound.");
        }
        if (this.vertex[i] == null) {
            this.vertex[i] = new Point2D.Float(x, y);
        } else {
            this.vertex[i].setLocation(x, y);
        }
    }

    public Point2D.Float getVertex(int i) {
        if (i < 0 || i >= this.vertex.length) {
            throw new IllegalArgumentException("index of vertex is out of bound.");
        }
        return this.vertex[i];
    }

    public int getVertexCount() {
        return this.vertex.length;
    }

    @Override
    public void translateBy(float dx, float dy) {
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float p = floatArray[n2];
            p.x += dx;
            p.y += dy;
            ++n2;
        }
    }

    @Override
    public void rotateBy(float degree) {
        Rectangle2D r = this.path.getBounds2D();
        double cx = r.getCenterX();
        double cy = r.getCenterY();
        double a = Math.toRadians(degree);
        double sin = Math.sin(a);
        double cos = Math.cos(a);
        double dx = 0.0;
        double dy = 0.0;
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            dx = (double)v.x - cx;
            dy = (double)v.y - cy;
            v.x = (float)(dx * cos - dy * sin + cx);
            v.y = (float)(dx * sin + dy * cos + cy);
            ++n2;
        }
    }

    @Override
    public void scale(float scale) {
        Rectangle2D r = this.path.getBounds2D();
        double cx = r.getCenterX();
        double cy = r.getCenterY();
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            v.x = (float)(((double)v.x - cx) * (double)scale + cx);
            v.y = (float)(((double)v.y - cy) * (double)scale + cy);
            ++n2;
        }
    }

    @Override
    public void scaleX(float scale) {
        Rectangle2D r = this.path.getBounds2D();
        double cx = r.getCenterX();
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            v.x = (float)(((double)v.x - cx) * (double)scale + cx);
            ++n2;
        }
    }

    @Override
    public void scaleY(float scale) {
        Rectangle2D r = this.path.getBounds2D();
        double cy = r.getCenterY();
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            v.y = (float)(((double)v.y - cy) * (double)scale + cy);
            ++n2;
        }
    }

    @Override
    public void shearX(float shear) {
        Rectangle2D r = this.path.getBounds2D();
        double cy = r.getCenterY();
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            v.x += (float)((double)v.y - cy) * shear;
            ++n2;
        }
    }

    @Override
    public void shearY(float shear) {
        Rectangle2D r = this.path.getBounds2D();
        double cx = r.getCenterX();
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            v.y += (float)((double)v.x - cx) * shear;
            ++n2;
        }
    }

    @Override
    public void flipX() {
        float cx = (float)this.path.getBounds2D().getCenterX();
        float dx = 0.0f;
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            dx = v.x - cx;
            v.x = cx - dx;
            ++n2;
        }
    }

    @Override
    public void flipY() {
        float cy = (float)this.path.getBounds2D().getCenterY();
        float dy = 0.0f;
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            dy = v.y - cy;
            v.y = cy - dy;
            ++n2;
        }
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(Rectangle r) {
        this.update();
        return this.path.intersects(r);
    }

    @Override
    public boolean contains(double x, double y) {
        this.update();
        return this.path.contains(x, y);
    }

    public Point2D.Float getBoundCenter() {
        Rectangle2D r = this.path.getBounds2D();
        return new Point2D.Float((float)r.getCenterX(), (float)r.getCenterY());
    }

    public void translateCenterTo(float x, float y) {
        Point2D.Float center = this.getCenter();
        this.translateBy(x - center.x, y - center.y);
    }

    @Override
    public Point2D.Float getCenter() {
        float xc = 0.0f;
        float yc = 0.0f;
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            xc += v.x;
            yc += v.y;
            ++n2;
        }
        return new Point2D.Float(xc / (float)this.vertex.length, yc / (float)this.vertex.length);
    }

    @Override
    public float getArea() {
        Point2D.Float v2;
        Point2D.Float v1;
        float area = 0.0f;
        int n = this.vertex.length;
        int i = 0;
        while (i < n - 1) {
            v1 = this.vertex[i];
            v2 = this.vertex[i + 1];
            area = (float)((double)area + (v1.getX() * v2.getY() - v2.getX() * v1.getY()));
            ++i;
        }
        v1 = this.vertex[n - 1];
        v2 = this.vertex[0];
        area = (float)((double)area + (v1.getX() * v2.getY() - v2.getX() * v1.getY()));
        return area * 0.5f;
    }

    @Override
    public Rectangle getBounds() {
        int xmin;
        int ymin = xmin = Integer.MAX_VALUE;
        int xmax = -xmin;
        int ymax = -xmin;
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            if ((float)xmin > v.x) {
                xmin = Math.round(v.x);
            }
            if ((float)ymin > v.y) {
                ymin = Math.round(v.y);
            }
            if ((float)xmax < v.x) {
                xmax = Math.round(v.x);
            }
            if ((float)ymax < v.y) {
                ymax = Math.round(v.y);
            }
            ++n2;
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    @Override
    public Rectangle2D getBounds2D() {
        float xmin;
        float ymin = xmin = Float.MAX_VALUE;
        float xmax = -xmin;
        float ymax = -xmin;
        Point2D.Float[] floatArray = this.vertex;
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            if (xmin > v.x) {
                xmin = v.x;
            }
            if (ymin > v.y) {
                ymin = v.y;
            }
            if (xmax < v.x) {
                xmax = v.x;
            }
            if (ymax < v.y) {
                ymax = v.y;
            }
            ++n2;
        }
        return new Rectangle2D.Float(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        this.update();
        return this.path.contains(r);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        this.update();
        return this.path.contains(x, y, w, h);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        this.update();
        return this.path.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        this.update();
        return this.path.getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        this.update();
        return this.path.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        this.update();
        return this.path.intersects(x, y, w, h);
    }
}

